/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2007 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and documentation
 * files (the "Software"), including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense and/or sell copies of
 * the Software, and to permit persons who receive copies from any such
 * party to do so, with the only requirement being that the above copyright
 * and this permission notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/


#define addpt_width_small 22
#define addpt_height_small 22
static unsigned char addpt_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width_small 22
#define align_height_small 22
static unsigned char align_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width_small 22
#define arc_height_small 22
static unsigned char arc_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width_small 22
#define arc_box_height_small 22
static unsigned char arc_box_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width_small 22
#define autoarrow_height_small 22
static unsigned char autoarrow_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width_small 22
#define box_height_small 22
static unsigned char box_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width_small 22
#define break_height_small 22
static unsigned char break_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width_small 22
#define open_comp_height_small 22
static unsigned char open_comp_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width_small 22
#define join_split_height_small 22
static unsigned char join_split_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define chop_width_small 22
#define chop_height_small 22
static unsigned char chop_bits_small[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00,
   0x00, 0x1c, 0x00, 0xc0, 0x13, 0x00, 0x30, 0x14, 0x00, 0x10, 0x2a, 0x00,
   0x90, 0x65, 0x00, 0x50, 0x64, 0x00, 0x30, 0x92, 0x00, 0x60, 0x89, 0x00,
   0xc0, 0x05, 0x01, 0x00, 0x03, 0x01, 0x04, 0x00, 0x02, 0x08, 0x00, 0x02,
   0x08, 0x00, 0x04, 0x11, 0x04, 0x04, 0x06, 0x03, 0x08, 0x88, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define c_intspl_width_small 22
#define c_intspl_height_small 22
static unsigned char c_intspl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width_small 22
#define c_spl_height_small 22
static unsigned char c_spl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width_small 22
#define cirdia_height_small 22
static unsigned char cirdia_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width_small 22
#define cirrad_height_small 22
static unsigned char cirrad_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width_small 22
#define convert_height_small 22
static unsigned char convert_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width_small 22
#define copy_height_small 22
static unsigned char copy_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width_small 22
#define delete_height_small 22
static unsigned char delete_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width_small 22
#define deletept_height_small 22
static unsigned char deletept_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width_small 22
#define edit_height_small 22
static unsigned char edit_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width_small 22
#define elldia_height_small 22
static unsigned char elldia_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width_small 22
#define ellrad_height_small 22
static unsigned char ellrad_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width_small 22
#define flip_x_height_small 22
static unsigned char flip_x_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width_small 22
#define flip_y_height_small 22
static unsigned char flip_y_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width_small 22
#define glue_height_small 22
static unsigned char glue_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width_small 22
#define intspl_height_small 22
static unsigned char intspl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width_small 22
#define line_height_small 22
static unsigned char line_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width_small 22
#define move_height_small 22
static unsigned char move_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width_small 22
#define movept_height_small 22
static unsigned char movept_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width_small 22
#define picobj_height_small 22
static unsigned char picobj_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width_small 45
#define library_height_small 22
static unsigned char library_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width_small 22
#define polygon_height_small 22
static unsigned char polygon_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width_small 22
#define regpoly_height_small 22
static unsigned char regpoly_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width_small 22
#define rotCCW_height_small 22
static unsigned char rotCCW_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width_small 22
#define rotCW_height_small 22
static unsigned char rotCW_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width_small 22
#define scale_height_small 22
static unsigned char scale_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width_small 22
#define spl_height_small 22
static unsigned char spl_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width_small 22
#define text_height_small 22
static unsigned char text_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width_small 22
#define update_height_small 22
static unsigned char update_bits_small[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define tangent_width_small 22
#define tangent_height_small 22
static unsigned char tangent_bits_small[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x0f,0x00,0x03,0x02,
 0x00,0x0c,0x02,0x24,0x10,0x02,0x2c,0x20,0x00,0x34,0x20,0x00,
 0x24,0x40,0x00,0x00,0x40,0x00,0xfe,0xff,0x03,0x00,0x40,0x00,
 0x00,0x40,0x00,0x00,0x20,0x00,0x00,0x20,0x00,0x00,0x10,0x00,
 0x00,0x0c,0x00,0x00,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,};
#define anglemeas_width_small 22
#define anglemeas_height_small 22
static unsigned char anglemeas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x36,0x00,0xc0,0x74,0x00,0xc0,
 0x84,0x01,0xc0,0x0e,0x02,0xc0,0x00,0x0c,0xc0,0x00,0x38,0xc0,0x00,0xc4,0xc8,
 0x00,0x84,0xd3,0x00,0x84,0xcb,0x00,0x68,0xd8,0x00,0x18,0xc0,0x06,0x06,0xc0,
 0x84,0x01,0xc0,0x66,0x00,0xc0,0x34,0x00,0xc0,0x36,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define lenmeas_width_small 22
#define lenmeas_height_small 22
static unsigned char lenmeas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0xf0,0x00,0xc0,0x8c,0xc0,0xcc,
 0x84,0xb0,0xc8,0x82,0x10,0xc9,0xc2,0x10,0xc9,0x60,0x08,0xc9,0x18,0x0c,0xcf,
 0x08,0x02,0xc0,0xf0,0x01,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x24,0x49,0xd2,0xfc,0xff,0xdf,0x00,0x00,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};
#define areameas_width_small 22
#define areameas_height_small 22
static unsigned char areameas_bits_small[] = {
 0x00,0x00,0xc0,0x00,0x00,0xc0,0x00,0x00,0xc0,0x80,0x01,0xc0,0xc0,0x03,0xc0,
 0x60,0x05,0xc0,0x50,0x0d,0xc0,0x58,0x15,0xc0,0x54,0x15,0xc0,0x56,0x35,0xc0,
 0x56,0x35,0xcc,0x56,0xf5,0xd7,0x56,0x55,0xd5,0x56,0x55,0xd5,0xdc,0x57,0xd5,
 0x78,0x5c,0xcd,0x18,0x58,0xc7,0x00,0xf8,0xc1,0x00,0x20,0xc0,0x00,0x00,0xc0,
 0x00,0x00,0xc0,0x00,0x00,0xc0};


/****** NORMAL SIZE ICONS ******/

#define regpoly_width_big 36
#define regpoly_height_big 32
static unsigned char regpoly_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width_big 36
#define addpt_height_big 32
static unsigned char addpt_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width_big 36
#define align_height_big 32
static unsigned char align_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width_big 36
#define arc_height_big 32
static unsigned char arc_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width_big 36
#define autoarrow_height_big 32
static unsigned char autoarrow_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width_big 36
#define box_height_big 32
static unsigned char box_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width_big 36
#define arc_box_height_big 32
static unsigned char arc_box_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width_big 36
#define cirdia_height_big 32
static unsigned char cirdia_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width_big 36
#define cirrad_height_big 32
static unsigned char cirrad_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width_big 36
#define convert_height_big 32
static unsigned char convert_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width_big 36
#define c_spl_height_big 32
static unsigned char c_spl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width_big 36
#define copy_height_big 32
static unsigned char copy_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width_big 36
#define glue_height_big 32
static unsigned char glue_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width_big 36
#define break_height_big 32
static unsigned char break_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width_big 36
#define open_comp_height_big 32
static unsigned char open_comp_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width_big 36
#define join_split_height_big 32
static unsigned char join_split_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define chop_width_big 36
#define chop_height_big 32
static unsigned char chop_bits_big[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x0c, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00,
   0x00, 0x00, 0xc0, 0x73, 0x00, 0x00, 0x00, 0x3c, 0xf0, 0x00, 0x00, 0x80,
   0x03, 0xe6, 0x00, 0x00, 0x80, 0x80, 0xe1, 0x01, 0x00, 0x80, 0x70, 0xc0,
   0x01, 0x00, 0x80, 0x0c, 0xd2, 0x03, 0x00, 0x80, 0x00, 0x89, 0x03, 0x00,
   0x80, 0xc0, 0xc8, 0x01, 0x00, 0x80, 0x21, 0x24, 0x03, 0x00, 0x00, 0x13,
   0x12, 0x03, 0x00, 0x00, 0x02, 0x09, 0x06, 0x00, 0x00, 0x06, 0x09, 0x06,
   0x00, 0x00, 0x8c, 0x04, 0x0c, 0x00, 0x00, 0x18, 0x02, 0x0c, 0x00, 0x00,
   0x60, 0x01, 0x18, 0x00, 0x20, 0xc0, 0x00, 0x18, 0x00, 0x40, 0x00, 0x00,
   0x30, 0x00, 0x40, 0x00, 0x00, 0x30, 0x00, 0x80, 0x00, 0x00, 0x60, 0x00,
   0x00, 0x01, 0x00, 0x60, 0x00, 0x00, 0x02, 0x40, 0xc0, 0x00, 0x08, 0x02,
   0x30, 0xc0, 0x00, 0x30, 0x04, 0x0c, 0x80, 0x01, 0xc0, 0x00, 0x03, 0x80,
   0x01, 0x00, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};


#define delete_width_big 36
#define delete_height_big 32
static unsigned char delete_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width_big 36
#define deletept_height_big 32
static unsigned char deletept_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width_big 36
#define elldia_height_big 32
static unsigned char elldia_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width_big 36
#define ellrad_height_big 32
static unsigned char ellrad_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width_big 36
#define flip_x_height_big 32
static unsigned char flip_x_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width_big 36
#define flip_y_height_big 32
static unsigned char flip_y_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width_big 36
#define intspl_height_big 32
static unsigned char intspl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width_big 36
#define c_intspl_height_big 32
static unsigned char c_intspl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width_big 36
#define line_height_big 32
static unsigned char line_bits_big[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width_big 73
#define library_height_big 32
static unsigned char library_bits_big[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width_big 36
#define move_height_big 32
static unsigned char move_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width_big 36
#define movept_height_big 32
static unsigned char movept_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width_big 36
#define polygon_height_big 32
static unsigned char polygon_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width_big 36
#define scale_height_big 32
static unsigned char scale_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width_big 36
#define spl_height_big 32
static unsigned char spl_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width_big 36
#define text_height_big 32
static unsigned char text_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width_big 36
#define picobj_height_big 32
static unsigned char picobj_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width_big 36
#define rotCCW_height_big 32
static unsigned char rotCCW_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width_big 36
#define rotCW_height_big 32
static unsigned char rotCW_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width_big 36
#define update_height_big 32
static unsigned char update_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width_big 36
#define edit_height_big 32
static unsigned char edit_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define areameas_width_big 36
#define areameas_height_big 32
static unsigned char areameas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0xee,0x00,0x00,0x00,0x00,0x27,0x01,0x00,0x00,0x80,
0x25,0x03,0x00,0x00,0xc0,0x24,0x05,0x00,0x00,0xe0,0x24,0x09,
0x00,0x00,0xa0,0x24,0x09,0x00,0x00,0xb0,0x24,0x19,0x00,0x00,
0xb0,0x24,0x19,0x00,0x00,0x98,0x24,0x39,0x00,0x00,0x98,0x24,
0x29,0x00,0x00,0x98,0x24,0x29,0x60,0x00,0x98,0x24,0xe9,0xdc,
0x00,0x98,0x24,0xc9,0x97,0x01,0x98,0x24,0x49,0x92,0x01,0x98,
0x24,0x49,0x92,0x01,0x90,0x24,0x49,0x92,0x01,0xb0,0xfc,0x49,
0x92,0x01,0xb0,0x0e,0x4b,0x92,0x00,0xe0,0x03,0x4e,0xd2,0x00,
0xc0,0x00,0x4c,0x72,0x00,0x00,0x00,0x4c,0x3a,0x00,0x00,0x00,
0xdc,0x07,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define tangent_width_big 36
#define tangent_height_big 32
static unsigned char tangent_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x7d,0x00,0x00,0xe0,0x00,0x11,
0x00,0x00,0x00,0x03,0x11,0x00,0x00,0x00,0x0c,0x11,0x00,0x00,
0x00,0x10,0x11,0x00,0x00,0x00,0x20,0x01,0x00,0x10,0x01,0x20,
0x01,0x00,0x30,0x01,0x40,0x01,0x00,0x50,0x01,0x40,0x01,0x00,
0x90,0x01,0x80,0x01,0x00,0x10,0x01,0x80,0x01,0x00,0x00,0x00,
0xc0,0x01,0x00,0xf8,0xff,0xff,0x3f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x80,0x01,0x00,0x00,0x00,0x80,0x01,0x00,0x00,
0x00,0x40,0x01,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x01,0x00,0x00,0x00,0x10,0x01,0x00,
0x00,0x00,0x0c,0x01,0x00,0x00,0x00,0x03,0x01,0x00,0x00,0xe0,
0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};
#define anglemeas_width_big 36
#define anglemeas_height_big 32
static unsigned char anglemeas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x07,0x00,0x00,
0x00,0x30,0x07,0x00,0x00,0x00,0x20,0x0f,0x00,0x00,0x00,0x20,
0x30,0x00,0x00,0x00,0x20,0x40,0x00,0x00,0x00,0x20,0x80,0x01,
0x00,0x00,0x70,0x00,0x06,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,
0x00,0x00,0x21,0xc0,0x00,0x00,0x80,0xc0,0x20,0x01,0x00,0x80,
0x00,0x0f,0x01,0x00,0x80,0x00,0x8e,0x00,0x00,0x80,0x00,0x4f,
0x00,0x00,0x80,0xc0,0x20,0x00,0x00,0x00,0x21,0xe0,0x01,0x00,
0x00,0x1a,0x00,0x00,0x30,0x00,0x06,0x00,0x00,0x48,0x80,0x01,
0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x30,0x30,0x00,0x00,0x00,
0x40,0x0f,0x00,0x00,0x00,0x48,0x07,0x00,0x00,0x00,0x30,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define lenmeas_width_big 36
#define lenmeas_height_big 32
static unsigned char lenmeas_bits_big[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x80,0x13,0x00,0x40,
0x00,0x70,0x10,0x80,0xc1,0x00,0x18,0x10,0xe0,0x83,0x01,0x08,
0x10,0x30,0x06,0x01,0x0c,0x10,0x10,0x0c,0x01,0x04,0x18,0x18,
0x08,0x01,0x04,0x08,0x08,0x0c,0x01,0x04,0x04,0x08,0x04,0x01,
0x00,0x03,0x0c,0x84,0x01,0xc0,0x00,0x06,0xdc,0x00,0x60,0x00,
0x03,0x70,0x00,0x60,0xc0,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x02,
0x08,0x21,0x84,0x10,0x02,0x08,0x21,0x84,0x10,0x02,0xf8,0xff,
0xff,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};


/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/

#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define grid_iso1_width 32					// isometric grid
#define grid_iso1_height 32
static unsigned char grid_iso1_bits[] = {
0x00,0x00,0x00,0x00,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0xc8,0x27,0x9f,0x7c,0x3e,0xf9,0xe4,0x13,
0x08,0x21,0x84,0x10,0x3e,0xf9,0xe4,0x13,0xc8,0x27,0x9f,0x7c,
0x08,0x21,0x84,0x10,0x00,0x00,0x00,0x00};

#define grid_iso2_width 32
#define grid_iso2_height 32
static unsigned char grid_iso2_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,
0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,
0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,
0x20,0x7c,0x08,0x1f,0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,
0x26,0x93,0xc9,0x64,0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,
0xf8,0x10,0x3e,0x04,0x26,0x93,0xc9,0x64,0x20,0x7c,0x08,0x1f,
0x20,0x10,0x08,0x04,0x20,0x7c,0x08,0x1f,0x26,0x93,0xc9,0x64,
0xf8,0x10,0x3e,0x04,0x20,0x10,0x08,0x04,0xf8,0x10,0x3e,0x04,
0x26,0x93,0xc9,0x64,0x00,0x00,0x00,0x00};

#define grid_iso3_width 32
#define grid_iso3_height 32
static unsigned char grid_iso3_bits[] = {
0x00,0x00,0x00,0x00,0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,
0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,
0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,
0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,0x40,0xe0,0x03,0x01,
0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,0xf0,0x81,0xc0,0x07,
0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,0x4c,0x86,0x30,0x19,
0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,0x40,0x80,0x00,0x01,
0x40,0xe0,0x03,0x01,0x42,0x98,0x0c,0x61,0x4c,0x86,0x30,0x19,
0xf0,0x81,0xc0,0x07,0x40,0x80,0x00,0x01,0xf0,0x81,0xc0,0x07,
0x4c,0x86,0x30,0x19,0x42,0x98,0x0c,0x61,0x40,0xe0,0x03,0x01,
0x40,0x80,0x00,0x01,0x00,0x00,0x00,0x00};

#define grid_iso4_width 32
#define grid_iso4_height 32
static unsigned char grid_iso4_bits[] = {
0x00,0x00,0x00,0x00,0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,
0x60,0x32,0x40,0x00,0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,
0x80,0x0f,0x40,0x00,0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,
0x06,0x02,0x43,0x18,0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,
0x00,0x02,0x40,0x00,0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,
0x06,0x02,0x43,0x18,0x18,0xc2,0x40,0x60,0x60,0x32,0x40,0x00,
0x80,0x0f,0x40,0x00,0x00,0x02,0x40,0x00,0x80,0x0f,0x40,0x00,
0x60,0x32,0x40,0x00,0x18,0xc2,0x40,0x60,0x06,0x02,0x43,0x18,
0x00,0x02,0x4c,0x06,0x00,0x02,0xf0,0x01,0x00,0x02,0x40,0x00,
0x00,0x02,0xf0,0x01,0x00,0x02,0x4c,0x06,0x06,0x02,0x43,0x18,
0x18,0xc2,0x40,0x60,0x00,0x00,0x00,0x00};


#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};


/* Define structs for icons with two size variations */
icon_struct	regpoly_ic;
icon_struct	addpt_ic;
icon_struct	align_ic;
icon_struct	arc_ic;
icon_struct	autoarrow_ic;
icon_struct	box_ic;
icon_struct	arc_box_ic;
icon_struct	cirrad_ic;
icon_struct	cirdia_ic;
icon_struct	c_spl_ic;
icon_struct	intspl_ic;
icon_struct	c_intspl_ic;
icon_struct	copy_ic;
icon_struct	glue_ic;
icon_struct	break_ic;
icon_struct	open_comp_ic;
icon_struct	join_split_ic;
icon_struct	chop_ic;
icon_struct	deletept_ic;
icon_struct	ellrad_ic;
icon_struct	elldia_ic;
icon_struct	flip_x_ic;
icon_struct	flip_y_ic;
icon_struct	line_ic;
icon_struct	library_ic;
icon_struct	move_ic;
icon_struct	movept_ic;
icon_struct	polygon_ic;
icon_struct	delete_ic;
icon_struct	rotCCW_ic;
icon_struct	scale_ic;
icon_struct	convert_ic;
icon_struct	spl_ic;
icon_struct	text_ic;
icon_struct	picobj_ic;
icon_struct	rotCW_ic;
icon_struct	update_ic;
icon_struct	edit_ic;
icon_struct	tangent_ic;
icon_struct	anglemeas_ic;
icon_struct	lenmeas_ic;
icon_struct	areameas_ic;



void populate_icons_big()
{
	icon_struct	regpoly_ic_ = { regpoly_width_big, regpoly_height_big, (char*)regpoly_bits_big };
	icon_struct	addpt_ic_ = { addpt_width_big, addpt_height_big, (char*)addpt_bits_big };
	icon_struct	align_ic_ = { align_width_big, align_height_big, (char*)align_bits_big };
	icon_struct	arc_ic_ = { arc_width_big, arc_height_big, (char*)arc_bits_big };
	icon_struct	autoarrow_ic_ = { autoarrow_width_big, autoarrow_height_big, (char*)autoarrow_bits_big };
	icon_struct	box_ic_ = { box_width_big, box_height_big, (char*)box_bits_big };
	icon_struct	arc_box_ic_ = { arc_box_width_big, arc_box_height_big, (char*)arc_box_bits_big };
	icon_struct	cirrad_ic_ = { cirrad_width_big, cirrad_height_big, (char*)cirrad_bits_big };
	icon_struct	cirdia_ic_ = { cirdia_width_big, cirdia_height_big, (char*)cirdia_bits_big };
	icon_struct	c_spl_ic_ = { c_spl_width_big, c_spl_height_big, (char*)c_spl_bits_big };
	icon_struct	intspl_ic_ = { intspl_width_big, intspl_height_big, (char*)intspl_bits_big };
	icon_struct	c_intspl_ic_ = { c_intspl_width_big, c_intspl_height_big, (char*)c_intspl_bits_big };
	icon_struct	copy_ic_ = { copy_width_big, copy_height_big, (char*)copy_bits_big };
	icon_struct	glue_ic_ = { glue_width_big, glue_height_big, (char*)glue_bits_big };
	icon_struct	break_ic_ = { break_width_big, break_height_big, (char*)break_bits_big };
	icon_struct	open_comp_ic_ = { open_comp_width_big, open_comp_height_big, (char*)open_comp_bits_big };
	icon_struct	join_split_ic_ = { join_split_width_big, join_split_height_big, (char*)join_split_bits_big };
	icon_struct	chop_ic_ = { chop_width_big, chop_height_big, (char*)chop_bits_big };
	icon_struct	deletept_ic_ = { deletept_width_big, deletept_height_big, (char*)deletept_bits_big };
	icon_struct	ellrad_ic_ = { ellrad_width_big, ellrad_height_big, (char*)ellrad_bits_big };
	icon_struct	elldia_ic_ = { elldia_width_big, elldia_height_big, (char*)elldia_bits_big };
	icon_struct	flip_x_ic_ = { flip_x_width_big, flip_x_height_big, (char*)flip_x_bits_big };
	icon_struct	flip_y_ic_ = { flip_y_width_big, flip_y_height_big, (char*)flip_y_bits_big };
	icon_struct	line_ic_ = { line_width_big, line_height_big, (char*)line_bits_big };
	icon_struct	library_ic_ = {library_width_big, library_height_big, (char*)library_bits_big };
	icon_struct	move_ic_ = { move_width_big, move_height_big, (char*)move_bits_big };
	icon_struct	movept_ic_ = { movept_width_big, movept_height_big, (char*)movept_bits_big };
	icon_struct	polygon_ic_ = { polygon_width_big, polygon_height_big, (char*)polygon_bits_big };
	icon_struct	delete_ic_ = { delete_width_big, delete_height_big, (char*)delete_bits_big };
	icon_struct	rotCCW_ic_ = { rotCCW_width_big, rotCCW_height_big, (char*)rotCCW_bits_big };
	icon_struct	scale_ic_ = { scale_width_big, scale_height_big, (char*)scale_bits_big };
	icon_struct	convert_ic_ = { convert_width_big, convert_height_big, (char*)convert_bits_big };
	icon_struct	spl_ic_ = { spl_width_big, spl_height_big, (char*)spl_bits_big };
	icon_struct	text_ic_ = { text_width_big, text_height_big, (char*)text_bits_big };
	icon_struct	picobj_ic_ = { picobj_width_big, picobj_height_big, (char*)picobj_bits_big };
	icon_struct	rotCW_ic_ = { rotCW_width_big, rotCW_height_big, (char*)rotCW_bits_big };
	icon_struct	update_ic_ = { update_width_big, update_height_big, (char*)update_bits_big };
	icon_struct	edit_ic_ = { edit_width_big, edit_height_big, (char*)edit_bits_big };
	icon_struct	tangent_ic_ = { tangent_width_big, tangent_height_big, (char*)tangent_bits_big };
	icon_struct	anglemeas_ic_ = { anglemeas_width_big, anglemeas_height_big, (char*)anglemeas_bits_big };
	icon_struct	lenmeas_ic_ = { lenmeas_width_big, lenmeas_height_big, (char*)lenmeas_bits_big };
	icon_struct	areameas_ic_ = { areameas_width_big, areameas_height_big, (char*)areameas_bits_big };
	regpoly_ic = regpoly_ic_;
	addpt_ic = addpt_ic_;
	align_ic = align_ic_;
	arc_ic = arc_ic_;
	autoarrow_ic = autoarrow_ic_;
	box_ic = box_ic_;
	arc_box_ic = arc_box_ic_;
	cirrad_ic = cirrad_ic_;
	cirdia_ic = cirdia_ic_;
	c_spl_ic = c_spl_ic_;
	intspl_ic = intspl_ic_;
	c_intspl_ic = c_intspl_ic_;
	copy_ic = copy_ic_;
	glue_ic = glue_ic_;
	break_ic = break_ic_;
	open_comp_ic = open_comp_ic_;
	join_split_ic = join_split_ic_;
	chop_ic = chop_ic_;
	deletept_ic = deletept_ic_;
	ellrad_ic = ellrad_ic_;
	elldia_ic = elldia_ic_;
	flip_x_ic = flip_x_ic_;
	flip_y_ic = flip_y_ic_;
	line_ic = line_ic_;
	library_ic = library_ic_;
	move_ic = move_ic_;
	movept_ic = movept_ic_;
	polygon_ic = polygon_ic_;
	delete_ic = delete_ic_;
	rotCCW_ic = rotCCW_ic_;
	scale_ic = scale_ic_;
	convert_ic = convert_ic_;
	spl_ic = spl_ic_;
	text_ic = text_ic_;
	picobj_ic = picobj_ic_;
	rotCW_ic = rotCW_ic_;
	update_ic = update_ic_;
	edit_ic = edit_ic_;
	tangent_ic = tangent_ic_;
	anglemeas_ic = anglemeas_ic_;
	lenmeas_ic = lenmeas_ic_;
	areameas_ic = areameas_ic_;
}


void populate_icons_small()
{
	icon_struct	regpoly_ic_ = { regpoly_width_small, regpoly_height_small, (char*)regpoly_bits_small };
	icon_struct	addpt_ic_ = { addpt_width_small, addpt_height_small, (char*)addpt_bits_small };
	icon_struct	align_ic_ = { align_width_small, align_height_small, (char*)align_bits_small };
	icon_struct	arc_ic_ = { arc_width_small, arc_height_small, (char*)arc_bits_small };
	icon_struct	autoarrow_ic_ = { autoarrow_width_small, autoarrow_height_small, (char*)autoarrow_bits_small };
	icon_struct	box_ic_ = { box_width_small, box_height_small, (char*)box_bits_small };
	icon_struct	arc_box_ic_ = { arc_box_width_small, arc_box_height_small, (char*)arc_box_bits_small };
	icon_struct	cirrad_ic_ = { cirrad_width_small, cirrad_height_small, (char*)cirrad_bits_small };
	icon_struct	cirdia_ic_ = { cirdia_width_small, cirdia_height_small, (char*)cirdia_bits_small };
	icon_struct	c_spl_ic_ = { c_spl_width_small, c_spl_height_small, (char*)c_spl_bits_small };
	icon_struct	intspl_ic_ = { intspl_width_small, intspl_height_small, (char*)intspl_bits_small };
	icon_struct	c_intspl_ic_ = { c_intspl_width_small, c_intspl_height_small, (char*)c_intspl_bits_small };
	icon_struct	copy_ic_ = { copy_width_small, copy_height_small, (char*)copy_bits_small };
	icon_struct	glue_ic_ = { glue_width_small, glue_height_small, (char*)glue_bits_small };
	icon_struct	break_ic_ = { break_width_small, break_height_small, (char*)break_bits_small };
	icon_struct	open_comp_ic_ = { open_comp_width_small, open_comp_height_small, (char*)open_comp_bits_small };
	icon_struct	join_split_ic_ = { join_split_width_small, join_split_height_small, (char*)join_split_bits_small };
	icon_struct	chop_ic_ = { chop_width_small, chop_height_small, (char*)chop_bits_small };
	icon_struct	deletept_ic_ = { deletept_width_small, deletept_height_small, (char*)deletept_bits_small };
	icon_struct	ellrad_ic_ = { ellrad_width_small, ellrad_height_small, (char*)ellrad_bits_small };
	icon_struct	elldia_ic_ = { elldia_width_small, elldia_height_small, (char*)elldia_bits_small };
	icon_struct	flip_x_ic_ = { flip_x_width_small, flip_x_height_small, (char*)flip_x_bits_small };
	icon_struct	flip_y_ic_ = { flip_y_width_small, flip_y_height_small, (char*)flip_y_bits_small };
	icon_struct	line_ic_ = { line_width_small, line_height_small, (char*)line_bits_small };
	icon_struct	library_ic_ = {library_width_small, library_height_small, (char*)library_bits_small };
	icon_struct	move_ic_ = { move_width_small, move_height_small, (char*)move_bits_small };
	icon_struct	movept_ic_ = { movept_width_small, movept_height_small, (char*)movept_bits_small };
	icon_struct	polygon_ic_ = { polygon_width_small, polygon_height_small, (char*)polygon_bits_small };
	icon_struct	delete_ic_ = { delete_width_small, delete_height_small, (char*)delete_bits_small };
	icon_struct	rotCCW_ic_ = { rotCCW_width_small, rotCCW_height_small, (char*)rotCCW_bits_small };
	icon_struct	scale_ic_ = { scale_width_small, scale_height_small, (char*)scale_bits_small };
	icon_struct	convert_ic_ = { convert_width_small, convert_height_small, (char*)convert_bits_small };
	icon_struct	spl_ic_ = { spl_width_small, spl_height_small, (char*)spl_bits_small };
	icon_struct	text_ic_ = { text_width_small, text_height_small, (char*)text_bits_small };
	icon_struct	picobj_ic_ = { picobj_width_small, picobj_height_small, (char*)picobj_bits_small };
	icon_struct	rotCW_ic_ = { rotCW_width_small, rotCW_height_small, (char*)rotCW_bits_small };
	icon_struct	update_ic_ = { update_width_small, update_height_small, (char*)update_bits_small };
	icon_struct	edit_ic_ = { edit_width_small, edit_height_small, (char*)edit_bits_small };
	icon_struct	tangent_ic_ = { tangent_width_small, tangent_height_small, (char*)tangent_bits_small };
	icon_struct	anglemeas_ic_ = { anglemeas_width_small, anglemeas_height_small, (char*)anglemeas_bits_small };
	icon_struct	lenmeas_ic_ = { lenmeas_width_small, lenmeas_height_small, (char*)lenmeas_bits_small };
	icon_struct	areameas_ic_ = { areameas_width_small, areameas_height_small, (char*)areameas_bits_small };
	regpoly_ic = regpoly_ic_;
	addpt_ic = addpt_ic_;
	align_ic = align_ic_;
	arc_ic = arc_ic_;
	autoarrow_ic = autoarrow_ic_;
	box_ic = box_ic_;
	arc_box_ic = arc_box_ic_;
	cirrad_ic = cirrad_ic_;
	cirdia_ic = cirdia_ic_;
	c_spl_ic = c_spl_ic_;
	intspl_ic = intspl_ic_;
	c_intspl_ic = c_intspl_ic_;
	copy_ic = copy_ic_;
	glue_ic = glue_ic_;
	break_ic = break_ic_;
	open_comp_ic = open_comp_ic_;
	join_split_ic = join_split_ic_;
	chop_ic = chop_ic_;
	deletept_ic = deletept_ic_;
	ellrad_ic = ellrad_ic_;
	elldia_ic = elldia_ic_;
	flip_x_ic = flip_x_ic_;
	flip_y_ic = flip_y_ic_;
	line_ic = line_ic_;
	library_ic = library_ic_;
	move_ic = move_ic_;
	movept_ic = movept_ic_;
	polygon_ic = polygon_ic_;
	delete_ic = delete_ic_;
	rotCCW_ic = rotCCW_ic_;
	scale_ic = scale_ic_;
	convert_ic = convert_ic_;
	spl_ic = spl_ic_;
	text_ic = text_ic_;
	picobj_ic = picobj_ic_;
	rotCW_ic = rotCW_ic_;
	update_ic = update_ic_;
	edit_ic = edit_ic_;
	tangent_ic = tangent_ic_;
	anglemeas_ic = anglemeas_ic_;
	lenmeas_ic = lenmeas_ic_;
	areameas_ic = areameas_ic_;
}




/* create the data structures for them */

icon_struct	open_arc_ic = { open_arc_width, open_arc_height,
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height,
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height,
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height,
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height,
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height,
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height,
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height,
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height,
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height,
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height,
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height,
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height,
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height,
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height,
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	grid_iso1_ic = { grid_iso1_width, grid_iso1_height,		// isometric grid
				(char*)grid_iso1_bits };
icon_struct	grid_iso2_ic = { grid_iso2_width, grid_iso2_height,
				(char*)grid_iso2_bits };
icon_struct	grid_iso3_ic = { grid_iso3_width, grid_iso3_height,
				(char*)grid_iso3_bits };
icon_struct	grid_iso4_ic = { grid_iso4_width, grid_iso4_height,
				(char*)grid_iso4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height,
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height,
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height,
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height,
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height,
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height,
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height,
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height,
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height,
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height,
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height,
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height,
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height,
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height,
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height,
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height,
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height,
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height,
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height,
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height,
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height,
				(char*)fbarrows_bits };


/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define no_arrow_width 32
#define no_arrow_height 32
unsigned char no_arrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x04,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x24,0x32,0xd1,0x13,
0x24,0x4a,0x51,0x10,0x62,0x4a,0x53,0x20,0x62,0x4a,0x53,0x20,
0xa2,0x4a,0xd5,0x21,0xa2,0x4a,0x55,0x20,0x22,0x4b,0x59,0x20,
0x22,0x4b,0x59,0x20,0x24,0x4a,0x51,0x10,0x24,0x32,0xd1,0x13,
0x08,0x00,0x00,0x08,0x08,0x00,0x00,0x08,0x10,0x00,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x40, 0x00, 0x06,
  0x00, 0x20, 0xe0, 0x01, 0x00, 0x10, 0x1e, 0x00, 0x00, 0xe8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0x10, 0x0f, 0x00, 0x00, 0x20, 0x70, 0x00,
  0x00, 0x40, 0x80, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x07,
  0x00, 0xe0, 0xff, 0x01, 0x00, 0xf0, 0x1f, 0x00, 0x00, 0xf8, 0x01, 0x00,
  0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow10o_width 32
#define arrow10o_height 32
unsigned char arrow10o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0x08,0x1f,0x00,0x00,0x08,0xf0,0x01,
 0xf8,0xff,0xff,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow10f_width 32
#define arrow10f_height 32
unsigned char arrow10f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00,
  0x00, 0xf8, 0x01, 0x00, 0x00, 0xf8, 0x1f, 0x00, 0x00, 0xf8, 0xff, 0x01,
  0xf8, 0xff, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow11o_width 32
#define arrow11o_height 32
unsigned char arrow11o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1c,0x00,0x00,0x00,
 0xe8,0x01,0x00,0x00,0x10,0x1e,0x00,0x00,0x20,0xe0,0x01,0x00,0x40,0x00,0x06,
 0xfc,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow11f_width 32
#define arrow11f_height 32
unsigned char arrow11f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
  0x00, 0xf8, 0x00, 0x00, 0x00, 0xf0, 0x0f, 0x00, 0x00, 0xe0, 0x7f, 0x00,
  0x00, 0xc0, 0xff, 0x07, 0xfc, 0xff, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow12o_width 32
#define arrow12o_height 32
unsigned char arrow12o_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x03,0x00,0x00,0x80,0x1c,0x00,0x00,0x80,0xe0,0x01,0x00,0x40,0x00,0x0e,
 0xf0,0xff,0xff,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow12f_width 32
#define arrow12f_height 32
unsigned char arrow12f_bits[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x03, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x80, 0xff, 0x01,
  0x00, 0xc0, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };
#define arrow13a_width 32
#define arrow13a_height 32
unsigned char arrow13a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow13b_width 32
#define arrow13b_height 32
unsigned char arrow13b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14a_width 32
#define arrow14a_height 32
unsigned char arrow14a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow14b_width 32
#define arrow14b_height 32
unsigned char arrow14b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
icon_struct	no_arrow_ic = { no_arrow_width, no_arrow_height,
			      (char*)no_arrow_bits };
icon_struct	arrow0_ic = { arrow0_width, arrow0_height,
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height,
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height,
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height,
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height,
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height,
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height,
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height,
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height,
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height,
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height,
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height,
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height,
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height,
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height,
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height,
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height,
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height,
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height,
			      (char*)arrow9b_bits };
icon_struct	arrow10o_ic = { arrow10o_width, arrow10o_height,
			      (char*)arrow10o_bits };
icon_struct	arrow10f_ic = { arrow10f_width, arrow10f_height,
			      (char*)arrow10f_bits };
icon_struct	arrow11o_ic = { arrow11o_width, arrow11o_height,
			      (char*)arrow11o_bits };
icon_struct	arrow11f_ic = { arrow11f_width, arrow11f_height,
			      (char*)arrow11f_bits };
icon_struct	arrow12o_ic = { arrow12o_width, arrow12o_height,
			      (char*)arrow12o_bits };
icon_struct	arrow12f_ic = { arrow12f_width, arrow12f_height,
			      (char*)arrow12f_bits };
icon_struct	arrow13a_ic = { arrow13a_width, arrow13a_height,
			      (char*)arrow13a_bits };
icon_struct	arrow13b_ic = { arrow13b_width, arrow13b_height,
			      (char*)arrow13b_bits };
icon_struct	arrow14a_ic = { arrow14a_width, arrow14a_height,
			      (char*)arrow14a_bits };
icon_struct	arrow14b_ic = { arrow14b_width, arrow14b_height,
			      (char*)arrow14b_bits };

icon_struct	printer_ic = { printer_width, printer_height,
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

/* new icon from Marc-Aurle Darche */

#define fig_width 64
#define fig_height 64
static char fig_bits[] = {
 0x55,0x55,0x55,0x55,0x55,0xb5,0x6d,0xdb,0x55,0x55,0xa9,0xa4,0x54,0xd5,0xb6,
 0xb5,0x2a,0x95,0x4a,0x95,0xd2,0x6a,0xdb,0xde,0xa9,0x52,0xaa,0x52,0xf5,0xab,
 0x6d,0x6b,0x55,0x55,0x49,0xaa,0xea,0xd7,0xaa,0xd5,0xaa,0x4a,0x25,0x49,0x6a,
 0x2b,0xb7,0xbe,0xa5,0x2a,0x55,0xa5,0xd2,0xdf,0xda,0xd5,0x9a,0x54,0x29,0x95,
 0xd4,0x5f,0xad,0xba,0xa5,0x52,0xa5,0x52,0xea,0xfb,0x76,0xd7,0x55,0x95,0x14,
 0x49,0xe5,0xef,0xda,0xba,0xaa,0xaa,0xaa,0x54,0xf2,0xff,0x6b,0xdb,0xaa,0x24,
 0x49,0x25,0xb5,0xef,0xad,0xad,0x95,0xaa,0x24,0x92,0xf4,0xfe,0xdb,0xf6,0x54,
 0x55,0x55,0xa9,0xfa,0xff,0x6f,0xad,0xab,0x4a,0x55,0x25,0xf9,0x6f,0xbf,0xbb,
 0x54,0x02,0x00,0x95,0xac,0xfb,0xfd,0xd6,0x4a,0x1f,0x50,0x19,0x80,0x5e,0xef,
 0xbb,0x55,0x1f,0xe0,0x7a,0x50,0xeb,0xfa,0xdd,0xaa,0x3e,0xe0,0x3d,0xf8,0x5f,
 0xbf,0xb7,0x55,0x5f,0xe0,0x3c,0xfc,0xea,0xea,0xdf,0x4a,0x7f,0x40,0x1d,0xff,
 0x5d,0xbf,0xbf,0xaa,0x7e,0xc2,0x4e,0xff,0xeb,0xfa,0xdf,0x55,0xf5,0x40,0x84,
 0x7f,0x5f,0xef,0x7e,0xaa,0xf2,0x80,0xe5,0xdf,0xb7,0xfb,0xff,0x55,0x6a,0x81,
 0xf2,0xfb,0xed,0xbe,0xbf,0xaa,0xea,0x89,0xf0,0x7f,0xbf,0xf7,0xff,0xa5,0xea,
 0x01,0xfc,0xff,0xfd,0xde,0x7f,0x54,0xd5,0x03,0xfe,0xff,0xef,0xff,0xff,0x95,
 0xa4,0x03,0xf6,0xef,0xbf,0xff,0xff,0x55,0xd5,0x15,0xf6,0xbf,0xf7,0xfb,0x7f,
 0x55,0x95,0x43,0xf4,0xff,0xff,0xbf,0xff,0xaa,0xaa,0x07,0xea,0xff,0xff,0xff,
 0xff,0xaa,0x54,0x03,0xf4,0xff,0xee,0xfe,0xff,0xaa,0x52,0x11,0xec,0xff,0xff,
 0xff,0x7f,0xaa,0xca,0x18,0xe8,0xff,0xff,0xff,0xff,0x55,0x55,0x1c,0xe8,0xff,
 0xff,0xff,0xbf,0xaa,0x6a,0x2e,0xf0,0xff,0xff,0xff,0xff,0x52,0x15,0xbf,0xd0,
 0xff,0xff,0xff,0x5f,0xaa,0x9a,0x3f,0xaa,0x1f,0x9c,0xff,0xff,0x95,0xc6,0x7b,
 0xa0,0x07,0x04,0xff,0xaf,0xaa,0xd2,0x7a,0x69,0x07,0x00,0xfe,0xbf,0x5b,0xe3,
 0xba,0x40,0x03,0x08,0xff,0xef,0xd5,0x78,0xf5,0x64,0x45,0x0f,0xff,0xd7,0x6d,
 0x74,0x75,0x89,0xe1,0xff,0x7f,0xfa,0xb6,0x5c,0xf5,0xa1,0x02,0x00,0x0f,0x80,
 0x0b,0xe8,0x5a,0x04,0x05,0x81,0x0f,0x80,0x42,0xa2,0x8e,0x50,0x0c,0x80,0x03,
 0x81,0xbd,0xbd,0x7d,0xbf,0xd7,0x96,0xa3,0xe9,0xff,0xff,0xfe,0xff,0xe2,0xc3,
 0xc2,0xe0,0xff,0x77,0xfd,0xff,0xe9,0x83,0x83,0xe8,0x55,0xad,0x56,0x55,0x51,
 0x53,0x4b,0xb0,0xaa,0xb5,0xab,0xea,0xe0,0xc2,0x07,0xf8,0xdd,0x56,0x75,0xbf,
 0x52,0xcb,0x1e,0xfa,0x6b,0xbb,0xad,0xd5,0xe0,0x41,0x8e,0xdf,0xad,0xd5,0xda,
 0xea,0x54,0x25,0x06,0xf8,0xb6,0x6e,0x6f,0xbf,0xf0,0x03,0x01,0xd0,0xdb,0x55,
 0xb5,0xd5,0x54,0x89,0x60,0xe0,0xad,0xba,0x5b,0x6d,0xf0,0xeb,0xa1,0xc1,0xea,
 0x6e,0xed,0x0b,0x5d,0xbf,0xe9,0xca,0xbf,0xd5,0xb6,0x06,0xb8,0xfd,0x01,0xe0,
 0x52,0xbb,0xdb,0x05,0xde,0x77,0x13,0xf0,0xef,0xd6,0xb6,0x2e,0x77,0xff,0x85,
 0xb8,0x5a,0x7b,0xdb,0xab,0xef,0xdd,0x5f,0xff,0xed,0xad,0x6d,0xfd,0xfb,0xf7,
 0xff,0xef};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM

/* XPM version of xfig icon - first in full color for TrueColor displays,
   then in reduced color for 256 color-mapped displays */

char * fig_full_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64      253            2",
/* colors */
".. c #050804", ".# c #138820", ".a c #793d26", ".b c #ac8664", ".c c #084808", ".d c #74622c",
".e c #e0c68c", ".f c #d0895b", ".g c #3f180a", ".h c #ae643e", ".i c #47511c", ".j c #9c522e",
".k c #ccaa74", ".l c #066813", ".m c #785030", ".n c #412f27", ".o c #b17859", ".p c #eda870",
".q c #117611", ".r c #072804", ".s c #84767c", ".t c #f9e6a4", ".u c #60301f", ".v c #925132",
".w c #ed9967", ".x c #748634", ".y c #1b9c2c", ".z c #07580d", ".A c #9a6350", ".B c #eac8c4",
".C c #cc986c", ".D c #c5774e", ".E c #efb97f", ".F c #b09ea8", ".G c #603b30", ".H c #8c4930",
".I c #342818", ".J c #bb8863", ".K c #b27052", ".L c #7a4730", ".M c #1e6818", ".N c #073707",
".O c #9b6f4f", ".P c #248822", ".Q c #24791f", ".R c #9e5834", ".S c #ae786a", ".T c #8e5b3d",
".U c #1f5717", ".V c #d4a6a0", ".W c #805c3e", ".X c #43251e", ".Y c #b98b84", ".Z c #260f05",
".0 c #eca99d", ".1 c #10801e", ".2 c #e9d9df", ".3 c #d1998e", ".4 c #ae5e39", ".5 c #0a7015",
".6 c #613247", ".7 c #086011", ".8 c #074008", ".9 c #14480e", "#. c #e9dd9c", "## c #cd8d7f",
"#a c #623c3f", "#b c #a05853", "#c c #1c9428", "#d c #924f52", "#e c #279b29", "#f c #f1b7ad",
"#g c #4c2413", "#h c #996960", "#i c #753e49", "#j c #ac6554", "#k c #74514f", "#l c #bd704a",
"#m c #5e4732", "#n c #b27e5b", "#o c #7c4745", "#p c #d5babe", "#q c #766667", "#r c #522f28",
"#s c #f8c9c3", "#t c #c4966c", "#u c #041804", "#v c #fae8e6", "#w c #a4634b", "#x c #ca8055",
"#y c #1c7f21", "#z c #1c892a", "#A c #0a500f", "#B c #d29062", "#C c #f3af77", "#D c #a27759",
"#E c #6c3521", "#F c #6c3c2f", "#G c #c48a60", "#H c #997169", "#I c #ae8069", "#J c #dd9d90",
"#K c #fbc88b", "#L c #146818", "#M c #84503c", "#N c #082f05", "#O c #603629", "#P c #de9966",
"#Q c #14380a", "#R c #259425", "#S c #f0b0a5", "#T c #146016", "#U c #25a430", "#V c #605e24",
"#W c #51372f", "#X c #bc6843", "#Y c #bc7852", "#Z c #1c7720", "#0 c #945638", "#1 c #145812",
"#2 c #ac715c", "#3 c #1e6f16", "#4 c #b99391", "#5 c #2f1c15", "#6 c #147019", "#7 c #14400a",
"#8 c #522a32", "#9 c #746e6c", "a. c #f7d0cb", "a# c #94868c", "aa c #e2b982", "ab c #bfadb4",
"ac c #ac9aa0", "ad c #fcfafa", "ae c #e3a774", "af c #4f4947", "ag c #f0a290", "ah c #f8d7d3",
"ai c #fbf7b0", "aj c #896240", "ak c #fcd898", "al c #1a0a04", "am c #2c3614", "an c #e3a89e",
"ao c #87645e", "ap c #685048", "aq c #a07972", "ar c #e4a694", "as c #c4a4a8", "at c #a7888f",
"au c #888084", "av c #ef9f69", "aw c #f1bf87", "ax c #d9c1c4", "ay c #f0bfba", "az c #dcd294",
"aA c #052004", "aB c #6c4834", "aC c #9c5150", "aD c #1d6012", "aE c #fbe1e0", "aF c #904a52",
"aG c #805e54", "aH c #844225", "aI c #b9877c", "aJ c #6c3644", "aK c #6c3b46", "aL c #84534c",
"aM c #c4948e", "aN c #25811f", "aO c #d49f96", "aP c #14500e", "aQ c #fceff0", "aR c #a48264",
"aS c #fbd092", "aT c #e2a06e", "aU c #e4b078", "aV c #a17f79", "aW c #fcb87e", "aX c #a46f4e",
"aY c #e4b6b0", "aZ c #fcb076", "a0 c #341404", "a1 c #443a24", "a2 c #cf9f6f", "a3 c #c48e84",
"a4 c #c48879", "a5 c #041004", "a6 c #fce09c", "a7 c #aa8784", "a8 c #dc885f", "a9 c #fc9a74",
"b. c #844830", "b# c #8f5b4e", "ba c #fcaa94", "bb c #ac5e54", "bc c #a46a5c", "bd c #844847",
"be c #d4825a", "bf c #a47264", "bg c #bc806f", "bh c #fcb29c", "bi c #1c7228", "bj c #343234",
"bk c #148e25", "bl c #401e13", "bm c #78563f", "bn c #e4ced4", "bo c #ceaeae", "bp c #cf9285",
"bq c #4f2a1e", "br c #846a4c", "bs c #8a6a69", "bt c #94766c", "bu c #fca284", "bv c #fcaa74",
"bw c #bc7a64", "bx c #fcbab1", "by c #bc8059", "bz c #dc915f", "bA c #143204", "bB c #fcc084",
"bC c #fcc1b5", "bD c #141a04", "bE c #8c7274", "bF c #ecd094", "bG c #6c4846", "bH c #a46a51",
"bI c #1c8e24", "bJ c #78422e", "bK c #b36a43", "bL c #1ca22c", "bM c #9c6a52", "bN c #5c4234",
"bO c #b68e6a", "bP c #278e20", "bQ c #a45e39", "bR c #422a20", "bS c #633642", "bT c #a05e4f",
"bU c #945651", "bV c #7b4246", "bW c #ac6a54", "bX c #795651", "bY c #e0a297", "bZ c #bc9a99",
"b0 c #342214", "b1 c #c4b2b4", "b2 c #e4aea6", "b3 c #ecc68c", "b4 c #7c4f3f", "b5 c #0f781d",
"b6 c #5c3231",
/* pixels */
"bK.h#XbKbK#X#l#X#l#l#l#l#l#l#l#l.D#l.D.D#Y.D.D#Y.D.D#Y.D.D#Y#l.D#l#l#l#l#l#l#XbKbKbK.h.h.h.h.h.hbQ.4bQ.R.R.R.R.R.R.j.R.v.j.v.j.v",
"bK#XbKbK#lbK#lbK#l#l#l#l#l.D#l.D#l.D#Y#l.D#l#Y.D#Y#Y.D#Y#Y.D.D#l.D.D#l#l#l#l.ObK#XbK#XbK.h.h.h.4.4bQbQbQ.4.R.R.R.j.j.j.j.j.j.v.v",
"bKbKbK#XbK#l#l#l#l#l#l#l#l.D#l.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y.D#Y#l.D.D#l.xbk.5.hbKbKbK.h.h.h.4bQ.4bQ.RbQ.R.R.R.R.R.j.j.j.v.v.j",
".hbK#lbK#X#l#X#l#l#l#l.D#l.D#Y.D#Y#Y.D#Y#Y#x#Yby.D#Yby#Y#x#Y#Y#Y#Y.D#Y#Y.h.z.q.1.7bKbK#XbK.h.h.h.hbQbQ.4.RbQ.R.R.R.j#0.j.j.v.v.v",
"#X#XbK#l#lbK#l#l#l#l.D#l#Y#Y#Y#Y#Y.Dby#Yby#Yby#Ybyby.Dby#Yby.Dby#Y#Y#Y#YbQ.r.7#y.7#VbKbKbKbK.h.h.4bQ.4bQbQ.R.R.R.R.j#0.j.j.j.v.v",
"bKbK#lbK#l#l#l#l#l#Y#l#Y#Y.D#Y.D#Yby#Yby.Dbybyby#xbybybybybyby#Yby.D#Y#Y#Y#w.8.q.M.z.m#lbK.hbK.h.h.hbQbQbQbQ.R.R.R.R#0.v.j.v.v.v",
"bK#lbK#l#l#l#l#l#Y#l#Y#Y#Y#Y#Yby#Yby#Ybybybybybybybybybybyby.Dbyby#Yby#Y#YaX.N.9#1.z.N#0bKbKbK.h.hbQ.hbQbQ.RbQ.R.j.R.j.j.v.j.v.v",
"#lbK#X#l#l#l#l#Y#l#Y#Y#Y#Y#Y#Y#Yby#xbybybyby#xbybybybyby#xbybybybybyby#Y#x.K.r.c#A.z.7#A.ibKbK.hbKbQ.4bQbQbQ.R.R.R#0#0#0.j.v.v.v",
"bK#l#l#l#l#l#l#Y#Y#Y#Y#Y#Ybybybybybybybybybyby.Jbybyby.Jbybybybybyby#Yby#YbM.N.z.7.5.5#T.l.7.W.h.h.h.hbQbQbQ.R.R.R.R.j#0.v.v.v.v",
"bK#lbK#lbK#Y#l#Y#l#Y#Y#Yby#Yby#Ybybybybyby.Jby.Jby.J.Jby.Jby.Jbybybybyby#n#m.8.z.7.7.U.#.1.5#A.WbK.hbQbQbQbQbQ.R.R.j#0.j.v.v.v.v",
"#l#l#l#l#Y.K#Y.K#Y#Y#Y#Yby#Yby#nby#n.J.J.Jby.J.J.J.Jby.J.J.Jby.JbybybybybH.N#A.c.9#L.1.1.1.1.l.c.W.h.hbQbQbQ.R.R.R#0.R#0.v.v.v.v",
"#X.K#l.K#l#l#Y#Y#Y#Y.o#Yby#nbybyby.Jby#n.J.J.J.J.J.J.J.J.J.J.Jby.J.Jby#n.m.8.c.N.z.l.l.5.5.l.l.7#AbQ#wbQbQbQ.RbQ.R#0.j.v.j.v.v.v",
"#l.K#l#l.o#l.o#Y.o#Ybyby#nbyby#n.Jby.J.J.J.J.J.J.J.J.J.J.J.J.J.J#n.J#n#Dam.N.N.9.7.7.l.l.l.z.7.7.7.z.W.hbQbQbQ.T.R.R#0.v.v.v.v.H",
".K#l.K#l#Y.K#Y#Y#Y#Y.o#Yby#nbyby.J.J#n.J.J.J.J.J.J.J.J.J.J.J.J.J.Jby.Jbm.r.N#A.z.7.7.l.l.7.7.l.5.l.7.z.ibQbT.R.R.R.R.v.R.v.v.v.v",
"#l#l.K#l.K#Y.o#Y.o#0#nbybybK.KaX.K#D.o.O.O#D#naR#n.bbO.J.b.J.b.J.J.J#Da1.N.c#A.7.7.lb5.1.5.5.1.1.1.1.5.l.z.mbQ.R.R#0#0.v.v.v.v.H",
".K#l.K#l.o#l.o#YaX#lbO.k.ea6a6a6a6akakakakaSbFaT.WbObO#D#Y.C#t.C#t#t.K.T.W.W.d#V.7.1.#.1.1bkbkbkbkbk.1.5.5.7.i#0#0.R.v.j.v.v.H.v",
".K#l.K#Y.K#Y.o#Y#0#E.v.hbeaaa6a6a6.t.taS#G#G#x#xaj.JbOaj.fa2.e#.aiaiaiaiazaz#K.o#3.#bk.#.#.ybk.y.ybk.#.1.1.5.z.c.m.R#0#0.v.v.v.v",
".K#l.K.K#l.o#Y.oaBal.Za0aH#Baka6a6a6a6aS#xbqbqa0#D.J.J#W.u.H#Y.p.taib3bz.f.D#Y.W.#bkbk#c#c.ybLbL.y.y.1.#.1.1.l.z.c.L.v#d.v.v#M.H",
".K.K#l.o.K#Y.o.o.Lalalala0bKaaa6a6a6a6.t#xblalb0aRbObralala0bKakaiaUa8#wbq.Z.ZaD.##c#c#c.ybLbLbLbL.ybk.#.1.1.5.7.c.c.m.v.v.v.H.v",
"#l.K.K#l.o.K#Y.obmalalalal.a#Gakakaka6a6.E#M..bNbObO#m..a0.vb3#.aUa8.L.Z..al#Q.qbk#c.y.y#e#U#UbLbL.ybI#c.1.#.1.l.z.8.8.H.v.v#M.H",
".K.K.K.K.o#Y.o.o#Malalalala0.D#Kaka6aka6aSbKal.O.baRalalbJaU#.aebe#Fal..bD#Q#L#Z#z#c#cbP#R#U#U#UbL#ebIbI#Z.1b5.5.z.8.8.N#M.H.v.H",
".K.K#l.K#l.o.o.o.Aa1.Xalal.Z#0aeakakakakak#P#WaRbObral.aa2bFae#l#Oal#N#A.7#6b5#6.##c#e#e#e#U#U#U#e.ybPbI#y.#b5.l.z.c.8.N#W.v#d.H",
".K.K.K.o.K.o.o#Y.o.o#n.Oalal.g#lakakakakak.EbQbObO.b#F#Gb3ae.K.u..#N.c.z.7#6.q#Z#z#cbP#e#U#e#e#e#R#e#c#y.#.1.1.l.z.c.8.8#N.H#M.H",
".K.K.K.K.o.K.o.o.o#n#n#nbmala0.haeaSakakakak.Dbt.J.O#YaSaT#l.X..#N.8#A.z#L#6#3#3#ybIbP#R#e#e#e#ebP#RbI#z#y#y.q.7.c.8.8.N#N#W.vbd",
".K.K.K.K.K.o.o.o.o.o#n#n.oalal.a.faSaSaSakaSaTaj#D.o#KaTbK.X...r#N.8#A.c.7#L#6b5aN#y.PbP#R#RbP#R#R.P#y#Z#6.q#6.7#A.c.8.8.r.Ib..H",
"bW.K.K.K.o.K#Y.o.obw.S.o#n#mal.g.DaaaSaSaSaS#KbQbKawaebK.X..#u.N#N.8.c.c#T#L#6#3#Z#3aN.P.PbPaN.P#zaN#Z#Z#L#6#L.7.8.8.8.N#NaAb.bd",
".KbW.K.K#2.K.o.o.o.o#n#n#IbMal.Z.R#PaSaSaSaSaSa8aaaebQbq..a5.r#N#N.N#A#A.7#T.MaD#Z#3aN#y.P.PaNaN#y.M#3#Z#T#6.7#A.c.c.8#N.raA.G.v",
"bW.K.K#2.K.o#2#2.o.o.o.o#n#nalal.u.D#K#KaS#KaS#K.EbH.u...na5aA#N.N#N.c.9#A#1#T#Tbi.M#3.Q#y#y#y.M#y#3.M#LaP#L.7#A.N.N.8.N.raA#rb.",
".KbW.K.K.K#2.K.o.o.o.S.o#I.o.Wala0.4a2#K#K#KaS#K#B#Oal.Wbma5aA.r#N#N.8.8aP#1#1.U.MaD.M.Q#Z#Z.Q.Ubi#L#L#T.c#T.z.8.N.8.N.N.r#ubqbd",
"bW.KbW.K#2.K.o#2.o.S.o.S.o.S.Oalal.H.D#K#K#K#K#K#P#Fbm.bapa5#u.r#N#N.8.8.caP#1aP#TaDaD#3#3#3.MaDbi#1#T#1.9.z.c.8#N.N#N.raA#u.nb.",
"bWbW.KbW.K#2.K#2.o.K.o.o.o#I.obNal#g#lbB#K#K#K#K.EbQaR#Ibma5#u.r.r#N.N.N#7aPaP.9.U#TaD#T#L.M#LaP#T#1#T.9.c#A.c.8.N.N#NaA#ua5b0bd",
"bWbWbW.K.K.K#2.K#2#2.o.S.o.o.S.Wal#g#laWbBbBbBbB#K#x.T#I.Wa5#uaA.r.r#N.8.N.c.9.9aP#1aPaD#T#1.U#7#TaPaP.N.8.9.8.N.r.r.r.r#ua5bqb.",
"bWbWbWbW#2#2.K#2#2.o#2.o.o.o.o.Sbl.Rae.EbBbB#KbBbBav#0#naja5#u#uaA.raA.NbA.N.9#7.9aPaP#1#1#1#7aPaP.c#7#N.c.8.N#N.r.r.raA#u..#r#o",
"#jbWbWbWbWbW#2#2#2#2#2bf.obf.o.AbQaT.E.f.fbBbBbBbBbB.h#h#Ha5a5#uaAaAaA#N#N.N#7.c#Q.9#7.9aP.9#7.c.9.9.8.r.8.N#N.r.raAaAa5a5..#E#o",
"bWbWbWbWbWbW#2bW#2#2#2.obf.obM.R#PaW.f.jbQbBaWbBbBaW.f#0.o#5a5#u#uaA#u.r.rbA#N#Q#Q#7#Q.9#7.9#N.9.8.N#N.r.N#N.r.raAaA#ua5....bJbV",
"bK#j#jbWbW#2bWbW#2#2#2bW#2aX.R#BaW#B.a.g#XaTbBaWaWaW#C#0aXbN..#u#u#u#uaA.raAbA.N#N#Q.N#Q.8#Q#N#7#NbA#N.r#N#NaA#u#u#ua5.....XbJ#o",
"#j#j#jbW#jbWbWbW#2bW#2#2aX.v.faW#BbJ.Z.Z.v#laWaWaWaWaW#l.W.A..a5#uaA#uaAaAaA.rbA.rbA.rbA#NbA#N#N.r.r.raA.raA#u#u#ua5......b6bVbJ",
"#j#j#j#jbWbWbWbWbWbWbWbH.v.faWav.R.Zalal#E.havaWaWaWaW#P.v#2.n..#u#u#u#uaAaAbDaA.raA.r.r.raAbA.raAaAaA#u#u#u#ua5a5......#5bJbVbV",
"#j#j#j#j#jbWbWbW#2bWbH.v#xaZ#P.Rbl.I#rala0.R.faWaZaZ#C#C.R.A.A....a5#u#uafas.2aQbnaubD.rafa##9bDaAaA#u#u#ua5a5a5a5......aJbJbVbJ",
"#j#w#j#j#j#j#j#jbc#w#0#xaZ.p.hbqbR.A.Aal.ZaH.RaZaZ.EaZ#C#x#MbWb4..a5a5#qayahaEaEaQaEaubEa.adaQab#u#ua5a5#ua5a5........bq.LbVbVbV",
"#jbb#j#w#jbH#jbW#w#0#xaZbv.K.u...Tbc#2#5.Z.g.4#P#CaZ#C#CaT.v#wbc#r..afb2a.#sbCbCbC#fbZ.3a.a.#say#9a5a5a5a5a5..a5.....Z#ibVbJbVbJ",
"bbbT#jbT#j#jbcbT.v#xaZav#x.aalb4bWbWaX#oala0.jbK#C#C#C#C.pbQ#MbW.Aa0a7bC#s.0.wbhbxaObsbgbhbxbxaO#qa5a5..a5........#5aKbJbVbV#i#i",
"bb#jbb#jbb#wbT.j#xaZaZ#xaH.ZaB#jbWbcbW.Aalal.u.4#P#C.p#C.p#BaH#jbcbcbYbCbC.3aLbKbyaLbRbd.wag.3bf.na5.............ZaK#obVbJbJ#ibJ",
"bbbQbbbT#jbU.jbebvaZbe.vblb6#wbcbc#jbc#j.Gal.g.R#x#C.p.p.p.p.R#M#jbf.0bCbx.Y#W.ubq#5al#g.aaLb4aoa5..........bj#qbsb4bVbV#i#i#i#i",
"#b#b.R#0.v.ja8bvaZav.4.ubRb##j#j#w#jbc#j#Mal#g.j.D.p.p.p.p.p.fb..Sa3#fbx#S#4ababbZacb1bnaQaQaEat.........s#p#vadaQaE#p#p#pb1as#i",
"b..4bK.DbeavaZaZbvbv#X#X.4bQ#0#b#j#wbU.v.R.R.R.h#P.p.p.p.paT.p#Y.vbg###J.BaQadadabaEadaQaEa.boap......a#a.ad#va.#s#saEadadadb1.G",
"b..4bzbza8.w.w.w.w#P#Pav.w#l.HbT#w#jb6.j#xbz#PaT.p.p.pavae.paTaT#P.f.Rb#bx#fbx#SaM#J#S#S#S#S#4bN#r#ObsayaE#sana3###S.0ananara7bS",
".uaH.aaH.a.a.a.aaHaHaHaHaHaHaHbTbTbU.g.aaH.HaHaHaHaHaHaHaH.H.H.v#Mb..vaqa4#2bHbW.Y.AbWbY#Sb2aIbGbd#o.Y#sah#Sa3b4bwbh#SanbfbT#H#a",
"b6alalalalalalalalalalalalal#Fbbbb#Malalal.Zal.Zal.Z.Zal.Z.Z.Zbl.G#h.SbpaM.G.u.ubq#Wa4#S#Sanaq#ibdbGaObC#San#H#Wa3bxananaVbq#g.G",
"aC#i#O#E#OaJ#O#FaJ#F#FaJ#O.G#dbTbTbd#r#r#rbq#r.Xbq.X.XbR.X.Xb0.X.AbY#f#S.YbGaK#F#FaB#J#f#SbYbs#obd#Wbp#Sb2an#H#q#Sa.#SbY#HbSb6aK",
"#b#b#b#bbb#b#b#bbQ#b#b#bbb#b#bbTbb#b#b#b#b#b#b#b#b#b#b#b#b#bbUbU.SbY#S#Sa7b4#daF#dbXbY#S#S.3aG#o#obRbwbab2ana7axaha.anaMbXbSaKaJ",
"aC.4aCbbaC#b#bbb#b#bbb#b#b#bbb#b#b#b#bbT#b#bbT#bb##bbU#bbUbUbU#d#I.0#SanaV#o#daL#o.Aan#S#SaMap#obV.X#oa9.0anayadaEaY#J#H#raJaKaK",
"#baC#baC.4aC#baC#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#b#bbUbUbU#d#b#daLa4.0#SbY#HbdbdaF#o.S.0#SanaIbGbVbVb6#g.va9an.0#Sb2a3.A.GbSaKaJbS",
"aCaCaCaCaCaC#baC.4aC#baC#b#baC#b#b#b#b#bbU#b#dbU#daCbUaCbU#d#daLbpag#SaO#qaFaLbdaK.Y.0.0anaV#kat#4#ibqaoanahbY#hb#.L#rb6aJ#aaJaJ",
"aC#b#b#b#baC#baCaCaC#baCaC#b#baCaC#daC#d#b#d#b#d#b#d#d#d#d#d#0bU.3.0#SbpaGbdbdbd.G##.0.0bYbZ.2aQac#iaobZ#S#fan#say#pa##iaKaJbSaJ",
"aCaCaCaCaC#baCaCaCaCaC#baCaCaC#b#d#b#b#daCbU#d#d#d#d#d#0#d#d#db##J#S.0.Y#kbdbdbd.Ga4.0an.0aEaQ.Bbtat.BaQaEananan#SbCa.axbXbSaJbS",
"aCaCaCaCaCaCaCaC#baCaCaCaCaC#daC#daC#d#daC#d#d#d#d#d#d#d#daLaFbfbYbaan#IbGbdbdbdb6bTbu.0anan.3bgaqaY#vahanbga4#JanbYb2ayboaKbSbS",
"aCaCaCaCaCaCaCaCaCaCaCaCaC#d.R#daC#daC#d#d#d#d#d#d#daF#dbdaFbdbgan.0.3bs#ibdbdbV#i.u.R#jbHbT#M#Oao#f#sbY#Ib4b.bTbg#JbYbY.VbsbS.6",
"aCaCaCaCaCaCaCaCaCaC#daC#daC#d#d#d#d#0#d#d#d#d#d#dbd#d#h#p#pa7#J.0.0#IbGbdbVbVbVbVbSbq.u.ub6b6bq.S.0.0bYaI#Wbl.ubJ.D.0bY.3bs.6bS",
"aCaFaCaFaCaFaFaCaFaC#daC#daFaCaFaC#daFaF#daF#daFaFaFaLaOahadad#S.0##.AaKbVbdbVbV#ibVbV#i#i#i#i#8b#buanbY.Vbo.Fab#pa.aybYaIbGbS.6",
"aCaFaCaFaCaFaCaFaCaFaCaFaFaCaFaFaFaFaF#daFaFbdaFbdaF#obp#S#f#say#J#hbS#ibVbVbVbV#i#i#i#i#iaK#ib6#ObebabYanayaEadad#vaYbpaG#8bS.6",
"aCaFaFaFaFaCaFaCaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbV.Kag.0babp.A.GaKbd#ibd#i#i#i#i#i#i#iaK#iaJblbV.DbpbYbYb2#SaYbYbgaL#W.6.6.6",
"aFaFaCaFaFaFaFaFaCaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdbdbdbdaH#jbw#2aL.uaKbV#ibV#i#ibV#i#i#iaK#iaJaKaJaJbl.a#dbT#2bg.Sbc#M.Gb6.6.6.6.6",
"aFaFaFaFaCaFaFaFaFaFaFaFaFaFaFaFaFbdaFbdaFbdaFbdaFbVbd#i#E#E.ub6#i#ibVbV#i#i#i#i#i#i#iaJ#iaJaKaJaKaJ#8bq.u#F#O.u.u#8#8.6.6.6.6.6"
};

/* now reduced colors (notice that some match the predefined brown3, brown4, red4, etc */

char * fig_reduced_c_icon_X[] = {
/* width height num_colors chars_per_pixel */
"    64    64       32            1",
/* colors */
". c #000000", "# c #009000", "a c #925132", "b c #bb8863", "c c #145812", "d c #fbc88b",
"e c #bc8059", "f c #000000", "g c #9e5834", "h c #47511c", "i c #ed9967", "j c #000000",
"k c #b17859", "l c #000000", "m c #84767c", "n c #fbf7b0", "o c #748634", "p c #00b000",
"q c #a05853", "r c #ffe0e0", "s c #bc7852", "t c #b09ea8", "u c #000000", "v c #b27052",
"w c #ffc0c0", "x c #aa8784", "y c #900000", "z c #d5babe", "A c #803000", "B c #bd704a",
"C c #ffffff", "D c #a04000",
/* pixels */
"BgBBBBBBBBBBBBBBsBssssssssssssBsBBBBBBBBBBgggggggggggggggggagaga",
"BBBBBBBBBBBBBsBsBssBsBsssssssssBssBBBBvBBBBBggggggggggggggggggaa",
"BBBBBBBBBBBBBsBssssssssssssssssssBssBo##gBBBgggggggggggggggggaag",
"gBBBBBBBBBBsBssssssssesessesesssssssgc##cBBBBgggggggggggggaggaaa",
"BBBBBBBBBBsBsssssseseseseesesesessssglc#chBBBBggggggggggggagggaa",
"BBBBBBBBBsBsssssseseseeeeeeeeeesessssql#ccaBBgBgggggggggggaagaaa",
"BBBBBBBBsBssssseseseeeeeeeeeeeseesessvlccclaBBBgggggggggggggagaa",
"BBBBBBBsBssssssseeeeeeeeeeeeeeeeeeesevlccccchBBgBggggggggaaagaaa",
"BBBBBBBsssssseeeeeeeeeebeeebeeeeeesesqlcc##cccaggggggggggggaaaaa",
"BBBBBsBsBssseseseeeeebebebbebebeeeeekulcccc###caBgggggggggagaaaa",
"BBBBsvsvssssesekekbbbebbbbebbbebeeeevlcccc####ccaggggggggagaaaaa",
"BvBvBBssssksekeeebekbbbbbbbbbbbebbekalclccc##ccccgqggggggagagaaa",
"BvBBkBkskseekeekbebbbbbbbbbbbbbbkbkklllcccccccccccaggggaggaaaaaa",
"vBvBsvssssksekeebbkbbbbbbbbbbbbbbeballccccccccc#ccchgqggggagaaaa",
"BBvBvskskakeeBvvvkkvvkkkkbbbbbbbbbkjlccccc#########ccagggaaaaaaa",
"vBvBkBksvBbidddddddddddiabbksbbbbbvaaaahc############chaagagaaaa",
"vBvsvsksauageddddnndbbeeabbaeiddnnnndddk#####p#pp#####ccagaaaaaa",
"vBvvBksku.ffabddddddefffkbbufasinndiessa###ppppppp####cccaayaaaa",
"vvBkvskka...fBdddddnef.fkby..fBdniiqfffc#ppppppppp#####cccaaaaaa",
"BvvBkvska....abdddddda.ubbu.faddiiaf..l##ppppppppp#p###ccllaaaaa",
"vvvvkskka....fsddddddB.vbk..aidieu...lc##pp#pppppp######clllaaaa",
"vvBvBkkkqjf..faidddddiukby.aidiBu.lcc####ppppppppp#####ccclluaya",
"vvvkvkkskkkv..fBddddddgbbbubdivf.lccc####p#pppppppp####ccclllaaa",
"vvvvkvkkkkkka.fgidddddsmbvsdiBf.llccc######ppppp#p#####cclllluaA",
"vvvvvkkkkkkkk..aedddddiakkdiBf.lllcccc######pp#pp######ccclllfaa",
"vvvvkvskkekkku.fsddddddgBdiBf..lllcccc##############c#ccllllllaA",
"vvvvkvkkkkkkbq.fgidddddidigf..llllcccccc#########c##c#ccccllllua",
"vvvkvkkkkkkkkk..fsdddddddvf.j.llllcccccc#c#####c##ccccccllllllja",
"vvvvvkvkkkkkbka.fgidddddbu.aa.llllllccccccc####c#ccccccllllll.fA",
"vvvvkvkkkkkkkkv..asdddddiuabu..lllllccccccc###cc#ccccccllllll.ja",
"vvvvvkvkkvkkkbku.fBddddddgkba..llllllcccccccccccccccccclllll..fA",
"vvvvvvkvkkkkkkka.fBddddddeaba..llllllcccccccccclcccllcllllll..fa",
"vvvvkkvkkkkkkkkkfgiddddddiaka...llllllclcccccclcccllclllllll..jA",
"vvvvvvkkkkkkkkkqgideedddddgqm...lllllllclclccclccclllllllll...uA",
"vvvvvvkvkkkkkkqgideggdddddeakf...l.llllllllclclcllllllllll....aA",
"BvvvvkvvkkkvkvgbdbafBiddddiavu.....llllllllllllllllllll......faA",
"vvvvvvvvkvkkvaedbaffaBdddddBaq...l.lllllllllllllllllll.......uAa",
"vvvvvvvvvvvvaedigf..ugiddddiakj.....ll.llllllllllll.........faAA",
"vvvvvvvvkvvaeiigffj.fgediiiigqq.....utrCrm.luxm.ll..........uaAa",
"vqvvvvvvvqaeiigffqq.fagiidiieava...mrrrrCrmmrCCt...........faAAA",
"vqvqvvvvqaeiivf.avkfffgiiiiiiaqvj.uwrrrrrztwrrrrm.........fuAaAa",
"qqvqvvvqaeiiea.avvvA.fgBiiiiigavqfxrrwidrwmbdrrwm........fuaAAuu",
"qvqvqqqgeiieafuvvvvq..fgiiiiibavvvwrrwyBeyfAiwwkj.......fuAAaaua",
"qgqqvygeiieafuqvvvvvu.fgeiiiiigavkwrrxufff.fayay......jmmaAAuuuu",
"qqgaagiiiigffyvvqvvva.fgsiiiiieakxzrwxttttzrCCrx....mzCCCrzzzztu",
"agBseiiiiiBBggaqvqyaggggiiiiiiisabbwrCCCtrCCrrzu...xrCCrrrrCCCzu",
"agiiiiiiiiiiiBaqqvugeiiiiiiiiiiiiegyrzrwxwwwwwxujumrrrwxbwwwwwxu",
"faaaaaaaaaaaaaaqqyfaaaaaaaaaaaaaaaaxbkvvxqvwwwxuAAxrrwxaedwwkqmu",
"u.............uqqa...f.f.ff.ffffuqkwxufffubwwwxuAuwrwwmuxrwwxffu",
"DuuuuuuuuuuuuuyqqAjjjfjfffffffffqwzwxuuuuuwzwwmAAuwwwwmmwrwwmuuu",
"qqqqqqqqgqqqqqqqqqqqqqqqqqqqqqyykwwwxayAyAwwwwyAAfewwwxzrrwxAuuu",
"DgDqDqqqqqqqqqqqqqqqqqqqyqyqyyyybwwwxAyyAqwwwxuAAfAiwwrCrzwmjuuu",
"qDqDgDqDqqqqqqqqqqqqqqqqqyyyyqyybwwwmAAAAkwwwxuAAufaiwwwwxquuuuu",
"DDDDDDqDgDqDqqDqqqqqyqyyyDyDyyyywwwwmAyAuxwwwxAxxufywrwqyajuuuuu",
"DqqqqDqDDDqDDqqDDyDyqyqyqyyyyyaywwwwyAAAubwwwtrCtuytwzwrrzxuuuuu",
"DDDDDqDDDDDqDDDqyqqyDyyyyyyayyyywwwxAAAAubwwwrCrmxrCrwwwwrrzAuuu",
"DDDDDDDDqDDDDDyDyDyyDyyyyyyyyyAkwwwbuAAAuqwwwwwbxzCrwbbwwwwrzuuu",
"DDDDDDDDDDDDDygyDyDyyyyyyyAyAAAbwwwmuAAAufgvvqauyzrwbaaqbwwwwmuu",
"DDDDDDDDDDyDyDyyyyayyyyyyAyqzzxwwwbuAAAAAufffuufkwwwxuffaswwwmuu",
"DADADAADADyDyADADyAAyAyAAAywrCCwwbquAAAAuAAuuuuuywwwwzttzrrwxuuu",
"DADADADADADAADAAAAAyAAAAAAAwwzrrwquuAAAAuuuuuuuuuewwwrrCCCzwyuuu",
"DAAAADADAAADAAAAAAAAAAAAAAAvwwwwquuAuAuuuuuuuuuufAswwwwwzwbyuuuu",
"AADAAAAADAAAAAAAAAAAAAAAAAAavekyfuAuAuuAuuuuuuuuufayqkbkvauuuuuu",
"AAAADAAAAAAAAAAAAAAAAAAAAAAuuufuuuAAuuuuuuuuuuuuuuuffuuffuuuuuuu"
};

#endif /* USE_XPM */

/* bitmap of letters for splash screen ("3.2.X") */
#include "version.xbm"

/* splash background in XPM */

#ifdef USE_SPLASH
#include "splash.xpm"
#endif

/* splash background for monochrome or non-XPM compile */

#include "splash.xbm"

icon_struct	letters_ic = { letters_width, letters_height,
			      (char*)letters_bits };
icon_struct	spl_bckgnd_ic = { spl_bckgnd_width, spl_bckgnd_height,
			      (char*)spl_bckgnd_bits };

#define		MODE_SW_HT_SMALL	22	/* height of a small mode switch icon */
#define		MODE_SW_WD_SMALL	22	/* width of a small mode switch icon */
#define		MODE_SW_HT_BIG	32	/* height of a mode switch icon */
#define		MODE_SW_WD_BIG	36	/* width of a mode switch icon */



int mode_sw_ht;
int mode_sw_wd;

void setup_icons_small()
{
	mode_sw_ht = MODE_SW_HT_SMALL;
	mode_sw_wd = MODE_SW_WD_SMALL;
	populate_icons_small();
}

void setup_icons_big()
{
	mode_sw_ht = MODE_SW_HT_BIG;
	mode_sw_wd = MODE_SW_WD_BIG;
	populate_icons_big();
}
