#pragma once
// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See lvt_file_generator.py for modifications

/*
 * Copyright (c) 2015-2023 The Khronos Group Inc.
 * Copyright (c) 2015-2023 Valve Corporation
 * Copyright (c) 2015-2023 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include <vulkan/vulkan.h>

#ifdef _WIN32
/* Windows-specific common code: */
// WinBase.h defines CreateSemaphore and synchapi.h defines CreateEvent
//  undefine them to avoid conflicts with VkLayerDispatchTable struct members.
#ifdef CreateSemaphore
#undef CreateSemaphore
#endif
#ifdef CreateEvent
#undef CreateEvent
#endif
#endif

namespace vk {

extern PFN_vkCreateInstance CreateInstance;
extern PFN_vkDestroyInstance DestroyInstance;
extern PFN_vkEnumeratePhysicalDevices EnumeratePhysicalDevices;
extern PFN_vkGetPhysicalDeviceFeatures GetPhysicalDeviceFeatures;
extern PFN_vkGetPhysicalDeviceFormatProperties GetPhysicalDeviceFormatProperties;
extern PFN_vkGetPhysicalDeviceImageFormatProperties GetPhysicalDeviceImageFormatProperties;
extern PFN_vkGetPhysicalDeviceProperties GetPhysicalDeviceProperties;
extern PFN_vkGetPhysicalDeviceQueueFamilyProperties GetPhysicalDeviceQueueFamilyProperties;
extern PFN_vkGetPhysicalDeviceMemoryProperties GetPhysicalDeviceMemoryProperties;
extern PFN_vkGetInstanceProcAddr GetInstanceProcAddr;
extern PFN_vkGetDeviceProcAddr GetDeviceProcAddr;
extern PFN_vkCreateDevice CreateDevice;
extern PFN_vkDestroyDevice DestroyDevice;
extern PFN_vkEnumerateInstanceExtensionProperties EnumerateInstanceExtensionProperties;
extern PFN_vkEnumerateDeviceExtensionProperties EnumerateDeviceExtensionProperties;
extern PFN_vkEnumerateInstanceLayerProperties EnumerateInstanceLayerProperties;
extern PFN_vkEnumerateDeviceLayerProperties EnumerateDeviceLayerProperties;
extern PFN_vkGetDeviceQueue GetDeviceQueue;
extern PFN_vkQueueSubmit QueueSubmit;
extern PFN_vkQueueWaitIdle QueueWaitIdle;
extern PFN_vkDeviceWaitIdle DeviceWaitIdle;
extern PFN_vkAllocateMemory AllocateMemory;
extern PFN_vkFreeMemory FreeMemory;
extern PFN_vkMapMemory MapMemory;
extern PFN_vkUnmapMemory UnmapMemory;
extern PFN_vkFlushMappedMemoryRanges FlushMappedMemoryRanges;
extern PFN_vkInvalidateMappedMemoryRanges InvalidateMappedMemoryRanges;
extern PFN_vkGetDeviceMemoryCommitment GetDeviceMemoryCommitment;
extern PFN_vkBindBufferMemory BindBufferMemory;
extern PFN_vkBindImageMemory BindImageMemory;
extern PFN_vkGetBufferMemoryRequirements GetBufferMemoryRequirements;
extern PFN_vkGetImageMemoryRequirements GetImageMemoryRequirements;
extern PFN_vkGetImageSparseMemoryRequirements GetImageSparseMemoryRequirements;
extern PFN_vkGetPhysicalDeviceSparseImageFormatProperties GetPhysicalDeviceSparseImageFormatProperties;
extern PFN_vkQueueBindSparse QueueBindSparse;
extern PFN_vkCreateFence CreateFence;
extern PFN_vkDestroyFence DestroyFence;
extern PFN_vkResetFences ResetFences;
extern PFN_vkGetFenceStatus GetFenceStatus;
extern PFN_vkWaitForFences WaitForFences;
extern PFN_vkCreateSemaphore CreateSemaphore;
extern PFN_vkDestroySemaphore DestroySemaphore;
extern PFN_vkCreateEvent CreateEvent;
extern PFN_vkDestroyEvent DestroyEvent;
extern PFN_vkGetEventStatus GetEventStatus;
extern PFN_vkSetEvent SetEvent;
extern PFN_vkResetEvent ResetEvent;
extern PFN_vkCreateQueryPool CreateQueryPool;
extern PFN_vkDestroyQueryPool DestroyQueryPool;
extern PFN_vkGetQueryPoolResults GetQueryPoolResults;
extern PFN_vkCreateBuffer CreateBuffer;
extern PFN_vkDestroyBuffer DestroyBuffer;
extern PFN_vkCreateBufferView CreateBufferView;
extern PFN_vkDestroyBufferView DestroyBufferView;
extern PFN_vkCreateImage CreateImage;
extern PFN_vkDestroyImage DestroyImage;
extern PFN_vkGetImageSubresourceLayout GetImageSubresourceLayout;
extern PFN_vkCreateImageView CreateImageView;
extern PFN_vkDestroyImageView DestroyImageView;
extern PFN_vkCreateShaderModule CreateShaderModule;
extern PFN_vkDestroyShaderModule DestroyShaderModule;
extern PFN_vkCreatePipelineCache CreatePipelineCache;
extern PFN_vkDestroyPipelineCache DestroyPipelineCache;
extern PFN_vkGetPipelineCacheData GetPipelineCacheData;
extern PFN_vkMergePipelineCaches MergePipelineCaches;
extern PFN_vkCreateGraphicsPipelines CreateGraphicsPipelines;
extern PFN_vkCreateComputePipelines CreateComputePipelines;
extern PFN_vkDestroyPipeline DestroyPipeline;
extern PFN_vkCreatePipelineLayout CreatePipelineLayout;
extern PFN_vkDestroyPipelineLayout DestroyPipelineLayout;
extern PFN_vkCreateSampler CreateSampler;
extern PFN_vkDestroySampler DestroySampler;
extern PFN_vkCreateDescriptorSetLayout CreateDescriptorSetLayout;
extern PFN_vkDestroyDescriptorSetLayout DestroyDescriptorSetLayout;
extern PFN_vkCreateDescriptorPool CreateDescriptorPool;
extern PFN_vkDestroyDescriptorPool DestroyDescriptorPool;
extern PFN_vkResetDescriptorPool ResetDescriptorPool;
extern PFN_vkAllocateDescriptorSets AllocateDescriptorSets;
extern PFN_vkFreeDescriptorSets FreeDescriptorSets;
extern PFN_vkUpdateDescriptorSets UpdateDescriptorSets;
extern PFN_vkCreateFramebuffer CreateFramebuffer;
extern PFN_vkDestroyFramebuffer DestroyFramebuffer;
extern PFN_vkCreateRenderPass CreateRenderPass;
extern PFN_vkDestroyRenderPass DestroyRenderPass;
extern PFN_vkGetRenderAreaGranularity GetRenderAreaGranularity;
extern PFN_vkCreateCommandPool CreateCommandPool;
extern PFN_vkDestroyCommandPool DestroyCommandPool;
extern PFN_vkResetCommandPool ResetCommandPool;
extern PFN_vkAllocateCommandBuffers AllocateCommandBuffers;
extern PFN_vkFreeCommandBuffers FreeCommandBuffers;
extern PFN_vkBeginCommandBuffer BeginCommandBuffer;
extern PFN_vkEndCommandBuffer EndCommandBuffer;
extern PFN_vkResetCommandBuffer ResetCommandBuffer;
extern PFN_vkCmdBindPipeline CmdBindPipeline;
extern PFN_vkCmdSetViewport CmdSetViewport;
extern PFN_vkCmdSetScissor CmdSetScissor;
extern PFN_vkCmdSetLineWidth CmdSetLineWidth;
extern PFN_vkCmdSetDepthBias CmdSetDepthBias;
extern PFN_vkCmdSetBlendConstants CmdSetBlendConstants;
extern PFN_vkCmdSetDepthBounds CmdSetDepthBounds;
extern PFN_vkCmdSetStencilCompareMask CmdSetStencilCompareMask;
extern PFN_vkCmdSetStencilWriteMask CmdSetStencilWriteMask;
extern PFN_vkCmdSetStencilReference CmdSetStencilReference;
extern PFN_vkCmdBindDescriptorSets CmdBindDescriptorSets;
extern PFN_vkCmdBindIndexBuffer CmdBindIndexBuffer;
extern PFN_vkCmdBindVertexBuffers CmdBindVertexBuffers;
extern PFN_vkCmdDraw CmdDraw;
extern PFN_vkCmdDrawIndexed CmdDrawIndexed;
extern PFN_vkCmdDrawIndirect CmdDrawIndirect;
extern PFN_vkCmdDrawIndexedIndirect CmdDrawIndexedIndirect;
extern PFN_vkCmdDispatch CmdDispatch;
extern PFN_vkCmdDispatchIndirect CmdDispatchIndirect;
extern PFN_vkCmdCopyBuffer CmdCopyBuffer;
extern PFN_vkCmdCopyImage CmdCopyImage;
extern PFN_vkCmdBlitImage CmdBlitImage;
extern PFN_vkCmdCopyBufferToImage CmdCopyBufferToImage;
extern PFN_vkCmdCopyImageToBuffer CmdCopyImageToBuffer;
extern PFN_vkCmdUpdateBuffer CmdUpdateBuffer;
extern PFN_vkCmdFillBuffer CmdFillBuffer;
extern PFN_vkCmdClearColorImage CmdClearColorImage;
extern PFN_vkCmdClearDepthStencilImage CmdClearDepthStencilImage;
extern PFN_vkCmdClearAttachments CmdClearAttachments;
extern PFN_vkCmdResolveImage CmdResolveImage;
extern PFN_vkCmdSetEvent CmdSetEvent;
extern PFN_vkCmdResetEvent CmdResetEvent;
extern PFN_vkCmdWaitEvents CmdWaitEvents;
extern PFN_vkCmdPipelineBarrier CmdPipelineBarrier;
extern PFN_vkCmdBeginQuery CmdBeginQuery;
extern PFN_vkCmdEndQuery CmdEndQuery;
extern PFN_vkCmdResetQueryPool CmdResetQueryPool;
extern PFN_vkCmdWriteTimestamp CmdWriteTimestamp;
extern PFN_vkCmdCopyQueryPoolResults CmdCopyQueryPoolResults;
extern PFN_vkCmdPushConstants CmdPushConstants;
extern PFN_vkCmdBeginRenderPass CmdBeginRenderPass;
extern PFN_vkCmdNextSubpass CmdNextSubpass;
extern PFN_vkCmdEndRenderPass CmdEndRenderPass;
extern PFN_vkCmdExecuteCommands CmdExecuteCommands;
extern PFN_vkEnumerateInstanceVersion EnumerateInstanceVersion;
extern PFN_vkBindBufferMemory2 BindBufferMemory2;
extern PFN_vkBindImageMemory2 BindImageMemory2;
extern PFN_vkGetDeviceGroupPeerMemoryFeatures GetDeviceGroupPeerMemoryFeatures;
extern PFN_vkCmdSetDeviceMask CmdSetDeviceMask;
extern PFN_vkCmdDispatchBase CmdDispatchBase;
extern PFN_vkEnumeratePhysicalDeviceGroups EnumeratePhysicalDeviceGroups;
extern PFN_vkGetImageMemoryRequirements2 GetImageMemoryRequirements2;
extern PFN_vkGetBufferMemoryRequirements2 GetBufferMemoryRequirements2;
extern PFN_vkGetImageSparseMemoryRequirements2 GetImageSparseMemoryRequirements2;
extern PFN_vkGetPhysicalDeviceFeatures2 GetPhysicalDeviceFeatures2;
extern PFN_vkGetPhysicalDeviceProperties2 GetPhysicalDeviceProperties2;
extern PFN_vkGetPhysicalDeviceFormatProperties2 GetPhysicalDeviceFormatProperties2;
extern PFN_vkGetPhysicalDeviceImageFormatProperties2 GetPhysicalDeviceImageFormatProperties2;
extern PFN_vkGetPhysicalDeviceQueueFamilyProperties2 GetPhysicalDeviceQueueFamilyProperties2;
extern PFN_vkGetPhysicalDeviceMemoryProperties2 GetPhysicalDeviceMemoryProperties2;
extern PFN_vkGetPhysicalDeviceSparseImageFormatProperties2 GetPhysicalDeviceSparseImageFormatProperties2;
extern PFN_vkTrimCommandPool TrimCommandPool;
extern PFN_vkGetDeviceQueue2 GetDeviceQueue2;
extern PFN_vkCreateSamplerYcbcrConversion CreateSamplerYcbcrConversion;
extern PFN_vkDestroySamplerYcbcrConversion DestroySamplerYcbcrConversion;
extern PFN_vkCreateDescriptorUpdateTemplate CreateDescriptorUpdateTemplate;
extern PFN_vkDestroyDescriptorUpdateTemplate DestroyDescriptorUpdateTemplate;
extern PFN_vkUpdateDescriptorSetWithTemplate UpdateDescriptorSetWithTemplate;
extern PFN_vkGetPhysicalDeviceExternalBufferProperties GetPhysicalDeviceExternalBufferProperties;
extern PFN_vkGetPhysicalDeviceExternalFenceProperties GetPhysicalDeviceExternalFenceProperties;
extern PFN_vkGetPhysicalDeviceExternalSemaphoreProperties GetPhysicalDeviceExternalSemaphoreProperties;
extern PFN_vkGetDescriptorSetLayoutSupport GetDescriptorSetLayoutSupport;
extern PFN_vkCmdDrawIndirectCount CmdDrawIndirectCount;
extern PFN_vkCmdDrawIndexedIndirectCount CmdDrawIndexedIndirectCount;
extern PFN_vkCreateRenderPass2 CreateRenderPass2;
extern PFN_vkCmdBeginRenderPass2 CmdBeginRenderPass2;
extern PFN_vkCmdNextSubpass2 CmdNextSubpass2;
extern PFN_vkCmdEndRenderPass2 CmdEndRenderPass2;
extern PFN_vkResetQueryPool ResetQueryPool;
extern PFN_vkGetSemaphoreCounterValue GetSemaphoreCounterValue;
extern PFN_vkWaitSemaphores WaitSemaphores;
extern PFN_vkSignalSemaphore SignalSemaphore;
extern PFN_vkGetBufferDeviceAddress GetBufferDeviceAddress;
extern PFN_vkGetBufferOpaqueCaptureAddress GetBufferOpaqueCaptureAddress;
extern PFN_vkGetDeviceMemoryOpaqueCaptureAddress GetDeviceMemoryOpaqueCaptureAddress;
extern PFN_vkGetPhysicalDeviceToolProperties GetPhysicalDeviceToolProperties;
extern PFN_vkCreatePrivateDataSlot CreatePrivateDataSlot;
extern PFN_vkDestroyPrivateDataSlot DestroyPrivateDataSlot;
extern PFN_vkSetPrivateData SetPrivateData;
extern PFN_vkGetPrivateData GetPrivateData;
extern PFN_vkCmdSetEvent2 CmdSetEvent2;
extern PFN_vkCmdResetEvent2 CmdResetEvent2;
extern PFN_vkCmdWaitEvents2 CmdWaitEvents2;
extern PFN_vkCmdPipelineBarrier2 CmdPipelineBarrier2;
extern PFN_vkCmdWriteTimestamp2 CmdWriteTimestamp2;
extern PFN_vkQueueSubmit2 QueueSubmit2;
extern PFN_vkCmdCopyBuffer2 CmdCopyBuffer2;
extern PFN_vkCmdCopyImage2 CmdCopyImage2;
extern PFN_vkCmdCopyBufferToImage2 CmdCopyBufferToImage2;
extern PFN_vkCmdCopyImageToBuffer2 CmdCopyImageToBuffer2;
extern PFN_vkCmdBlitImage2 CmdBlitImage2;
extern PFN_vkCmdResolveImage2 CmdResolveImage2;
extern PFN_vkCmdBeginRendering CmdBeginRendering;
extern PFN_vkCmdEndRendering CmdEndRendering;
extern PFN_vkCmdSetCullMode CmdSetCullMode;
extern PFN_vkCmdSetFrontFace CmdSetFrontFace;
extern PFN_vkCmdSetPrimitiveTopology CmdSetPrimitiveTopology;
extern PFN_vkCmdSetViewportWithCount CmdSetViewportWithCount;
extern PFN_vkCmdSetScissorWithCount CmdSetScissorWithCount;
extern PFN_vkCmdBindVertexBuffers2 CmdBindVertexBuffers2;
extern PFN_vkCmdSetDepthTestEnable CmdSetDepthTestEnable;
extern PFN_vkCmdSetDepthWriteEnable CmdSetDepthWriteEnable;
extern PFN_vkCmdSetDepthCompareOp CmdSetDepthCompareOp;
extern PFN_vkCmdSetDepthBoundsTestEnable CmdSetDepthBoundsTestEnable;
extern PFN_vkCmdSetStencilTestEnable CmdSetStencilTestEnable;
extern PFN_vkCmdSetStencilOp CmdSetStencilOp;
extern PFN_vkCmdSetRasterizerDiscardEnable CmdSetRasterizerDiscardEnable;
extern PFN_vkCmdSetDepthBiasEnable CmdSetDepthBiasEnable;
extern PFN_vkCmdSetPrimitiveRestartEnable CmdSetPrimitiveRestartEnable;
extern PFN_vkGetDeviceBufferMemoryRequirements GetDeviceBufferMemoryRequirements;
extern PFN_vkGetDeviceImageMemoryRequirements GetDeviceImageMemoryRequirements;
extern PFN_vkGetDeviceImageSparseMemoryRequirements GetDeviceImageSparseMemoryRequirements;

// Extension function pointers
// VK_AMD_buffer_marker
extern PFN_vkCmdWriteBufferMarkerAMD CmdWriteBufferMarkerAMD;
// VK_AMD_display_native_hdr
extern PFN_vkSetLocalDimmingAMD SetLocalDimmingAMD;
// VK_AMD_draw_indirect_count
extern PFN_vkCmdDrawIndirectCountAMD CmdDrawIndirectCountAMD;
extern PFN_vkCmdDrawIndexedIndirectCountAMD CmdDrawIndexedIndirectCountAMD;
// VK_AMD_shader_info
extern PFN_vkGetShaderInfoAMD GetShaderInfoAMD;
// VK_ANDROID_external_memory_android_hardware_buffer
#ifdef VK_USE_PLATFORM_ANDROID_KHR
extern PFN_vkGetAndroidHardwareBufferPropertiesANDROID GetAndroidHardwareBufferPropertiesANDROID;
extern PFN_vkGetMemoryAndroidHardwareBufferANDROID GetMemoryAndroidHardwareBufferANDROID;
#endif // VK_USE_PLATFORM_ANDROID_KHR
// VK_EXT_acquire_drm_display
extern PFN_vkAcquireDrmDisplayEXT AcquireDrmDisplayEXT;
extern PFN_vkGetDrmDisplayEXT GetDrmDisplayEXT;
// VK_EXT_acquire_xlib_display
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
extern PFN_vkAcquireXlibDisplayEXT AcquireXlibDisplayEXT;
extern PFN_vkGetRandROutputDisplayEXT GetRandROutputDisplayEXT;
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
// VK_EXT_attachment_feedback_loop_dynamic_state
extern PFN_vkCmdSetAttachmentFeedbackLoopEnableEXT CmdSetAttachmentFeedbackLoopEnableEXT;
// VK_EXT_buffer_device_address
extern PFN_vkGetBufferDeviceAddressEXT GetBufferDeviceAddressEXT;
// VK_EXT_calibrated_timestamps
extern PFN_vkGetPhysicalDeviceCalibrateableTimeDomainsEXT GetPhysicalDeviceCalibrateableTimeDomainsEXT;
extern PFN_vkGetCalibratedTimestampsEXT GetCalibratedTimestampsEXT;
// VK_EXT_color_write_enable
extern PFN_vkCmdSetColorWriteEnableEXT CmdSetColorWriteEnableEXT;
// VK_EXT_conditional_rendering
extern PFN_vkCmdBeginConditionalRenderingEXT CmdBeginConditionalRenderingEXT;
extern PFN_vkCmdEndConditionalRenderingEXT CmdEndConditionalRenderingEXT;
// VK_EXT_debug_marker
extern PFN_vkDebugMarkerSetObjectTagEXT DebugMarkerSetObjectTagEXT;
extern PFN_vkDebugMarkerSetObjectNameEXT DebugMarkerSetObjectNameEXT;
extern PFN_vkCmdDebugMarkerBeginEXT CmdDebugMarkerBeginEXT;
extern PFN_vkCmdDebugMarkerEndEXT CmdDebugMarkerEndEXT;
extern PFN_vkCmdDebugMarkerInsertEXT CmdDebugMarkerInsertEXT;
// VK_EXT_debug_report
extern PFN_vkCreateDebugReportCallbackEXT CreateDebugReportCallbackEXT;
extern PFN_vkDestroyDebugReportCallbackEXT DestroyDebugReportCallbackEXT;
extern PFN_vkDebugReportMessageEXT DebugReportMessageEXT;
// VK_EXT_debug_utils
extern PFN_vkSetDebugUtilsObjectNameEXT SetDebugUtilsObjectNameEXT;
extern PFN_vkSetDebugUtilsObjectTagEXT SetDebugUtilsObjectTagEXT;
extern PFN_vkQueueBeginDebugUtilsLabelEXT QueueBeginDebugUtilsLabelEXT;
extern PFN_vkQueueEndDebugUtilsLabelEXT QueueEndDebugUtilsLabelEXT;
extern PFN_vkQueueInsertDebugUtilsLabelEXT QueueInsertDebugUtilsLabelEXT;
extern PFN_vkCmdBeginDebugUtilsLabelEXT CmdBeginDebugUtilsLabelEXT;
extern PFN_vkCmdEndDebugUtilsLabelEXT CmdEndDebugUtilsLabelEXT;
extern PFN_vkCmdInsertDebugUtilsLabelEXT CmdInsertDebugUtilsLabelEXT;
extern PFN_vkCreateDebugUtilsMessengerEXT CreateDebugUtilsMessengerEXT;
extern PFN_vkDestroyDebugUtilsMessengerEXT DestroyDebugUtilsMessengerEXT;
extern PFN_vkSubmitDebugUtilsMessageEXT SubmitDebugUtilsMessageEXT;
// VK_EXT_descriptor_buffer
extern PFN_vkGetDescriptorSetLayoutSizeEXT GetDescriptorSetLayoutSizeEXT;
extern PFN_vkGetDescriptorSetLayoutBindingOffsetEXT GetDescriptorSetLayoutBindingOffsetEXT;
extern PFN_vkGetDescriptorEXT GetDescriptorEXT;
extern PFN_vkCmdBindDescriptorBuffersEXT CmdBindDescriptorBuffersEXT;
extern PFN_vkCmdSetDescriptorBufferOffsetsEXT CmdSetDescriptorBufferOffsetsEXT;
extern PFN_vkCmdBindDescriptorBufferEmbeddedSamplersEXT CmdBindDescriptorBufferEmbeddedSamplersEXT;
extern PFN_vkGetBufferOpaqueCaptureDescriptorDataEXT GetBufferOpaqueCaptureDescriptorDataEXT;
extern PFN_vkGetImageOpaqueCaptureDescriptorDataEXT GetImageOpaqueCaptureDescriptorDataEXT;
extern PFN_vkGetImageViewOpaqueCaptureDescriptorDataEXT GetImageViewOpaqueCaptureDescriptorDataEXT;
extern PFN_vkGetSamplerOpaqueCaptureDescriptorDataEXT GetSamplerOpaqueCaptureDescriptorDataEXT;
extern PFN_vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT GetAccelerationStructureOpaqueCaptureDescriptorDataEXT;
// VK_EXT_device_fault
extern PFN_vkGetDeviceFaultInfoEXT GetDeviceFaultInfoEXT;
// VK_EXT_direct_mode_display
extern PFN_vkReleaseDisplayEXT ReleaseDisplayEXT;
// VK_EXT_directfb_surface
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
extern PFN_vkCreateDirectFBSurfaceEXT CreateDirectFBSurfaceEXT;
extern PFN_vkGetPhysicalDeviceDirectFBPresentationSupportEXT GetPhysicalDeviceDirectFBPresentationSupportEXT;
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
// VK_EXT_discard_rectangles
extern PFN_vkCmdSetDiscardRectangleEXT CmdSetDiscardRectangleEXT;
extern PFN_vkCmdSetDiscardRectangleEnableEXT CmdSetDiscardRectangleEnableEXT;
extern PFN_vkCmdSetDiscardRectangleModeEXT CmdSetDiscardRectangleModeEXT;
// VK_EXT_display_control
extern PFN_vkDisplayPowerControlEXT DisplayPowerControlEXT;
extern PFN_vkRegisterDeviceEventEXT RegisterDeviceEventEXT;
extern PFN_vkRegisterDisplayEventEXT RegisterDisplayEventEXT;
extern PFN_vkGetSwapchainCounterEXT GetSwapchainCounterEXT;
// VK_EXT_display_surface_counter
extern PFN_vkGetPhysicalDeviceSurfaceCapabilities2EXT GetPhysicalDeviceSurfaceCapabilities2EXT;
// VK_EXT_extended_dynamic_state
extern PFN_vkCmdSetCullModeEXT CmdSetCullModeEXT;
extern PFN_vkCmdSetFrontFaceEXT CmdSetFrontFaceEXT;
extern PFN_vkCmdSetPrimitiveTopologyEXT CmdSetPrimitiveTopologyEXT;
extern PFN_vkCmdSetViewportWithCountEXT CmdSetViewportWithCountEXT;
extern PFN_vkCmdSetScissorWithCountEXT CmdSetScissorWithCountEXT;
extern PFN_vkCmdBindVertexBuffers2EXT CmdBindVertexBuffers2EXT;
extern PFN_vkCmdSetDepthTestEnableEXT CmdSetDepthTestEnableEXT;
extern PFN_vkCmdSetDepthWriteEnableEXT CmdSetDepthWriteEnableEXT;
extern PFN_vkCmdSetDepthCompareOpEXT CmdSetDepthCompareOpEXT;
extern PFN_vkCmdSetDepthBoundsTestEnableEXT CmdSetDepthBoundsTestEnableEXT;
extern PFN_vkCmdSetStencilTestEnableEXT CmdSetStencilTestEnableEXT;
extern PFN_vkCmdSetStencilOpEXT CmdSetStencilOpEXT;
// VK_EXT_extended_dynamic_state2
extern PFN_vkCmdSetPatchControlPointsEXT CmdSetPatchControlPointsEXT;
extern PFN_vkCmdSetRasterizerDiscardEnableEXT CmdSetRasterizerDiscardEnableEXT;
extern PFN_vkCmdSetDepthBiasEnableEXT CmdSetDepthBiasEnableEXT;
extern PFN_vkCmdSetLogicOpEXT CmdSetLogicOpEXT;
extern PFN_vkCmdSetPrimitiveRestartEnableEXT CmdSetPrimitiveRestartEnableEXT;
// VK_EXT_extended_dynamic_state3
extern PFN_vkCmdSetTessellationDomainOriginEXT CmdSetTessellationDomainOriginEXT;
extern PFN_vkCmdSetDepthClampEnableEXT CmdSetDepthClampEnableEXT;
extern PFN_vkCmdSetPolygonModeEXT CmdSetPolygonModeEXT;
extern PFN_vkCmdSetRasterizationSamplesEXT CmdSetRasterizationSamplesEXT;
extern PFN_vkCmdSetSampleMaskEXT CmdSetSampleMaskEXT;
extern PFN_vkCmdSetAlphaToCoverageEnableEXT CmdSetAlphaToCoverageEnableEXT;
extern PFN_vkCmdSetAlphaToOneEnableEXT CmdSetAlphaToOneEnableEXT;
extern PFN_vkCmdSetLogicOpEnableEXT CmdSetLogicOpEnableEXT;
extern PFN_vkCmdSetColorBlendEnableEXT CmdSetColorBlendEnableEXT;
extern PFN_vkCmdSetColorBlendEquationEXT CmdSetColorBlendEquationEXT;
extern PFN_vkCmdSetColorWriteMaskEXT CmdSetColorWriteMaskEXT;
extern PFN_vkCmdSetRasterizationStreamEXT CmdSetRasterizationStreamEXT;
extern PFN_vkCmdSetConservativeRasterizationModeEXT CmdSetConservativeRasterizationModeEXT;
extern PFN_vkCmdSetExtraPrimitiveOverestimationSizeEXT CmdSetExtraPrimitiveOverestimationSizeEXT;
extern PFN_vkCmdSetDepthClipEnableEXT CmdSetDepthClipEnableEXT;
extern PFN_vkCmdSetSampleLocationsEnableEXT CmdSetSampleLocationsEnableEXT;
extern PFN_vkCmdSetColorBlendAdvancedEXT CmdSetColorBlendAdvancedEXT;
extern PFN_vkCmdSetProvokingVertexModeEXT CmdSetProvokingVertexModeEXT;
extern PFN_vkCmdSetLineRasterizationModeEXT CmdSetLineRasterizationModeEXT;
extern PFN_vkCmdSetLineStippleEnableEXT CmdSetLineStippleEnableEXT;
extern PFN_vkCmdSetDepthClipNegativeOneToOneEXT CmdSetDepthClipNegativeOneToOneEXT;
extern PFN_vkCmdSetViewportWScalingEnableNV CmdSetViewportWScalingEnableNV;
extern PFN_vkCmdSetViewportSwizzleNV CmdSetViewportSwizzleNV;
extern PFN_vkCmdSetCoverageToColorEnableNV CmdSetCoverageToColorEnableNV;
extern PFN_vkCmdSetCoverageToColorLocationNV CmdSetCoverageToColorLocationNV;
extern PFN_vkCmdSetCoverageModulationModeNV CmdSetCoverageModulationModeNV;
extern PFN_vkCmdSetCoverageModulationTableEnableNV CmdSetCoverageModulationTableEnableNV;
extern PFN_vkCmdSetCoverageModulationTableNV CmdSetCoverageModulationTableNV;
extern PFN_vkCmdSetShadingRateImageEnableNV CmdSetShadingRateImageEnableNV;
extern PFN_vkCmdSetRepresentativeFragmentTestEnableNV CmdSetRepresentativeFragmentTestEnableNV;
extern PFN_vkCmdSetCoverageReductionModeNV CmdSetCoverageReductionModeNV;
// VK_EXT_external_memory_host
extern PFN_vkGetMemoryHostPointerPropertiesEXT GetMemoryHostPointerPropertiesEXT;
// VK_EXT_full_screen_exclusive
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkGetPhysicalDeviceSurfacePresentModes2EXT GetPhysicalDeviceSurfacePresentModes2EXT;
extern PFN_vkAcquireFullScreenExclusiveModeEXT AcquireFullScreenExclusiveModeEXT;
extern PFN_vkReleaseFullScreenExclusiveModeEXT ReleaseFullScreenExclusiveModeEXT;
extern PFN_vkGetDeviceGroupSurfacePresentModes2EXT GetDeviceGroupSurfacePresentModes2EXT;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_EXT_hdr_metadata
extern PFN_vkSetHdrMetadataEXT SetHdrMetadataEXT;
// VK_EXT_headless_surface
extern PFN_vkCreateHeadlessSurfaceEXT CreateHeadlessSurfaceEXT;
// VK_EXT_host_query_reset
extern PFN_vkResetQueryPoolEXT ResetQueryPoolEXT;
// VK_EXT_image_compression_control
extern PFN_vkGetImageSubresourceLayout2EXT GetImageSubresourceLayout2EXT;
// VK_EXT_image_drm_format_modifier
extern PFN_vkGetImageDrmFormatModifierPropertiesEXT GetImageDrmFormatModifierPropertiesEXT;
// VK_EXT_line_rasterization
extern PFN_vkCmdSetLineStippleEXT CmdSetLineStippleEXT;
// VK_EXT_mesh_shader
extern PFN_vkCmdDrawMeshTasksEXT CmdDrawMeshTasksEXT;
extern PFN_vkCmdDrawMeshTasksIndirectEXT CmdDrawMeshTasksIndirectEXT;
extern PFN_vkCmdDrawMeshTasksIndirectCountEXT CmdDrawMeshTasksIndirectCountEXT;
// VK_EXT_metal_objects
#ifdef VK_USE_PLATFORM_METAL_EXT
extern PFN_vkExportMetalObjectsEXT ExportMetalObjectsEXT;
#endif // VK_USE_PLATFORM_METAL_EXT
// VK_EXT_metal_surface
#ifdef VK_USE_PLATFORM_METAL_EXT
extern PFN_vkCreateMetalSurfaceEXT CreateMetalSurfaceEXT;
#endif // VK_USE_PLATFORM_METAL_EXT
// VK_EXT_multi_draw
extern PFN_vkCmdDrawMultiEXT CmdDrawMultiEXT;
extern PFN_vkCmdDrawMultiIndexedEXT CmdDrawMultiIndexedEXT;
// VK_EXT_opacity_micromap
extern PFN_vkCreateMicromapEXT CreateMicromapEXT;
extern PFN_vkDestroyMicromapEXT DestroyMicromapEXT;
extern PFN_vkCmdBuildMicromapsEXT CmdBuildMicromapsEXT;
extern PFN_vkBuildMicromapsEXT BuildMicromapsEXT;
extern PFN_vkCopyMicromapEXT CopyMicromapEXT;
extern PFN_vkCopyMicromapToMemoryEXT CopyMicromapToMemoryEXT;
extern PFN_vkCopyMemoryToMicromapEXT CopyMemoryToMicromapEXT;
extern PFN_vkWriteMicromapsPropertiesEXT WriteMicromapsPropertiesEXT;
extern PFN_vkCmdCopyMicromapEXT CmdCopyMicromapEXT;
extern PFN_vkCmdCopyMicromapToMemoryEXT CmdCopyMicromapToMemoryEXT;
extern PFN_vkCmdCopyMemoryToMicromapEXT CmdCopyMemoryToMicromapEXT;
extern PFN_vkCmdWriteMicromapsPropertiesEXT CmdWriteMicromapsPropertiesEXT;
extern PFN_vkGetDeviceMicromapCompatibilityEXT GetDeviceMicromapCompatibilityEXT;
extern PFN_vkGetMicromapBuildSizesEXT GetMicromapBuildSizesEXT;
// VK_EXT_pageable_device_local_memory
extern PFN_vkSetDeviceMemoryPriorityEXT SetDeviceMemoryPriorityEXT;
// VK_EXT_pipeline_properties
extern PFN_vkGetPipelinePropertiesEXT GetPipelinePropertiesEXT;
// VK_EXT_private_data
extern PFN_vkCreatePrivateDataSlotEXT CreatePrivateDataSlotEXT;
extern PFN_vkDestroyPrivateDataSlotEXT DestroyPrivateDataSlotEXT;
extern PFN_vkSetPrivateDataEXT SetPrivateDataEXT;
extern PFN_vkGetPrivateDataEXT GetPrivateDataEXT;
// VK_EXT_sample_locations
extern PFN_vkCmdSetSampleLocationsEXT CmdSetSampleLocationsEXT;
extern PFN_vkGetPhysicalDeviceMultisamplePropertiesEXT GetPhysicalDeviceMultisamplePropertiesEXT;
// VK_EXT_shader_module_identifier
extern PFN_vkGetShaderModuleIdentifierEXT GetShaderModuleIdentifierEXT;
extern PFN_vkGetShaderModuleCreateInfoIdentifierEXT GetShaderModuleCreateInfoIdentifierEXT;
// VK_EXT_shader_object
extern PFN_vkCreateShadersEXT CreateShadersEXT;
extern PFN_vkDestroyShaderEXT DestroyShaderEXT;
extern PFN_vkGetShaderBinaryDataEXT GetShaderBinaryDataEXT;
extern PFN_vkCmdBindShadersEXT CmdBindShadersEXT;
// VK_EXT_swapchain_maintenance1
extern PFN_vkReleaseSwapchainImagesEXT ReleaseSwapchainImagesEXT;
// VK_EXT_tooling_info
extern PFN_vkGetPhysicalDeviceToolPropertiesEXT GetPhysicalDeviceToolPropertiesEXT;
// VK_EXT_transform_feedback
extern PFN_vkCmdBindTransformFeedbackBuffersEXT CmdBindTransformFeedbackBuffersEXT;
extern PFN_vkCmdBeginTransformFeedbackEXT CmdBeginTransformFeedbackEXT;
extern PFN_vkCmdEndTransformFeedbackEXT CmdEndTransformFeedbackEXT;
extern PFN_vkCmdBeginQueryIndexedEXT CmdBeginQueryIndexedEXT;
extern PFN_vkCmdEndQueryIndexedEXT CmdEndQueryIndexedEXT;
extern PFN_vkCmdDrawIndirectByteCountEXT CmdDrawIndirectByteCountEXT;
// VK_EXT_validation_cache
extern PFN_vkCreateValidationCacheEXT CreateValidationCacheEXT;
extern PFN_vkDestroyValidationCacheEXT DestroyValidationCacheEXT;
extern PFN_vkMergeValidationCachesEXT MergeValidationCachesEXT;
extern PFN_vkGetValidationCacheDataEXT GetValidationCacheDataEXT;
// VK_EXT_vertex_input_dynamic_state
extern PFN_vkCmdSetVertexInputEXT CmdSetVertexInputEXT;
// VK_FUCHSIA_buffer_collection
#ifdef VK_USE_PLATFORM_FUCHSIA
extern PFN_vkCreateBufferCollectionFUCHSIA CreateBufferCollectionFUCHSIA;
extern PFN_vkSetBufferCollectionImageConstraintsFUCHSIA SetBufferCollectionImageConstraintsFUCHSIA;
extern PFN_vkSetBufferCollectionBufferConstraintsFUCHSIA SetBufferCollectionBufferConstraintsFUCHSIA;
extern PFN_vkDestroyBufferCollectionFUCHSIA DestroyBufferCollectionFUCHSIA;
extern PFN_vkGetBufferCollectionPropertiesFUCHSIA GetBufferCollectionPropertiesFUCHSIA;
#endif // VK_USE_PLATFORM_FUCHSIA
// VK_FUCHSIA_external_memory
#ifdef VK_USE_PLATFORM_FUCHSIA
extern PFN_vkGetMemoryZirconHandleFUCHSIA GetMemoryZirconHandleFUCHSIA;
extern PFN_vkGetMemoryZirconHandlePropertiesFUCHSIA GetMemoryZirconHandlePropertiesFUCHSIA;
#endif // VK_USE_PLATFORM_FUCHSIA
// VK_FUCHSIA_external_semaphore
#ifdef VK_USE_PLATFORM_FUCHSIA
extern PFN_vkImportSemaphoreZirconHandleFUCHSIA ImportSemaphoreZirconHandleFUCHSIA;
extern PFN_vkGetSemaphoreZirconHandleFUCHSIA GetSemaphoreZirconHandleFUCHSIA;
#endif // VK_USE_PLATFORM_FUCHSIA
// VK_FUCHSIA_imagepipe_surface
#ifdef VK_USE_PLATFORM_FUCHSIA
extern PFN_vkCreateImagePipeSurfaceFUCHSIA CreateImagePipeSurfaceFUCHSIA;
#endif // VK_USE_PLATFORM_FUCHSIA
// VK_GGP_stream_descriptor_surface
#ifdef VK_USE_PLATFORM_GGP
extern PFN_vkCreateStreamDescriptorSurfaceGGP CreateStreamDescriptorSurfaceGGP;
#endif // VK_USE_PLATFORM_GGP
// VK_GOOGLE_display_timing
extern PFN_vkGetRefreshCycleDurationGOOGLE GetRefreshCycleDurationGOOGLE;
extern PFN_vkGetPastPresentationTimingGOOGLE GetPastPresentationTimingGOOGLE;
// VK_HUAWEI_cluster_culling_shader
extern PFN_vkCmdDrawClusterHUAWEI CmdDrawClusterHUAWEI;
extern PFN_vkCmdDrawClusterIndirectHUAWEI CmdDrawClusterIndirectHUAWEI;
// VK_HUAWEI_invocation_mask
extern PFN_vkCmdBindInvocationMaskHUAWEI CmdBindInvocationMaskHUAWEI;
// VK_HUAWEI_subpass_shading
extern PFN_vkGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI;
extern PFN_vkCmdSubpassShadingHUAWEI CmdSubpassShadingHUAWEI;
// VK_INTEL_performance_query
extern PFN_vkInitializePerformanceApiINTEL InitializePerformanceApiINTEL;
extern PFN_vkUninitializePerformanceApiINTEL UninitializePerformanceApiINTEL;
extern PFN_vkCmdSetPerformanceMarkerINTEL CmdSetPerformanceMarkerINTEL;
extern PFN_vkCmdSetPerformanceStreamMarkerINTEL CmdSetPerformanceStreamMarkerINTEL;
extern PFN_vkCmdSetPerformanceOverrideINTEL CmdSetPerformanceOverrideINTEL;
extern PFN_vkAcquirePerformanceConfigurationINTEL AcquirePerformanceConfigurationINTEL;
extern PFN_vkReleasePerformanceConfigurationINTEL ReleasePerformanceConfigurationINTEL;
extern PFN_vkQueueSetPerformanceConfigurationINTEL QueueSetPerformanceConfigurationINTEL;
extern PFN_vkGetPerformanceParameterINTEL GetPerformanceParameterINTEL;
// VK_KHR_acceleration_structure
extern PFN_vkCreateAccelerationStructureKHR CreateAccelerationStructureKHR;
extern PFN_vkDestroyAccelerationStructureKHR DestroyAccelerationStructureKHR;
extern PFN_vkCmdBuildAccelerationStructuresKHR CmdBuildAccelerationStructuresKHR;
extern PFN_vkCmdBuildAccelerationStructuresIndirectKHR CmdBuildAccelerationStructuresIndirectKHR;
extern PFN_vkBuildAccelerationStructuresKHR BuildAccelerationStructuresKHR;
extern PFN_vkCopyAccelerationStructureKHR CopyAccelerationStructureKHR;
extern PFN_vkCopyAccelerationStructureToMemoryKHR CopyAccelerationStructureToMemoryKHR;
extern PFN_vkCopyMemoryToAccelerationStructureKHR CopyMemoryToAccelerationStructureKHR;
extern PFN_vkWriteAccelerationStructuresPropertiesKHR WriteAccelerationStructuresPropertiesKHR;
extern PFN_vkCmdCopyAccelerationStructureKHR CmdCopyAccelerationStructureKHR;
extern PFN_vkCmdCopyAccelerationStructureToMemoryKHR CmdCopyAccelerationStructureToMemoryKHR;
extern PFN_vkCmdCopyMemoryToAccelerationStructureKHR CmdCopyMemoryToAccelerationStructureKHR;
extern PFN_vkGetAccelerationStructureDeviceAddressKHR GetAccelerationStructureDeviceAddressKHR;
extern PFN_vkCmdWriteAccelerationStructuresPropertiesKHR CmdWriteAccelerationStructuresPropertiesKHR;
extern PFN_vkGetDeviceAccelerationStructureCompatibilityKHR GetDeviceAccelerationStructureCompatibilityKHR;
extern PFN_vkGetAccelerationStructureBuildSizesKHR GetAccelerationStructureBuildSizesKHR;
// VK_KHR_android_surface
#ifdef VK_USE_PLATFORM_ANDROID_KHR
extern PFN_vkCreateAndroidSurfaceKHR CreateAndroidSurfaceKHR;
#endif // VK_USE_PLATFORM_ANDROID_KHR
// VK_KHR_bind_memory2
extern PFN_vkBindBufferMemory2KHR BindBufferMemory2KHR;
extern PFN_vkBindImageMemory2KHR BindImageMemory2KHR;
// VK_KHR_buffer_device_address
extern PFN_vkGetBufferDeviceAddressKHR GetBufferDeviceAddressKHR;
extern PFN_vkGetBufferOpaqueCaptureAddressKHR GetBufferOpaqueCaptureAddressKHR;
extern PFN_vkGetDeviceMemoryOpaqueCaptureAddressKHR GetDeviceMemoryOpaqueCaptureAddressKHR;
// VK_KHR_copy_commands2
extern PFN_vkCmdCopyBuffer2KHR CmdCopyBuffer2KHR;
extern PFN_vkCmdCopyImage2KHR CmdCopyImage2KHR;
extern PFN_vkCmdCopyBufferToImage2KHR CmdCopyBufferToImage2KHR;
extern PFN_vkCmdCopyImageToBuffer2KHR CmdCopyImageToBuffer2KHR;
extern PFN_vkCmdBlitImage2KHR CmdBlitImage2KHR;
extern PFN_vkCmdResolveImage2KHR CmdResolveImage2KHR;
// VK_KHR_create_renderpass2
extern PFN_vkCreateRenderPass2KHR CreateRenderPass2KHR;
extern PFN_vkCmdBeginRenderPass2KHR CmdBeginRenderPass2KHR;
extern PFN_vkCmdNextSubpass2KHR CmdNextSubpass2KHR;
extern PFN_vkCmdEndRenderPass2KHR CmdEndRenderPass2KHR;
// VK_KHR_deferred_host_operations
extern PFN_vkCreateDeferredOperationKHR CreateDeferredOperationKHR;
extern PFN_vkDestroyDeferredOperationKHR DestroyDeferredOperationKHR;
extern PFN_vkGetDeferredOperationMaxConcurrencyKHR GetDeferredOperationMaxConcurrencyKHR;
extern PFN_vkGetDeferredOperationResultKHR GetDeferredOperationResultKHR;
extern PFN_vkDeferredOperationJoinKHR DeferredOperationJoinKHR;
// VK_KHR_descriptor_update_template
extern PFN_vkCreateDescriptorUpdateTemplateKHR CreateDescriptorUpdateTemplateKHR;
extern PFN_vkDestroyDescriptorUpdateTemplateKHR DestroyDescriptorUpdateTemplateKHR;
extern PFN_vkUpdateDescriptorSetWithTemplateKHR UpdateDescriptorSetWithTemplateKHR;
// VK_KHR_device_group
extern PFN_vkGetDeviceGroupPeerMemoryFeaturesKHR GetDeviceGroupPeerMemoryFeaturesKHR;
extern PFN_vkCmdSetDeviceMaskKHR CmdSetDeviceMaskKHR;
extern PFN_vkCmdDispatchBaseKHR CmdDispatchBaseKHR;
// VK_KHR_device_group_creation
extern PFN_vkEnumeratePhysicalDeviceGroupsKHR EnumeratePhysicalDeviceGroupsKHR;
// VK_KHR_display
extern PFN_vkGetPhysicalDeviceDisplayPropertiesKHR GetPhysicalDeviceDisplayPropertiesKHR;
extern PFN_vkGetPhysicalDeviceDisplayPlanePropertiesKHR GetPhysicalDeviceDisplayPlanePropertiesKHR;
extern PFN_vkGetDisplayPlaneSupportedDisplaysKHR GetDisplayPlaneSupportedDisplaysKHR;
extern PFN_vkGetDisplayModePropertiesKHR GetDisplayModePropertiesKHR;
extern PFN_vkCreateDisplayModeKHR CreateDisplayModeKHR;
extern PFN_vkGetDisplayPlaneCapabilitiesKHR GetDisplayPlaneCapabilitiesKHR;
extern PFN_vkCreateDisplayPlaneSurfaceKHR CreateDisplayPlaneSurfaceKHR;
// VK_KHR_display_swapchain
extern PFN_vkCreateSharedSwapchainsKHR CreateSharedSwapchainsKHR;
// VK_KHR_draw_indirect_count
extern PFN_vkCmdDrawIndirectCountKHR CmdDrawIndirectCountKHR;
extern PFN_vkCmdDrawIndexedIndirectCountKHR CmdDrawIndexedIndirectCountKHR;
// VK_KHR_dynamic_rendering
extern PFN_vkCmdBeginRenderingKHR CmdBeginRenderingKHR;
extern PFN_vkCmdEndRenderingKHR CmdEndRenderingKHR;
// VK_KHR_external_fence_capabilities
extern PFN_vkGetPhysicalDeviceExternalFencePropertiesKHR GetPhysicalDeviceExternalFencePropertiesKHR;
// VK_KHR_external_fence_fd
extern PFN_vkImportFenceFdKHR ImportFenceFdKHR;
extern PFN_vkGetFenceFdKHR GetFenceFdKHR;
// VK_KHR_external_fence_win32
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkImportFenceWin32HandleKHR ImportFenceWin32HandleKHR;
extern PFN_vkGetFenceWin32HandleKHR GetFenceWin32HandleKHR;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_KHR_external_memory_capabilities
extern PFN_vkGetPhysicalDeviceExternalBufferPropertiesKHR GetPhysicalDeviceExternalBufferPropertiesKHR;
// VK_KHR_external_memory_fd
extern PFN_vkGetMemoryFdKHR GetMemoryFdKHR;
extern PFN_vkGetMemoryFdPropertiesKHR GetMemoryFdPropertiesKHR;
// VK_KHR_external_memory_win32
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkGetMemoryWin32HandleKHR GetMemoryWin32HandleKHR;
extern PFN_vkGetMemoryWin32HandlePropertiesKHR GetMemoryWin32HandlePropertiesKHR;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_KHR_external_semaphore_capabilities
extern PFN_vkGetPhysicalDeviceExternalSemaphorePropertiesKHR GetPhysicalDeviceExternalSemaphorePropertiesKHR;
// VK_KHR_external_semaphore_fd
extern PFN_vkImportSemaphoreFdKHR ImportSemaphoreFdKHR;
extern PFN_vkGetSemaphoreFdKHR GetSemaphoreFdKHR;
// VK_KHR_external_semaphore_win32
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkImportSemaphoreWin32HandleKHR ImportSemaphoreWin32HandleKHR;
extern PFN_vkGetSemaphoreWin32HandleKHR GetSemaphoreWin32HandleKHR;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_KHR_fragment_shading_rate
extern PFN_vkGetPhysicalDeviceFragmentShadingRatesKHR GetPhysicalDeviceFragmentShadingRatesKHR;
extern PFN_vkCmdSetFragmentShadingRateKHR CmdSetFragmentShadingRateKHR;
// VK_KHR_get_display_properties2
extern PFN_vkGetPhysicalDeviceDisplayProperties2KHR GetPhysicalDeviceDisplayProperties2KHR;
extern PFN_vkGetPhysicalDeviceDisplayPlaneProperties2KHR GetPhysicalDeviceDisplayPlaneProperties2KHR;
extern PFN_vkGetDisplayModeProperties2KHR GetDisplayModeProperties2KHR;
extern PFN_vkGetDisplayPlaneCapabilities2KHR GetDisplayPlaneCapabilities2KHR;
// VK_KHR_get_memory_requirements2
extern PFN_vkGetImageMemoryRequirements2KHR GetImageMemoryRequirements2KHR;
extern PFN_vkGetBufferMemoryRequirements2KHR GetBufferMemoryRequirements2KHR;
extern PFN_vkGetImageSparseMemoryRequirements2KHR GetImageSparseMemoryRequirements2KHR;
// VK_KHR_get_physical_device_properties2
extern PFN_vkGetPhysicalDeviceFeatures2KHR GetPhysicalDeviceFeatures2KHR;
extern PFN_vkGetPhysicalDeviceProperties2KHR GetPhysicalDeviceProperties2KHR;
extern PFN_vkGetPhysicalDeviceFormatProperties2KHR GetPhysicalDeviceFormatProperties2KHR;
extern PFN_vkGetPhysicalDeviceImageFormatProperties2KHR GetPhysicalDeviceImageFormatProperties2KHR;
extern PFN_vkGetPhysicalDeviceQueueFamilyProperties2KHR GetPhysicalDeviceQueueFamilyProperties2KHR;
extern PFN_vkGetPhysicalDeviceMemoryProperties2KHR GetPhysicalDeviceMemoryProperties2KHR;
extern PFN_vkGetPhysicalDeviceSparseImageFormatProperties2KHR GetPhysicalDeviceSparseImageFormatProperties2KHR;
// VK_KHR_get_surface_capabilities2
extern PFN_vkGetPhysicalDeviceSurfaceCapabilities2KHR GetPhysicalDeviceSurfaceCapabilities2KHR;
extern PFN_vkGetPhysicalDeviceSurfaceFormats2KHR GetPhysicalDeviceSurfaceFormats2KHR;
// VK_KHR_maintenance1
extern PFN_vkTrimCommandPoolKHR TrimCommandPoolKHR;
// VK_KHR_maintenance3
extern PFN_vkGetDescriptorSetLayoutSupportKHR GetDescriptorSetLayoutSupportKHR;
// VK_KHR_maintenance4
extern PFN_vkGetDeviceBufferMemoryRequirementsKHR GetDeviceBufferMemoryRequirementsKHR;
extern PFN_vkGetDeviceImageMemoryRequirementsKHR GetDeviceImageMemoryRequirementsKHR;
extern PFN_vkGetDeviceImageSparseMemoryRequirementsKHR GetDeviceImageSparseMemoryRequirementsKHR;
// VK_KHR_map_memory2
extern PFN_vkMapMemory2KHR MapMemory2KHR;
extern PFN_vkUnmapMemory2KHR UnmapMemory2KHR;
// VK_KHR_performance_query
extern PFN_vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR;
extern PFN_vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR;
extern PFN_vkAcquireProfilingLockKHR AcquireProfilingLockKHR;
extern PFN_vkReleaseProfilingLockKHR ReleaseProfilingLockKHR;
// VK_KHR_pipeline_executable_properties
extern PFN_vkGetPipelineExecutablePropertiesKHR GetPipelineExecutablePropertiesKHR;
extern PFN_vkGetPipelineExecutableStatisticsKHR GetPipelineExecutableStatisticsKHR;
extern PFN_vkGetPipelineExecutableInternalRepresentationsKHR GetPipelineExecutableInternalRepresentationsKHR;
// VK_KHR_present_wait
extern PFN_vkWaitForPresentKHR WaitForPresentKHR;
// VK_KHR_push_descriptor
extern PFN_vkCmdPushDescriptorSetKHR CmdPushDescriptorSetKHR;
extern PFN_vkCmdPushDescriptorSetWithTemplateKHR CmdPushDescriptorSetWithTemplateKHR;
// VK_KHR_ray_tracing_maintenance1
extern PFN_vkCmdTraceRaysIndirect2KHR CmdTraceRaysIndirect2KHR;
// VK_KHR_ray_tracing_pipeline
extern PFN_vkCmdTraceRaysKHR CmdTraceRaysKHR;
extern PFN_vkCreateRayTracingPipelinesKHR CreateRayTracingPipelinesKHR;
extern PFN_vkGetRayTracingCaptureReplayShaderGroupHandlesKHR GetRayTracingCaptureReplayShaderGroupHandlesKHR;
extern PFN_vkCmdTraceRaysIndirectKHR CmdTraceRaysIndirectKHR;
extern PFN_vkGetRayTracingShaderGroupStackSizeKHR GetRayTracingShaderGroupStackSizeKHR;
extern PFN_vkCmdSetRayTracingPipelineStackSizeKHR CmdSetRayTracingPipelineStackSizeKHR;
// VK_KHR_sampler_ycbcr_conversion
extern PFN_vkCreateSamplerYcbcrConversionKHR CreateSamplerYcbcrConversionKHR;
extern PFN_vkDestroySamplerYcbcrConversionKHR DestroySamplerYcbcrConversionKHR;
// VK_KHR_shared_presentable_image
extern PFN_vkGetSwapchainStatusKHR GetSwapchainStatusKHR;
// VK_KHR_surface
extern PFN_vkDestroySurfaceKHR DestroySurfaceKHR;
extern PFN_vkGetPhysicalDeviceSurfaceSupportKHR GetPhysicalDeviceSurfaceSupportKHR;
extern PFN_vkGetPhysicalDeviceSurfaceCapabilitiesKHR GetPhysicalDeviceSurfaceCapabilitiesKHR;
extern PFN_vkGetPhysicalDeviceSurfaceFormatsKHR GetPhysicalDeviceSurfaceFormatsKHR;
extern PFN_vkGetPhysicalDeviceSurfacePresentModesKHR GetPhysicalDeviceSurfacePresentModesKHR;
// VK_KHR_swapchain
extern PFN_vkCreateSwapchainKHR CreateSwapchainKHR;
extern PFN_vkDestroySwapchainKHR DestroySwapchainKHR;
extern PFN_vkGetSwapchainImagesKHR GetSwapchainImagesKHR;
extern PFN_vkAcquireNextImageKHR AcquireNextImageKHR;
extern PFN_vkQueuePresentKHR QueuePresentKHR;
extern PFN_vkGetDeviceGroupPresentCapabilitiesKHR GetDeviceGroupPresentCapabilitiesKHR;
extern PFN_vkGetDeviceGroupSurfacePresentModesKHR GetDeviceGroupSurfacePresentModesKHR;
extern PFN_vkGetPhysicalDevicePresentRectanglesKHR GetPhysicalDevicePresentRectanglesKHR;
extern PFN_vkAcquireNextImage2KHR AcquireNextImage2KHR;
// VK_KHR_synchronization2
extern PFN_vkCmdSetEvent2KHR CmdSetEvent2KHR;
extern PFN_vkCmdResetEvent2KHR CmdResetEvent2KHR;
extern PFN_vkCmdWaitEvents2KHR CmdWaitEvents2KHR;
extern PFN_vkCmdPipelineBarrier2KHR CmdPipelineBarrier2KHR;
extern PFN_vkCmdWriteTimestamp2KHR CmdWriteTimestamp2KHR;
extern PFN_vkQueueSubmit2KHR QueueSubmit2KHR;
extern PFN_vkCmdWriteBufferMarker2AMD CmdWriteBufferMarker2AMD;
extern PFN_vkGetQueueCheckpointData2NV GetQueueCheckpointData2NV;
// VK_KHR_timeline_semaphore
extern PFN_vkGetSemaphoreCounterValueKHR GetSemaphoreCounterValueKHR;
extern PFN_vkWaitSemaphoresKHR WaitSemaphoresKHR;
extern PFN_vkSignalSemaphoreKHR SignalSemaphoreKHR;
// VK_KHR_video_decode_queue
extern PFN_vkCmdDecodeVideoKHR CmdDecodeVideoKHR;
// VK_KHR_video_encode_queue
#ifdef VK_ENABLE_BETA_EXTENSIONS
extern PFN_vkCmdEncodeVideoKHR CmdEncodeVideoKHR;
#endif // VK_ENABLE_BETA_EXTENSIONS
// VK_KHR_video_queue
extern PFN_vkGetPhysicalDeviceVideoCapabilitiesKHR GetPhysicalDeviceVideoCapabilitiesKHR;
extern PFN_vkGetPhysicalDeviceVideoFormatPropertiesKHR GetPhysicalDeviceVideoFormatPropertiesKHR;
extern PFN_vkCreateVideoSessionKHR CreateVideoSessionKHR;
extern PFN_vkDestroyVideoSessionKHR DestroyVideoSessionKHR;
extern PFN_vkGetVideoSessionMemoryRequirementsKHR GetVideoSessionMemoryRequirementsKHR;
extern PFN_vkBindVideoSessionMemoryKHR BindVideoSessionMemoryKHR;
extern PFN_vkCreateVideoSessionParametersKHR CreateVideoSessionParametersKHR;
extern PFN_vkUpdateVideoSessionParametersKHR UpdateVideoSessionParametersKHR;
extern PFN_vkDestroyVideoSessionParametersKHR DestroyVideoSessionParametersKHR;
extern PFN_vkCmdBeginVideoCodingKHR CmdBeginVideoCodingKHR;
extern PFN_vkCmdEndVideoCodingKHR CmdEndVideoCodingKHR;
extern PFN_vkCmdControlVideoCodingKHR CmdControlVideoCodingKHR;
// VK_KHR_wayland_surface
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
extern PFN_vkCreateWaylandSurfaceKHR CreateWaylandSurfaceKHR;
extern PFN_vkGetPhysicalDeviceWaylandPresentationSupportKHR GetPhysicalDeviceWaylandPresentationSupportKHR;
#endif // VK_USE_PLATFORM_WAYLAND_KHR
// VK_KHR_win32_surface
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkCreateWin32SurfaceKHR CreateWin32SurfaceKHR;
extern PFN_vkGetPhysicalDeviceWin32PresentationSupportKHR GetPhysicalDeviceWin32PresentationSupportKHR;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_KHR_xcb_surface
#ifdef VK_USE_PLATFORM_XCB_KHR
extern PFN_vkCreateXcbSurfaceKHR CreateXcbSurfaceKHR;
extern PFN_vkGetPhysicalDeviceXcbPresentationSupportKHR GetPhysicalDeviceXcbPresentationSupportKHR;
#endif // VK_USE_PLATFORM_XCB_KHR
// VK_KHR_xlib_surface
#ifdef VK_USE_PLATFORM_XLIB_KHR
extern PFN_vkCreateXlibSurfaceKHR CreateXlibSurfaceKHR;
extern PFN_vkGetPhysicalDeviceXlibPresentationSupportKHR GetPhysicalDeviceXlibPresentationSupportKHR;
#endif // VK_USE_PLATFORM_XLIB_KHR
// VK_MVK_ios_surface
#ifdef VK_USE_PLATFORM_IOS_MVK
extern PFN_vkCreateIOSSurfaceMVK CreateIOSSurfaceMVK;
#endif // VK_USE_PLATFORM_IOS_MVK
// VK_MVK_macos_surface
#ifdef VK_USE_PLATFORM_MACOS_MVK
extern PFN_vkCreateMacOSSurfaceMVK CreateMacOSSurfaceMVK;
#endif // VK_USE_PLATFORM_MACOS_MVK
// VK_NN_vi_surface
#ifdef VK_USE_PLATFORM_VI_NN
extern PFN_vkCreateViSurfaceNN CreateViSurfaceNN;
#endif // VK_USE_PLATFORM_VI_NN
// VK_NVX_binary_import
extern PFN_vkCreateCuModuleNVX CreateCuModuleNVX;
extern PFN_vkCreateCuFunctionNVX CreateCuFunctionNVX;
extern PFN_vkDestroyCuModuleNVX DestroyCuModuleNVX;
extern PFN_vkDestroyCuFunctionNVX DestroyCuFunctionNVX;
extern PFN_vkCmdCuLaunchKernelNVX CmdCuLaunchKernelNVX;
// VK_NVX_image_view_handle
extern PFN_vkGetImageViewHandleNVX GetImageViewHandleNVX;
extern PFN_vkGetImageViewAddressNVX GetImageViewAddressNVX;
// VK_NV_acquire_winrt_display
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkAcquireWinrtDisplayNV AcquireWinrtDisplayNV;
extern PFN_vkGetWinrtDisplayNV GetWinrtDisplayNV;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_NV_clip_space_w_scaling
extern PFN_vkCmdSetViewportWScalingNV CmdSetViewportWScalingNV;
// VK_NV_cooperative_matrix
extern PFN_vkGetPhysicalDeviceCooperativeMatrixPropertiesNV GetPhysicalDeviceCooperativeMatrixPropertiesNV;
// VK_NV_copy_memory_indirect
extern PFN_vkCmdCopyMemoryIndirectNV CmdCopyMemoryIndirectNV;
extern PFN_vkCmdCopyMemoryToImageIndirectNV CmdCopyMemoryToImageIndirectNV;
// VK_NV_coverage_reduction_mode
extern PFN_vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV;
// VK_NV_device_diagnostic_checkpoints
extern PFN_vkCmdSetCheckpointNV CmdSetCheckpointNV;
extern PFN_vkGetQueueCheckpointDataNV GetQueueCheckpointDataNV;
// VK_NV_device_generated_commands
extern PFN_vkGetGeneratedCommandsMemoryRequirementsNV GetGeneratedCommandsMemoryRequirementsNV;
extern PFN_vkCmdPreprocessGeneratedCommandsNV CmdPreprocessGeneratedCommandsNV;
extern PFN_vkCmdExecuteGeneratedCommandsNV CmdExecuteGeneratedCommandsNV;
extern PFN_vkCmdBindPipelineShaderGroupNV CmdBindPipelineShaderGroupNV;
extern PFN_vkCreateIndirectCommandsLayoutNV CreateIndirectCommandsLayoutNV;
extern PFN_vkDestroyIndirectCommandsLayoutNV DestroyIndirectCommandsLayoutNV;
// VK_NV_external_memory_capabilities
extern PFN_vkGetPhysicalDeviceExternalImageFormatPropertiesNV GetPhysicalDeviceExternalImageFormatPropertiesNV;
// VK_NV_external_memory_rdma
extern PFN_vkGetMemoryRemoteAddressNV GetMemoryRemoteAddressNV;
// VK_NV_external_memory_win32
#ifdef VK_USE_PLATFORM_WIN32_KHR
extern PFN_vkGetMemoryWin32HandleNV GetMemoryWin32HandleNV;
#endif // VK_USE_PLATFORM_WIN32_KHR
// VK_NV_fragment_shading_rate_enums
extern PFN_vkCmdSetFragmentShadingRateEnumNV CmdSetFragmentShadingRateEnumNV;
// VK_NV_memory_decompression
extern PFN_vkCmdDecompressMemoryNV CmdDecompressMemoryNV;
extern PFN_vkCmdDecompressMemoryIndirectCountNV CmdDecompressMemoryIndirectCountNV;
// VK_NV_mesh_shader
extern PFN_vkCmdDrawMeshTasksNV CmdDrawMeshTasksNV;
extern PFN_vkCmdDrawMeshTasksIndirectNV CmdDrawMeshTasksIndirectNV;
extern PFN_vkCmdDrawMeshTasksIndirectCountNV CmdDrawMeshTasksIndirectCountNV;
// VK_NV_optical_flow
extern PFN_vkGetPhysicalDeviceOpticalFlowImageFormatsNV GetPhysicalDeviceOpticalFlowImageFormatsNV;
extern PFN_vkCreateOpticalFlowSessionNV CreateOpticalFlowSessionNV;
extern PFN_vkDestroyOpticalFlowSessionNV DestroyOpticalFlowSessionNV;
extern PFN_vkBindOpticalFlowSessionImageNV BindOpticalFlowSessionImageNV;
extern PFN_vkCmdOpticalFlowExecuteNV CmdOpticalFlowExecuteNV;
// VK_NV_ray_tracing
extern PFN_vkCreateAccelerationStructureNV CreateAccelerationStructureNV;
extern PFN_vkDestroyAccelerationStructureNV DestroyAccelerationStructureNV;
extern PFN_vkGetAccelerationStructureMemoryRequirementsNV GetAccelerationStructureMemoryRequirementsNV;
extern PFN_vkBindAccelerationStructureMemoryNV BindAccelerationStructureMemoryNV;
extern PFN_vkCmdBuildAccelerationStructureNV CmdBuildAccelerationStructureNV;
extern PFN_vkCmdCopyAccelerationStructureNV CmdCopyAccelerationStructureNV;
extern PFN_vkCmdTraceRaysNV CmdTraceRaysNV;
extern PFN_vkCreateRayTracingPipelinesNV CreateRayTracingPipelinesNV;
extern PFN_vkGetRayTracingShaderGroupHandlesKHR GetRayTracingShaderGroupHandlesKHR;
extern PFN_vkGetRayTracingShaderGroupHandlesNV GetRayTracingShaderGroupHandlesNV;
extern PFN_vkGetAccelerationStructureHandleNV GetAccelerationStructureHandleNV;
extern PFN_vkCmdWriteAccelerationStructuresPropertiesNV CmdWriteAccelerationStructuresPropertiesNV;
extern PFN_vkCompileDeferredNV CompileDeferredNV;
// VK_NV_scissor_exclusive
extern PFN_vkCmdSetExclusiveScissorEnableNV CmdSetExclusiveScissorEnableNV;
extern PFN_vkCmdSetExclusiveScissorNV CmdSetExclusiveScissorNV;
// VK_NV_shading_rate_image
extern PFN_vkCmdBindShadingRateImageNV CmdBindShadingRateImageNV;
extern PFN_vkCmdSetViewportShadingRatePaletteNV CmdSetViewportShadingRatePaletteNV;
extern PFN_vkCmdSetCoarseSampleOrderNV CmdSetCoarseSampleOrderNV;
// VK_QCOM_tile_properties
extern PFN_vkGetFramebufferTilePropertiesQCOM GetFramebufferTilePropertiesQCOM;
extern PFN_vkGetDynamicRenderingTilePropertiesQCOM GetDynamicRenderingTilePropertiesQCOM;
// VK_QNX_screen_surface
#ifdef VK_USE_PLATFORM_SCREEN_QNX
extern PFN_vkCreateScreenSurfaceQNX CreateScreenSurfaceQNX;
extern PFN_vkGetPhysicalDeviceScreenPresentationSupportQNX GetPhysicalDeviceScreenPresentationSupportQNX;
#endif // VK_USE_PLATFORM_SCREEN_QNX
// VK_VALVE_descriptor_set_host_mapping
extern PFN_vkGetDescriptorSetLayoutHostMappingInfoVALVE GetDescriptorSetLayoutHostMappingInfoVALVE;
extern PFN_vkGetDescriptorSetHostMappingVALVE GetDescriptorSetHostMappingVALVE;

void InitCore(const char *api_name);
void InitInstanceExtension(VkInstance instance, const char* extension_name);
void InitDeviceExtension(VkInstance instance, VkDevice device, const char* extension_name);
void ResetAllExtensions();

} // namespace vk
