// DESCRIPTION: Verilator: Verilog Test module
//
// This file ONLY is placed into the Public Domain, for any use,
// without warranty, 2023 by Antmicro Ltd.
// SPDX-License-Identifier: CC0-1.0

class Cls;
   int f;
   function new(int x);
      f = x;
   endfunction
endclass

class ExtendCls extends Cls;
   function new(int x);
      super.new(x);
   endfunction
endclass

class AnotherExtendCls extends Cls;
   function new(int x);
      super.new(x);
   endfunction
endclass

class ExtendExtendCls extends ExtendCls;
   function new(int x);
      super.new(x);
   endfunction
endclass

module t (/*AUTOARG*/);
   initial begin
      Cls cls1 = null, cls2 = null;
      ExtendCls ext_cls = null;
      AnotherExtendCls an_ext_cls = null;
      ExtendExtendCls ext_ext_cls = null;

      cls1 = (cls1 == null) ? cls2 : cls1;
      if (cls1 != null) $stop;

      cls1 = new(1);
      cls1 = (cls1 == null) ? cls2 : cls1;
      if (cls1.f != 1) $stop;

      cls1 = (cls1 != null) ? cls2 : cls1;
      if (cls1 != null) $stop;

      cls1 = new(1);
      cls2 = new(2);
      cls1 = (cls1 != null) ? cls2 : cls1;
      if (cls1.f != 2) $stop;

      cls1 = null;
      cls1 = (ext_cls != null) ? ext_cls : cls2;
      if (cls1.f != 2) $stop;

      ext_cls = new(3);
      cls1 = (ext_cls != null) ? ext_cls : cls2;
      if (cls1.f != 3) $stop;

      ext_ext_cls = new(4);
      an_ext_cls = new(5);
      cls1 = (ext_ext_cls.f != 4) ? ext_ext_cls : an_ext_cls;
      if (cls1.f != 5) $stop;

      $write("*-* All Finished *-*\n");
      $finish;
   end
endmodule
