/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//*****************************************************************************
//
// Class:	 UserNotificationServiceLinux
// Date created: 10 Feb 2007
// Description:	 The main class of the service.
//
//*****************************************************************************

#ifndef _USER_NOTIFICATION_SERVICE_H
#define _USER_NOTIFICATION_SERVICE_H

#include "UNSStatus.h"
#include "UNSEventLogger.h"
#include "UserNotificationThread.h"
#include "Credentials.h"
#include "PostureRetrievalThread.h"
#include "AMTStatusThread.h"

#define BACKLOG			(100)	// Max. request backlog
#define	UNS_WAIT_TIME	5000	// Recover wait time.

class UserNotificationService
{
 public:
  UserNotificationService();
  virtual ~UserNotificationService(void);

  // initialize logger
  void InitLogger();
  
  // disable logger
  void DeinitLogger();

  // Perform initialization tasks.
  unsigned long ServiceInitialization(unsigned long	argc,
				      const char	**argv,
				      unsigned long	*specificError);

  // Set credentials from command line
  unsigned long SetCredentialsMode(unsigned long argc,
				   const char    **argv,
				   unsigned long *specificError);

  // Parse Argument
  unsigned long ParseArguments(	int argc,
				const char **argv,
				Credentials **unsCreds,
				Credentials **eacCreds);

  unsigned long UpdateRegistry(int argc, const char **argv);

  // Listen to incoming connections and process them.
  unsigned long Start();

  // Stop the service.
  void Stop();

  // Suspend the service.
  void Suspend();

  // Resume the service.
  void Resume();

#ifdef _DEBUG
  void setClientIP(const string &clip);
  void setServerIP(const string &svip);
#endif

 private:
  // Stop the service.
  void InternalStop();
  // Data members.
  UNSEventLogger	*m_Logger;		   // Used to log events.
  PostureRetrievalThread m_PostureRetreivalThread; // The NAC thread.
  UserNotificationThread m_UserNotificationThread; // The UNS thread
  AMTStatusThread	 m_AMTStatusThread;	   // The AMTStatus thread.
  bool	   		 m_init;
  Semaphore		 m_StopSemaphore;
};

#endif
