/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef UPOWERBATTERYDBUS_H
#define UPOWERBATTERYDBUS_H

#include <QObject>
#include <QtDBus>
#include <QDBusInterface>

class UpowerBatteryDBus : public QObject
{
    Q_OBJECT
public:
    explicit UpowerBatteryDBus(int batteryId, const QString &batteryDBusPath, QObject *parent = nullptr);
    ~UpowerBatteryDBus();

private:
    void initBatteryInfo();

    int m_batteryId;

    QDBusInterface *m_DBusInterface;

    int m_batteryState;

    double m_percentage;

    double m_energy;

    double m_energyFull;

    double m_energyFullDesign;

    double m_energyRate;

    qlonglong m_timeToFull;

    qlonglong m_timeToEmpty;

    double m_temperature;

    int m_warninglevel;

    QString m_vendor;

    QString m_model;

signals:
    void batteryInfoChanged(int, QStringList);

private slots:
    void dealBatteryPropertiesMessage(QDBusMessage);

public:
    int getBatteryState();
    double getBatteryPercentage();
    double getEnergyNow();
    double getEnergyFull();
    double getEnergyFullDesign();
    double getEnergyRate();
    qlonglong getTimeToFull();
    qlonglong getTimeToEmpty();
    double getBatteryTemperature();
    int getWarninglevel();
    QString getBatteryVendor();
    QString getBatteryModel();
};

#endif // UPOWERBATTERYDBUS_H
