/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AREATEST_H
#define AREATEST_H

#include "../../registeredSession/area/areainterface.h"
#include <QtTest>
#include <QCoreApplication>

class AreaTest : public QObject
{
    Q_OBJECT

public:
    AreaTest();
    ~AreaTest();

private slots:
    void initTestCase();
    void cleanupTestCase();
    void testFormatCountry() const;
    void testCalendar() const;
    void testFirstDay() const;
    void testDateFormat() const;
    void testTimeFormat() const;
    void testShowLanguageList() const;
    void testLanguage() const;

private:
    AreaInterface *area            = nullptr;
    QString       formatCountry    = "";
    QString       calendar         = "";
    QString       firstDay         = "";
    QString       dateFormat       = "";
    QString       timeFormat       = "";
    QStringList   showLanguageList = {};
    QString       language         = "";
};

#endif // AREATEST_H
