/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class TOSLibraryLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String string) {
        Object object;
        Object object2;
        boolean bl = false;
        boolean bl2 = true;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        String string2 = "";
        try {
            string2 = string2 + "Attempting to load library '" + string + "'\n";
            System.loadLibrary(string);
            bl = true;
            string2 = string2 + "Library loaded successfully\n";
        }
        catch (Throwable throwable) {
            string2 = string2 + "Could not load library '" + string + "': " + throwable.getMessage() + "\n";
            object2 = new ByteArrayOutputStream();
            object = new PrintStream((OutputStream)object2);
            throwable.printStackTrace((PrintStream)object);
            string2 = string2 + "----------\n";
            string2 = string2 + ((ByteArrayOutputStream)object2).toString();
            string2 = string2 + "----------\n";
        }
        if (!bl) {
            System.err.println("Error loading the TinyOS JNI libraries the conventional way!");
            System.err.println(string2);
            System.out.println("In order to load the library '" + string + "' Java tries to locate the file '" + System.mapLibraryName(string) + "' in one of the " + "following paths:");
            System.out.println(System.getProperty("java.library.path"));
            System.out.println();
            String string3 = System.getProperty("os.name");
            object2 = System.getProperty("os.arch");
            System.out.println("The operating system is '" + string3 + "' (" + (String)object2 + ")");
            System.out.println();
            object = null;
            File file = null;
            if (string3.toLowerCase().startsWith("linux")) {
                if (((String)object2).toLowerCase().equals("x86") || ((String)object2).toLowerCase().equals("i386")) {
                    object = "linux_x86_" + string;
                } else if (!((String)object2).toLowerCase().equals("ppc") && ((String)object2).toLowerCase().equals("amd64")) {
                    object = "linux_amd64_" + string;
                }
            } else if (string3.toLowerCase().startsWith("windows")) {
                if (((String)object2).toLowerCase().equals("x86") || ((String)object2).toLowerCase().equals("i386")) {
                    object = "windows_x86_" + string;
                } else if (!((String)object2).toLowerCase().equals("ppc") && ((String)object2).toLowerCase().equals("amd64")) {
                    // empty if block
                }
            } else if (string3.toLowerCase().startsWith("mac os x")) {
                object = "macosx_universal_" + string;
            }
            if (object != null) {
                object = (String)object + ".lib";
            }
            if (object == null) {
                bl2 = false;
                System.out.println("The operating system and architecture is currently not supported");
            }
            if (bl2) {
                System.out.println("Trying to locate the file '" + (String)object + "' in the classpath");
                inputStream = TOSLibraryLoader.class.getResourceAsStream((String)object);
                if (inputStream == null) {
                    System.out.println("The library file was not found in the classpath");
                    bl2 = false;
                }
            }
            if (bl2) {
                try {
                    file = File.createTempFile(string, ".lib");
                }
                catch (IOException iOException) {
                    bl2 = false;
                    file = null;
                    System.out.println("Could not create temporary file to extract library, aborting...");
                    iOException.printStackTrace();
                }
            }
            if (file == null) {
                bl2 = false;
            }
            if (bl2) {
                System.out.println("Temporary file created: '" + file.getAbsolutePath() + "'");
                file.deleteOnExit();
                try {
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[1024];
                    int n = 0;
                    while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    bl2 = false;
                    System.out.println("An error occurred while copying the library file, aborting...");
                    file.delete();
                    file = null;
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
            if (bl2) {
                try {
                    System.out.println("Library copied successfully. Let's load it.");
                    System.load(file.getAbsolutePath());
                    bl = true;
                    System.out.println("Library loaded successfully");
                }
                catch (Throwable throwable) {
                    bl2 = false;
                    System.out.println("Error loading the library: " + throwable.getMessage());
                    throwable.printStackTrace();
                    file.delete();
                    file = null;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        TOSLibraryLoader.load("toscomm");
    }
}

