//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azblob

import (
	"net/http"
	"time"
)

// AppendBlobAppendBlockFromURLResponse contains the response from method AppendBlob.AppendBlockFromURL.
type AppendBlobAppendBlockFromURLResponse struct {
	AppendBlobAppendBlockFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AppendBlobAppendBlockFromURLResult contains the result from method AppendBlob.AppendBlockFromURL.
type AppendBlobAppendBlockFromURLResult struct {
	// BlobAppendOffset contains the information returned from the x-ms-blob-append-offset header response.
	BlobAppendOffset *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// AppendBlobAppendBlockResponse contains the response from method AppendBlob.AppendBlock.
type AppendBlobAppendBlockResponse struct {
	AppendBlobAppendBlockResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AppendBlobAppendBlockResult contains the result from method AppendBlob.AppendBlock.
type AppendBlobAppendBlockResult struct {
	// BlobAppendOffset contains the information returned from the x-ms-blob-append-offset header response.
	BlobAppendOffset *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// AppendBlobCreateResponse contains the response from method AppendBlob.Create.
type AppendBlobCreateResponse struct {
	AppendBlobCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AppendBlobCreateResult contains the result from method AppendBlob.Create.
type AppendBlobCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// AppendBlobSealResponse contains the response from method AppendBlob.Seal.
type AppendBlobSealResponse struct {
	AppendBlobSealResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// AppendBlobSealResult contains the result from method AppendBlob.Seal.
type AppendBlobSealResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobAbortCopyFromURLResponse contains the response from method Blob.AbortCopyFromURL.
type BlobAbortCopyFromURLResponse struct {
	BlobAbortCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobAbortCopyFromURLResult contains the result from method Blob.AbortCopyFromURL.
type BlobAbortCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobAcquireLeaseResponse contains the response from method Blob.AcquireLease.
type BlobAcquireLeaseResponse struct {
	BlobAcquireLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobAcquireLeaseResult contains the result from method Blob.AcquireLease.
type BlobAcquireLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobBreakLeaseResponse contains the response from method Blob.BreakLease.
type BlobBreakLeaseResponse struct {
	BlobBreakLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobBreakLeaseResult contains the result from method Blob.BreakLease.
type BlobBreakLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseTime contains the information returned from the x-ms-lease-time header response.
	LeaseTime *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobChangeLeaseResponse contains the response from method Blob.ChangeLease.
type BlobChangeLeaseResponse struct {
	BlobChangeLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobChangeLeaseResult contains the result from method Blob.ChangeLease.
type BlobChangeLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobCopyFromURLResponse contains the response from method Blob.CopyFromURL.
type BlobCopyFromURLResponse struct {
	BlobCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobCopyFromURLResult contains the result from method Blob.CopyFromURL.
type BlobCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// BlobCreateSnapshotResponse contains the response from method Blob.CreateSnapshot.
type BlobCreateSnapshotResponse struct {
	BlobCreateSnapshotResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobCreateSnapshotResult contains the result from method Blob.CreateSnapshot.
type BlobCreateSnapshotResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Snapshot contains the information returned from the x-ms-snapshot header response.
	Snapshot *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// BlobDeleteResponse contains the response from method Blob.Delete.
type BlobDeleteResponse struct {
	BlobDeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobDeleteResult contains the result from method Blob.Delete.
type BlobDeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobDownloadResponse contains the response from method Blob.Download.
type BlobDownloadResponse struct {
	BlobDownloadResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobDownloadResult contains the result from method Blob.Download.
type BlobDownloadResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobContentMD5 contains the information returned from the x-ms-blob-content-md5 header response.
	BlobContentMD5 []byte

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	ContentCRC64 []byte

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentRange contains the information returned from the Content-Range header response.
	ContentRange *string

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsCurrentVersion contains the information returned from the x-ms-is-current-version header response.
	IsCurrentVersion *bool

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// ObjectReplicationPolicyID contains the information returned from the x-ms-or-policy-id header response.
	ObjectReplicationPolicyID *string

	// ObjectReplicationRules contains the information returned from the x-ms-or header response.
	ObjectReplicationRules map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// TagCount contains the information returned from the x-ms-tag-count header response.
	TagCount *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// BlobGetAccessControlResponse contains the response from method Blob.GetAccessControl.
type BlobGetAccessControlResponse struct {
	BlobGetAccessControlResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobGetAccessControlResult contains the result from method Blob.GetAccessControl.
type BlobGetAccessControlResult struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSACL contains the information returned from the x-ms-acl header response.
	XMSACL *string

	// XMSGroup contains the information returned from the x-ms-group header response.
	XMSGroup *string

	// XMSOwner contains the information returned from the x-ms-owner header response.
	XMSOwner *string

	// XMSPermissions contains the information returned from the x-ms-permissions header response.
	XMSPermissions *string
}

// BlobGetAccountInfoResponse contains the response from method Blob.GetAccountInfo.
type BlobGetAccountInfoResponse struct {
	BlobGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobGetAccountInfoResult contains the result from method Blob.GetAccountInfo.
type BlobGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobGetPropertiesResponse contains the response from method Blob.GetProperties.
type BlobGetPropertiesResponse struct {
	BlobGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobGetPropertiesResult contains the result from method Blob.GetProperties.
type BlobGetPropertiesResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// AccessTier contains the information returned from the x-ms-access-tier header response.
	AccessTier *string

	// AccessTierChangeTime contains the information returned from the x-ms-access-tier-change-time header response.
	AccessTierChangeTime *time.Time

	// AccessTierInferred contains the information returned from the x-ms-access-tier-inferred header response.
	AccessTierInferred *bool

	// ArchiveStatus contains the information returned from the x-ms-archive-status header response.
	ArchiveStatus *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// CreationTime contains the information returned from the x-ms-creation-time header response.
	CreationTime *time.Time

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// DestinationSnapshot contains the information returned from the x-ms-copy-destination-snapshot header response.
	DestinationSnapshot *string

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// ExpiresOn contains the information returned from the x-ms-expiry-time header response.
	ExpiresOn *time.Time

	// IsCurrentVersion contains the information returned from the x-ms-is-current-version header response.
	IsCurrentVersion *bool

	// IsIncrementalCopy contains the information returned from the x-ms-incremental-copy header response.
	IsIncrementalCopy *bool

	// IsSealed contains the information returned from the x-ms-blob-sealed header response.
	IsSealed *bool

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// ObjectReplicationPolicyID contains the information returned from the x-ms-or-policy-id header response.
	ObjectReplicationPolicyID *string

	// ObjectReplicationRules contains the information returned from the x-ms-or header response.
	ObjectReplicationRules map[string]string

	// RehydratePriority contains the information returned from the x-ms-rehydrate-priority header response.
	RehydratePriority *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// TagCount contains the information returned from the x-ms-tag-count header response.
	TagCount *int64

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// BlobGetTagsResponse contains the response from method Blob.GetTags.
type BlobGetTagsResponse struct {
	BlobGetTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobGetTagsResult contains the result from method Blob.GetTags.
type BlobGetTagsResult struct {
	BlobTags
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// BlobQueryResponse contains the response from method Blob.Query.
type BlobQueryResponse struct {
	BlobQueryResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobQueryResult contains the result from method Blob.Query.
type BlobQueryResult struct {
	// AcceptRanges contains the information returned from the Accept-Ranges header response.
	AcceptRanges *string

	// BlobCommittedBlockCount contains the information returned from the x-ms-blob-committed-block-count header response.
	BlobCommittedBlockCount *int32

	// BlobContentMD5 contains the information returned from the x-ms-blob-content-md5 header response.
	BlobContentMD5 []byte

	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// BlobType contains the information returned from the x-ms-blob-type header response.
	BlobType *BlobType

	// CacheControl contains the information returned from the Cache-Control header response.
	CacheControl *string

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	ContentCRC64 []byte

	// ContentDisposition contains the information returned from the Content-Disposition header response.
	ContentDisposition *string

	// ContentEncoding contains the information returned from the Content-Encoding header response.
	ContentEncoding *string

	// ContentLanguage contains the information returned from the Content-Language header response.
	ContentLanguage *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// ContentRange contains the information returned from the Content-Range header response.
	ContentRange *string

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// CopyCompletionTime contains the information returned from the x-ms-copy-completion-time header response.
	CopyCompletionTime *time.Time

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyProgress contains the information returned from the x-ms-copy-progress header response.
	CopyProgress *string

	// CopySource contains the information returned from the x-ms-copy-source header response.
	CopySource *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// CopyStatusDescription contains the information returned from the x-ms-copy-status-description header response.
	CopyStatusDescription *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobReleaseLeaseResponse contains the response from method Blob.ReleaseLease.
type BlobReleaseLeaseResponse struct {
	BlobReleaseLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobReleaseLeaseResult contains the result from method Blob.ReleaseLease.
type BlobReleaseLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobRenameResponse contains the response from method Blob.Rename.
type BlobRenameResponse struct {
	BlobRenameResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobRenameResult contains the result from method Blob.Rename.
type BlobRenameResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobRenewLeaseResponse contains the response from method Blob.RenewLease.
type BlobRenewLeaseResponse struct {
	BlobRenewLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobRenewLeaseResult contains the result from method Blob.RenewLease.
type BlobRenewLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobSetAccessControlResponse contains the response from method Blob.SetAccessControl.
type BlobSetAccessControlResponse struct {
	BlobSetAccessControlResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetAccessControlResult contains the result from method Blob.SetAccessControl.
type BlobSetAccessControlResult struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobSetExpiryResponse contains the response from method Blob.SetExpiry.
type BlobSetExpiryResponse struct {
	BlobSetExpiryResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetExpiryResult contains the result from method Blob.SetExpiry.
type BlobSetExpiryResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobSetHTTPHeadersResponse contains the response from method Blob.SetHTTPHeaders.
type BlobSetHTTPHeadersResponse struct {
	BlobSetHTTPHeadersResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetHTTPHeadersResult contains the result from method Blob.SetHTTPHeaders.
type BlobSetHTTPHeadersResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobSetMetadataResponse contains the response from method Blob.SetMetadata.
type BlobSetMetadataResponse struct {
	BlobSetMetadataResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetMetadataResult contains the result from method Blob.SetMetadata.
type BlobSetMetadataResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// BlobSetTagsResponse contains the response from method Blob.SetTags.
type BlobSetTagsResponse struct {
	BlobSetTagsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetTagsResult contains the result from method Blob.SetTags.
type BlobSetTagsResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobSetTierResponse contains the response from method Blob.SetTier.
type BlobSetTierResponse struct {
	BlobSetTierResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobSetTierResult contains the result from method Blob.SetTier.
type BlobSetTierResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlobStartCopyFromURLResponse contains the response from method Blob.StartCopyFromURL.
type BlobStartCopyFromURLResponse struct {
	BlobStartCopyFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobStartCopyFromURLResult contains the result from method Blob.StartCopyFromURL.
type BlobStartCopyFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// BlobUndeleteResponse contains the response from method Blob.Undelete.
type BlobUndeleteResponse struct {
	BlobUndeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlobUndeleteResult contains the result from method Blob.Undelete.
type BlobUndeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// BlockBlobCommitBlockListResponse contains the response from method BlockBlob.CommitBlockList.
type BlockBlobCommitBlockListResponse struct {
	BlockBlobCommitBlockListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlockBlobCommitBlockListResult contains the result from method BlockBlob.CommitBlockList.
type BlockBlobCommitBlockListResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// BlockBlobGetBlockListResponse contains the response from method BlockBlob.GetBlockList.
type BlockBlobGetBlockListResponse struct {
	BlockBlobGetBlockListResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlockBlobGetBlockListResult contains the result from method BlockBlob.GetBlockList.
type BlockBlobGetBlockListResult struct {
	BlockList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// BlockBlobStageBlockFromURLResponse contains the response from method BlockBlob.StageBlockFromURL.
type BlockBlobStageBlockFromURLResponse struct {
	BlockBlobStageBlockFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlockBlobStageBlockFromURLResult contains the result from method BlockBlob.StageBlockFromURL.
type BlockBlobStageBlockFromURLResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// BlockBlobStageBlockResponse contains the response from method BlockBlob.StageBlock.
type BlockBlobStageBlockResponse struct {
	BlockBlobStageBlockResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlockBlobStageBlockResult contains the result from method BlockBlob.StageBlock.
type BlockBlobStageBlockResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// BlockBlobUploadResponse contains the response from method BlockBlob.Upload.
type BlockBlobUploadResponse struct {
	BlockBlobUploadResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// BlockBlobUploadResult contains the result from method BlockBlob.Upload.
type BlockBlobUploadResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// ContainerAcquireLeaseResponse contains the response from method Container.AcquireLease.
type ContainerAcquireLeaseResponse struct {
	ContainerAcquireLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerAcquireLeaseResult contains the result from method Container.AcquireLease.
type ContainerAcquireLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerBreakLeaseResponse contains the response from method Container.BreakLease.
type ContainerBreakLeaseResponse struct {
	ContainerBreakLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerBreakLeaseResult contains the result from method Container.BreakLease.
type ContainerBreakLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseTime contains the information returned from the x-ms-lease-time header response.
	LeaseTime *int32

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerChangeLeaseResponse contains the response from method Container.ChangeLease.
type ContainerChangeLeaseResponse struct {
	ContainerChangeLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerChangeLeaseResult contains the result from method Container.ChangeLease.
type ContainerChangeLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerCreateResponse contains the response from method Container.Create.
type ContainerCreateResponse struct {
	ContainerCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerCreateResult contains the result from method Container.Create.
type ContainerCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerDeleteResponse contains the response from method Container.Delete.
type ContainerDeleteResponse struct {
	ContainerDeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerDeleteResult contains the result from method Container.Delete.
type ContainerDeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerGetAccessPolicyResponse contains the response from method Container.GetAccessPolicy.
type ContainerGetAccessPolicyResponse struct {
	ContainerGetAccessPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerGetAccessPolicyResult contains the result from method Container.GetAccessPolicy.
type ContainerGetAccessPolicyResult struct {
	// BlobPublicAccess contains the information returned from the x-ms-blob-public-access header response.
	BlobPublicAccess *PublicAccessType `xml:"BlobPublicAccess"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// a collection of signed identifiers
	SignedIdentifiers []*SignedIdentifier `xml:"SignedIdentifier"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ContainerGetAccountInfoResponse contains the response from method Container.GetAccountInfo.
type ContainerGetAccountInfoResponse struct {
	ContainerGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerGetAccountInfoResult contains the result from method Container.GetAccountInfo.
type ContainerGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerGetPropertiesResponse contains the response from method Container.GetProperties.
type ContainerGetPropertiesResponse struct {
	ContainerGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerGetPropertiesResult contains the result from method Container.GetProperties.
type ContainerGetPropertiesResult struct {
	// BlobPublicAccess contains the information returned from the x-ms-blob-public-access header response.
	BlobPublicAccess *PublicAccessType

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// DefaultEncryptionScope contains the information returned from the x-ms-default-encryption-scope header response.
	DefaultEncryptionScope *string

	// DenyEncryptionScopeOverride contains the information returned from the x-ms-deny-encryption-scope-override header response.
	DenyEncryptionScopeOverride *bool

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// HasImmutabilityPolicy contains the information returned from the x-ms-has-immutability-policy header response.
	HasImmutabilityPolicy *bool

	// HasLegalHold contains the information returned from the x-ms-has-legal-hold header response.
	HasLegalHold *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseDuration contains the information returned from the x-ms-lease-duration header response.
	LeaseDuration *LeaseDurationType

	// LeaseState contains the information returned from the x-ms-lease-state header response.
	LeaseState *LeaseStateType

	// LeaseStatus contains the information returned from the x-ms-lease-status header response.
	LeaseStatus *LeaseStatusType

	// Metadata contains the information returned from the x-ms-meta header response.
	Metadata map[string]string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerListBlobFlatSegmentResponse contains the response from method Container.ListBlobFlatSegment.
type ContainerListBlobFlatSegmentResponse struct {
	ContainerListBlobFlatSegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerListBlobFlatSegmentResult contains the result from method Container.ListBlobFlatSegment.
type ContainerListBlobFlatSegmentResult struct {
	ListBlobsFlatSegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ContainerListBlobHierarchySegmentResponse contains the response from method Container.ListBlobHierarchySegment.
type ContainerListBlobHierarchySegmentResponse struct {
	ContainerListBlobHierarchySegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerListBlobHierarchySegmentResult contains the result from method Container.ListBlobHierarchySegment.
type ContainerListBlobHierarchySegmentResult struct {
	ListBlobsHierarchySegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string `xml:"ContentType"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ContainerReleaseLeaseResponse contains the response from method Container.ReleaseLease.
type ContainerReleaseLeaseResponse struct {
	ContainerReleaseLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerReleaseLeaseResult contains the result from method Container.ReleaseLease.
type ContainerReleaseLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerRenewLeaseResponse contains the response from method Container.RenewLease.
type ContainerRenewLeaseResponse struct {
	ContainerRenewLeaseResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerRenewLeaseResult contains the result from method Container.RenewLease.
type ContainerRenewLeaseResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// LeaseID contains the information returned from the x-ms-lease-id header response.
	LeaseID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerRestoreResponse contains the response from method Container.Restore.
type ContainerRestoreResponse struct {
	ContainerRestoreResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerRestoreResult contains the result from method Container.Restore.
type ContainerRestoreResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerSetAccessPolicyResponse contains the response from method Container.SetAccessPolicy.
type ContainerSetAccessPolicyResponse struct {
	ContainerSetAccessPolicyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerSetAccessPolicyResult contains the result from method Container.SetAccessPolicy.
type ContainerSetAccessPolicyResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ContainerSetMetadataResponse contains the response from method Container.SetMetadata.
type ContainerSetMetadataResponse struct {
	ContainerSetMetadataResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ContainerSetMetadataResult contains the result from method Container.SetMetadata.
type ContainerSetMetadataResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryCreateResponse contains the response from method Directory.Create.
type DirectoryCreateResponse struct {
	DirectoryCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// DirectoryCreateResult contains the result from method Directory.Create.
type DirectoryCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryDeleteResponse contains the response from method Directory.Delete.
type DirectoryDeleteResponse struct {
	DirectoryDeleteResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// DirectoryDeleteResult contains the result from method Directory.Delete.
type DirectoryDeleteResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// Marker contains the information returned from the x-ms-continuation header response.
	Marker *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectoryGetAccessControlResponse contains the response from method Directory.GetAccessControl.
type DirectoryGetAccessControlResponse struct {
	DirectoryGetAccessControlResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// DirectoryGetAccessControlResult contains the result from method Directory.GetAccessControl.
type DirectoryGetAccessControlResult struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSACL contains the information returned from the x-ms-acl header response.
	XMSACL *string

	// XMSGroup contains the information returned from the x-ms-group header response.
	XMSGroup *string

	// XMSOwner contains the information returned from the x-ms-owner header response.
	XMSOwner *string

	// XMSPermissions contains the information returned from the x-ms-permissions header response.
	XMSPermissions *string
}

// DirectoryRenameResponse contains the response from method Directory.Rename.
type DirectoryRenameResponse struct {
	DirectoryRenameResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// DirectoryRenameResult contains the result from method Directory.Rename.
type DirectoryRenameResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentLength contains the information returned from the Content-Length header response.
	ContentLength *int64

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// Marker contains the information returned from the x-ms-continuation header response.
	Marker *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// DirectorySetAccessControlResponse contains the response from method Directory.SetAccessControl.
type DirectorySetAccessControlResponse struct {
	DirectorySetAccessControlResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// DirectorySetAccessControlResult contains the result from method Directory.SetAccessControl.
type DirectorySetAccessControlResult struct {
	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// PageBlobClearPagesResponse contains the response from method PageBlob.ClearPages.
type PageBlobClearPagesResponse struct {
	PageBlobClearPagesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobClearPagesResult contains the result from method PageBlob.ClearPages.
type PageBlobClearPagesResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// PageBlobCopyIncrementalResponse contains the response from method PageBlob.CopyIncremental.
type PageBlobCopyIncrementalResponse struct {
	PageBlobCopyIncrementalResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobCopyIncrementalResult contains the result from method PageBlob.CopyIncremental.
type PageBlobCopyIncrementalResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// CopyID contains the information returned from the x-ms-copy-id header response.
	CopyID *string

	// CopyStatus contains the information returned from the x-ms-copy-status header response.
	CopyStatus *CopyStatusType

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// PageBlobCreateResponse contains the response from method PageBlob.Create.
type PageBlobCreateResponse struct {
	PageBlobCreateResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobCreateResult contains the result from method PageBlob.Create.
type PageBlobCreateResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// VersionID contains the information returned from the x-ms-version-id header response.
	VersionID *string
}

// PageBlobGetPageRangesDiffResponse contains the response from method PageBlob.GetPageRangesDiff.
type PageBlobGetPageRangesDiffResponse struct {
	PageBlobGetPageRangesDiffResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobGetPageRangesDiffResult contains the result from method PageBlob.GetPageRangesDiff.
type PageBlobGetPageRangesDiffResult struct {
	PageList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// PageBlobGetPageRangesResponse contains the response from method PageBlob.GetPageRanges.
type PageBlobGetPageRangesResponse struct {
	PageBlobGetPageRangesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobGetPageRangesResult contains the result from method PageBlob.GetPageRanges.
type PageBlobGetPageRangesResult struct {
	PageList
	// BlobContentLength contains the information returned from the x-ms-blob-content-length header response.
	BlobContentLength *int64 `xml:"BlobContentLength"`

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// ETag contains the information returned from the ETag header response.
	ETag *string `xml:"ETag"`

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time `xml:"LastModified"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// PageBlobResizeResponse contains the response from method PageBlob.Resize.
type PageBlobResizeResponse struct {
	PageBlobResizeResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobResizeResult contains the result from method PageBlob.Resize.
type PageBlobResizeResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// PageBlobUpdateSequenceNumberResponse contains the response from method PageBlob.UpdateSequenceNumber.
type PageBlobUpdateSequenceNumberResponse struct {
	PageBlobUpdateSequenceNumberResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobUpdateSequenceNumberResult contains the result from method PageBlob.UpdateSequenceNumber.
type PageBlobUpdateSequenceNumberResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// PageBlobUploadPagesFromURLResponse contains the response from method PageBlob.UploadPagesFromURL.
type PageBlobUploadPagesFromURLResponse struct {
	PageBlobUploadPagesFromURLResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobUploadPagesFromURLResult contains the result from method PageBlob.UploadPagesFromURL.
type PageBlobUploadPagesFromURLResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// PageBlobUploadPagesResponse contains the response from method PageBlob.UploadPages.
type PageBlobUploadPagesResponse struct {
	PageBlobUploadPagesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// PageBlobUploadPagesResult contains the result from method PageBlob.UploadPages.
type PageBlobUploadPagesResult struct {
	// BlobSequenceNumber contains the information returned from the x-ms-blob-sequence-number header response.
	BlobSequenceNumber *int64

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// ContentMD5 contains the information returned from the Content-MD5 header response.
	ContentMD5 []byte

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// ETag contains the information returned from the ETag header response.
	ETag *string

	// EncryptionKeySHA256 contains the information returned from the x-ms-encryption-key-sha256 header response.
	EncryptionKeySHA256 *string

	// EncryptionScope contains the information returned from the x-ms-encryption-scope header response.
	EncryptionScope *string

	// IsServerEncrypted contains the information returned from the x-ms-request-server-encrypted header response.
	IsServerEncrypted *bool

	// LastModified contains the information returned from the Last-Modified header response.
	LastModified *time.Time

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string

	// XMSContentCRC64 contains the information returned from the x-ms-content-crc64 header response.
	XMSContentCRC64 []byte
}

// ServiceFilterBlobsResponse contains the response from method Service.FilterBlobs.
type ServiceFilterBlobsResponse struct {
	ServiceFilterBlobsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceFilterBlobsResult contains the result from method Service.FilterBlobs.
type ServiceFilterBlobsResult struct {
	FilterBlobSegment
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ServiceGetAccountInfoResponse contains the response from method Service.GetAccountInfo.
type ServiceGetAccountInfoResponse struct {
	ServiceGetAccountInfoResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceGetAccountInfoResult contains the result from method Service.GetAccountInfo.
type ServiceGetAccountInfoResult struct {
	// AccountKind contains the information returned from the x-ms-account-kind header response.
	AccountKind *AccountKind

	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// Date contains the information returned from the Date header response.
	Date *time.Time

	// IsHierarchicalNamespaceEnabled contains the information returned from the x-ms-is-hns-enabled header response.
	IsHierarchicalNamespaceEnabled *bool

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// SKUName contains the information returned from the x-ms-sku-name header response.
	SKUName *SKUName

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ServiceGetPropertiesResponse contains the response from method Service.GetProperties.
type ServiceGetPropertiesResponse struct {
	ServiceGetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceGetPropertiesResult contains the result from method Service.GetProperties.
type ServiceGetPropertiesResult struct {
	StorageServiceProperties
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ServiceGetStatisticsResponse contains the response from method Service.GetStatistics.
type ServiceGetStatisticsResponse struct {
	ServiceGetStatisticsResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceGetStatisticsResult contains the result from method Service.GetStatistics.
type ServiceGetStatisticsResult struct {
	StorageServiceStats
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ServiceGetUserDelegationKeyResponse contains the response from method Service.GetUserDelegationKey.
type ServiceGetUserDelegationKeyResponse struct {
	ServiceGetUserDelegationKeyResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceGetUserDelegationKeyResult contains the result from method Service.GetUserDelegationKey.
type ServiceGetUserDelegationKeyResult struct {
	UserDelegationKey
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// Date contains the information returned from the Date header response.
	Date *time.Time `xml:"Date"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ServiceListContainersSegmentResponse contains the response from method Service.ListContainers.
type ServiceListContainersSegmentResponse struct {
	ServiceListContainersSegmentResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceListContainersSegmentResult contains the result from method Service.ListContainers.
type ServiceListContainersSegmentResult struct {
	ListContainersSegmentResponse
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string `xml:"ClientRequestID"`

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string `xml:"RequestID"`

	// Version contains the information returned from the x-ms-version header response.
	Version *string `xml:"Version"`
}

// ServiceSetPropertiesResponse contains the response from method Service.SetProperties.
type ServiceSetPropertiesResponse struct {
	ServiceSetPropertiesResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceSetPropertiesResult contains the result from method Service.SetProperties.
type ServiceSetPropertiesResult struct {
	// ClientRequestID contains the information returned from the x-ms-client-request-id header response.
	ClientRequestID *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}

// ServiceSubmitBatchResponse contains the response from method Service.SubmitBatch.
type ServiceSubmitBatchResponse struct {
	ServiceSubmitBatchResult
	// RawResponse contains the underlying HTTP response.
	RawResponse *http.Response
}

// ServiceSubmitBatchResult contains the result from method Service.SubmitBatch.
type ServiceSubmitBatchResult struct {
	// ContentType contains the information returned from the Content-Type header response.
	ContentType *string

	// RequestID contains the information returned from the x-ms-request-id header response.
	RequestID *string

	// Version contains the information returned from the x-ms-version header response.
	Version *string
}
