// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified Dedicated Hosts or all your Dedicated Hosts. The results
// describe only the Dedicated Hosts in the Region you're currently using. All
// listed instances consume capacity on your Dedicated Host. Dedicated Hosts that
// have recently been released are listed with the state released.
func (c *Client) DescribeHosts(ctx context.Context, params *DescribeHostsInput, optFns ...func(*Options)) (*DescribeHostsOutput, error) {
	if params == nil {
		params = &DescribeHostsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeHosts", params, optFns, addOperationDescribeHostsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeHostsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeHostsInput struct {

	// The filters.
	//
	// * auto-placement - Whether auto-placement is enabled or disabled
	// (on | off).
	//
	// * availability-zone - The Availability Zone of the host.
	//
	// *
	// client-token - The idempotency token that you provided when you allocated the
	// host.
	//
	// * host-reservation-id - The ID of the reservation assigned to this
	// host.
	//
	// * instance-type - The instance type size that the Dedicated Host is
	// configured to support.
	//
	// * state - The allocation state of the Dedicated Host
	// (available | under-assessment | permanent-failure | released |
	// released-permanent-failure).
	//
	// * tag-key - The key of a tag assigned to the
	// resource. Use this filter to find all resources assigned a tag with a specific
	// key, regardless of the tag value.
	Filter []types.Filter

	// The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.
	HostIds []string

	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error. You cannot specify this parameter
	// and the host IDs parameter in the same request.
	MaxResults int32

	// The token to use to retrieve the next page of results.
	NextToken *string
}

type DescribeHostsOutput struct {

	// Information about the Dedicated Hosts.
	Hosts []types.Host

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationDescribeHostsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeHosts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeHosts{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeHosts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeHostsAPIClient is a client that implements the DescribeHosts operation.
type DescribeHostsAPIClient interface {
	DescribeHosts(context.Context, *DescribeHostsInput, ...func(*Options)) (*DescribeHostsOutput, error)
}

var _ DescribeHostsAPIClient = (*Client)(nil)

// DescribeHostsPaginatorOptions is the paginator options for DescribeHosts
type DescribeHostsPaginatorOptions struct {
	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value. This value can be between 5 and 500. If maxResults is given a
	// larger value than 500, you receive an error. You cannot specify this parameter
	// and the host IDs parameter in the same request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeHostsPaginator is a paginator for DescribeHosts
type DescribeHostsPaginator struct {
	options   DescribeHostsPaginatorOptions
	client    DescribeHostsAPIClient
	params    *DescribeHostsInput
	nextToken *string
	firstPage bool
}

// NewDescribeHostsPaginator returns a new DescribeHostsPaginator
func NewDescribeHostsPaginator(client DescribeHostsAPIClient, params *DescribeHostsInput, optFns ...func(*DescribeHostsPaginatorOptions)) *DescribeHostsPaginator {
	options := DescribeHostsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	if params == nil {
		params = &DescribeHostsInput{}
	}

	return &DescribeHostsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeHostsPaginator) HasMorePages() bool {
	return p.firstPage || p.nextToken != nil
}

// NextPage retrieves the next DescribeHosts page.
func (p *DescribeHostsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeHostsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.DescribeHosts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken && prevToken != nil && p.nextToken != nil && *prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeHosts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "DescribeHosts",
	}
}
