#include <SyFi.h>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() { 
    
    initSyFi(2); 
   
    Dof dof(true, true); 

    Triangle t1(lst(0,0), lst(1,0), lst(0,1)); 
    Triangle t2(lst(1,1), lst(1,0), lst(0,1)); 

    // Create a finite element and corresponding 
    // degrees of freedom on the first triangle
    int order = 2; 
    Lagrange fe; 
    fe.set_order(order); 
    fe.set_polygon(t1); 
    fe.compute_basis_functions(); 
    for (unsigned int i=0; i< fe.nbf() ; i++) {
        cout <<"fe.dof("<<i<<")= "<<fe.dof(i)<<endl;  
        // insert local dof in global set of dofs   
        dof.insert_dof(1,i, fe.dof(i)); 
    }

    // Create a finite element and corresponding 
    // degrees of freedom on the second triangle
    fe.set_polygon(t2); 
    fe.compute_basis_functions(); 
    for (unsigned int i=0; i< fe.nbf() ; i++) {
        cout <<"fe.dof("<<i<<")= "<<fe.dof(i)<<endl; 
        // insert local dof in global set of dofs   
        dof.insert_dof(2,i, fe.dof(i)); 
    }

    // Print out the global degrees of freedom an their 
    // corresponding local degrees of freedom 
    vector<pair<unsigned int,unsigned int> > vec; 
    pair<unsigned int,unsigned int> index; 
    ex exdof; 
    for (unsigned int i=0; i< dof.size(); i++) {
        exdof = dof.glob_dof(i); 
        vec = dof.glob2loc(i);
        cout <<"global dof " <<i<<" dof "<<exdof<<endl; 
        for (unsigned int j=0; j<vec.size(); j++) { 
            index = vec[j]; 
            cout <<"  element "<<index.first<<" local dof "<<index.second<<endl; 
        }
    }
}



