/** @file cmdline.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.6
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef CMDLINE_H
#define CMDLINE_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "sxsim"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "sxsim"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * execute_arg;	/**< @brief Execute commands from FILE in interactive mode.  */
  char * execute_orig;	/**< @brief Execute commands from FILE in interactive mode original value given at command line.  */
  const char *execute_help; /**< @brief Execute commands from FILE in interactive mode help description.  */
  char * dump_cluster_arg;	/**< @brief Dump content of cluster stored in FILE to stdout in CSV format.  */
  char * dump_cluster_orig;	/**< @brief Dump content of cluster stored in FILE to stdout in CSV format original value given at command line.  */
  const char *dump_cluster_help; /**< @brief Dump content of cluster stored in FILE to stdout in CSV format help description.  */
  char * node_list_arg;	/**< @brief Read list of nodes from FILE.  */
  char * node_list_orig;	/**< @brief Read list of nodes from FILE original value given at command line.  */
  const char *node_list_help; /**< @brief Read list of nodes from FILE help description.  */
  char * hash_list_arg;	/**< @brief Read list of hashes from FILE.  */
  char * hash_list_orig;	/**< @brief Read list of hashes from FILE original value given at command line.  */
  const char *hash_list_help; /**< @brief Read list of hashes from FILE help description.  */
  char ** store_data_arg;	/**< @brief Simulate storing of FILE/DIR and optionally force replica count N. This option can be used multiple times, also with different values for N..  */
  char ** store_data_orig;	/**< @brief Simulate storing of FILE/DIR and optionally force replica count N. This option can be used multiple times, also with different values for N. original value given at command line.  */
  unsigned int store_data_min; /**< @brief Simulate storing of FILE/DIR and optionally force replica count N. This option can be used multiple times, also with different values for N.'s minimum occurreces */
  unsigned int store_data_max; /**< @brief Simulate storing of FILE/DIR and optionally force replica count N. This option can be used multiple times, also with different values for N.'s maximum occurreces */
  const char *store_data_help; /**< @brief Simulate storing of FILE/DIR and optionally force replica count N. This option can be used multiple times, also with different values for N. help description.  */
  int replica_count_arg;	/**< @brief Set replica count for storage (default='1').  */
  char * replica_count_orig;	/**< @brief Set replica count for storage original value given at command line.  */
  const char *replica_count_help; /**< @brief Set replica count for storage help description.  */
  char * on_lowspace_addnode_arg;	/**< @brief When cluster gets full add new node(s) NAMEPREFIX-ID of size CAPACITY (allows K, M, G, T suffixes; default M).  */
  char * on_lowspace_addnode_orig;	/**< @brief When cluster gets full add new node(s) NAMEPREFIX-ID of size CAPACITY (allows K, M, G, T suffixes; default M) original value given at command line.  */
  const char *on_lowspace_addnode_help; /**< @brief When cluster gets full add new node(s) NAMEPREFIX-ID of size CAPACITY (allows K, M, G, T suffixes; default M) help description.  */
  char * on_lowspace_addspace_arg;	/**< @brief When node gets full resize it by SIZE (allows K, M, G, T suffixes; default M).  */
  char * on_lowspace_addspace_orig;	/**< @brief When node gets full resize it by SIZE (allows K, M, G, T suffixes; default M) original value given at command line.  */
  const char *on_lowspace_addspace_help; /**< @brief When node gets full resize it by SIZE (allows K, M, G, T suffixes; default M) help description.  */
  int on_upgrade_rebalance_flag;	/**< @brief Force rebalance after each upgrade to the cluster (instead of automatic mode) (default=off).  */
  const char *on_upgrade_rebalance_help; /**< @brief Force rebalance after each upgrade to the cluster (instead of automatic mode) help description.  */
  int blkstats_flag;	/**< @brief Print block statistics for input data (default=off).  */
  const char *blkstats_help; /**< @brief Print block statistics for input data help description.  */
  int block_size_arg;	/**< @brief Set block size (in bytes) (default='65536').  */
  char * block_size_orig;	/**< @brief Set block size (in bytes) original value given at command line.  */
  const char *block_size_help; /**< @brief Set block size (in bytes) help description.  */
  int autobs_small_arg;	/**< @brief Set small block size for autobs (default='4096').  */
  char * autobs_small_orig;	/**< @brief Set small block size for autobs original value given at command line.  */
  const char *autobs_small_help; /**< @brief Set small block size for autobs help description.  */
  int autobs_medium_arg;	/**< @brief Set medium block size for autobs mode (default='16384').  */
  char * autobs_medium_orig;	/**< @brief Set medium block size for autobs mode original value given at command line.  */
  const char *autobs_medium_help; /**< @brief Set medium block size for autobs mode help description.  */
  int autobs_big_arg;	/**< @brief Set big block size for autobs mode (default='1048576').  */
  char * autobs_big_orig;	/**< @brief Set big block size for autobs mode original value given at command line.  */
  const char *autobs_big_help; /**< @brief Set big block size for autobs mode help description.  */
  int autobs_small_limit_arg;	/**< @brief Set maximum file size for small block in autobs mode (default='131072').  */
  char * autobs_small_limit_orig;	/**< @brief Set maximum file size for small block in autobs mode original value given at command line.  */
  const char *autobs_small_limit_help; /**< @brief Set maximum file size for small block in autobs mode help description.  */
  int autobs_big_limit_arg;	/**< @brief Set minimum file size for big block in autobs mode (default='134217728').  */
  char * autobs_big_limit_orig;	/**< @brief Set minimum file size for big block in autobs mode original value given at command line.  */
  const char *autobs_big_limit_help; /**< @brief Set minimum file size for big block in autobs mode help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int execute_given ;	/**< @brief Whether execute was given.  */
  unsigned int dump_cluster_given ;	/**< @brief Whether dump-cluster was given.  */
  unsigned int node_list_given ;	/**< @brief Whether node-list was given.  */
  unsigned int hash_list_given ;	/**< @brief Whether hash-list was given.  */
  unsigned int store_data_given ;	/**< @brief Whether store-data was given.  */
  unsigned int replica_count_given ;	/**< @brief Whether replica-count was given.  */
  unsigned int on_lowspace_addnode_given ;	/**< @brief Whether on-lowspace-addnode was given.  */
  unsigned int on_lowspace_addspace_given ;	/**< @brief Whether on-lowspace-addspace was given.  */
  unsigned int on_upgrade_rebalance_given ;	/**< @brief Whether on-upgrade-rebalance was given.  */
  unsigned int blkstats_given ;	/**< @brief Whether blkstats was given.  */
  unsigned int block_size_given ;	/**< @brief Whether block-size was given.  */
  unsigned int autobs_small_given ;	/**< @brief Whether autobs-small was given.  */
  unsigned int autobs_medium_given ;	/**< @brief Whether autobs-medium was given.  */
  unsigned int autobs_big_given ;	/**< @brief Whether autobs-big was given.  */
  unsigned int autobs_small_limit_given ;	/**< @brief Whether autobs-small-limit was given.  */
  unsigned int autobs_big_limit_given ;	/**< @brief Whether autobs-big-limit was given.  */

} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief the description string of the program */
extern const char *gengetopt_args_info_description;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);

extern const char *cmdline_parser_block_size_values[];  /**< @brief Possible values for block-size. */
extern const char *cmdline_parser_autobs_small_values[];  /**< @brief Possible values for autobs-small. */
extern const char *cmdline_parser_autobs_medium_values[];  /**< @brief Possible values for autobs-medium. */
extern const char *cmdline_parser_autobs_big_values[];  /**< @brief Possible values for autobs-big. */


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* CMDLINE_H */
