/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RESOLVEDCMD_H
#define _SC_RESOLVEDCMD_H

// sc
#include "ScCmd.h"
class ResolvedParam;
class CmdResultCallback;


/**
 * Command for telling subversion that one resolved the conflicts in the given file or folder.
 */
class ResolvedCmd : public ScCmd
{
public:
  /**
   * Construct a ResolvedCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  ResolvedCmd( ResolvedParam* param, CmdResultCallback* cb );
  ~ResolvedCmd();

  void run();

private:
  // in
  ResolvedParam*     _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_RESOLVEDCMD_H
