# Contributing Guidelines for `spopt`

Thank you for your interest in contributing! We work primarily on Github. Please review the contributing procedures [here](http://pysal.org/getting_started#for-developers) and [here](https://github.com/pysal/pysal/wiki/GitHub-Standard-Operating-Procedures) so that we can accept your contributions! Alternatively, contact someone in the [development chat channel](https://gitter.im//pysal/pysal).


## Style and format

1. Python 3.6, 3.7, and 3.8 are the officially supported versions.
2. This project follows the formatting conventions of [`black`](https://black.readthedocs.io/en/stable/) and utilizes [`pre-commit`](https://pre-commit.com) to format commits prior to pull requests being made. 
    * LJ Miranda provides an [excellent, concise guide](https://ljvmiranda921.github.io/notebook/2018/06/21/precommits-using-black-and-flake8/) on setting up and implementing a `pre-commit` hook for `black`.
