from django.test import TestCase

from .models import Eleves, Inventaire, Materiel

# Create your tests here.

class TestAvecBDD(TestCase):
    """
    Tests qui nécessitent de déployer une base de données de tests
    """

    fixtures = ['fixtures/test_data.json']
    
    def test_inventaire(self):
        # nombre total de livres
        livres = Inventaire.objects.all()
        self.assertGreater(
            len(livres), 3000, "on attendrait plus de 3000 livres")
        # dont « non prêtés »
        it, _ = Inventaire.iter_non_prete()
        self.assertEqual(
            sum(1 for _ in it), 1965, "on attendrait 1965 livres non prêtés")
        # dont « prêtés »
        it, _ = Inventaire.iter_prete()
        self.assertEqual(
            sum(1 for _ in it), 1951, "on attendrait 1951 livres prêtés")
        # manuels "Physique Chimie 2nde" prêtés
        ref = Materiel.objects.get(titre="Physique Chimie 2nde")
        it, _ = Inventaire.iter_prete(ref)
        self.assertEqual(
            sum(1 for _ in it), 60,
            "On attendrait 60 livres de Physique Chimie 2nde")
        # À qui est ce livre ?
        liv = Inventaire.objects.get(id = 227)
        self.assertEqual(
            liv.materiel.titre, "Team deutsch 2nde",
            "le titre du livre n°227 devrait être Team deutsch 2nde")
        e = liv.actuellement_a()
        self.assertIs(
            e, None, "le livre Team deutsch 2nde n° 227 ne devrait pas prêté")
        liv = Inventaire.objects.get(id = 667)
        self.assertEqual(
            liv.materiel.titre, "Gammar training time 2nde",
            "le titre du livre n°667 devrait être Gammar training time 2nde")
        e = liv.actuellement_a()
        f = Eleves.objects.get(NomPrenomEleve = "Bifidus Celestine")
        self.assertEqual(
            e.id, f.id,
            "le livre Gammar training time 2nde n° 667 devrait être prêté à " +
            "Bifidus Celestine")
        return
    
