/* scripts spécifiques à l'aide de SLM */

var sommaireTimer = -1; /* une place pour accèder au timer qui replie le sommaire */

function restartSommaireTimer(){
    if (sommaireTimer > 0) clearTimeout(sommaireTimer);
    sommaireTimer = setTimeout(replieSommaire, 3000);
}

function replieSommaire(){
    $(".summary .collapsible").hide(500);
}

function deplieSommaire(){
    $(".summary .collapsible").show(100);
    restartSommaireTimer();
}

function retourAuSommaire(){
    deplieSommaire();
    location.hash='#sommaire';
}

/**
 * Crée un sommaire dans les pages, en examinant les éléments "h2>a",
 * dans la première division de classe "span1"
 **/
function sommaire(){
    var ancres = $("h2>a");
    var container = $("<div class='summary'>≡</div>");
    container.append($("<a name='sommaire'>"));
    container.on("click", deplieSommaire);
    $("section.main-content").prepend(container);
    var div = $("<div class='collapsible'>");
    container.append(div);
    div.on("mouseover", restartSommaireTimer);
    div.append($("<h3>").text("Sommaire"));
    var ul = $("<ul>").addClass("sidetitles");
    div.append(ul);
    var numero = 1;
    ancres.each(function(_, a){
	a= $(a);
	a.attr("name", "name-" + numero);
	var h2 = a.parent()
	var text = h2.text();
	var href = "#name-" + numero;
	var li = $("<li>");
	ul.append(li);
	li.append($("<a>").attr({href: href,}).text(text));
	var button = $("<button>").addClass("sommaire").attr({
	    onclick: "retourAuSommaire();",
	    title: "Remonter au sommaire",
	}).addClass("gotop").text("↟");
	button.insertBefore(h2);
	numero +=1;
    });
    restartSommaireTimer();
}

$( document ).ready(function(){sommaire();});
