/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFStk -- Attribute Filesystem Toolkit Library
 *
 * version.c -- AtFS toolkit library
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: version.c[7.0] Thu Aug 26 13:52:22 1993 axel@cs.tu-berlin.de frozen $
 */

#include "atfs.h"
#include "atfstk.h"

/*================
 * version number
 *================*/

EXPORT int atVno (aso)
     Af_key *aso;
{
  return ((af_retnumattr (aso, AF_ATTGEN) << 16) |
	  (0x0000FFFF & af_retnumattr (aso, AF_ATTREV)));
}

/*==========================
 *  version number aliases
 *==========================*/

EXPORT int atSetVersAlias (aso, alias)
     Af_key *aso;
     char   *alias;
{
  Af_attrs attrBuf;
  Af_set   hitSet;
  int      hitCount;
  Af_key   foundAso;
  char     aliasAttr[AT_MAXALIASLEN];

  sprintf (aliasAttr, "%s=%s", AT_ATTALIAS, alias);
  af_initattrs (&attrBuf);
  strcpy (attrBuf.af_syspath, af_retattr (aso, AF_ATTSPATH));
  strcpy (attrBuf.af_name, af_retattr (aso, AF_ATTNAME));
  strcpy (attrBuf.af_type, af_retattr (aso, AF_ATTTYPE));
  attrBuf.af_udattrs[0] = aliasAttr;
  attrBuf.af_udattrs[1] = NULL;

  if ((hitCount = af_find (&attrBuf, &hitSet)) < 0) { 
    af_dropset (&hitSet); 
    atError (AT_ERROR, af_errmsg ("atSetVersAlias"));
    return (FALSE);
  }

  if (hitCount > 0) {
    char msgBuf[NAME_MAX + AT_MAXALIASLEN + 64];
    /* version number alias already in use */
    af_setgkey  (&hitSet, 0, &foundAso);
    af_dropset (&hitSet);
    if ((af_retnumattr (aso, AF_ATTGEN) == af_retnumattr (&foundAso, AF_ATTGEN)) &&
	(af_retnumattr (aso, AF_ATTREV) == af_retnumattr (&foundAso, AF_ATTREV)))
      return (TRUE);
    sprintf (msgBuf, "version number alias %s already in use for: %s",
	     alias, af_retattr (&foundAso, AF_ATTBOUND));
    atError (AT_MSG, msgBuf); 
    return (FALSE);
 }

  if (af_setattr (aso, AF_ADD, aliasAttr) == -1) {
    atError (AT_ERROR, af_errmsg ("atSetVersAlias"));
    return (FALSE);
  }
  return (TRUE);
}

EXPORT int atDelVersAlias (aso, alias)
     Af_key *aso;
     char   *alias;
{
  char *aliasValPtr, *thisPtr, *nextPtr;
  char aliasAttr[AT_MAXALIASLEN];

  aliasValPtr = thisPtr = af_retattr (aso, AT_ATTALIAS);

  if (!(thisPtr && thisPtr[0])) {
    af_freeattr (aliasValPtr);
    return (TRUE);
  }

  if (af_setattr (aso, AF_REMOVE, AT_ATTALIAS) == -1) {
    atError (AT_ERROR, af_errmsg ("atDelVersAlias"));
    af_freeattr (aliasValPtr);
    return (FALSE);
  }

  /* if alias argument is emty, delete all alias names */
  if (!(alias && alias[0])) {
    af_freeattr (aliasValPtr);
    return (TRUE);
  }

  if ((nextPtr = strchr (thisPtr, '\n'))) {
    *nextPtr = '\0';
    nextPtr++;
  }
  while (thisPtr) {
    if (strcmp (thisPtr, alias)) {
      /* no, this is not the value we are looking for */
      sprintf (aliasAttr, "%s=%s", AT_ATTALIAS, thisPtr);
      if (af_setattr (aso, AF_ADD, aliasAttr) == -1) {
	atError (AT_ERROR, af_errmsg ("atDelVersAlias"));
	af_freeattr (aliasValPtr);
	return (FALSE);
      }
    }
    thisPtr = nextPtr;
    if (thisPtr && (nextPtr = strchr (thisPtr, '\n'))) {
      *nextPtr = '\0';
      nextPtr++;
    }
  }

  af_freeattr (aliasValPtr);
  return (TRUE);
}
