/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "common/config-manager.h"
#include "common/debug.h"
#include "common/file.h"
#include "common/fs.h"
#include "common/memstream.h"

#include "hdb/hdb.h"
#include "hdb/file-manager.h"
#include "hdb/mpc.h"
#include "hdb/menu.h"
#include "hdb/sound.h"

namespace HDB {

const SoundLookUp soundList[] =  {
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	//
	// List of all the sounds we need
	// Define new ones here!
	//
	//@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
	//
	//	enum value			hyperspace_msd.h			lua global name
	//---------------------------------------------------------------
	{SONG_NONE,				POP_WAV,					"SND_POP" },
	{SND_GUI_INPUT,			FUTUREBEEP2_WAV,			"SND_GUI_INPUT"},
	{SND_MAIL_PROCESS,		COMPUTERPROCESS_WAV,		"SND_MAIL_PROCESS"},
	{SND_MONKEY_OOHOOH,		MONKEY_OOHOOH_WAV,			"SND_MONKEY_OOHOOH"},
	{SND_GET_GEM,			GET_GEM_WAV,				"SND_GET_GEM"},
	{SND_MENU_ACCEPT,		MENU_ACCEPT_WAV,			"SND_MENU_ACCEPT"},
	{SND_MENU_BACKOUT,		MENU_BACKOUT_WAV,			"SND_MENU_BACKOUT"},
	{SND_MENU_SLIDER,		MENU_SLIDER_WAV,			"SND_MENU_SLIDER"},
	{SND_DIALOG_CLOSE,		DIALOG_CLOSE_WAV,			"SND_DIALOG_CLOSE"},
	{SND_CRATE_SLIDE,		CRATE_SLIDE_WAV,			"SND_CRATE_SLIDE"},
	{SND_LIGHT_SLIDE,		LIGHT_SLIDE_WAV,			"SND_LIGHT_SLIDE"},
	{SND_HEAVY_SLIDE,		HEAVY_SLIDE_WAV,			"SND_HEAVY_SLIDE"},
	{SND_POP,				POP_WAV,					"SND_POP"},
	{SND_TELEPORT,			TELEPORT3_WAV,				"SND_TELEPORT"},
	{SND_FOOTSTEPS,			FOOTSTEPS_WAV,				"SND_FOOTSTEPS"},
	{SND_SPLASH,			SPLASH_WAV,					"SND_SPLASH"},
	{SND_CELLHOLDER_USE_REJECT, CELLHOLDER_USE_REJECT_WAV, "SND_CELLHOLDER_USE_REJECT"},
	{SND_CHICKEN_AMBIENT,	CHICKEN_AMBIENT_WAV,		"SND_CHICKEN_AMBIENT"},
	{SND_FERRET_SQUEAK,		FERRET_SQUEAK_WAV,			"SND_FERRET_SQUEAK"},
	{SND_SWITCH_USE,		SWITCH_USE_WAV,				"SND_SWITCH_USE"},
	{SND_MOVE_SELECTION,	MOVE_SELECTION_WAV,			"SND_MOVE_SELECTION"},
	{SND_NOTICE,			NOTICE_WAV,					"SND_NOTICE"},
	{SND_MAINTBOT_WHOOSH1,	MAINTBOT_WHOOSH1_WAV,		"SND_MAINTBOT_WHOOSH1"},
	{SND_MAINTBOT_WHOOSH2,	MAINTBOT_WHOOSH2_WAV,		"SND_MAINTBOT_WHOOSH2"},
	{SND_SHIPMOVING_INTRO,	SHIP_MOVING_INTRO_WAV,		"SND_SHIPMOVING_INTRO"},
	{SND_DIALOG_OPEN,		DIALOG_OPEN_WAV,			"SND_DIALOG_OPEN"},
	{SND_TOUCHPLATE_CLICK,	TOUCHPLATE_CLICK_WAV,		"SND_TOUCHPLATE_CLICK"},
	{SND_DOOR_OPEN_CLOSE, 	DOOR_OPEN_CLOSE_WAV,		"SND_DOOR_OPEN_CLOSE"},
	{SND_MBOT_HYEAH,		MBOT_HYEAH_WAV,				"SND_MBOT_HYEAH"},
	{SND_MBOT_YEAH,			MBOT_YEAH_WAV,				"SND_MBOT_YEAH"},
	{SND_MBOT_WHISTLE1,		MBOT_WHISTLE1_WAV,			"SND_MBOT_WHISTLE1"},
	{SND_CLUB_MISS,			CLUB_MISS_WAV,				"SND_CLUB_MISS"},
	{SND_CLUB_HIT_METAL,	CLUB_HIT_METAL_WAV,			"SND_CLUB_HIT_METAL"},
	{SND_CLUB_HIT_FLESH,	CLUB_HIT_FLESH_WAV,			"SND_CLUB_HIT_FLESH"},
	{SND_FROG_LICK,			FROG_LICK_WAV,				"SND_FROG_LICK"},
	{SND_ROBOT_STUNNED,		ROBOT_STUNNED_WAV,			"SND_ROBOT_STUNNED"},
	{SND_QUEST_FAILED,		QUEST_FAILED_WAV,			"SND_QUEST_FAILED"},
	{SND_GET_MONKEYSTONE,	GET_MONKEYSTONE_WAV,		"SND_GET_MONKEYSTONE"},
	{SND_INSERT_CELL,		INSERT_CELL_WAV,			"SND_INSERT_CELL"},
	{SND_CABINET_OPEN,		CABINET_OPEN_WAV,			"SND_CABINET_OPEN"},
	{SND_CABINET_CLOSE,		CABINET_CLOSE_WAV,			"SND_CABINET_CLOSE"},
	{SND_MAILSORTER_HAPPY,	MAILSORTER_HAPPY_WAV,		"SND_MAILSORTER_HAPPY"},
	{SND_QUEST_COMPLETE,	QUEST_COMPLETE_WAV,			"SND_QUEST_COMPLETE"},
	{SND_TRY_AGAIN,			TRY_AGAIN_WAV,				"SND_TRY_AGAIN"},
	{SND_AIRLOCK_CLOSE,		AIRLOCK_CLOSE_WAV,			"SND_AIRLOCK_CLOSE"},
	{SND_BYE,				BYE_WAV,					"SND_BYE"},
	{SND_FART,				FART_WAV,					"SND_FART"},
	{SND_FART2,				FART2_WAV,					"SND_FART2"},
	{SND_GUY_UHUH,			GUY_UHUH_WAV,				"SND_GUY_UHUH"},
	{SND_GUY_DYING,			GUY_DYING_WAV,				"SND_GUY_DYING"},
	{SND_GEM_THROW,			GEM_THROW_WAV,				"SND_GEM_THROW"},
	{SND_INV_SELECT,		INV_SELECT_WAV,				"SND_INV_SELECT"},
	{SND_INFOCOMP,			INFOCOMP_WAV,				"SND_INFOCOMP"},
	{SND_CLOCK_BONK,		CLOCK_BONK_WAV,				"SND_CLOCK_BONK"},
	{SND_HDB,				HDB_WAV,					"SND_HDB"},
	{SND_VORTEX_SAVE,		VORTEXIAN_SAVE_WAV,			"SND_VORTEX_SAVE"},
	{SND_GET_GOO,			GET_GOO_WAV,				"SND_GET_GOO"},
	{SND_MANNY_CRASH,		MANNY_CRASH_WAV,			"SND_MANNY_CRASH"},
	{SND_BARREL_EXPLODE,	BARREL_EXPLODE_WAV,			"SND_BARREL_EXPLODE"},
	{SND_BARREL_MELTING,	BARREL_MELTING_WAV,			"SND_BARREL_MELTING"},
	{SND_CHICKEN_BAGAWK,	CHICKEN_BAGAWK_WAV,			"SND_CHICKEN_BAGAWK"},
	{SND_CHICKEN_DEATH,		CHICKEN_DEATH_WAV,			"SND_CHICKEN_DEATH"},
	{SND_GET_THING,			GET_THING_WAV,				"SND_GET_THING"},
	{SND_STEPS_ICE,			STEPS_ICE_WAV,				"SND_STEPS_ICE"},
	{SND_FOURFIRE_TURN,		FOURFIRE_TURN_WAV,			"SND_FOURFIRE_TURN"},
	{SND_FOUR_FIRE,			FOUR_FIRE_WAV,				"SND_FOUR_FIRE"},
	{SND_SHOCKBOT_AMBIENT,	SHOCKBOT_AMBIENT_WAV,		"SND_SHOCKBOT_AMBIENT"},
	{SND_SHOCKBOT_SHOCK,	SHOCKBOT_SHOCK_WAV,			"SND_SHOCKBOT_SHOCK"},
	{SND_RAILRIDER_ONTRACK,	RAILRIDER_ONTRACK_WAV,		"SND_RAILRIDER_ONTRACK"},
	{SND_RAILRIDER_TASTE, 	RAILRIDER_TASTE_WAV,		"SND_RAILRIDER_TASTE"},
	{SND_RAILRIDER_EXIT,	RAILRIDER_EXIT_WAV,			"SND_RAILRIDER_EXIT"},
	{SND_GUY_FRIED,			GUY_FRIED_WAV,				"SND_GUY_FRIED"},
	{SND_MAILSORTER_UNHAPPY,MAILSORTER_UNHAPPY_WAV,		"SND_MAILSORTER_UNHAPPY"},
	{SND_GET_CLUB,			GET_CLUB_WAV,				"SND_GET_CLUB"},
	{SND_GUY_GRABBED,		GUY_GRABBED_WAV,			"SND_GUY_GRABBED"},
	{SND_GUY_DROWN,			GUY_DROWN_WAV,				"SND_GUY_DROWN"},
	{SND_BUZZFLY_FLY,		BUZZFLY_AMBIENT_WAV,		"SND_BUZZFLY_FLY"},
	{SND_BUZZFLY_STUNNED,	BUZZFLY_STUNNED_WAV,		"SND_BUZZFLY_STUNNED"},
	{SND_BUZZFLY_STING,		BUZZFLY_STING_WAV,			"SND_BUZZFLY_STING"},
	{SND_FATFROG_STUNNED, 	FATFROG_STUNNED_WAV,		"SND_FATFROG_STUNNED"},
	{SND_NOPUSH_SIZZLE,		GUY_NOPUSH_SIZZLE_WAV,		"SND_NOPUSH_SIZZLE"},
	{SND_OMNIBOT_FIRE,		OMNIBOT_FIRE_WAV,			"SND_OMNIBOT_FIRE"},
	{SND_RIGHTBOT_TURN,		RIGHTBOT_TURN_WAV,			"SND_RIGHTBOT_TURN"},
	{SND_RIGHTBOT_STUNNED,	RIGHTBOT_STUNNED_WAV,		"SND_RIGHTBOT_STUNNED"},
	{SND_MONKEY_WIN,		MONKEY_WIN_WAV,				"SND_MONKEY_WIN"},
	{SND_FALL_DOWN_HOLE,	FALL_DOWN_HOLE_WAV,			"SND_FALL_DOWN_HOLE"},
	{SND_MBOT_HMMM,			MBOT_HMMM_WAV,				"SND_MBOT_HMMM"},
	{SND_MBOT_HMMM2,		MBOT_HMMM2_WAV,				"SND_MBOT_HMMM2"},
	{SND_MBOT_DEATH,		MBOT_DEATH_WAV,				"SND_MBOT_DEATH"},
	{SND_MBOT_WHISTLE2,		MBOT_WHISTLE2_WAV,			"SND_MBOT_WHISTLE2"},
	{SND_MBOT_WHISTLE3,		MBOT_WHISTLE3_WAV,			"SND_MBOT_WHISTLE3"},
	{SND_DEADEYE_AMB01,		DEADEYE_AMBIENT01_WAV,		"SND_DEADEYE_AMB01"},
	{SND_DEADEYE_AMB02,		DEADEYE_AMBIENT02_WAV,		"SND_DEADEYE_AMB02"},
	{SND_DEADEYE_ATTACK01,	DEADEYE_GROWL01_WAV,		"SND_DEADEYE_ATTACK01"},
	{SND_DEADEYE_ATTACK02,	DEADEYE_GROWL02_WAV,		"SND_DEADEYE_ATTACK02"},
	{SND_FROG_RIBBIT1,		FROG_RIBBIT1_WAV,			"SND_FROG_RIBBIT1"},
	{SND_FROG_RIBBIT2,		FROG_RIBBIT2_WAV,			"SND_FROG_RIBBIT2"},
	{SND_MEERKAT_BITE,		MEERKAT_BITE_WAV,			"SND_MEERKAT_BITE"},
	{SND_BRIDGE_EXTEND,		BRIDGE_EXTEND_WAV,			"SND_BRIDGE_EXTEND"},
	{SND_BRIDGE_START,		BRIDGE_START_WAV,			"SND_BRIDGE_START"},
	{SND_BRIDGE_END,		BRIDGE_END_WAV,				"SND_BRIDGE_END"},
	{SND_MACHINE_AMBIENT1,	MACHINE_AMBIENT1_WAV,		"SND_MACHINE_AMBIENT1"},
	{SND_GET_STUNNER,		GET_STUNNER_WAV,			"SND_GET_STUNNER"},
	{SND_GET_SLUG,			GET_SLUG_WAV,				"SND_GET_SLUG"},
	{SND_PANIC,				PANIC_WAV,					"SND_PANIC"},
	{SND_PANIC_COUNT,		PANIC_TIMER_WAV,			"SND_PANIC_COUNT"},
	{SND_PANIC_DEATH,		PANIC_DEATH_WAV,			"SND_PANIC_DEATH"},
	{SND_LASER_LOOP,		LASER_LOOP_WAV,				"SND_LASER_LOOP"},
	{SND_SLOT_WIN,			SLOT_WIN_WAV,				"SND_SLOT_WIN"},
	{SND_SLOT_SPIN,			SLOT_SPIN_WAV,				"SND_SLOT_SPIN"},
	{SND_SLOT_STOP,			SLOT_STOP_WAV,				"SND_SLOT_STOP"},
	{SND_GOOD_FAERIE_AMBIENT,	GOOD_FAERIE_AMBIENT_WAV,"SND_GOOD_FAERIE_AMBIENT"},
	{SND_GOOD_FAERIE_SPELL,		GOOD_FAERIE_SPELL_WAV,	"SND_GOOD_FAERIE_SPELL"},
	{SND_GOOD_FAERIE_STUNNED,	GOOD_FAERIE_STUNNED_WAV,"SND_GOOD_FAERIE_STUNNED"},
	{SND_ICEPUFF_WARNING,	ICEPUFF_WARNING_WAV,		"SND_ICEPUFF_WARNING"},
	{SND_ICEPUFF_THROW,		ICEPUFF_THROW_WAV,			"SND_ICEPUFF_THROW"},
	{SND_ICEPUFF_STUNNED,	ICEPUFF_STUNNED_WAV,		"SND_ICEPUFF_STUNNED"},
	{SND_ICEPUFF_APPEAR,	ICEPUFF_APPEAR_WAV,			"SND_ICEPUFF_APPEAR"},
	{SND_GUY_PLUMMET,		GUY_PLUMMET_WAV,			"SND_GUY_PLUMMET"},
	{SND_PUSH_DIVERTER,		LASERD_PUSH_WAV,			"SND_PUSH_DIVERTER"},
	{SND_TURNBOT_TURN,		TURNBOT_TURN_WAV,			"SND_TURNBOT_TURN"},
	{SND_PUSHBOT_STRAIN,	PUSHBOT_STRAIN_WAV,			"SND_PUSHBOT_STRAIN"},
	{SND_MONKEYSTONE_SECRET_STAR, MONKEYSTONE_SECRET_STAR_WAV, "SND_MONKEYSTONE_SECRET_STAR"},
	{SND_OMNIBOT_AMBIENT, 	OMNIBOT_AMBIENT_WAV,		"SND_OMNIBOT_AMBIENT"},
	{SND_PUSHBOT_STUNNED,	PUSHBOT_STUNNED_WAV,		"SND_PUSHBOT_STUNNED"},
	{SND_MEERKAT_WARNING,	MEERKAT_WARNING_WAV,		"SND_MEERKAT_WARNING"},
	{SND_MEERKAT_APPEAR,	MEERKAT_APPEAR_WAV,			"SND_MEERKAT_APPEAR"},
	{SND_MEERKAT_STUNNED,	MEERKAT_STUNNED_WAV,		"SND_MEERKAT_STUNNED"},
	{SND_TURNBOT_STUNNED,	TURNBOT_STUNNED_WAV,		"SND_TURNBOT_STUNNED"},
	{SND_DRAGON_WAKE,		DRAGON_WAKE_WAV,			"SND_DRAGON_WAKE"},
	{SND_DRAGON_FALLASLEEP,	DRAGON_FALL_ASLEEP_WAV,		"SND_DRAGON_FALLASLEEP"},
	{SND_DRAGON_BREATHEFIRE,DRAGON_BREATHE_FIRE_WAV,	"SND_DRAGON_BREATHEFIRE"},
	{SND_BADFAIRY_AMBIENT,	BAD_FAERIE_AMBIENT_WAV,		"SND_BADFAIRY_AMBIENT"},
	{SND_BADFAIRY_SPELL,	BAD_FAERIE_SPELL_WAV,		"SND_BADFAIRY_SPELL"},
	{SND_BADFAIRY_STUNNED,	BAD_FAERIE_STUNNED_WAV,		"SND_BADFAIRY_STUNNED"},
	{SND_DEMIGOD_AMBIENT,	DEMIGOD_AMBIENT_WAV,		"SND_DEMIGOD_AMBIENT"},
	{SND_DEMIGOD_HOLYSPEECH,DEMIGOD_HOLYSPEECH_WAV,		"SND_DEMIGOD_HOLYSPEECH"},
	{SND_DEMIGOD_UNHAPPY,	DEMIGOD_UNHAPPY_WAV,		"SND_DEMIGOD_UNHAPPY"},
	{SND_GATEPUDDLE_AMBIENT,GATEPUDDLE_AMBIENT_WAV,		"SND_GATEPUDDLE_AMBIENT"},
	{SND_GATEPUDDLE_DISSIPATE, GATEPUDDLE_DISSIPATE_WAV, "SND_GATEPUDDLE_DISSIPATE"},
	{SND_GATEPUDDLE_SPAWN,	GATEPUDDLE_SPAWN_WAV,		"SND_GATEPUDDLE_SPAWN"},
	{SND_REALSLOT_SPIN,		SLOTMACHINE_SPINS_WAV,		"SND_REALSLOT_SPIN"},
	{SND_REALSLOT_STOP,		SLOTMACHINE_STOP_WAV,		"SND_REALSLOT_STOP"},
	{SND_REALSLOT_WIN,		SLOTMACHINE_WIN_WAV,		"SND_REALSLOT_WIN"},
	{SND_SLUG_FIRE,			SLUG_FIRE_WAV,				"SND_SLUG_FIRE"},
	{SND_SLUG_HIT,			SLUG_HIT_WAV,				"SND_SLUG_HIT"},
	{SND_STUNNER_FIRE,		STUNNER_ZAP_WAV,			"SND_STUNNER_FIRE"},
	{SND_UNLOCKED_ITEM,		UNLOCKED_ITEM_WAV,			"SND_UNLOCKED_ITEM"},

		//
		// MP1/2 music - external to .MPC file; they're in a MUSIC subdir
		//
	{SONG_TITLE,			SFNAME_TITLE,				"SONG_TITLE"},
	{SONG_MENU,				SFNAME_MENU,				"SONG_MENU"},
	{SONG_ROBO,				SFNAME_ROBO,				"SONG_ROBO"},
	{SONG_MEXI,				SFNAME_MEXI,				"SONG_MEXI"},
	{SONG_BASSO,			SFNAME_BASSO,				"SONG_BASSO"},
	{SONG_WIND,				SFNAME_WIND,				"SONG_WIND"},
	{SONG_INDUSTRO,			SFNAME_INDUSTRO,			"SONG_INDUSTRO"},
	{SONG_JACKIN,			SFNAME_JACKIN,				"SONG_JACKIN"},
	{SONG_SNEAKERS,			SFNAME_SNEAKERS,			"SONG_SNEAKERS"},
	{SONG_QUIET,			SFNAME_QUIET,				"SONG_QUIET"},
	{SONG_JEEBIES,			SFNAME_JEEBIES,				"SONG_JEEBIES"},
	{SONG_VIBRACIOUS,		SFNAME_VIBRACIOUS,			"SONG_VIBRACIOUS"},
	{SONG_ROMANTIC,			SFNAME_ROMANTIC,			"SONG_ROMANTIC"},
	{SONG_ARETHERE,			SFNAME_ARETHERE,			"SONG_ARETHERE"},

	{SONG_CORRIDOR,			SFNAME_CORRIDOR,			"SONG_CORRIDOR"},
	{SONG_MOKE,				SFNAME_MOKE,				"SONG_MOKE"},
	{SONG_TILES,			SFNAME_TILES,				"SONG_TILES"},
	{SONG_DARKVIB,			SFNAME_DARKVIB,				"SONG_DARKVIB"},
	{SONG_EXPER,			SFNAME_EXPER,				"SONG_EXPER"},

	{SND_BEEPBEEPBEEP,		BEEPBEEPBEEP_WAV,			"SND_BEEPBEEPBEEP"},

		//
		// Voice files - in the .MPC file
		//
	{V00_AIRLOCK_01,		M00_AIRLOCK_01_MP3,			"V00_AIRLOCK_01"},
	{V00_ARNIE_01,			M00_ARNIE_01_MP3,			"V00_ARNIE_01"},

	{V00_BRAD_01,			M00_BRAD_01_MP3,			"V00_BRAD_01"},
	{V00_BRAD_02,			M00_BRAD_02_MP3,			"V00_BRAD_02"},
	{V00_BRAD_03,			M00_BRAD_03_MP3,			"V00_BRAD_03"},

	{V00_BUSTER_01,			M00_BUSTER_01_MP3,			"V00_BUSTER_01"},
	{V00_BUSTER_02,			M00_BUSTER_02_MP3,			"V00_BUSTER_02"},
	{V00_BUSTER_03,			M00_BUSTER_03_MP3,			"V00_BUSTER_03"},
	{V00_BUSTER_04,			M00_BUSTER_04_MP3,			"V00_BUSTER_04"},
	{V00_BUSTER_05,			M00_BUSTER_05_MP3,			"V00_BUSTER_05"},
	{V00_BUSTER_06,			M00_BUSTER_06_MP3,			"V00_BUSTER_06"},
	{V00_BUSTER_07,			M00_BUSTER_07_MP3,			"V00_BUSTER_07"},
	{V00_BUSTER_08,			M00_BUSTER_08_MP3,			"V00_BUSTER_08"},
	{V00_BUSTER_09,			M00_BUSTER_09_MP3,			"V00_BUSTER_09"},
	{V00_BUSTER_10,			M00_BUSTER_10_MP3,			"V00_BUSTER_10"},
	{V00_BUSTER_11,			M00_BUSTER_11_MP3,			"V00_BUSTER_11"},
	{V00_BUSTER_12,			M00_BUSTER_12_MP3,			"V00_BUSTER_12"},
	{V00_BUSTER_13A,		M00_BUSTER_13A_MP3,			"V00_BUSTER_13A"},
	{V00_BUSTER_13B,		M00_BUSTER_13B_MP3,			"V00_BUSTER_13B"},
	{V00_BUSTER_14,			M00_BUSTER_14_MP3,			"V00_BUSTER_14"},
	{V00_BUSTER_15,			M00_BUSTER_15_MP3,			"V00_BUSTER_15"},
	{V00_BUSTER_16,			M00_BUSTER_16_MP3,			"V00_BUSTER_16"},
	{V00_BUSTER_17,			M00_BUSTER_17_MP3,			"V00_BUSTER_17"},
	{V00_BUSTER_18,			M00_BUSTER_18_MP3,			"V00_BUSTER_18"},
	{V00_BUSTER_19,			M00_BUSTER_19_MP3,			"V00_BUSTER_19"},

	{V00_CHICKEN_01,		M00_CHICKEN_01_MP3,			"V00_CHICKEN_01"},

	{V00_CHUTEGUARD_01,		M00_CHUTEGUARD_01_MP3,		"V00_CHUTEGUARD_01"},
	{V00_CHUTEGUARD_02,		M00_CHUTEGUARD_02_MP3,		"V00_CHUTEGUARD_02"},
	{V00_CHUTEGUARD_03,		M00_CHUTEGUARD_03_MP3,		"V00_CHUTEGUARD_03"},
	{V00_CHUTEGUARD_04,		M00_CHUTEGUARD_04_MP3,		"V00_CHUTEGUARD_04"},
	{V00_CHUTEGUARD_05,		M00_CHUTEGUARD_05_MP3,		"V00_CHUTEGUARD_05"},

	{V00_COOPER_01,			M00_COOPER_01_MP3,			"V00_COOPER_01"},
	{V00_COOPER_02,			M00_COOPER_02_MP3,			"V00_COOPER_02"},
	{V00_COOPER_03,			M00_COOPER_03_MP3,			"V00_COOPER_03"},
	{V00_COOPER_04,			M00_COOPER_04_MP3,			"V00_COOPER_04"},
	{V00_COOPER_05,			M00_COOPER_05_MP3,			"V00_COOPER_05"},

	{V00_DINERS_01,			M00_DINERS_01_MP3,			"V00_DINERS_01"},
	{V00_DINERS_02,			M00_DINERS_02_MP3,			"V00_DINERS_02"},
	{V00_DINERS_03,			M00_DINERS_03_MP3,			"V00_DINERS_03"},
	{V00_DINERS_04,			M00_DINERS_04_MP3,			"V00_DINERS_04"},
	{V00_DINERS_05,			M00_DINERS_05_MP3,			"V00_DINERS_05"},
	{V00_DINERS_06,			M00_DINERS_06_MP3,			"V00_DINERS_06"},

	{V00_DOLLY_01,			M00_DOLLY_01_MP3,			"V00_DOLLY_01"},
	{V00_DOLLY_02,			M00_DOLLY_02_MP3,			"V00_DOLLY_02"},
	{V00_DOLLY_03,			M00_DOLLY_03_MP3,			"V00_DOLLY_03"},
	{V00_DOLLY_04,			M00_DOLLY_04_MP3,			"V00_DOLLY_04"},
	{V00_DOLLY_05,			M00_DOLLY_05_MP3,			"V00_DOLLY_05"},
	{V00_DOLLY_06,			M00_DOLLY_06_MP3,			"V00_DOLLY_06"},
	{V00_DOLLY_07,			M00_DOLLY_07_MP3,			"V00_DOLLY_07"},
	{V00_DOLLY_08,			M00_DOLLY_08_MP3,			"V00_DOLLY_08"},
	{V00_DOLLY_09,			M00_DOLLY_09_MP3,			"V00_DOLLY_09"},

	{V00_DOREK_01,			M00_DOREK_01_MP3,			"V00_DOREK_01"},
	{V00_DOREK_02,			M00_DOREK_02_MP3,			"V00_DOREK_02"},
	{V00_DOREK_03,			M00_DOREK_03_MP3,			"V00_DOREK_03"},
	{V00_DOREK_04,			M00_DOREK_04_MP3,			"V00_DOREK_04"},

	{V00_ENGCOMPUTER_01,	M00_ENGCOMPUTER_01_MP3,		"V00_ENGCOMPUTER_01"},
	{V00_ENGCOMPUTER_02,	M00_ENGCOMPUTER_02_MP3,		"V00_ENGCOMPUTER_02"},

	{V00_FARBLE_01,			M00_FARBLE_01_MP3,			"V00_FARBLE_01"},
	{V00_FARBLE_02,			M00_FARBLE_02_MP3,			"V00_FARBLE_02"},
	{V00_FARBLE_03,			M00_FARBLE_03_MP3,			"V00_FARBLE_03"},
	{V00_FARBLE_04,			M00_FARBLE_04_MP3,			"V00_FARBLE_04"},
	{V00_FARBLE_05,			M00_FARBLE_05_MP3,			"V00_FARBLE_05"},
	{V00_FARBLE_06,			M00_FARBLE_06_MP3,			"V00_FARBLE_06"},
	{V00_FARBLE_07,			M00_FARBLE_07_MP3,			"V00_FARBLE_07"},
	{V00_FARBLE_08,			M00_FARBLE_08_MP3,			"V00_FARBLE_08"},

	{V00_GRUNETT_01,		M00_GRUNETT_01_MP3,			"V00_GRUNETT_01"},
	{V00_GRUNETT_02,		M00_GRUNETT_02_MP3,			"V00_GRUNETT_02"},
	{V00_GRUNETT_03,		M00_GRUNETT_03_MP3,			"V00_GRUNETT_03"},
	{V00_GRUNETT_04,		M00_GRUNETT_04_MP3,			"V00_GRUNETT_04"},

	{V00_GUY_01,			M00_GUY_01_MP3,				"V00_GUY_01"},
	{V00_GUY_02,			M00_GUY_02_MP3,				"V00_GUY_02"},
	{V00_GUY_03,			M00_GUY_03_MP3,				"V00_GUY_03"},
	{V00_GUY_04,			M00_GUY_04_MP3,				"V00_GUY_04"},
	{V00_GUY_05,			M00_GUY_05_MP3,				"V00_GUY_05"},
	{V00_GUY_06,			M00_GUY_06_MP3,				"V00_GUY_06"},
	{V00_GUY_07,			M00_GUY_07_MP3,				"V00_GUY_07"},
	{V00_GUY_08,			M00_GUY_08_MP3,				"V00_GUY_08"},
	{V00_GUY_09,			M00_GUY_09_MP3,				"V00_GUY_09"},
	{V00_GUY_10A,			M00_GUY_10A_MP3,			"V00_GUY_10A"},
	{V00_GUY_10B,			M00_GUY_10B_MP3,			"V00_GUY_10B"},
	{V00_GUY_11,			M00_GUY_11_MP3,				"V00_GUY_11"},
	{V00_GUY_12,			M00_GUY_12_MP3,				"V00_GUY_12"},
	{V00_GUY_13,			M00_GUY_13_MP3,				"V00_GUY_13"},
	{V00_GUY_14,			M00_GUY_14_MP3,				"V00_GUY_14"},
	{V00_GUY_15,			M00_GUY_15_MP3,				"V00_GUY_15"},
	{V00_GUY_16,			M00_GUY_16_MP3,				"V00_GUY_16"},
	{V00_GUY_17,			M00_GUY_17_MP3,				"V00_GUY_17"},
	{V00_GUY_18,			M00_GUY_18_MP3,				"V00_GUY_18"},

	{V00_HUMBERT_01,		M00_HUMBERT_01_MP3,			"V00_HUMBERT_01"},
	{V00_HUMBERT_02,		M00_HUMBERT_02_MP3,			"V00_HUMBERT_02"},

	{V00_ILLIAC_01,			M00_ILLIAC_01_MP3,			"V00_ILLIAC_01"},
	{V00_INFOCOMP_01,		M00_INFOCOMP_01_MP3,		"V00_INFOCOMP_01"},

	{V00_JAQUES_01,			M00_JAQUES_01_MP3,			"V00_JAQUES_01"},
	{V00_JAQUES_03,			M00_JAQUES_03_MP3,			"V00_JAQUES_03"},
	{V00_JAQUES_04,			M00_JAQUES_04_MP3,			"V00_JAQUES_04"},
	{V00_JAQUES_05,			M00_JAQUES_05_MP3,			"V00_JAQUES_05"},

	{V00_LUMBAR_01,			M00_LUMBAR_01_MP3,			"V00_LUMBAR_01"},

	{V00_MAILSORTER_01,		M00_MAILSORTER_01_MP3,		"V00_MAILSORTER_01"},
	{V00_MAILSORTER_02,		M00_MAILSORTER_02_MP3,		"V00_MAILSORTER_02"},
	{V00_MAILSORTER_03,		M00_MAILSORTER_03_MP3,		"V00_MAILSORTER_03"},
	{V00_MAILSORTER_04,		M00_MAILSORTER_04_MP3,		"V00_MAILSORTER_04"},
	{V00_MAILSORTER_05,		M00_MAILSORTER_05_MP3,		"V00_MAILSORTER_05"},
	{V00_MAILSORTER_06,		M00_MAILSORTER_06_MP3,		"V00_MAILSORTER_06"},
	{V00_MAILSORTER_07,		M00_MAILSORTER_07_MP3,		"V00_MAILSORTER_07"},
	{V00_MAILSORTER_08,		M00_MAILSORTER_08_MP3,		"V00_MAILSORTER_08"},
	{V00_MAILSORTER_09,		M00_MAILSORTER_09_MP3,		"V00_MAILSORTER_09"},
	{V00_MAILSORTER_10,		M00_MAILSORTER_10_MP3,		"V00_MAILSORTER_10"},
	{V00_MAILSORTER_11,		M00_MAILSORTER_11_MP3,		"V00_MAILSORTER_11"},
	{V00_MAILSORTER_12,		M00_MAILSORTER_12_MP3,		"V00_MAILSORTER_12"},
	{V00_MAILSORTER_13,		M00_MAILSORTER_13_MP3,		"V00_MAILSORTER_13"},
	{V00_MAILSORTER_14,		M00_MAILSORTER_14_MP3,		"V00_MAILSORTER_14"},
	{V00_MAILSORTER_15,		M00_MAILSORTER_15_MP3,		"V00_MAILSORTER_15"},

	{V00_MANNY_01,			M00_MANNY_01_MP3,			"V00_MANNY_01"},
	{V00_MANNY_02,			M00_MANNY_02_MP3,			"V00_MANNY_02"},
	{V00_MANNY_03,			M00_MANNY_03_MP3,			"V00_MANNY_03"},
	{V00_MANNY_04,			M00_MANNY_04_MP3,			"V00_MANNY_04"},
	{V00_MANNY_05,			M00_MANNY_05_MP3,			"V00_MANNY_05"},
	{V00_MANNY_06,			M00_MANNY_06_MP3,			"V00_MANNY_06"},
	{V00_MANNY_07,			M00_MANNY_07_MP3,			"V00_MANNY_07"},
	{V00_MANNY_08,			M00_MANNY_08_MP3,			"V00_MANNY_08"},
	{V00_MANNY_09,			M00_MANNY_09_MP3,			"V00_MANNY_09"},
	{V00_MANNY_10,			M00_MANNY_10_MP3,			"V00_MANNY_10"},
	{V00_MANNY_11,			M00_MANNY_11_MP3,			"V00_MANNY_11"},
	{V00_MANNY_12,			M00_MANNY_12_MP3,			"V00_MANNY_12"},
	{V00_MANNY_13,			M00_MANNY_13_MP3,			"V00_MANNY_13"},
	{V00_MANNY_14,			M00_MANNY_14_MP3,			"V00_MANNY_14"},
	{V00_MANNY_15,			M00_MANNY_15_MP3,			"V00_MANNY_15"},
	{V00_MANNY_16,			M00_MANNY_16_MP3,			"V00_MANNY_16"},
	{V00_MANNY_17,			M00_MANNY_17_MP3,			"V00_MANNY_17"},
	{V00_MANNY_18,			M00_MANNY_18_MP3,			"V00_MANNY_18"},

	{V00_NOTEBRICK_01,		M00_NOTEBRICK_01_MP3,		"V00_NOTEBRICK_01"},

	{V00_PILOTS_01,			M00_PILOTS_01_MP3,			"V00_PILOTS_01"},
	{V00_PILOTS_02,			M00_PILOTS_02_MP3,			"V00_PILOTS_02"},

	{V00_POLONEY_01,		M00_POLONEY_01_MP3,			"V00_POLONEY_01"},
	{V00_POLONEY_02,		M00_POLONEY_02_MP3,			"V00_POLONEY_02"},
	{V00_POLONEY_03,		M00_POLONEY_03_MP3,			"V00_POLONEY_03"},
	{V00_POLONEY_04,		M00_POLONEY_04_MP3,			"V00_POLONEY_04"},
	{V00_POLONEY_05,		M00_POLONEY_05_MP3,			"V00_POLONEY_05"},
	{V00_POLONEY_06,		M00_POLONEY_06_MP3,			"V00_POLONEY_06"},

	{V00_SARGE_01,			M00_SARGE_01_MP3,			"V00_SARGE_01"},
	{V00_SARGE_02,			M00_SARGE_02_MP3,			"V00_SARGE_02"},
	{V00_SARGE_03,			M00_SARGE_03_MP3,			"V00_SARGE_03"},
	{V00_SARGE_04,			M00_SARGE_04_MP3,			"V00_SARGE_04"},
	{V00_SARGE_05,			M00_SARGE_05_MP3,			"V00_SARGE_05"},
	{V00_SARGE_06,			M00_SARGE_06_MP3,			"V00_SARGE_06"},
	{V00_SARGE_07,			M00_SARGE_07_MP3,			"V00_SARGE_07"},
	{V00_SARGE_08,			M00_SARGE_08_MP3,			"V00_SARGE_08"},
	{V00_SARGE_09,			M00_SARGE_09_MP3,			"V00_SARGE_09"},
	{V00_SARGE_10,			M00_SARGE_10_MP3,			"V00_SARGE_10"},
	{V00_SARGE_11,			M00_SARGE_11_MP3,			"V00_SARGE_11"},
	{V00_SARGE_12,			M00_SARGE_12_MP3,			"V00_SARGE_12"},
	{V00_SARGE_13,			M00_SARGE_13_MP3,			"V00_SARGE_13"},
	{V00_SARGE_14,			M00_SARGE_14_MP3,			"V00_SARGE_14"},
	{V00_SARGE_15,			M00_SARGE_15_MP3,			"V00_SARGE_15"},
	{V00_SARGE_16,			M00_SARGE_16_MP3,			"V00_SARGE_16"},

	{V01_ALABASTER_01,		M01_ALABASTER_01_MP3,		"V01_ALABASTER_01"},
	{V01_ALABASTER_02,		M01_ALABASTER_02_MP3,		"V01_ALABASTER_02"},
	{V01_ALABASTER_03,		M01_ALABASTER_03_MP3,		"V01_ALABASTER_03"},
	{V01_ALABASTER_04,		M01_ALABASTER_04_MP3,		"V01_ALABASTER_04"},
	{V01_ALABASTER_05,		M01_ALABASTER_05_MP3,		"V01_ALABASTER_05"},
	{V01_ALABASTER_06,		M01_ALABASTER_06_MP3,		"V01_ALABASTER_06"},
	{V01_BRAKER_01,			M01_BRAKER_01_MP3,			"V01_BRAKER_01"},
	{V01_BRAKER_02,			M01_BRAKER_02_MP3,			"V01_BRAKER_02"},
	{V01_BRAKER_03,			M01_BRAKER_03_MP3,			"V01_BRAKER_03"},
	{V01_BRAKER_04,			M01_BRAKER_04_MP3,			"V01_BRAKER_04"},
	{V01_CHISTE_01,			M01_CHISTE_01_MP3,			"V01_CHISTE_01"},
	{V01_CHISTE_02,			M01_CHISTE_02_MP3,			"V01_CHISTE_02"},
	{V01_CHISTE_03,			M01_CHISTE_03_MP3,			"V01_CHISTE_03"},
	{V01_CHISTE_04,			M01_CHISTE_04_MP3,			"V01_CHISTE_04"},
	{V01_CHISTE_05,			M01_CHISTE_05_MP3,			"V01_CHISTE_05"},
	{V01_CHISTE_06,			M01_CHISTE_06_MP3,			"V01_CHISTE_06"},
	{V01_CHISTE_07,			M01_CHISTE_07_MP3,			"V01_CHISTE_07"},
	{V01_CHISTE_08,			M01_CHISTE_08_MP3,			"V01_CHISTE_08"},
	{V01_CHISTE_09,			M01_CHISTE_09_MP3,			"V01_CHISTE_09"},
	{V01_CHISTE_10,			M01_CHISTE_10_MP3,			"V01_CHISTE_10"},
	{V01_CHISTE_11,			M01_CHISTE_11_MP3,			"V01_CHISTE_11"},
	{V01_CHISTE_12,			M01_CHISTE_12_MP3,			"V01_CHISTE_12"},
	{V01_CHISTE_13,			M01_CHISTE_13_MP3,			"V01_CHISTE_13"},
	{V01_CHISTE_14,			M01_CHISTE_14_MP3,			"V01_CHISTE_14"},
	{V01_COVERT_01,			M01_COVERT_01_MP3,			"V01_COVERT_01"},
	{V01_COVERT_02,			M01_COVERT_02_MP3,			"V01_COVERT_02"},
	{V01_COVERT_03,			M01_COVERT_03_MP3,			"V01_COVERT_03"},
	{V01_COVERT_04,			M01_COVERT_04_MP3,			"V01_COVERT_04"},
	{V01_COVERT_05,			M01_COVERT_05_MP3,			"V01_COVERT_05"},
	{V01_COVERT_06,			M01_COVERT_06_MP3,			"V01_COVERT_06"},
	{V01_COVERT_07,			M01_COVERT_07_MP3,			"V01_COVERT_07"},
	{V01_COVERT_08,			M01_COVERT_08_MP3,			"V01_COVERT_08"},
	{V01_COVERT_09,			M01_COVERT_09_MP3,			"V01_COVERT_09"},
	{V01_COVERT_10,			M01_COVERT_10_MP3,			"V01_COVERT_10"},
	{V01_COVERT_11,			M01_COVERT_11_MP3,			"V01_COVERT_11"},
	{V01_COVERT_12,			M01_COVERT_12_MP3,			"V01_COVERT_12"},
	{V01_COVERT_13,			M01_COVERT_13_MP3,			"V01_COVERT_13"},
	{V01_DAGEAUBE_01,		M01_DAGEAUBE_01_MP3,		"V01_DAGEAUBE_01"},
	{V01_DAGEAUBE_02,		M01_DAGEAUBE_02_MP3,		"V01_DAGEAUBE_02"},
	{V01_DAGEAUBE_03,		M01_DAGEAUBE_03_MP3,		"V01_DAGEAUBE_03"},
	{V01_DAGEAUBE_04,		M01_DAGEAUBE_04_MP3,		"V01_DAGEAUBE_04"},
	{V01_DAGEAUBE_05,		M01_DAGEAUBE_05_MP3,		"V01_DAGEAUBE_05"},
	{V01_EMC2_01,			M01_EMC2_01_MP3,			"V01_EMC2_01"},
	{V01_EMC2_02,			M01_EMC2_02_MP3,			"V01_EMC2_02"},
	{V01_GIZZARD_01,		M01_GIZZARD_01_MP3,			"V01_GIZZARD_01"},
	{V01_GIZZARD_02,		M01_GIZZARD_02_MP3,			"V01_GIZZARD_02"},
	{V01_GUY_01,			M01_GUY_01_MP3,				"V01_GUY_01"},
	{V01_GUY_02,			M01_GUY_02_MP3,				"V01_GUY_02"},
	{V01_GUY_03,			M01_GUY_03_MP3,				"V01_GUY_03"},
	{V01_GUY_04,			M01_GUY_04_MP3,				"V01_GUY_04"},
	{V01_GUY_05,			M01_GUY_05_MP3,				"V01_GUY_05"},
	{V01_HIDROW_01,			M01_HIDROW_01_MP3,			"V01_HIDROW_01"},
	{V01_HIDROW_02,			M01_HIDROW_02_MP3,			"V01_HIDROW_02"},
	{V01_HIDROW_03,			M01_HIDROW_03_MP3,			"V01_HIDROW_03"},
	{V01_KEBOTTLE_01,		M01_KEBOTTLE_01_MP3,		"V01_KEBOTTLE_01"},
	{V01_KEBOTTLE_02,		M01_KEBOTTLE_02_MP3,		"V01_KEBOTTLE_02"},
	{V01_KEBOTTLE_03,		M01_KEBOTTLE_03_MP3,		"V01_KEBOTTLE_03"},
	{V01_KEBOTTLE_04,		M01_KEBOTTLE_04_MP3,		"V01_KEBOTTLE_04"},
	{V01_KEBOTTLE_05,		M01_KEBOTTLE_05_MP3,		"V01_KEBOTTLE_05"},
	{V01_KEBOTTLE_06,		M01_KEBOTTLE_06_MP3,		"V01_KEBOTTLE_06"},
	{V01_KEBOTTLE_07,		M01_KEBOTTLE_07_MP3,		"V01_KEBOTTLE_07"},
	{V01_PONTE_01,			M01_PONTE_01_MP3,			"V01_PONTE_01"},
	{V01_PONTE_02,			M01_PONTE_02_MP3,			"V01_PONTE_02"},
	{V01_PONTE_03,			M01_PONTE_03_MP3,			"V01_PONTE_03"},
	{V01_PONTE_04,			M01_PONTE_04_MP3,			"V01_PONTE_04"},
	{V01_PONTE_05,			M01_PONTE_05_MP3,			"V01_PONTE_05"},
	{V01_PONTE_06,			M01_PONTE_06_MP3,			"V01_PONTE_06"},
	{V01_PONTE_07,			M01_PONTE_07_MP3,			"V01_PONTE_07"},
	{V01_PONTE_08,			M01_PONTE_08_MP3,			"V01_PONTE_08"},
	{V01_PONTE_09,			M01_PONTE_09_MP3,			"V01_PONTE_09"},
	{V01_PONTE_10,			M01_PONTE_10_MP3,			"V01_PONTE_10"},
	{V01_POPOPOLIS_01,		M01_POPOPOLIS_01_MP3,		"V01_POPOPOLIS_01"},
	{V01_POPOPOLIS_02,		M01_POPOPOLIS_02_MP3,		"V01_POPOPOLIS_02"},
	{V01_POPOPOLIS_03,		M01_POPOPOLIS_03_MP3,		"V01_POPOPOLIS_03"},
	{V01_POPOPOLIS_04,		M01_POPOPOLIS_04_MP3,		"V01_POPOPOLIS_04"},
	{V01_POPOPOLIS_05,		M01_POPOPOLIS_05_MP3,		"V01_POPOPOLIS_05"},
	{V01_POPOPOLIS_06,		M01_POPOPOLIS_06_MP3,		"V01_POPOPOLIS_06"},
	{V01_POPOPOLIS_07,		M01_POPOPOLIS_07_MP3,		"V01_POPOPOLIS_07"},
	{V01_POPOPOLIS_08,		M01_POPOPOLIS_08_MP3,		"V01_POPOPOLIS_08"},
	{V01_POPOPOLIS_09,		M01_POPOPOLIS_09_MP3,		"V01_POPOPOLIS_09"},
	{V01_POPOPOLIS_10,		M01_POPOPOLIS_10_MP3,		"V01_POPOPOLIS_10"},
	{V01_POPOPOLIS_11,		M01_POPOPOLIS_11_MP3,		"V01_POPOPOLIS_11"},
	{V01_POPOPOLIS_12,		M01_POPOPOLIS_12_MP3,		"V01_POPOPOLIS_12"},
	{V01_POPOPOLIS_13,		M01_POPOPOLIS_13_MP3,		"V01_POPOPOLIS_13"},
	{V01_POPOPOLIS_14,		M01_POPOPOLIS_14_MP3,		"V01_POPOPOLIS_14"},
	{V01_POPOPOLIS_15,		M01_POPOPOLIS_15_MP3,		"V01_POPOPOLIS_15"},
	{V01_POPOPOLIS_16,		M01_POPOPOLIS_16_MP3,		"V01_POPOPOLIS_16"},
	{V01_POPOPOLIS_17,		M01_POPOPOLIS_17_MP3,		"V01_POPOPOLIS_17"},
	{V01_POPOPOLIS_18,		M01_POPOPOLIS_18_MP3,		"V01_POPOPOLIS_18"},
	{V01_POPOPOLIS_19,		M01_POPOPOLIS_19_MP3,		"V01_POPOPOLIS_19"},
	{V01_POPOPOLIS_20,		M01_POPOPOLIS_20_MP3,		"V01_POPOPOLIS_20"},
	{V01_POPOPOLIS_21,		M01_POPOPOLIS_21_MP3,		"V01_POPOPOLIS_21"},
	{V01_POPOPOLIS_22,		M01_POPOPOLIS_22_MP3,		"V01_POPOPOLIS_22"},
	{V01_POPOPOLIS_23,		M01_POPOPOLIS_23_MP3,		"V01_POPOPOLIS_23"},
	{V01_POPOPOLIS_24,		M01_POPOPOLIS_24_MP3,		"V01_POPOPOLIS_24"},
	{V01_POPOPOLIS_25,		M01_POPOPOLIS_25_MP3,		"V01_POPOPOLIS_25"},
	{V01_POPOPOLIS_26,		M01_POPOPOLIS_26_MP3,		"V01_POPOPOLIS_26"},
	{V01_POPOPOLIS_27,		M01_POPOPOLIS_27_MP3,		"V01_POPOPOLIS_27"},
	{V01_POPOPOLIS_28,		M01_POPOPOLIS_28_MP3,		"V01_POPOPOLIS_28"},
	{V01_POPOPOLIS_29,		M01_POPOPOLIS_29_MP3,		"V01_POPOPOLIS_29"},
	{V01_POPOPOLIS_30,		M01_POPOPOLIS_30_MP3,		"V01_POPOPOLIS_30"},
	{V01_POPOPOLIS_31,		M01_POPOPOLIS_31_MP3,		"V01_POPOPOLIS_31"},
	{V01_POPOPOLIS_32,		M01_POPOPOLIS_32_MP3,		"V01_POPOPOLIS_32"},
	{V01_POPOPOLIS_33,		M01_POPOPOLIS_33_MP3,		"V01_POPOPOLIS_33"},
	{V01_POPOPOLIS_34,		M01_POPOPOLIS_34_MP3,		"V01_POPOPOLIS_34"},
	{V01_POPOPOLIS_35,		M01_POPOPOLIS_35_MP3,		"V01_POPOPOLIS_35"},
	{V01_POPOPOLIS_36,		M01_POPOPOLIS_36_MP3,		"V01_POPOPOLIS_36"},
	{V01_POPOPOLIS_37,		M01_POPOPOLIS_37_MP3,		"V01_POPOPOLIS_37"},
	{V01_SARGE_01,			M01_SARGE_01_MP3,			"V01_SARGE_01"},
	{V01_SARGE_02,			M01_SARGE_02_MP3,			"V01_SARGE_02"},
	{V01_SARGE_03,			M01_SARGE_03_MP3,			"V01_SARGE_03"},
	{V01_SARGE_04,			M01_SARGE_04_MP3,			"V01_SARGE_04"},
	{V01_SOBREDELLE_01,		M01_SOBREDELLE_01_MP3,		"V01_SOBREDELLE_01"},
	{V01_SOBREDELLE_02,		M01_SOBREDELLE_02_MP3,		"V01_SOBREDELLE_02"},
	{V01_SOBREDELLE_03,		M01_SOBREDELLE_03_MP3,		"V01_SOBREDELLE_03"},
	{V01_WAYNE_01,			M01_WAYNE_01_MP3,			"V01_WAYNE_01"},
	{V01_WAYNE_02,			M01_WAYNE_02_MP3,			"V01_WAYNE_02"},
	{V01_ZIQUOZ_01,			M01_ZIQUOZ_01_MP3,			"V01_ZIQUOZ_01"},
	{V01_ZIQUOZ_02,			M01_ZIQUOZ_02_MP3,			"V01_ZIQUOZ_02"},
	{V01_ZIQUOZ_03,			M01_ZIQUOZ_03_MP3,			"V01_ZIQUOZ_03"},

	{V02_AGUSTO_01,			M02_AGUSTO_01_MP3,			"V02_AGUSTO_01"},
	{V02_AGUSTO_02,			M02_AGUSTO_02_MP3,			"V02_AGUSTO_02"},
	{V02_ALBONDIGAS_01,		M02_ALBONDIGAS_01_MP3,		"V02_ALBONDIGAS_01"},
	{V02_ALBONDIGAS_02,		M02_ALBONDIGAS_02_MP3,		"V02_ALBONDIGAS_02"},
	{V02_BUMPER_01,			M02_BUMPER_01_MP3,			"V02_BUMPER_01"},
	{V02_BUMPER_02,			M02_BUMPER_02_MP3,			"V02_BUMPER_02"},
	{V02_BUMPER_03,			M02_BUMPER_03_MP3,			"V02_BUMPER_03"},
	{V02_BUMPER_04,			M02_BUMPER_04_MP3,			"V02_BUMPER_04"},
	{V02_BUMPER_05,			M02_BUMPER_05_MP3,			"V02_BUMPER_05"},
	{V02_BUMPER_06,			M02_BUMPER_06_MP3,			"V02_BUMPER_06"},
	{V02_BUMPER_07,			M02_BUMPER_07_MP3,			"V02_BUMPER_07"},
	{V02_DELGADO_01,		M02_DELGADO_01_MP3,			"V02_DELGADO_01"},
	{V02_FEBRARO_01,		M02_FEBRARO_01_MP3,			"V02_FEBRARO_01"},
	{V02_GUY_01,			M02_GUY_01_MP3,				"V02_GUY_01"},
	{V02_GUY_02,			M02_GUY_02_MP3,				"V02_GUY_02"},
	{V03_ACROPHO_01,		M03_ACROPHO_01_MP3,			"V03_ACROPHO_01"},
	{V03_ACROPHO_02,		M03_ACROPHO_02_MP3,			"V03_ACROPHO_02"},
	{V03_ACROPHO_03,		M03_ACROPHO_03_MP3,			"V03_ACROPHO_03"},
	{V03_ACROPHO_04,		M03_ACROPHO_04_MP3,			"V03_ACROPHO_04"},
	{V03_ENERO_01,			M03_ENERO_01_MP3,			"V03_ENERO_01"},
	{V03_ENERO_02,			M03_ENERO_02_MP3,			"V03_ENERO_02"},
	{V03_ENERO_03,			M03_ENERO_03_MP3,			"V03_ENERO_03"},
	{V03_ENERO_04,			M03_ENERO_04_MP3,			"V03_ENERO_04"},
	{V03_ENERO_05,			M03_ENERO_05_MP3,			"V03_ENERO_05"},
	{V03_GAIA_01,			M03_GAIA_01_MP3,			"V03_GAIA_01"},
	{V03_GAIA_02,			M03_GAIA_02_MP3,			"V03_GAIA_02"},
	{V03_GAIA_03,			M03_GAIA_03_MP3,			"V03_GAIA_03"},
	{V03_GAIA_04,			M03_GAIA_04_MP3,			"V03_GAIA_04"},
	{V03_GAIA_05,			M03_GAIA_05_MP3,			"V03_GAIA_05"},
	{V03_GAIA_06,			M03_GAIA_06_MP3,			"V03_GAIA_06"},
	{V03_LAGO_01,			M03_LAGO_01_MP3,			"V03_LAGO_01"},
	{V03_LAGO_02,			M03_LAGO_02_MP3,			"V03_LAGO_02"},
	{V03_LAGO_04,			M03_LAGO_04_MP3,			"V03_LAGO_04"},
	{V03_LAGO_05,			M03_LAGO_05_MP3,			"V03_LAGO_05"},
	{V03_LAGO_06,			M03_LAGO_06_MP3,			"V03_LAGO_06"},
	{V03_LAGO_07,			M03_LAGO_07_MP3,			"V03_LAGO_07"},
	{V04_BONIFACE_01,		M04_BONIFACE_01_MP3,		"V04_BONIFACE_01"},
	{V04_BONIFACE_02,		M04_BONIFACE_02_MP3,		"V04_BONIFACE_02"},
	{V04_BONIFACE_03,		M04_BONIFACE_03_MP3,		"V04_BONIFACE_03"},
	{V04_BONIFACE_04,		M04_BONIFACE_04_MP3,		"V04_BONIFACE_04"},
	{V04_BONIFACE_05,		M04_BONIFACE_05_MP3,		"V04_BONIFACE_05"},
	{V04_BONIFACE_06,		M04_BONIFACE_06_MP3,		"V04_BONIFACE_06"},
	{V04_BONIFACE_07,		M04_BONIFACE_07_MP3,		"V04_BONIFACE_07"},
	{V04_JULIO_01,			M04_JULIO_01_MP3,			"V04_JULIO_01"},
	{V04_JULIO_02,			M04_JULIO_02_MP3,			"V04_JULIO_02"},
	{V04_JULIO_04,			M04_JULIO_04_MP3,			"V04_JULIO_04"},
	{V04_MARZO_01,			M04_MARZO_01_MP3,			"V04_MARZO_01"},
	{V04_OCTUBRE_01,		M04_OCTUBRE_01_MP3,			"V04_OCTUBRE_01"},
	{V04_OCTUBRE_02,		M04_OCTUBRE_02_MP3,			"V04_OCTUBRE_02"},
	{V04_OCTUBRE_03,		M04_OCTUBRE_03_MP3,			"V04_OCTUBRE_03"},
	{V05_ABRIL_01,			M05_ABRIL_01_MP3,			"V05_ABRIL_01"},
	{V05_ABRIL_02,			M05_ABRIL_02_MP3,			"V05_ABRIL_02"},
	{V05_ABRIL_03,			M05_ABRIL_03_MP3,			"V05_ABRIL_03"},
	{V05_ABRIL_04,			M05_ABRIL_04_MP3,			"V05_ABRIL_04"},
	{V05_ABRIL_05,			M05_ABRIL_05_MP3,			"V05_ABRIL_05"},
	{V05_GELIGELLA_01,		M05_GELIGELLA_01_MP3,		"V05_GELIGELLA_01"},
	{V05_GELIGELLA_02,		M05_GELIGELLA_02_MP3,		"V05_GELIGELLA_02"},
	{V05_RAILRIDER_01,		M05_RAILRIDER_01_MP3,		"V05_RAILRIDER_01"},
	{V05_RAILRIDER_02,		M05_RAILRIDER_02_MP3,		"V05_RAILRIDER_02"},
	{V05_RAILRIDER_03,		M05_RAILRIDER_03_MP3,		"V05_RAILRIDER_03"},
	{V05_RAILRIDER_04,		M05_RAILRIDER_04_MP3,		"V05_RAILRIDER_04"},
	{V05_EVERLOO_01,		M05_EVERLOO_01_MP3,			"V05_EVERLOO_01"},
	{V05_EVERLOO_02,		M05_EVERLOO_02_MP3,			"V05_EVERLOO_02"},
	{V05_EVERLOO_03,		M05_EVERLOO_03_MP3,			"V05_EVERLOO_03"},
	{V05_EVERLOO_04,		M05_EVERLOO_04_MP3,			"V05_EVERLOO_04"},
	{V06_AZUL_01,			M06_AZUL_01_MP3,			"V06_AZUL_01"},
	{V06_AZUL_02,			M06_AZUL_02_MP3,			"V06_AZUL_02"},
	{V06_AZUL_03,			M06_AZUL_03_MP3,			"V06_AZUL_03"},
	{V06_AZUL_04,			M06_AZUL_04_MP3,			"V06_AZUL_04"},
	{V06_AZUL_05,			M06_AZUL_05_MP3,			"V06_AZUL_05"},
	{V06_AZUL_06,			M06_AZUL_06_MP3,			"V06_AZUL_06"},
	{V06_AZUL_07,			M06_AZUL_07_MP3,			"V06_AZUL_07"},
	{V06_AZUL_08,			M06_AZUL_08_MP3,			"V06_AZUL_08"},
	{V06_GUY_01,			M06_GUY_01_MP3,				"V06_GUY_01"},
	{V06_GUY_02,			M06_GUY_02_MP3,				"V06_GUY_02"},
	{V06_GUY_03,			M06_GUY_03_MP3,				"V06_GUY_03"},
	{V06_GUY_04,			M06_GUY_04_MP3,				"V06_GUY_04"},
	{V06_HANSON_01,			M06_HANSON_01_MP3,			"V06_HANSON_01"},
	{V06_HANSON_03,			M06_HANSON_03_MP3,			"V06_HANSON_03"},
	{V06_HANSON_04,			M06_HANSON_04_MP3,			"V06_HANSON_04"},
	{V06_HANSON_05,			M06_HANSON_05_MP3,			"V06_HANSON_05"},
	{V06_HANSON_06,			M06_HANSON_06_MP3,			"V06_HANSON_06"},
	{V06_HANSON_07,			M06_HANSON_07_MP3,			"V06_HANSON_07"},
	{V06_HANSON_08,			M06_HANSON_08_MP3,			"V06_HANSON_08"},
	{V06_HANSON_09,			M06_HANSON_09_MP3,			"V06_HANSON_09"},
	{V06_HANSON_10,			M06_HANSON_10_MP3,			"V06_HANSON_10"},
	{V06_HANSON_11,			M06_HANSON_11_MP3,			"V06_HANSON_11"},
	{V06_HANSON_12,			M06_HANSON_12_MP3,			"V06_HANSON_12"},
	{V06_JUNIO_01,			M06_JUNIO_01_MP3,			"V06_JUNIO_01"},
	{V06_JUNIO_02,			M06_JUNIO_02_MP3,			"V06_JUNIO_02"},
	{V06_JUNIO_03,			M06_JUNIO_03_MP3,			"V06_JUNIO_03"},
	{V06_JUNIO_04,			M06_JUNIO_04_MP3,			"V06_JUNIO_04"},
	{V06_JUNIO_05,			M06_JUNIO_05_MP3,			"V06_JUNIO_05"},
	{V06_JUNIO_06,			M06_JUNIO_06_MP3,			"V06_JUNIO_06"},
	{V06_JUNIO_07,			M06_JUNIO_07_MP3,			"V06_JUNIO_07"},
	{V06_JUNIO_08,			M06_JUNIO_08_MP3,			"V06_JUNIO_08"},
	{V06_JUNIO_09,			M06_JUNIO_09_MP3,			"V06_JUNIO_09"},
	{V06_NARANJA_01,		M06_NARANJA_01_MP3,			"V06_NARANJA_01"},
	{V06_NARANJA_02,		M06_NARANJA_02_MP3,			"V06_NARANJA_02"},
	{V06_NARANJA_03,		M06_NARANJA_03_MP3,			"V06_NARANJA_03"},
	{V06_NARANJA_04,		M06_NARANJA_04_MP3,			"V06_NARANJA_04"},
	{V06_NARANJA_05,		M06_NARANJA_05_MP3,			"V06_NARANJA_05"},
	{V06_SEPTEMBRE_01,		M06_SEPTEMBRE_01_MP3,		"V06_SEPTEMBRE_01"},
	{V06_SEPTEMBRE_02,		M06_SEPTEMBRE_02_MP3,		"V06_SEPTEMBRE_02"},
	{V06_SEPTEMBRE_03,		M06_SEPTEMBRE_03_MP3,		"V06_SEPTEMBRE_03"},
	{V06_SEPTEMBRE_04,		M06_SEPTEMBRE_04_MP3,		"V06_SEPTEMBRE_04"},
	{V06_SEPTEMBRE_05,		M06_SEPTEMBRE_05_MP3,		"V06_SEPTEMBRE_05"},
	{V06_SEPTEMBRE_06,		M06_SEPTEMBRE_06_MP3,		"V06_SEPTEMBRE_06"},
	{V06_SEPTEMBRE_07,		M06_SEPTEMBRE_07_MP3,		"V06_SEPTEMBRE_07"},
	{V06_SEPTEMBRE_08,		M06_SEPTEMBRE_08_MP3,		"V06_SEPTEMBRE_08"},
	{V06_SEPTEMBRE_09,		M06_SEPTEMBRE_09_MP3,		"V06_SEPTEMBRE_09"},
	{V06_WORKER_01,			M06_WORKER_01_MP3,			"V06_WORKER_01"},
	{V06_WORKER_02,			M06_WORKER_02_MP3,			"V06_WORKER_02"},
	{V06_WORKER_03,			M06_WORKER_03_MP3,			"V06_WORKER_03"},
	{V06_WORKER_04,			M06_WORKER_04_MP3,			"V06_WORKER_04"},
	{V07_CERCO_01,			M07_CERCO_01_MP3,			"V07_CERCO_01"},
	{V07_CERCO_02,			M07_CERCO_02_MP3,			"V07_CERCO_02"},
	{V07_COMPUTER_01,		M07_COMPUTER_01_MP3,		"V07_COMPUTER_01"},
	{V07_MAYO_01,			M07_MAYO_01_MP3,			"V07_MAYO_01"},
	{V07_MAYO_02,			M07_MAYO_02_MP3,			"V07_MAYO_02"},
	{V07_NOVIEMBRE_01,		M07_NOVIEMBRE_01_MP3,		"V07_NOVIEMBRE_01"},
	{V07_NOVIEMBRE_02,		M07_NOVIEMBRE_02_MP3,		"V07_NOVIEMBRE_02"},
	{V07_NOVIEMBRE_03,		M07_NOVIEMBRE_03_MP3,		"V07_NOVIEMBRE_03"},
	{V07_PANITO_01,			M07_PANITO_01_MP3,			"V07_PANITO_01"},
	{V07_PANITO_02,			M07_PANITO_02_MP3,			"V07_PANITO_02"},
	{V07_PANITO_03,			M07_PANITO_03_MP3,			"V07_PANITO_03"},
	{V07_PANITO_04,			M07_PANITO_04_MP3,			"V07_PANITO_04"},
	{V07_PANITO_05,			M07_PANITO_05_MP3,			"V07_PANITO_05"},
	{V08_COOKIE_01,			M08_COOKIE_01_MP3,			"V08_COOKIE_01"},
	{V08_COOKIE_02,			M08_COOKIE_02_MP3,			"V08_COOKIE_02"},
	{V08_DICIEMBRE_01,		M08_DICIEMBRE_01_MP3,		"V08_DICIEMBRE_01"},
	{V08_GUY_01,			M08_GUY_01_MP3,				"V08_GUY_01"},
	{V08_GUY_02,			M08_GUY_02_MP3,				"V08_GUY_02"},
	{V08_GUY_03,			M08_GUY_03_MP3,				"V08_GUY_03"},
	{V08_MACHINA_01,		M08_MACHINA_01_MP3,			"V08_MACHINA_01"},
	{V08_MACHINA_02,		M08_MACHINA_02_MP3,			"V08_MACHINA_02"},
	{V08_MACHINA_03,		M08_MACHINA_03_MP3,			"V08_MACHINA_03"},
	{V08_MACHINA_04,		M08_MACHINA_04_MP3,			"V08_MACHINA_04"},
	{V08_MACHINA_05,		M08_MACHINA_05_MP3,			"V08_MACHINA_05"},
	{V08_MACHINA_06,		M08_MACHINA_06_MP3,			"V08_MACHINA_06"},
	{V08_MACHINA_07,		M08_MACHINA_07_MP3,			"V08_MACHINA_07"},
	{V08_MACHINA_08,		M08_MACHINA_08_MP3,			"V08_MACHINA_08"},
	{V08_MACHINA_09,		M08_MACHINA_09_MP3,			"V08_MACHINA_09"},
	{V08_MESA_01,			M08_MESA_01_MP3,			"V08_MESA_01"},
	{V08_MESA_02,			M08_MESA_02_MP3,			"V08_MESA_02"},
	{V08_MESA_03,			M08_MESA_03_MP3,			"V08_MESA_03"},
	{V08_MESA_04,			M08_MESA_04_MP3,			"V08_MESA_04"},
	{V08_SHAKIR_01,			M08_SHAKIR_01_MP3,			"V08_SHAKIR_01"},
	{V08_SHAKIR_02,			M08_SHAKIR_02_MP3,			"V08_SHAKIR_02"},
	{V08_SHAKIR_03,			M08_SHAKIR_03_MP3,			"V08_SHAKIR_03"},
	{V09_VIOLETA_01,		M09_VIOLETA_01_MP3,			"V09_VIOLETA_01"},
	{V09_VIOLETA_02,		M09_VIOLETA_02_MP3,			"V09_VIOLETA_02"},
	{V09_VIOLETA_03,		M09_VIOLETA_03_MP3,			"V09_VIOLETA_03"},
	{V09_VIOLETA_04,		M09_VIOLETA_04_MP3,			"V09_VIOLETA_04"},
	{V10_CHICKEN_01,		M10_CHICKEN_01_MP3,			"V10_CHICKEN_01"},
	{V10_COOPER_01,			M10_COOPER_01_MP3,			"V10_COOPER_01"},
	{V10_COOPER_02,			M10_COOPER_02_MP3,			"V10_COOPER_02"},
	{V10_COOPER_03,			M10_COOPER_03_MP3,			"V10_COOPER_03"},
	{V10_COOPER_04,			M10_COOPER_04_MP3,			"V10_COOPER_04"},
	{V10_COOPER_05,			M10_COOPER_05_MP3,			"V10_COOPER_05"},
	{V10_COOPER_06,			M10_COOPER_06_MP3,			"V10_COOPER_06"},
	{V10_COOPER_07,			M10_COOPER_07_MP3,			"V10_COOPER_07"},
	{V10_COOPER_08,			M10_COOPER_08_MP3,			"V10_COOPER_08"},
	{V10_COOPER_09,			M10_COOPER_09_MP3,			"V10_COOPER_09"},
	{V10_DOLLY_01,			M10_DOLLY_01_MP3,			"V10_DOLLY_01"},
	{V10_DOLLY_02,			M10_DOLLY_02_MP3,			"V10_DOLLY_02"},
	{V10_DOLLY_03,			M10_DOLLY_03_MP3,			"V10_DOLLY_03"},
	{V10_DOLLY_04,			M10_DOLLY_04_MP3,			"V10_DOLLY_04"},
	{V10_DOLLY_05,			M10_DOLLY_05_MP3,			"V10_DOLLY_05"},
	{V10_DOLLY_06,			M10_DOLLY_06_MP3,			"V10_DOLLY_06"},
	{V10_DOLLY_07,			M10_DOLLY_07_MP3,			"V10_DOLLY_07"},
	{V10_DOLLY_08,			M10_DOLLY_08_MP3,			"V10_DOLLY_08"},
	{V10_DOLLY_09,			M10_DOLLY_09_MP3,			"V10_DOLLY_09"},
	{V10_DOLLY_10,			M10_DOLLY_10_MP3,			"V10_DOLLY_10"},
	{V10_ENGCOMPUTER_01,	M10_ENGCOMPUTER_01_MP3,		"V10_ENGCOMPUTER_01"},
	{V10_FARBLE_01,			M10_FARBLE_01_MP3,			"V10_FARBLE_01"},
	{V10_FARBLE_02,			M10_FARBLE_02_MP3,			"V10_FARBLE_02"},
	{V10_FARBLE_03,			M10_FARBLE_03_MP3,			"V10_FARBLE_03"},
	{V10_FARBLE_04,			M10_FARBLE_04_MP3,			"V10_FARBLE_04"},
	{V10_FARBLE_05,			M10_FARBLE_05_MP3,			"V10_FARBLE_05"},
	{V10_FARBLE_06,			M10_FARBLE_06_MP3,			"V10_FARBLE_06"},
	{V10_GRUNETT_01,		M10_GRUNETT_01_MP3,			"V10_GRUNETT_01"},
	{V10_GRUNETT_02,		M10_GRUNETT_02_MP3,			"V10_GRUNETT_02"},
	{V10_GRUNETT_03,		M10_GRUNETT_03_MP3,			"V10_GRUNETT_03"},
	{V10_GRUNETT_04,		M10_GRUNETT_04_MP3,			"V10_GRUNETT_04"},
	{V10_GRUNETT_05,		M10_GRUNETT_05_MP3,			"V10_GRUNETT_05"},
	{V10_GRUNETT_06,		M10_GRUNETT_06_MP3,			"V10_GRUNETT_06"},
	{V10_GUY_01,			M10_GUY_01_MP3,				"V10_GUY_01"},
	{V10_GUY_02,			M10_GUY_02_MP3,				"V10_GUY_02"},
	{V10_GUY_03,			M10_GUY_03_MP3,				"V10_GUY_03"},
	{V10_GUY_04,			M10_GUY_04_MP3,				"V10_GUY_04"},
	{V10_GUY_05,			M10_GUY_05_MP3,				"V10_GUY_05"},
	{V10_GUY_06,			M10_GUY_06_MP3,				"V10_GUY_06"},
	{V10_GUY_07,			M10_GUY_07_MP3,				"V10_GUY_07"},
	{V10_GUY_08,			M10_GUY_08_MP3,				"V10_GUY_08"},
	{V10_INFOCOMP_01,		M10_INFOCOMP_01_MP3,		"V10_INFOCOMP_01"},
	{V10_NOTEBRICK_01,		M10_NOTEBRICK_01_MP3,		"V10_NOTEBRICK_01"},
	{V10_PILOTS_01,			M10_PILOTS_01_MP3,			"V10_PILOTS_01"},
	{V10_PILOTS_02,			M10_PILOTS_02_MP3,			"V10_PILOTS_02"},
	{V10_PILOTS_03,			M10_PILOTS_03_MP3,			"V10_PILOTS_03"},
	{V10_PILOTS_04,			M10_PILOTS_04_MP3,			"V10_PILOTS_04"},
	{V10_PILOTS_05,			M10_PILOTS_05_MP3,			"V10_PILOTS_05"},
	{V10_SARGE_01,			M10_SARGE_01_MP3,			"V10_SARGE_01"},
	{V10_SARGE_02,			M10_SARGE_02_MP3,			"V10_SARGE_02"},
	{V10_SARGE_03,			M10_SARGE_03_MP3,			"V10_SARGE_03"},
	{V10_SARGE_04,			M10_SARGE_04_MP3,			"V10_SARGE_04"},
	{V10_SARGE_05,			M10_SARGE_05_MP3,			"V10_SARGE_05"},
	{V11_ANCHOVY_01,		M11_ANCHOVY_01_MP3,			"V11_ANCHOVY_01"},
	{V11_ANCHOVY_02,		M11_ANCHOVY_02_MP3,			"V11_ANCHOVY_02"},
	{V11_ANCHOVY_03,		M11_ANCHOVY_03_MP3,			"V11_ANCHOVY_03"},
	{V11_ANCHOVY_04,		M11_ANCHOVY_04_MP3,			"V11_ANCHOVY_04"},
	{V11_ANCHOVY_05,		M11_ANCHOVY_05_MP3,			"V11_ANCHOVY_05"},
	{V11_ARBIVALL_01,		M11_ARBIVALL_01_MP3,		"V11_ARBIVALL_01"},
	{V11_ARBIVALL_02,		M11_ARBIVALL_02_MP3,		"V11_ARBIVALL_02"},
	{V11_ARBIVALL_03,		M11_ARBIVALL_03_MP3,		"V11_ARBIVALL_03"},
	{V11_ARBIVALL_04,		M11_ARBIVALL_04_MP3,		"V11_ARBIVALL_04"},
	{V11_ARBIVALL_05,		M11_ARBIVALL_05_MP3,		"V11_ARBIVALL_05"},
	{V11_ARBIVALL_06,		M11_ARBIVALL_06_MP3,		"V11_ARBIVALL_06"},
	{V11_ARBIVALL_07,		M11_ARBIVALL_07_MP3,		"V11_ARBIVALL_07"},
	{V11_ARNIE_01,			M11_ARNIE_01_MP3,			"V11_ARNIE_01"},
	{V11_BELINDA_01,		M11_BELINDA_01_MP3,			"V11_BELINDA_01"},
	{V11_BLOCK_01,			M11_BLOCK_01_MP3,			"V11_BLOCK_01"},
	{V11_BLOCK_02,			M11_BLOCK_02_MP3,			"V11_BLOCK_02"},
	{V11_BLOCK_03,			M11_BLOCK_03_MP3,			"V11_BLOCK_03"},
	{V11_BRAD_01,			M11_BRAD_01_MP3,			"V11_BRAD_01"},
	{V11_BRAD_02,			M11_BRAD_02_MP3,			"V11_BRAD_02"},
	{V11_BRAD_03,			M11_BRAD_03_MP3,			"V11_BRAD_03"},
	{V11_BUSTER_01,			M11_BUSTER_01_MP3,			"V11_BUSTER_01"},
	{V11_BUSTER_02,			M11_BUSTER_02_MP3,			"V11_BUSTER_02"},
	{V11_BUSTER_03,			M11_BUSTER_03_MP3,			"V11_BUSTER_03"},
	{V11_DINERS_01,			M11_DINERS_01_MP3,			"V11_DINERS_01"},
	{V11_DINERS_02,			M11_DINERS_02_MP3,			"V11_DINERS_02"},
	{V11_DOPPLER_01,		M11_DOPPLER_01_MP3,			"V11_DOPPLER_01"},
	{V11_DOPPLER_02,		M11_DOPPLER_02_MP3,			"V11_DOPPLER_02"},
	{V11_DOPPLER_03,		M11_DOPPLER_03_MP3,			"V11_DOPPLER_03"},
	{V11_DOPPLER_04,		M11_DOPPLER_04_MP3,			"V11_DOPPLER_04"},
	{V11_DOPPLER_05,		M11_DOPPLER_05_MP3,			"V11_DOPPLER_05"},
	{V11_DOREK_01,			M11_DOREK_01_MP3,			"V11_DOREK_01"},
	{V11_DOREK_02,			M11_DOREK_02_MP3,			"V11_DOREK_02"},
	{V11_DOREK_03,			M11_DOREK_03_MP3,			"V11_DOREK_03"},
	{V11_DOZER_01,			M11_DOZER_01_MP3,			"V11_DOZER_01"},
	{V11_DOZER_02,			M11_DOZER_02_MP3,			"V11_DOZER_02"},
	{V11_DOZER_03,			M11_DOZER_03_MP3,			"V11_DOZER_03"},
	{V11_DOZER_04,			M11_DOZER_04_MP3,			"V11_DOZER_04"},
	{V11_GNAPPE_01,			M11_GNAPPE_01_MP3,			"V11_GNAPPE_01"},
	{V11_GNAPPE_02,			M11_GNAPPE_02_MP3,			"V11_GNAPPE_02"},
	{V11_GNAPPE_03,			M11_GNAPPE_03_MP3,			"V11_GNAPPE_03"},
	{V11_GNAPPE_04,			M11_GNAPPE_04_MP3,			"V11_GNAPPE_04"},
	{V11_GNAPPE_05,			M11_GNAPPE_05_MP3,			"V11_GNAPPE_05"},
	{V11_GNODIMY_01,		M11_GNODIMY_01_MP3,			"V11_GNODIMY_01"},
	{V11_GNODIMY_02,		M11_GNODIMY_02_MP3,			"V11_GNODIMY_02"},
	{V11_GNODIMY_03,		M11_GNODIMY_03_MP3,			"V11_GNODIMY_03"},
	{V11_GNODIMY_04,		M11_GNODIMY_04_MP3,			"V11_GNODIMY_04"},
	{V11_GUY_01,			M11_GUY_01_MP3,				"V11_GUY_01"},
	{V11_GUY_02,			M11_GUY_02_MP3,				"V11_GUY_02"},
	{V11_GUY_03,			M11_GUY_03_MP3,				"V11_GUY_03"},
	{V11_GUY_04,			M11_GUY_04_MP3,				"V11_GUY_04"},
	{V11_GUY_05,			M11_GUY_05_MP3,				"V11_GUY_05"},
	{V11_GUY_06,			M11_GUY_06_MP3,				"V11_GUY_06"},
	{V11_GUY_07,			M11_GUY_07_MP3,				"V11_GUY_07"},
	{V11_GUY_08,			M11_GUY_08_MP3,				"V11_GUY_08"},
	{V11_GUY_09,			M11_GUY_09_MP3,				"V11_GUY_09"},
	{V11_GUY_10,			M11_GUY_10_MP3,				"V11_GUY_10"},
	{V11_GUY_11,			M11_GUY_11_MP3,				"V11_GUY_11"},
	{V11_GUY_12,			M11_GUY_12_MP3,				"V11_GUY_12"},
	{V11_GUY_13,			M11_GUY_13_MP3,				"V11_GUY_13"},
	{V11_GUY_15,			M11_GUY_15_MP3,				"V11_GUY_15"},
	{V11_GUY_16,			M11_GUY_16_MP3,				"V11_GUY_16"},
	{V11_GUY_17,			M11_GUY_17_MP3,				"V11_GUY_17"},
	{V11_HAMBRE_01,			M11_HAMBRE_01_MP3,			"V11_HAMBRE_01"},
	{V11_HAMBRE_02,			M11_HAMBRE_02_MP3,			"V11_HAMBRE_02"},
	{V11_HAMBRE_03,			M11_HAMBRE_03_MP3,			"V11_HAMBRE_03"},
	{V11_HAMBRE_04,			M11_HAMBRE_04_MP3,			"V11_HAMBRE_04"},
	{V11_HAMBRE_05,			M11_HAMBRE_05_MP3,			"V11_HAMBRE_05"},
	{V11_HUMBERT_01,		M11_HUMBERT_01_MP3,			"V11_HUMBERT_01"},
	{V11_ILLIAC_01,			M11_ILLIAC_01_MP3,			"V11_ILLIAC_01"},
	{V11_JAQUES_01,			M11_JAQUES_01_MP3,			"V11_JAQUES_01"},
	{V11_JAQUES_02,			M11_JAQUES_02_MP3,			"V11_JAQUES_02"},
	{V11_JAQUES_03,			M11_JAQUES_03_MP3,			"V11_JAQUES_03"},
	{V11_JAQUES_04,			M11_JAQUES_04_MP3,			"V11_JAQUES_04"},
	{V11_LUMBAR_01,			M11_LUMBAR_01_MP3,			"V11_LUMBAR_01"},
	{V11_MAN_IN_STALL_01,	M11_MAN_IN_STALL_01_MP3,	"V11_MAN_IN_STALL_01"},
	{V11_MAN_IN_STALL_02,	M11_MAN_IN_STALL_02_MP3,	"V11_MAN_IN_STALL_02"},
	{V11_MAN_IN_STALL_03,	M11_MAN_IN_STALL_03_MP3,	"V11_MAN_IN_STALL_03"},
	{V11_MAN_IN_STALL_04,	M11_MAN_IN_STALL_04_MP3,	"V11_MAN_IN_STALL_04"},
	{V11_MAN_IN_STALL_05,	M11_MAN_IN_STALL_05_MP3,	"V11_MAN_IN_STALL_05"},
	{V11_MANNY_01,			M11_MANNY_01_MP3,			"V11_MANNY_01"},
	{V11_MUMPS_01,			M11_MUMPS_01_MP3,			"V11_MUMPS_01"},
	{V11_MUMPS_02,			M11_MUMPS_02_MP3,			"V11_MUMPS_02"},
	{V11_MUMPS_03,			M11_MUMPS_03_MP3,			"V11_MUMPS_03"},
	{V11_MUMPS_04,			M11_MUMPS_04_MP3,			"V11_MUMPS_04"},
	{V11_MUMPS_05,			M11_MUMPS_05_MP3,			"V11_MUMPS_05"},
	{V11_MUMPS_06,			M11_MUMPS_06_MP3,			"V11_MUMPS_06"},
	{V11_MUMPS_07,			M11_MUMPS_07_MP3,			"V11_MUMPS_07"},
	{V11_MUMPS_08,			M11_MUMPS_08_MP3,			"V11_MUMPS_08"},
	{V11_MUMPS_09,			M11_MUMPS_09_MP3,			"V11_MUMPS_09"},
	{V11_MUMPS_10,			M11_MUMPS_10_MP3,			"V11_MUMPS_10"},
	{V11_MUMPS_11,			M11_MUMPS_11_MP3,			"V11_MUMPS_11"},
	{V11_MUMPS_12,			M11_MUMPS_12_MP3,			"V11_MUMPS_12"},
	{V11_MUMPS_13,			M11_MUMPS_13_MP3,			"V11_MUMPS_13"},
	{V11_MUMPS_14,			M11_MUMPS_14_MP3,			"V11_MUMPS_14"},
	{V11_MUMPS_15,			M11_MUMPS_15_MP3,			"V11_MUMPS_15"},
	{V11_MUMPS_16,			M11_MUMPS_16_MP3,			"V11_MUMPS_16"},
	{V11_MUMPS_17,			M11_MUMPS_17_MP3,			"V11_MUMPS_17"},
	{V11_MUMPS_18,			M11_MUMPS_18_MP3,			"V11_MUMPS_18"},
	{V11_MUMPS_19,			M11_MUMPS_19_MP3,			"V11_MUMPS_19"},
	{V11_MUMPS_20,			M11_MUMPS_20_MP3,			"V11_MUMPS_20"},
	{V11_MUMPS_22,			M11_MUMPS_22_MP3,			"V11_MUMPS_22"},
	{V11_MUMPS_23,			M11_MUMPS_23_MP3,			"V11_MUMPS_23"},
	{V11_MUMPS_24,			M11_MUMPS_24_MP3,			"V11_MUMPS_24"},
	{V11_MUMPS_25,			M11_MUMPS_25_MP3,			"V11_MUMPS_25"},
	{V11_MUMPS_26,			M11_MUMPS_26_MP3,			"V11_MUMPS_26"},
	{V11_PEDIMENT_01,		M11_PEDIMENT_01_MP3,		"V11_PEDIMENT_01"},
	{V11_PEDIMENT_02,		M11_PEDIMENT_02_MP3,		"V11_PEDIMENT_02"},
	{V11_PEDIMENT_03,		M11_PEDIMENT_03_MP3,		"V11_PEDIMENT_03"},
	{V11_PEDIMENT_04,		M11_PEDIMENT_04_MP3,		"V11_PEDIMENT_04"},
	{V11_PEDIMENT_05,		M11_PEDIMENT_05_MP3,		"V11_PEDIMENT_05"},
	{V11_PEDIMENT_06,		M11_PEDIMENT_06_MP3,		"V11_PEDIMENT_06"},
	{V11_PEDIMENT_07,		M11_PEDIMENT_07_MP3,		"V11_PEDIMENT_07"},
	{V11_PEDIMENT_08,		M11_PEDIMENT_08_MP3,		"V11_PEDIMENT_08"},
	{V11_POLONEY_01,		M11_POLONEY_01_MP3,			"V11_POLONEY_01"},
	{V11_POLONEY_02,		M11_POLONEY_02_MP3,			"V11_POLONEY_02"},
	{V11_POLONEY_03,		M11_POLONEY_03_MP3,			"V11_POLONEY_03"},
	{V11_SAUSAGE_01,		M11_SAUSAGE_01_MP3,			"V11_SAUSAGE_01"},
	{V11_SAUSAGE_02,		M11_SAUSAGE_02_MP3,			"V11_SAUSAGE_02"},
	{V11_SAUSAGE_03,		M11_SAUSAGE_03_MP3,			"V11_SAUSAGE_03"},
	{V11_SAUSAGE_04,		M11_SAUSAGE_04_MP3,			"V11_SAUSAGE_04"},
	{V11_SAUSAGE_05,		M11_SAUSAGE_05_MP3,			"V11_SAUSAGE_05"},
	{V11_SAUSAGE_06,		M11_SAUSAGE_06_MP3,			"V11_SAUSAGE_06"},
	{V11_SAUSAGE_07,		M11_SAUSAGE_07_MP3,			"V11_SAUSAGE_07"},
	{V11_SAUSAGE_08,		M11_SAUSAGE_08_MP3,			"V11_SAUSAGE_08"},
	{V11_SAUSAGE_09,		M11_SAUSAGE_09_MP3,			"V11_SAUSAGE_09"},
	{V11_SAUSAGE_10,		M11_SAUSAGE_10_MP3,			"V11_SAUSAGE_10"},
	{V12_ABLE_01,			M12_ABLE_01_MP3,			"V12_ABLE_01"},
	{V12_ABLE_02,			M12_ABLE_02_MP3,			"V12_ABLE_02"},
	{V12_ABLE_03,			M12_ABLE_03_MP3,			"V12_ABLE_03"},
	{V12_BUSY_01,			M12_BUSY_01_MP3,			"V12_BUSY_01"},
	{V12_BUSY_02,			M12_BUSY_02_MP3,			"V12_BUSY_02"},
	{V12_BUSY_03,			M12_BUSY_03_MP3,			"V12_BUSY_03"},
	{V12_BUSY_04,			M12_BUSY_04_MP3,			"V12_BUSY_04"},
	{V12_BUSY_05,			M12_BUSY_05_MP3,			"V12_BUSY_05"},
	{V12_BUSY_06,			M12_BUSY_06_MP3,			"V12_BUSY_06"},
	{V12_BUSY_07,			M12_BUSY_07_MP3,			"V12_BUSY_07"},
	{V12_BUSY_08,			M12_BUSY_08_MP3,			"V12_BUSY_08"},
	{V12_CHARLIE_01,		M12_CHARLIE_01_MP3,			"V12_CHARLIE_01"},
	{V12_CHARLIE_02,		M12_CHARLIE_02_MP3,			"V12_CHARLIE_02"},
	{V12_CONUNDRUM_01,		M12_CONUNDRUM_01_MP3,		"V12_CONUNDRUM_01"},
	{V12_CONUNDRUM_02,		M12_CONUNDRUM_02_MP3,		"V12_CONUNDRUM_02"},
	{V12_CONUNDRUM_03,		M12_CONUNDRUM_03_MP3,		"V12_CONUNDRUM_03"},
	{V12_CONUNDRUM_04,		M12_CONUNDRUM_04_MP3,		"V12_CONUNDRUM_04"},
	{V12_CONUNDRUM_05,		M12_CONUNDRUM_05_MP3,		"V12_CONUNDRUM_05"},
	{V12_FOXTROT_01,		M12_FOXTROT_01_MP3,			"V12_FOXTROT_01"},
	{V12_FOXTROT_02,		M12_FOXTROT_02_MP3,			"V12_FOXTROT_02"},
	{V12_GUY_01,			M12_GUY_01_MP3,				"V12_GUY_01"},
	{V12_GUY_02,			M12_GUY_02_MP3,				"V12_GUY_02"},
	{V12_GUY_03,			M12_GUY_03_MP3,				"V12_GUY_03"},
	{V12_HAUTE_01,			M12_HAUTE_01_MP3,			"V12_HAUTE_01"},
	{V12_HAUTE_02,			M12_HAUTE_02_MP3,			"V12_HAUTE_02"},
	{V12_HAUTE_03,			M12_HAUTE_03_MP3,			"V12_HAUTE_03"},
	{V12_HAUTE_04,			M12_HAUTE_04_MP3,			"V12_HAUTE_04"},
	{V12_HAUTE_05,			M12_HAUTE_05_MP3,			"V12_HAUTE_05"},
	{V12_HAUTE_06,			M12_HAUTE_06_MP3,			"V12_HAUTE_06"},
	{V12_HOVER_01,			M12_HOVER_01_MP3,			"V12_HOVER_01"},
	{V12_HOVER_02,			M12_HOVER_02_MP3,			"V12_HOVER_02"},
	{V12_RUBE_01,			M12_RUBE_01_MP3,			"V12_RUBE_01"},
	{V12_RUBE_02,			M12_RUBE_02_MP3,			"V12_RUBE_02"},
	{V12_RUBE_03,			M12_RUBE_03_MP3,			"V12_RUBE_03"},
	{V12_RUBE_04,			M12_RUBE_04_MP3,			"V12_RUBE_04"},
	{V12_RUBE_05,			M12_RUBE_05_MP3,			"V12_RUBE_05"},
	{V12_RUBE_06,			M12_RUBE_06_MP3,			"V12_RUBE_06"},
	{V12_RUBE_07,			M12_RUBE_07_MP3,			"V12_RUBE_07"},
	{V12_RUBE_08,			M12_RUBE_08_MP3,			"V12_RUBE_08"},
	{V12_RUBE_09,			M12_RUBE_09_MP3,			"V12_RUBE_09"},
	{V12_RUBE_10,			M12_RUBE_10_MP3,			"V12_RUBE_10"},
	{V12_TEKT_01,			M12_TEKT_01_MP3,			"V12_TEKT_01"},
	{V12_TEKT_02,			M12_TEKT_02_MP3,			"V12_TEKT_02"},
	{V12_TEKT_03,			M12_TEKT_03_MP3,			"V12_TEKT_03"},
	{V12_TEKT_04,			M12_TEKT_04_MP3,			"V12_TEKT_04"},
	{V12_TEKT_05,			M12_TEKT_05_MP3,			"V12_TEKT_05"},
	{V12_TEKT_06,			M12_TEKT_06_MP3,			"V12_TEKT_06"},
	{V12_TEKT_07,			M12_TEKT_07_MP3,			"V12_TEKT_07"},
	{V13_ANIBLE_01,			M13_ANIBLE_01_MP3,			"V13_ANIBLE_01"},
	{V13_ANIBLE_02,			M13_ANIBLE_02_MP3,			"V13_ANIBLE_02"},
	{V13_FLOWER_01,			M13_FLOWER_01_MP3,			"V13_FLOWER_01"},
	{V13_FLOWER_02,			M13_FLOWER_02_MP3,			"V13_FLOWER_02"},
	{V13_FOOCHANE_01,		M13_FOOCHANE_01_MP3,		"V13_FOOCHANE_01"},
	{V13_FOOCHANE_02,		M13_FOOCHANE_02_MP3,		"V13_FOOCHANE_02"},
	{V13_FOOCHANE_03,		M13_FOOCHANE_03_MP3,		"V13_FOOCHANE_03"},
	{V13_FOOCHANE_04,		M13_FOOCHANE_04_MP3,		"V13_FOOCHANE_04"},
	{V13_GHULABUL_01,		M13_GHULABUL_01_MP3,		"V13_GHULABUL_01"},
	{V13_GHULABUL_02,		M13_GHULABUL_02_MP3,		"V13_GHULABUL_02"},
	{V13_GHULABUL_03,		M13_GHULABUL_03_MP3,		"V13_GHULABUL_03"},
	{V13_GHULABUL_04,		M13_GHULABUL_04_MP3,		"V13_GHULABUL_04"},
	{V13_GHULABUL_05,		M13_GHULABUL_05_MP3,		"V13_GHULABUL_05"},
	{V13_GHULABUL_06,		M13_GHULABUL_06_MP3,		"V13_GHULABUL_06"},
	{V13_GHULABUL_07,		M13_GHULABUL_07_MP3,		"V13_GHULABUL_07"},
	{V13_GUY_01,			M13_GUY_01_MP3,				"V13_GUY_01"},
	{V13_GUY_02,			M13_GUY_02_MP3,				"V13_GUY_02"},
	{V13_HAVENGIN_01,		M13_HAVENGIN_01_MP3,		"V13_HAVENGIN_01"},
	{V13_MELO_01,			M13_MELO_01_MP3,			"V13_MELO_01"},
	{V13_MELO_02,			M13_MELO_02_MP3,			"V13_MELO_02"},
	{V13_MELO_03,			M13_MELO_03_MP3,			"V13_MELO_03"},
	{V13_MITAKO_01,			M13_MITAKO_01_MP3,			"V13_MITAKO_01"},
	{V13_MITAKO_02,			M13_MITAKO_02_MP3,			"V13_MITAKO_02"},
	{V13_MITAKO_03,			M13_MITAKO_03_MP3,			"V13_MITAKO_03"},
	{V13_SPOONIE_01,		M13_SPOONIE_01_MP3,			"V13_SPOONIE_01"},
	{V13_SPOONIE_02,		M13_SPOONIE_02_MP3,			"V13_SPOONIE_02"},
	{V13_SPOONIE_03,		M13_SPOONIE_03_MP3,			"V13_SPOONIE_03"},
	{V13_SPOONIE_04,		M13_SPOONIE_04_MP3,			"V13_SPOONIE_04"},
	{V13_SPOONIE_05,		M13_SPOONIE_05_MP3,			"V13_SPOONIE_05"},
	{V13_ZYGOTE_01,			M13_ZYGOTE_01_MP3,			"V13_ZYGOTE_01"},
	{V13_ZYGOTE_02,			M13_ZYGOTE_02_MP3,			"V13_ZYGOTE_02"},
	{V13_ZYGOTE_03,			M13_ZYGOTE_03_MP3,			"V13_ZYGOTE_03"},
	{V13_ZYGOTE_04,			M13_ZYGOTE_04_MP3,			"V13_ZYGOTE_04"},
	{V13_ZYGOTE_05,			M13_ZYGOTE_05_MP3,			"V13_ZYGOTE_05"},
	{V14_LAMORTE_01,		M14_LAMORTE_01_MP3,			"V14_LAMORTE_01"},
	{V14_LAMORTE_02,		M14_LAMORTE_02_MP3,			"V14_LAMORTE_02"},
	{V15_COPROLITE_01,		M15_COPROITE_01_MP3,		"V15_COPROLITE_01"},
	{V15_COPROLITE_02,		M15_COPROITE_02_MP3,		"V15_COPROLITE_02"},
	{V15_COPROLITE_03,		M15_COPROITE_03_MP3,		"V15_COPROLITE_03"},
	{V15_COPROLITE_04,		M15_COPROITE_04_MP3,		"V15_COPROLITE_04"},
	{V15_COPROLITE_05,		M15_COPROITE_05_MP3,		"V15_COPROLITE_05"},
	{V15_COPROLITE_06,		M15_COPROITE_06_MP3,		"V15_COPROLITE_06"},
	{V15_COPROLITE_07,		M15_COPROITE_07_MP3,		"V15_COPROLITE_07"},
	{V15_COPROLITE_08,		M15_COPROITE_08_MP3,		"V15_COPROLITE_08"},
	{V15_COPROLITE_09,		M15_COPROITE_09_MP3,		"V15_COPROLITE_09"},
	{V15_COPROLITE_10,		M15_COPROITE_10_MP3,		"V15_COPROLITE_10"},
	{V15_COPROLITE_11,		M15_COPROITE_11_MP3,		"V15_COPROLITE_11"},
	{V15_COPROLITE_12,		M15_COPROITE_12_MP3,		"V15_COPROLITE_12"},
	{V15_COPROLITE_13,		M15_COPROITE_13_MP3,		"V15_COPROLITE_13"},
	{V15_COPROLITE_14,		M15_COPROITE_14_MP3,		"V15_COPROLITE_14"},
	{V15_COPROLITE_15,		M15_COPROITE_15_MP3,		"V15_COPROLITE_15"},
	{V15_COPROLITE_16,		M15_COPROITE_16_MP3,		"V15_COPROLITE_16"},
	{V15_COPROLITE_17,		M15_COPROITE_17_MP3,		"V15_COPROLITE_17"},
	{V15_COPROLITE_18,		M15_COPROITE_18_MP3,		"V15_COPROLITE_18"},
	{V15_GUY_01,			M15_GUY_01_MP3,				"V15_GUY_01"},
	{V15_GUY_02,			M15_GUY_02_MP3,				"V15_GUY_02"},
	{V15_REED_01,			M15_REED_01_MP3,			"V15_REED_01"},
	{V15_REED_02,			M15_REED_02_MP3,			"V15_REED_02"},
	{V15_REED_03,			M15_REED_03_MP3,			"V15_REED_03"},
	{V16_DYING_01,			M16_DYING_01_MP3,			"V16_DYING_01"},
	{V16_DYING_02,			M16_DYING_02_MP3,			"V16_DYING_02"},
	{V16_GUY_01,			M16_GUY_01_MP3,				"V16_GUY_01"},
	{V16_GUY_02,			M16_GUY_02_MP3,				"V16_GUY_02"},
	{V16_GUY_03,			M16_GUY_03_MP3,				"V16_GUY_03"},
	{V17_ANDERSON_01,		M17_ANDERSON_01_MP3,		"V17_ANDERSON_01"},
	{V17_BARBER_01,			M17_BARBER_01_MP3,			"V17_BARBER_01"},
	{V17_CAMPBELL_01,		M17_CAMPBELL_01_MP3,		"V17_CAMPBELL_01"},
	{V17_DEVONSHIRE_01,		M17_DEVONSHIRE_01_MP3,		"V17_DEVONSHIRE_01"},
	{V17_EGGER_01,			M17_EGGER_01_MP3,			"V17_EGGER_01"},
	{V17_EMERALD_01,		M17_EMERALD_01_MP3,			"V17_EMERALD_01"},
	{V17_FLINGBESTER_01,	M17_FLINGBESTER_01_MP3,		"V17_FLINGBESTER_01"},
	{V17_GERSHWIN_01,		M17_GERSHWIN_01_MP3,		"V17_GERSHWIN_01"},
	{V17_GUY_01,			M17_GUY_01_MP3,				"V17_GUY_01"},
	{V17_GUY_02,			M17_GUY_02_MP3,				"V17_GUY_02"},
	{V17_GUY_03,			M17_GUY_03_MP3,				"V17_GUY_03"},
	{V17_GUY_04,			M17_GUY_04_MP3,				"V17_GUY_04"},
	{V17_HEPHASTUS_01,		M17_HEPHASTUS_01_MP3,		"V17_HEPHASTUS_01"},
	{V17_INIWA_01,			M17_INIWA_01_MP3,			"V17_INIWA_01"},
	{V17_INIWA_02,			M17_INIWA_02_MP3,			"V17_INIWA_02"},
	{V17_INIWA_03,			M17_INIWA_03_MP3,			"V17_INIWA_03"},
	{V17_KEYCODE_01,		M17_KEYCODE_01_MP3,			"V17_KEYCODE_01"},
	{V17_KEYCODE_02,		M17_KEYCODE_02_MP3,			"V17_KEYCODE_02"},
	{V17_KEYCODE_03,		M17_KEYCODE_03_MP3,			"V17_KEYCODE_03"},
	{V17_KEYCODE_04,		M17_KEYCODE_04_MP3,			"V17_KEYCODE_04"},
	{V17_TOERIG_01,			M17_TOERIG_01_MP3,			"V17_TOERIG_01"},
	{V17_TOERIG_02,			M17_TOERIG_02_MP3,			"V17_TOERIG_02"},
	{V17_WARNER_01,			M17_WARNER_01_MP3,			"V17_WARNER_01"},
	{V17_WARNER_02,			M17_WARNER_02_MP3,			"V17_WARNER_02"},
	{V17_WARNER_03,			M17_WARNER_03_MP3,			"V17_WARNER_03"},
	{V17_WARNER_04,			M17_WARNER_04_MP3,			"V17_WARNER_04"},
	{V17_YORP_01,			M17_YORP_01_MP3,			"V17_YORP_01"},
	{V17_YORP_02,			M17_YORP_02_MP3,			"V17_YORP_02"},
	{V18_DERECHA_01,		M18_DERECHA_01_MP3,			"V18_DERECHA_01"},
	{V18_GUY_01,			M18_GUY_01_MP3,				"V18_GUY_01"},
	{V18_IZQUIERDA_01,		M18_IZQUIERDA_01_MP3,		"V18_IZQUIERDA_01"},
	{V18_IZQUIERDA_02,		M18_IZQUIERDA_02_MP3,		"V18_IZQUIERDA_02"},
	{V18_IZQUIERDA_03,		M18_IZQUIERDA_03_MP3,		"V18_IZQUIERDA_03"},
	{V18_IZQUIERDA_04,		M18_IZQUIERDA_04_MP3,		"V18_IZQUIERDA_04"},
	{V18_IZQUIERDA_05,		M18_IZQUIERDA_05_MP3,		"V18_IZQUIERDA_05"},
	{V18_IZQUIERDA_06,		M18_IZQUIERDA_06_MP3,		"V18_IZQUIERDA_06"},
	{V19_CAVEAT_01,			M19_CAVEAT_01_MP3,			"V19_CAVEAT_01"},
	{V19_CAVEAT_02,			M19_CAVEAT_02_MP3,			"V19_CAVEAT_02"},
	{V19_ENDER_01,			M19_ENDER_01_MP3,			"V19_ENDER_01"},
	{V19_ENDER_02,			M19_ENDER_02_MP3,			"V19_ENDER_02"},
	{V19_FRUSTRATO_01,		M19_FRUSTRATO_01_MP3,		"V19_FRUSTRATO_01"},
	{V19_FRUSTRATO_02,		M19_FRUSTRATO_02_MP3,		"V19_FRUSTRATO_02"},
	{V19_FRUSTRATO_03,		M19_FRUSTRATO_03_MP3,		"V19_FRUSTRATO_03"},
	{V19_FRUSTRATO_04,		M19_FRUSTRATO_04_MP3,		"V19_FRUSTRATO_04"},
	{V19_FRUSTRATO_05,		M19_FRUSTRATO_05_MP3,		"V19_FRUSTRATO_05"},
	{V19_FRUSTRATO_06,		M19_FRUSTRATO_06_MP3,		"V19_FRUSTRATO_06"},
	{V19_FRUSTRATO_07,		M19_FRUSTRATO_07_MP3,		"V19_FRUSTRATO_07"},
	{V19_FRUSTRATO_08,		M19_FRUSTRATO_08_MP3,		"V19_FRUSTRATO_08"},
	{V19_FRUSTRATO_09,		M19_FRUSTRATO_09_MP3,		"V19_FRUSTRATO_09"},
	{V19_FRUSTRATO_10,		M19_FRUSTRATO_10_MP3,		"V19_FRUSTRATO_10"},
	{V19_GUY_01,			M19_GUY_01_MP3,				"V19_GUY_01"},
	{V19_GUY_02,			M19_GUY_02_MP3,				"V19_GUY_02"},
	{V19_GUY_03,			M19_GUY_03_MP3,				"V19_GUY_03"},
	{V19_INTER_01,			M19_INTER_01_MP3,			"V19_INTER_01"},
	{V19_INTER_02,			M19_INTER_02_MP3,			"V19_INTER_02"},
	{V19_LONE_01,			M19_LONE_01_MP3,			"V19_LONE_01"},
	{V19_LONE_02,			M19_LONE_02_MP3,			"V19_LONE_02"},
	{V19_LONE_03,			M19_LONE_03_MP3,			"V19_LONE_03"},
	{V19_PHILLIPS_01,		M19_PHILLIPS_01_MP3,		"V19_PHILLIPS_01"},
	{V19_PHILLIPS_02,		M19_PHILLIPS_02_MP3,		"V19_PHILLIPS_02"},
	{V19_PHILLIPS_03,		M19_PHILLIPS_03_MP3,		"V19_PHILLIPS_03"},
	{V19_PHILLIPS_04,		M19_PHILLIPS_04_MP3,		"V19_PHILLIPS_04"},
	{V19_PHILLIPS_05,		M19_PHILLIPS_05_MP3,		"V19_PHILLIPS_05"},
	{V19_RAILRIDER_01,		M19_RAILRIDER_01_MP3,		"V19_RAILRIDER_01"},
	{V19_RAILRIDER_02,		M19_RAILRIDER_02_MP3,		"V19_RAILRIDER_02"},
	{V19_RAILRIDER_03,		M19_RAILRIDER_03_MP3,		"V19_RAILRIDER_03"},
	{V19_RAILRIDER_04,		M19_RAILRIDER_04_MP3,		"V19_RAILRIDER_04"},
	{V19_REDRUM_01,			M19_REDRUM_01_MP3,			"V19_REDRUM_01"},
	{V19_REDRUM_02,			M19_REDRUM_02_MP3,			"V19_REDRUM_02"},
	{V19_REDRUM_03,			M19_REDRUM_03_MP3,			"V19_REDRUM_03"},
	{V19_REDRUM_04,			M19_REDRUM_04_MP3,			"V19_REDRUM_04"},
	{V19_REDRUM_05,			M19_REDRUM_05_MP3,			"V19_REDRUM_05"},
	{V19_REDRUM_06,			M19_REDRUM_06_MP3,			"V19_REDRUM_06"},
	{V19_STANDARD_01,		M19_STANDARD_01_MP3,		"V19_STANDARD_01"},
	{V19_STANDARD_02,		M19_STANDARD_02_MP3,		"V19_STANDARD_02"},
	{V20_ARNIE_01,			M20_ARNIE_01_MP3,			"V20_ARNIE_01"},
	{V20_ARNIE_02,			M20_ARNIE_02_MP3,			"V20_ARNIE_02"},
	{V20_BRAD_01,			M20_BRAD_01_MP3,			"V20_BRAD_01"},
	{V20_BRAD_02,			M20_BRAD_02_MP3,			"V20_BRAD_02"},
	{V20_BUSTER_01,			M20_BUSTER_01_MP3,			"V20_BUSTER_01"},
	{V20_BUSTER_02,			M20_BUSTER_02_MP3,			"V20_BUSTER_02"},
	{V20_BUSTER_03,			M20_BUSTER_03_MP3,			"V20_BUSTER_03"},
	{V20_COOPER_01,			M20_COOPER_01_MP3,			"V20_COOPER_01"},
	{V20_COOPER_02,			M20_COOPER_02_MP3,			"V20_COOPER_02"},
	{V20_DINERS_01,			M20_DINERS_01_MP3,			"V20_DINERS_01"},
	{V20_DINERS_02,			M20_DINERS_02_MP3,			"V20_DINERS_02"},
	{V20_DOLLY_01,			M20_DOLLY_01_MP3,			"V20_DOLLY_01"},
	{V20_DOREK_01,			M20_DOREK_01_MP3,			"V20_DOREK_01"},
	{V20_DOREK_02,			M20_DOREK_02_MP3,			"V20_DOREK_02"},
	{V20_DOREK_03,			M20_DOREK_03_MP3,			"V20_DOREK_03"},
	{V20_FARBLE_01,			M20_FARBLE_01_MP3,			"V20_FARBLE_01"},
	{V20_FARBLE_02,			M20_FARBLE_02_MP3,			"V20_FARBLE_02"},
	{V20_GRUNETT_01,		M20_GRUNETT_01_MP3,			"V20_GRUNETT_01"},
	{V20_GRUNETT_02,		M20_GRUNETT_02_MP3,			"V20_GRUNETT_02"},
	{V20_GUY_01,			M20_GUY_01_MP3,				"V20_GUY_01"},
	{V20_GUY_02,			M20_GUY_02_MP3,				"V20_GUY_02"},
	{V20_GUY_03,			M20_GUY_03_MP3,				"V20_GUY_03"},
	{V20_GUY_04,			M20_GUY_04_MP3,				"V20_GUY_04"},
	{V20_GUY_05,			M20_GUY_05_MP3,				"V20_GUY_05"},
	{V20_GUY_06,			M20_GUY_06_MP3,				"V20_GUY_06"},
	{V20_HUMBERT_01,		M20_HUMBERT_01_MP3,			"V20_HUMBERT_01"},
	{V20_ILLIAC_01,			M20_ILLIAC_01_MP3,			"V20_ILLIAC_01"},
	{V20_JACQUES_01,		M20_JAQUES_01_MP3,			"V20_JACQUES_01"},
	{V20_JACQUES_02,		M20_JAQUES_02_MP3,			"V20_JACQUES_02"},
	{V20_LUMBAR_01,			M20_LUMBAR_01_MP3,			"V20_LUMBAR_01"},
	{V20_MANNY_01,			M20_MANNY_01_MP3,			"V20_MANNY_01"},
	{V20_POLONEY_01,		M20_POLONEY_01_MP3,			"V20_POLONEY_01"},
	{V20_POLONEY_02,		M20_POLONEY_02_MP3,			"V20_POLONEY_02"},
	{V20_SARGE_01,			M20_SARGE_01_MP3,			"V20_SARGE_01"},
	{V20_SARGE_02,			M20_SARGE_02_MP3,			"V20_SARGE_02"},
	{V20_SARGE_03,			M20_SARGE_03_MP3,			"V20_SARGE_03"},
	{V20_SARGE_04,			M20_SARGE_04_MP3,			"V20_SARGE_04"},
	{V20_SARGE_05,			M20_SARGE_05_MP3,			"V20_SARGE_05"},
	{V21_ANTIMA_01,			M21_ANTIMA_01_MP3,			"V21_ANTIMA_01"},
	{V21_ANTIMA_02,			M21_ANTIMA_02_MP3,			"V21_ANTIMA_02"},
	{V21_ANTIMA_03,			M21_ANTIMA_03_MP3,			"V21_ANTIMA_03"},
	{V21_ANTIMA_04,			M21_ANTIMA_04_MP3,			"V21_ANTIMA_04"},
	{V21_ANTIMA_05,			M21_ANTIMA_05_MP3,			"V21_ANTIMA_05"},
	{V21_ANTIMA_06,			M21_ANTIMA_06_MP3,			"V21_ANTIMA_06"},
	{V21_ANTIMA_07,			M21_ANTIMA_07_MP3,			"V21_ANTIMA_07"},
	{V21_BRAN_ONOMI_01,		M21_BRAN_ONOMI_01_MP3,		"V21_BRAN_ONOMI_01"},
	{V21_BRAN_ONOMI_02,		M21_BRAN_ONOMI_02_MP3,		"V21_BRAN_ONOMI_02"},
	{V21_BRAN_ONOMI_03,		M21_BRAN_ONOMI_03_MP3,		"V21_BRAN_ONOMI_03"},
	{V21_CONTENNE_01,		M21_CONTENNE_01_MP3,		"V21_CONTENNE_01"},
	{V21_CONTENNE_02,		M21_CONTENNE_02_MP3,		"V21_CONTENNE_02"},
	{V21_CONTENNE_03,		M21_CONTENNE_03_MP3,		"V21_CONTENNE_03"},
	{V21_CONTENNE_04,		M21_CONTENNE_04_MP3,		"V21_CONTENNE_04"},
	{V21_CONTENNE_05,		M21_CONTENNE_05_MP3,		"V21_CONTENNE_05"},
	{V21_CONTENNE_06,		M21_CONTENNE_06_MP3,		"V21_CONTENNE_06"},
	{V21_CONTENNE_07,		M21_CONTENNE_07_MP3,		"V21_CONTENNE_07"},
	{V21_COUHOUSE_01,		M21_COUHOUSE_01_MP3,		"V21_COUHOUSE_01"},
	{V21_COUHOUSE_02,		M21_COUHOUSE_02_MP3,		"V21_COUHOUSE_02"},
	{V21_COUHOUSE_03,		M21_COUHOUSE_03_MP3,		"V21_COUHOUSE_03"},
	{V21_DEBENSHIRE_01,		M21_DEBENSHIRE_01_MP3,		"V21_DEBENSHIRE_01"},
	{V21_DEBENSHIRE_02,		M21_DEBENSHIRE_02_MP3,		"V21_DEBENSHIRE_02"},
	{V21_DEBENSHIRE_03,		M21_DEBENSHIRE_03_MP3,		"V21_DEBENSHIRE_03"},
	{V21_DEBENSHIRE_04,		M21_DEBENSHIRE_04_MP3,		"V21_DEBENSHIRE_04"},
	{V21_FEMURIA_01,		M21_FEMURIA_01_MP3,			"V21_FEMURIA_01"},
	{V21_FEMURIA_02,		M21_FEMURIA_02_MP3,			"V21_FEMURIA_02"},
	{V21_FEMURIA_03,		M21_FEMURIA_03_MP3,			"V21_FEMURIA_03"},
	{V21_FEMURIA_04,		M21_FEMURIA_04_MP3,			"V21_FEMURIA_04"},
	{V21_FEMURIA_05,		M21_FEMURIA_05_MP3,			"V21_FEMURIA_05"},
	{V21_GLARATTE_01,		M21_GLARATTE_01_MP3,		"V21_GLARATTE_01"},
	{V21_GLARATTE_02,		M21_GLARATTE_02_MP3,		"V21_GLARATTE_02"},
	{V21_GLARATTE_03,		M21_GLARATTE_03_MP3,		"V21_GLARATTE_03"},
	{V21_GLARATTE_04,		M21_GLARATTE_04_MP3,		"V21_GLARATTE_04"},
	{V21_GUY_01,			M21_GUY_01_MP3,				"V21_GUY_01"},
	{V21_GUY_02,			M21_GUY_02_MP3,				"V21_GUY_02"},
	{V21_GUY_03,			M21_GUY_03_MP3,				"V21_GUY_03"},
	{V21_GUY_04,			M21_GUY_04_MP3,				"V21_GUY_04"},
	{V21_GUY_05,			M21_GUY_05_MP3,				"V21_GUY_05"},
	{V21_GUY_06,			M21_GUY_06_MP3,				"V21_GUY_06"},
	{V21_GUY_07,			M21_GUY_07_MP3,				"V21_GUY_07"},
	{V21_GUY_08,			M21_GUY_08_MP3,				"V21_GUY_08"},
	{V21_GUY_09,			M21_GUY_09_MP3,				"V21_GUY_09"},
	{V21_HYPERBOLE_01,		M21_HYPERBOLE_01_MP3,		"V21_HYPERBOLE_01"},
	{V21_KREN_KREN_01,		M21_KREN_KREN_01_MP3,		"V21_KREN_KREN_01"},
	{V21_KREN_KREN_02,		M21_KREN_KREN_02_MP3,		"V21_KREN_KREN_02"},
	{V21_KREN_KREN_03,		M21_KREN_KREN_03_MP3,		"V21_KREN_KREN_03"},
	{V21_KREN_KREN_04,		M21_KREN_KREN_04_MP3,		"V21_KREN_KREN_04"},
	{V21_KREN_KREN_05,		M21_KREN_KREN_05_MP3,		"V21_KREN_KREN_05"},
	{V21_LITOTE_01,			M21_LITOTE_01_MP3,			"V21_LITOTE_01"},
	{V21_PERIOUS_01,		M21_PERIOUS_01_MP3,			"V21_PERIOUS_01"},
	{V21_PERIOUS_02,		M21_PERIOUS_02_MP3,			"V21_PERIOUS_02"},
	{V21_PERIOUS_03,		M21_PERIOUS_03_MP3,			"V21_PERIOUS_03"},
	{V21_PHAEDRUS_01,		M21_PHAEDRUS_01_MP3,		"V21_PHAEDRUS_01"},
	{V21_PHAEDRUS_02,		M21_PHAEDRUS_02_MP3,		"V21_PHAEDRUS_02"},
	{V21_PHAEDRUS_04,		M21_PHAEDRUS_04_MP3,		"V21_PHAEDRUS_04"},
	{V21_PHAEDRUS_05,		M21_PHAEDRUS_05_MP3,		"V21_PHAEDRUS_05"},
	{V21_PHAEDRUS_06,		M21_PHAEDRUS_06_MP3,		"V21_PHAEDRUS_06"},
	{V21_PHAEDRUS_07,		M21_PHAEDRUS_07_MP3,		"V21_PHAEDRUS_07"},
	{V21_PHAEDRUS_08,		M21_PHAEDRUS_08_MP3,		"V21_PHAEDRUS_08"},
	{V21_PHAEDRUS_09,		M21_PHAEDRUS_09_MP3,		"V21_PHAEDRUS_09"},
	{V21_PHAEDRUS_10,		M21_PHAEDRUS_10_MP3,		"V21_PHAEDRUS_10"},
	{V21_PHAEDRUS_11,		M21_PHAEDRUS_11_MP3,		"V21_PHAEDRUS_11"},
	{V21_PHAEDRUS_12,		M21_PHAEDRUS_12_MP3,		"V21_PHAEDRUS_12"},
	{V21_PHAEDRUS_13,		M21_PHAEDRUS_13_MP3,		"V21_PHAEDRUS_13"},
	{V21_PHAEDRUS_14,		M21_PHAEDRUS_14_MP3,		"V21_PHAEDRUS_14"},
	{V21_PHAEDRUS_15,		M21_PHAEDRUS_15_MP3,		"V21_PHAEDRUS_15"},
	{V21_PHAEDRUS_16,		M21_PHAEDRUS_16_MP3,		"V21_PHAEDRUS_16"},
	{V21_PHAEDRUS_17,		M21_PHAEDRUS_17_MP3,		"V21_PHAEDRUS_17"},
	{V21_PHAEDRUS_18,		M21_PHAEDRUS_18_MP3,		"V21_PHAEDRUS_18"},
	{V21_PHAEDRUS_19,		M21_PHAEDRUS_19_MP3,		"V21_PHAEDRUS_19"},
	{V21_PHAEDRUS_20,		M21_PHAEDRUS_20_MP3,		"V21_PHAEDRUS_20"},
	{V21_PHAEDRUS_21,		M21_PHAEDRUS_21_MP3,		"V21_PHAEDRUS_21"},
	{V21_PHAEDRUS_22,		M21_PHAEDRUS_22_MP3,		"V21_PHAEDRUS_22"},
	{V21_PHAEDRUS_23,		M21_PHAEDRUS_23_MP3,		"V21_PHAEDRUS_23"},
	{V21_PHAEDRUS_24,		M21_PHAEDRUS_24_MP3,		"V21_PHAEDRUS_24"},
	{V21_PHAEDRUS_25,		M21_PHAEDRUS_25_MP3,		"V21_PHAEDRUS_25"},
	{V21_PHAEDRUS_26,		M21_PHAEDRUS_26_MP3,		"V21_PHAEDRUS_26"},
	{V21_PHIPOLOSSI_01,		M21_PHIPOLOSSI_01_MP3,		"V21_PHIPOLOSSI_01"},
	{V21_PHIPOLOSSI_02,		M21_PHIPOLOSSI_02_MP3,		"V21_PHIPOLOSSI_02"},
	{V21_PHIPOLOSSI_03,		M21_PHIPOLOSSI_03_MP3,		"V21_PHIPOLOSSI_03"},
	{V21_PHIPOLOSSI_04,		M21_PHIPOLOSSI_04_MP3,		"V21_PHIPOLOSSI_04"},
	{V21_PHIPOLOSSI_05,		M21_PHIPOLOSSI_05_MP3,		"V21_PHIPOLOSSI_05"},
	{V21_PHIPOLOSSI_06,		M21_PHIPOLOSSI_06_MP3,		"V21_PHIPOLOSSI_06"},
	{V21_PLODDER_01,		M21_PLODDER_01_MP3,			"V21_PLODDER_01"},
	{V21_PLODDER_02,		M21_PLODDER_02_MP3,			"V21_PLODDER_02"},
	{V21_PLODDER_03,		M21_PLODDER_03_MP3,			"V21_PLODDER_03"},
	{V21_PLODDER_04,		M21_PLODDER_04_MP3,			"V21_PLODDER_04"},
	{V21_SARGE_01,			M21_SARGE_01_MP3,			"V21_SARGE_01"},
	{V21_SARGE_02,			M21_SARGE_02_MP3,			"V21_SARGE_02"},
	{V21_SARGE_03,			M21_SARGE_03_MP3,			"V21_SARGE_03"},
	{V21_SARGE_04,			M21_SARGE_04_MP3,			"V21_SARGE_04"},
	{V21_SARGE_05,			M21_SARGE_05_MP3,			"V21_SARGE_05"},
	{V21_SARGE_06,			M21_SARGE_06_MP3,			"V21_SARGE_06"},
	{V21_SARGE_07,			M21_SARGE_07_MP3,			"V21_SARGE_07"},
	{V21_SARGE_08,			M21_SARGE_08_MP3,			"V21_SARGE_08"},
	{V21_SATIRE_01,			M21_SATIRE_01_MP3,			"V21_SATIRE_01"},
	{V21_SATIRE_02,			M21_SATIRE_02_MP3,			"V21_SATIRE_02"},
	{V21_SHELLEY_01,		M21_SHELLEY_01_MP3,			"V21_SHELLEY_01"},
	{V21_SHELLEY_02,		M21_SHELLEY_02_MP3,			"V21_SHELLEY_02"},
	{V21_SHELLEY_03,		M21_SHELLEY_03_MP3,			"V21_SHELLEY_03"},
	{V21_SHELLEY_04,		M21_SHELLEY_04_MP3,			"V21_SHELLEY_04"},
	{V21_SHELLEY_05,		M21_SHELLEY_05_MP3,			"V21_SHELLEY_05"},
	{V21_VERILITH_01,		M21_VERILITH_01_MP3,		"V21_VERILITH_01"},
	{V21_VERILITH_02,		M21_VERILITH_02_MP3,		"V21_VERILITH_02"},
	{V21_VERILITH_03,		M21_VERILITH_03_MP3,		"V21_VERILITH_03"},
	{V21_VERILITH_04,		M21_VERILITH_04_MP3,		"V21_VERILITH_04"},
	{V21_VERILITH_05,		M21_VERILITH_05_MP3,		"V21_VERILITH_05"},
	{V22_GUY_01,			M22_GUY_01_MP3,				"V22_GUY_01"},
	{V22_OSCURO_01,			M22_OSCURO_01_MP3,			"V22_OSCURO_01"},
	{V22_OSCURO_02,			M22_OSCURO_02_MP3,			"V22_OSCURO_02"},
	{V22_VERILITH_01,		M22_VERILITH_01_MP3,		"V22_VERILITH_01"},
	{V22_VERILITH_02,		M22_VERILITH_02_MP3,		"V22_VERILITH_02"},
	{V22_VERILITH_03,		M22_VERILITH_03_MP3,		"V22_VERILITH_03"},
	{V22_VERILITH_04,		M22_VERILITH_04_MP3,		"V22_VERILITH_04"},
	{V23_GUY_01,			M23_GUY_01_MP3,				"V23_GUY_01"},
	{V23_GUY_02,			M23_GUY_02_MP3,				"V23_GUY_02"},
	{V23_GUY_03,			M23_GUY_03_MP3,				"V23_GUY_03"},
	{V23_INSANITO_01,		M23_INSANITO_01_MP3,		"V23_INSANITO_01"},
	{V23_INSANITO_02,		M23_INSANITO_02_MP3,		"V23_INSANITO_02"},
	{V23_INSANITO_03,		M23_INSANITO_03_MP3,		"V23_INSANITO_03"},
	{V23_INSANITO_04,		M23_INSANITO_04_MP3,		"V23_INSANITO_04"},
	{V23_INSANITO_05,		M23_INSANITO_05_MP3,		"V23_INSANITO_05"},
	{V23_VERILITH_01,		M23_VERILITH_01_MP3,		"V23_VERILITH_01"},
	{V24_GUY_01,			M24_GUY_01_MP3,				"V24_GUY_01"},
	{V24_GUY_02,			M24_GUY_02_MP3,				"V24_GUY_02"},
	{V24_GUY_03,			M24_GUY_03_MP3,				"V24_GUY_03"},
	{V24_MANAGOTA_01,		M24_MANAGOTA_01_MP3,		"V24_MANAGOTA_01"},
	{V24_MANAGOTA_02,		M24_MANAGOTA_02_MP3,		"V24_MANAGOTA_02"},
	{V24_MANAGOTA_03,		M24_MANAGOTA_03_MP3,		"V24_MANAGOTA_03"},
	{V24_MANAGOTA_04,		M24_MANAGOTA_04_MP3,		"V24_MANAGOTA_04"},
	{V25_BBOW_01,			M25_BBOW_01_MP3,			"V25_BBOW_01"},
	{V25_BBOW_02,			M25_BBOW_02_MP3,			"V25_BBOW_02"},
	{V25_BBOW_03,			M25_BBOW_03_MP3,			"V25_BBOW_03"},
	{V25_BBOW_04,			M25_BBOW_04_MP3,			"V25_BBOW_04"},
	{V25_GUY_01,			M25_GUY_01_MP3,				"V25_GUY_01"},
	{V25_GUY_02,			M25_GUY_02_MP3,				"V25_GUY_02"},
	{V25_VERILITH_01,		M25_VERILITH_01_MP3,		"V25_VERILITH_01"},
	{V26_GUY_01,			M26_GUY_01_MP3,				"V26_GUY_01"},
	{V26_GUY_02,			M26_GUY_02_MP3,				"V26_GUY_02"},
	{V26_GUY_03,			M26_GUY_03_MP3,				"V26_GUY_03"},
	{V26_GUY_04,			M26_GUY_04_MP3,				"V26_GUY_04"},
	{V26_GUY_05,			M26_GUY_05_MP3,				"V26_GUY_05"},
	{V26_FDOE_01,			M26_FDOE_01_MP3,			"V26_FDOE_01"},
	{V26_FDOE_02,			M26_FDOE_02_MP3,			"V26_FDOE_02"},
	{V26_FDOE_03,			M26_FDOE_03_MP3,			"V26_FDOE_03"},
	{V26_FDOE_04,			M26_FDOE_04_MP3,			"V26_FDOE_04"},
	{V27_AYONN_01,			M27_AYONN_01_MP3,			"V27_AYONN_01"},
	{V27_AYONN_02,			M27_AYONN_02_MP3,			"V27_AYONN_02"},
	{V27_AYONN_03,			M27_AYONN_03_MP3,			"V27_AYONN_03"},
	{V27_AYONN_04,			M27_AYONN_04_MP3,			"V27_AYONN_04"},
	{V27_BALE_01,			M27_BALE_01_MP3,			"V27_BALE_01"},
	{V27_BALE_02,			M27_BALE_02_MP3,			"V27_BALE_02"},
	{V27_BALE_03,			M27_BALE_03_MP3,			"V27_BALE_03"},
	{V27_GUY_01,			M27_GUY_01_MP3,				"V27_GUY_01"},
	{V27_GUY_02,			M27_GUY_02_MP3,				"V27_GUY_02"},
	{V27_GUY_03,			M27_GUY_03_MP3,				"V27_GUY_03"},
	{V27_ONABILDEN_01,		M27_ONABILDEN_01_MP3,		"V27_ONABILDEN_01"},
	{V27_ONABILDEN_02,		M27_ONABILDEN_02_MP3,		"V27_ONABILDEN_02"},
	{V27_ONABILDEN_03,		M27_ONABILDEN_03_MP3,		"V27_ONABILDEN_03"},
	{V27_ONABILDEN_04,		M27_ONABILDEN_04_MP3,		"V27_ONABILDEN_04"},
	{V28_FINN_01,			M28_FINN_01_MP3,			"V28_FINN_01"},
	{V28_FINN_02,			M28_FINN_02_MP3,			"V28_FINN_02"},
	{V28_FINN_03,			M28_FINN_03_MP3,			"V28_FINN_03"},
	{V28_GUY_01,			M28_GUY_01_MP3,				"V28_GUY_01"},
	{V28_GUY_02,			M28_GUY_02_MP3,				"V28_GUY_02"},
	{V28_GUY_03,			M28_GUY_03_MP3,				"V28_GUY_03"},
	{V29_ALERE_01,			M29_ALERE_01_MP3,			"V29_ALERE_01"},
	{V29_ALERE_02,			M29_ALERE_02_MP3,			"V29_ALERE_02"},
	{V29_ALERE_03,			M29_ALERE_03_MP3,			"V29_ALERE_03"},
	{V29_AOLOS_01,			M29_AOLOS_01_MP3,			"V29_AOLOS_01"},
	{V29_AOLOS_02,			M29_AOLOS_02_MP3,			"V29_AOLOS_02"},
	{V29_AOLOS_03,			M29_AOLOS_03_MP3,			"V29_AOLOS_03"},
	{V29_AOLOS_04,			M29_AOLOS_04_MP3,			"V29_AOLOS_04"},
	{V29_AOLOS_05,			M29_AOLOS_05_MP3,			"V29_AOLOS_05"},
	{V29_GUY_01,			M29_GUY_01_MP3,				"V29_GUY_01"},
	{V29_GUY_02,			M29_GUY_02_MP3,				"V29_GUY_02"},
	{V29_GUY_03,			M29_GUY_03_MP3,				"V29_GUY_03"},
	{V29_GUY_04,			M29_GUY_04_MP3,				"V29_GUY_04"},
	{V29_GUY_05,			M29_GUY_05_MP3,				"V29_GUY_05"},
	{V29_GUY_06,			M29_GUY_06_MP3,				"V29_GUY_06"},
	{V29_GUY_07,			M29_GUY_07_MP3,				"V29_GUY_07"},
	{V29_GUY_08,			M29_GUY_08_MP3,				"V29_GUY_08"},
	{V29_GUY_09,			M29_GUY_09_MP3,				"V29_GUY_09"},
	{V29_GUY_10,			M29_GUY_10_MP3,				"V29_GUY_10"},
	{V29_GUY_11,			M29_GUY_11_MP3,				"V29_GUY_11"},
	{V29_GUY_12,			M29_GUY_12_MP3,				"V29_GUY_12"},
	{V29_GUY_13,			M29_GUY_13_MP3,				"V29_GUY_13"},
	{V29_GUY_14,			M29_GUY_14_MP3,				"V29_GUY_14"},
	{V29_GUY_15,			M29_GUY_15_MP3,				"V29_GUY_15"},
	{V29_KORENAAR_01,		M29_KORENAAR_01_MP3,		"V29_KORENAAR_01"},
	{V29_KORENAAR_02,		M29_KORENAAR_02_MP3,		"V29_KORENAAR_02"},
	{V29_KORENAAR_03,		M29_KORENAAR_03_MP3,		"V29_KORENAAR_03"},
	{V29_KORENAAR_04,		M29_KORENAAR_04_MP3,		"V29_KORENAAR_04"},
	{V29_KORENAAR_05,		M29_KORENAAR_05_MP3,		"V29_KORENAAR_05"},
	{V29_PHARIBOS_01,		M29_PHARIBOS_01_MP3,		"V29_PHARIBOS_01"},
	{V29_PHARIBOS_02,		M29_PHARIBOS_02_MP3,		"V29_PHARIBOS_02"},
	{V29_VELEGAL_01,		M29_VELEGAL_01_MP3,			"V29_VELEGAL_01"},
	{V29_VELEGAL_02,		M29_VELEGAL_02_MP3,			"V29_VELEGAL_02"},
	{V30_AOLOS_01,			M30_AOLOS_01_MP3,			"V30_AOLOS_01"},
	{V30_AOLOS_02,			M30_AOLOS_02_MP3,			"V30_AOLOS_02"},
	{V30_AOLOS_03,			M30_AOLOS_03_MP3,			"V30_AOLOS_03"},
	{V30_AOLOS_04,			M30_AOLOS_04_MP3,			"V30_AOLOS_04"},
	{V30_AOLOS_05,			M30_AOLOS_05_MP3,			"V30_AOLOS_05"},
	{V30_AOLOS_06,			M30_AOLOS_06_MP3,			"V30_AOLOS_06"},
	{V30_AOLOS_07,			M30_AOLOS_07_MP3,			"V30_AOLOS_07"},
	{V30_AOLOS_08,			M30_AOLOS_08_MP3,			"V30_AOLOS_08"},
	{V30_AOLOS_09,			M30_AOLOS_09_MP3,			"V30_AOLOS_09"},
	{V30_AOLOS_11,			M30_AOLOS_11_MP3,			"V30_AOLOS_11"},
	{V30_AOLOS_12,			M30_AOLOS_12_MP3,			"V30_AOLOS_12"},
	{V30_AOLOS_13,			M30_AOLOS_13_MP3,			"V30_AOLOS_13"},
	{V30_AOLOS_14,			M30_AOLOS_14_MP3,			"V30_AOLOS_14"},
	{V30_AOLOS_15,			M30_AOLOS_15_MP3,			"V30_AOLOS_15"},
	{V30_AOLOS_16,			M30_AOLOS_16_MP3,			"V30_AOLOS_16"},
	{V30_AOLOS_17,			M30_AOLOS_17_MP3,			"V30_AOLOS_17"},
	{V30_AOLOS_18,			M30_AOLOS_18_MP3,			"V30_AOLOS_18"},
	{V30_AOLOS_19,			M30_AOLOS_19_MP3,			"V30_AOLOS_19"},
	{V30_AOLOS_20,			M30_AOLOS_20_MP3,			"V30_AOLOS_20"},
	{V30_CASINOX_01,		M30_CASINOX_01_MP3,			"V30_CASINOX_01"},
	{V30_CASINOX_02,		M30_CASINOX_02_MP3,			"V30_CASINOX_02"},
	{V30_CASINOX_03,		M30_CASINOX_03_MP3,			"V30_CASINOX_03"},
	{V30_CASINOX_04,		M30_CASINOX_04_MP3,			"V30_CASINOX_04"},
	{V30_CASINOX_05,		M30_CASINOX_05_MP3,			"V30_CASINOX_05"},
	{V30_CASINOX_06,		M30_CASINOX_06_MP3,			"V30_CASINOX_06"},
	{V30_CHICKEN_EXPLOSION_01,	M30_CHICKEN_EXPLOSION_01_MP3,	"V30_CHICKEN_EXPLOSION_01"},
	{V30_CHICKEN_EXPLOSION_02,	M30_CHICKEN_EXPLOSION_02_MP3,	"V30_CHICKEN_EXPLOSION_02"},
	{V30_DOPEFISH_01,		M30_DOPEFISH_01_MP3,		"V30_DOPEFISH_01"},
	{V30_DOPEFISH_02,		M30_DOPEFISH_02_MP3,		"V30_DOPEFISH_02"},
	{V30_DOPEFISH_03,		M30_DOPEFISH_03_MP3,		"V30_DOPEFISH_03"},
	{V30_DOPEFISH_04,		M30_DOPEFISH_04_MP3,		"V30_DOPEFISH_04"},
	{V30_GUY_01,			M30_GUY_01_MP3,				"V30_GUY_01"},
	{V30_GUY_02,			M30_GUY_02_MP3,				"V30_GUY_02"},
	{V30_JOHN_01,			M30_JOHN_01_MP3,			"V30_JOHN_01"},
	{V30_JOHN_02,			M30_JOHN_02_MP3,			"V30_JOHN_02"},
	{V30_JOHN_03,			M30_JOHN_03_MP3,			"V30_JOHN_03"},
	{V30_JOHN_04,			M30_JOHN_04_MP3,			"V30_JOHN_04"},
	{V30_JOHN_05,			M30_JOHN_05_MP3,			"V30_JOHN_05"},
	{V30_LUCAS_01,			M30_LUCAS_01_MP3,			"V30_LUCAS_01"},
	{V30_LUCAS_02,			M30_LUCAS_02_MP3,			"V30_LUCAS_02"},
	{V30_LUCAS_03,			M30_LUCAS_03_MP3,			"V30_LUCAS_03"},
	{V30_LUCAS_04,			M30_LUCAS_04_MP3,			"V30_LUCAS_04"},
	{V30_STEVIE_01,			M30_STEVIE_01_MP3,			"V30_STEVIE_01"},
	{V30_STEVIE_02,			M30_STEVIE_02_MP3,			"V30_STEVIE_02"},
	{V30_STEVIE_03,			M30_STEVIE_03_MP3,			"V30_STEVIE_03"},
	{V30_STEVIE_04,			M30_STEVIE_04_MP3,			"V30_STEVIE_04"},
	{V30_STEVIE_05,			M30_STEVIE_05_MP3,			"V30_STEVIE_05"},
	{V30_STEVIE_06,			M30_STEVIE_06_MP3,			"V30_STEVIE_06"},
	{V30_STEVIE_07,			M30_STEVIE_07_MP3,			"V30_STEVIE_07"},
	{V30_STEVIE_08,			M30_STEVIE_08_MP3,			"V30_STEVIE_08"},
	{V30_STEVIE_09,			M30_STEVIE_09_MP3,			"V30_STEVIE_09"},
	{V30_STEVIE_10,			M30_STEVIE_10_MP3,			"V30_STEVIE_10"},
	{V30_TOM_01,			M30_TOM_01_MP3,				"V30_TOM_01"},
	{V30_TOM_02,			M30_TOM_02_MP3,				"V30_TOM_02"},
	{V30_TOM_03,			M30_TOM_03_MP3,				"V30_TOM_03"},
	{V30_TOM_04,			M30_TOM_04_MP3,				"V30_TOM_04"},
	{V30_TOM_05,			M30_TOM_05_MP3,				"V30_TOM_05"},
	{V30_TOM_06,			M30_TOM_06_MP3,				"V30_TOM_06"},
	{V30_VERILITH_01,		M30_VERILITH_01_MP3,		"V30_VERILITH_01"},
	{V30_VERILITH_02,		M30_VERILITH_02_MP3,		"V30_VERILITH_02"},
	{V30_VERILITH_03,		M30_VERILITH_03_MP3,		"V30_VERILITH_03"},
	{V30_VERILITH_04,		M30_VERILITH_04_MP3,		"V30_VERILITH_04"},
	{V30_VERILITH_05,		M30_VERILITH_05_MP3,		"V30_VERILITH_05"},
	{V30_VERILITH_06,		M30_VERILITH_06_MP3,		"V30_VERILITH_06"},
	{V30_VERILITH_07,		M30_VERILITH_07_MP3,		"V30_VERILITH_07"},
	{OUTRO_DOLLY_01,		OUTRO_DOLLY_01_MP3,			"OUTRO_DOLLY_01"},
	{OUTRO_DOLLY_02,		OUTRO_DOLLY_02_MP3,			"OUTRO_DOLLY_02"},
	{OUTRO_DOLLY_03,		OUTRO_DOLLY_03_MP3,			"OUTRO_DOLLY_03"},
	{OUTRO_DOLLY_04,		OUTRO_DOLLY_04_MP3,			"OUTRO_DOLLY_04"},
	{OUTRO_DOLLY_05,		OUTRO_DOLLY_05_MP3,			"OUTRO_DOLLY_05"},
	{OUTRO_DOLLY_06,		OUTRO_DOLLY_06_MP3,			"OUTRO_DOLLY_06"},
	{OUTRO_DOLLY_07,		OUTRO_DOLLY_07_MP3,			"OUTRO_DOLLY_07"},
	{OUTRO_DOLLY_08,		OUTRO_DOLLY_08_MP3,			"OUTRO_DOLLY_08"},
	{OUTRO_DOLLY_09,		OUTRO_DOLLY_09_MP3,			"OUTRO_DOLLY_09"},
	{OUTRO_DOLLY_10,		OUTRO_DOLLY_10_MP3,			"OUTRO_DOLLY_10"},
	{OUTRO_DOLLY_11,		OUTRO_DOLLY_11_MP3,			"OUTRO_DOLLY_11"},
	{OUTRO_DOLLY_12,		OUTRO_DOLLY_12_MP3,			"OUTRO_DOLLY_12"},
	{OUTRO_DOLLY_13,		OUTRO_DOLLY_13_MP3,			"OUTRO_DOLLY_13"},
	{OUTRO_DOLLY_14,		OUTRO_DOLLY_14_MP3,			"OUTRO_DOLLY_14"},
	{OUTRO_DOLLY_15,		OUTRO_DOLLY_15_MP3,			"OUTRO_DOLLY_15"},
	{OUTRO_DOLLY_16,		OUTRO_DOLLY_16_MP3,			"OUTRO_DOLLY_16"},
	{OUTRO_DOLLY_17,		OUTRO_DOLLY_17_MP3,			"OUTRO_DOLLY_17"},
	{OUTRO_DOLLY_18,		OUTRO_DOLLY_18_MP3,			"OUTRO_DOLLY_18"},
	{OUTRO_DOREK_01,		OUTRO_DOREK_01_MP3,			"OUTRO_DOREK_01"},
	{OUTRO_DOREK_02,		OUTRO_DOREK_02_MP3,			"OUTRO_DOREK_02"},
	{OUTRO_DOREK_03,		OUTRO_DOREK_03_MP3,			"OUTRO_DOREK_03"},
	{OUTRO_DOREK_04,		OUTRO_DOREK_04_MP3,			"OUTRO_DOREK_04"},
	{OUTRO_DOREK_05,		OUTRO_DOREK_05_MP3,			"OUTRO_DOREK_05"},
	{OUTRO_DOREK_06,		OUTRO_DOREK_06_MP3,			"OUTRO_DOREK_06"},
	{OUTRO_GUY_01,			OUTRO_GUY_01_MP3,			"OUTRO_GUY_01"},
	{OUTRO_GUY_02,			OUTRO_GUY_02_MP3,			"OUTRO_GUY_02"},
	{OUTRO_GUY_03,			OUTRO_GUY_03_MP3,			"OUTRO_GUY_03"},
	{OUTRO_GUY_04,			OUTRO_GUY_04_MP3,			"OUTRO_GUY_04"},
	{OUTRO_GUY_05,			OUTRO_GUY_05_MP3,			"OUTRO_GUY_05"},
	{OUTRO_GUY_06,			OUTRO_GUY_06_MP3,			"OUTRO_GUY_06"},
	{OUTRO_JENKINS_01,		OUTRO_JENKINS_01_MP3,		"OUTRO_JENKINS_01"},
	{OUTRO_JENKINS_02,		OUTRO_JENKINS_02_MP3,		"OUTRO_JENKINS_02"},
	{OUTRO_JENKINS_03,		OUTRO_JENKINS_03_MP3,		"OUTRO_JENKINS_03"},
	{OUTRO_JENKINS_04,		OUTRO_JENKINS_04_MP3,		"OUTRO_JENKINS_04"},
	{OUTRO_JENKINS_05,		OUTRO_JENKINS_05_MP3,		"OUTRO_JENKINS_05"},
	{OUTRO_SARGE_01,		OUTRO_SARGE_01_MP3,			"OUTRO_SARGE_01"},
	{OUTRO_SARGE_02,		OUTRO_SARGE_02_MP3,			"OUTRO_SARGE_02"},
	{OUTRO_SARGE_03,		OUTRO_SARGE_03_MP3,			"OUTRO_SARGE_03"},
	{OUTRO_SARGE_04,		OUTRO_SARGE_04_MP3,			"OUTRO_SARGE_04"},
	{OUTRO_SARGE_05,		OUTRO_SARGE_05_MP3,			"OUTRO_SARGE_05"},
	{OUTRO_SARGE_06,		OUTRO_SARGE_06_MP3,			"OUTRO_SARGE_06"},
	{GUY_GOT_A_JOB,			GUY_GOT_A_JOB_MP3,			"GUY_GOT_A_JOB"},
	{GUY_WINS,				GUY_WINS_MP3,				"GUY_WINS"},
	{GUY_ENERGY_CELL,		GUY_ENERGY_CELL_MP3,		"GUY_ENERGY_CELL"},
	{GUY_COMPLETED,			GUY_COMPLETED_MP3,			"GUY_COMPLETED"},
	{GUY_GOT_SOMETHING,		GUY_GOT_SOMETHING_MP3,		"GUY_GOT_SOMETHING"},
	{HDB_INTRO,				HDB_INTRO_MP3,				"HDB_INTRO"},

	// Demo files
	{DEMO_SARGE_01,			DEMO_SARGE01_MP3,			"DEMO_SARGE_01"},
	{DEMO_SARGE_02,			DEMO_SARGE02_MP3,			"DEMO_SARGE_02"},
	{DEMO_SARGE_03,			DEMO_SARGE03_MP3,			"DEMO_SARGE_03"},
	{DEMO_SARGE_04,			DEMO_SARGE04_MP3,			"DEMO_SARGE_04"},
	{DEMO_SARGE_05,			DEMO_SARGE05_MP3,			"DEMO_SARGE_05"},
	{DEMO_SARGE_06,			DEMO_SARGE06_MP3,			"DEMO_SARGE_06"},

	{DEMO_GUY_01,			DEMO_GUY_01_MP3,			"DEMO_GUY_01"},
	{DEMO_PILOT_01,			DEMO_PILOT_01_MP3,			"DEMO_PILOT_01"},
	{DEMO_SCIENTIST_01,		DEMO_SCIENTIST_01_MP3,		"DEMO_SCIENTIST_01"},
	{DEMO_SCIENTIST_02,		DEMO_SCIENTIST_02_MP3,		"DEMO_SCIENTIST_02"},

	{LAST_SOUND,			nullptr,						nullptr}
};

Sound::Sound() {
	_numSounds = 0;
	_voicesOn = false;
	memset(_voicePlayed, 0, NUM_VOICES * sizeof(byte));
}

void Sound::test() {
	#ifdef USE_MAD
		Common::SeekableReadStream *soundStream = g_hdb->_fileMan->findFirstData("M00_AIRLOCK_01_MP3", TYPE_BINARY);
		Audio::SeekableAudioStream *audioStream = Audio::makeMP3Stream(soundStream, DisposeAfterUse::YES);
		Audio::SoundHandle *handle = new Audio::SoundHandle();
		g_hdb->_mixer->playStream(Audio::Mixer::kSFXSoundType, handle, audioStream);
	#endif
}

void Sound::init() {
	//
	// init sound caching system
	//
	int index = 0;
	while (soundList[index].idx != LAST_SOUND) {
		int index2 = soundList[index].idx;
		_soundCache[index2].loaded = SNDMEM_NOTCACHED;
		_soundCache[index2].name = soundList[index].name;
		_soundCache[index2].luaName = soundList[index].luaName;
		if (g_hdb->getPlatform() == Common::kPlatformLinux)
			_soundCache[index2].ext = SNDTYPE_OGG;
		else {
			if (index2 <= SND_UNLOCKED_ITEM || index2 == SND_BEEPBEEPBEEP)
				_soundCache[index2].ext = SNDTYPE_WAV;
			else
				_soundCache[index2].ext = SNDTYPE_MP3;
		}
		debug(9, "Registering sound: sName: %s, \tsLuaName: %s, \tExtension: %s", soundList[index].name, soundList[index].luaName, _soundCache[index].ext == SNDTYPE_MP3 ? "MP3" : "WAV");
		index++;
	}
	_numSounds = index;

	setVoiceStatus(true);
	clearPersistent();
}

void Sound::save(Common::OutSaveFile *out) {
	for (int i = 0; i < NUM_VOICES; i++) {
		out->writeByte(_voicePlayed[i]);
	}
}

void Sound::loadSaveFile(Common::InSaveFile *in) {
	for (int i = 0; i < NUM_VOICES; i++) {
		_voicePlayed[i] = in->readByte();
	}
}


void Sound::playSound(int index) {
	if (index > _numSounds || ConfMan.getInt(CONFIG_SFXVOL) == 0)
		return;

	// is sound in memory at least?
	if (_soundCache[index].loaded == SNDMEM_FREEABLE)
		_soundCache[index].loaded = SNDMEM_LOADED;

	// is sound marked as cached?
	if (_soundCache[index].loaded == SNDMEM_NOTCACHED) {
		Common::String updatedName(_soundCache[index].name);

		if (g_hdb->getPlatform() == Common::kPlatformLinux)
			updatedName.replace(updatedName.begin() + updatedName.size() - 4, updatedName.end(), "_OGG");

		Common::SeekableReadStream *stream = g_hdb->_fileMan->findFirstData(updatedName.c_str(), TYPE_BINARY, &_soundCache[index].size);

		_soundCache[index].data = (byte *)malloc(_soundCache[index].size);
		stream->read(_soundCache[index].data, _soundCache[index].size);

		_soundCache[index].loaded = SNDMEM_LOADED;
	}

	int soundChannel = kLaserChannel;

	// Select Free Audio Handle
	for (int i = 0; i < kLaserChannel; i++) {
		if (!g_hdb->_mixer->isSoundHandleActive(_handles[i])) {
			soundChannel = i;
			break;
		}
	}

	// If no free handles found
	if (soundChannel == kLaserChannel)
		return;

	if (_soundCache[index].data == nullptr)
		return;

	Audio::SeekableAudioStream *audioStream = nullptr;
	Common::MemoryReadStream *stream = new Common::MemoryReadStream(_soundCache[index].data, _soundCache[index].size, DisposeAfterUse::NO);

	if (_soundCache[index].ext == SNDTYPE_MP3) {
#ifdef USE_MAD
		audioStream = Audio::makeMP3Stream(stream, DisposeAfterUse::YES);
#endif // USE_MAD
	} else if (_soundCache[index].ext == SNDTYPE_OGG) {
#ifdef USE_VORBIS
		audioStream = Audio::makeVorbisStream(stream, DisposeAfterUse::YES);
#endif // USE_VORBIS
	} else {
		audioStream = Audio::makeWAVStream(stream, DisposeAfterUse::YES);
	}

	if (audioStream == nullptr) {
		warning("playSound: sound %d is corrupt", index);
		return;
	}

	g_hdb->_mixer->playStream(
		Audio::Mixer::kSFXSoundType,
		&_handles[soundChannel],
		audioStream,
		-1,
		Audio::Mixer::kMaxChannelVolume,
		0,
		DisposeAfterUse::YES,
		false,
		false
	);
}

void Sound::playSoundEx(int index, int channel, bool loop) {
	if (g_hdb->_mixer->isSoundHandleActive(_handles[channel]))
		return;

	if (index > _numSounds || ConfMan.getInt(CONFIG_SFXVOL) == 0)
		return;

	// is sound in memory at least?
	if (_soundCache[index].loaded == SNDMEM_FREEABLE)
		_soundCache[index].loaded = SNDMEM_LOADED;

	// is sound marked as cached?
	if (_soundCache[index].loaded == SNDMEM_NOTCACHED) {
		Common::String updatedName(_soundCache[index].name);

		if (g_hdb->getPlatform() == Common::kPlatformLinux)
			updatedName.replace(updatedName.begin() + updatedName.size() - 4, updatedName.end(), "_OGG");

		Common::SeekableReadStream *stream = g_hdb->_fileMan->findFirstData(updatedName.c_str(), TYPE_BINARY, &_soundCache[index].size);

		_soundCache[index].data = (byte *)malloc(_soundCache[index].size);
		stream->read(_soundCache[index].data, _soundCache[index].size);
		_soundCache[index].loaded = SNDMEM_LOADED;
	}

	if (_soundCache[index].data == nullptr)
		return;

	Audio::SeekableAudioStream *audioStream = nullptr;
	Common::MemoryReadStream *stream = new Common::MemoryReadStream(_soundCache[index].data, _soundCache[index].size, DisposeAfterUse::NO);

	if (_soundCache[index].ext == SNDTYPE_MP3) {
#ifdef USE_MAD
		audioStream = Audio::makeMP3Stream(stream, DisposeAfterUse::YES);
#endif // USE_MAD
	} else if (_soundCache[index].ext == SNDTYPE_OGG) {
#ifdef USE_VORBIS
		audioStream = Audio::makeVorbisStream(stream, DisposeAfterUse::YES);
#endif // USE_VORBIS
	} else {
		audioStream = Audio::makeWAVStream(stream, DisposeAfterUse::YES);
	}

	if (audioStream == nullptr) {
		warning("playSoundEx: sound %d is corrupt", index);
		return;
	}

	if (loop) {
		Audio::AudioStream *loopingStream = new Audio::LoopingAudioStream(audioStream, 0, DisposeAfterUse::YES);
		g_hdb->_mixer->playStream(
			Audio::Mixer::kSFXSoundType,
			&_handles[channel],
			loopingStream,
			-1,
			Audio::Mixer::kMaxChannelVolume,
			0,
			DisposeAfterUse::YES,
			false,
			false
		);
	} else {
		g_hdb->_mixer->playStream(
			Audio::Mixer::kSFXSoundType,
			&_handles[channel],
			audioStream,
			-1,
			Audio::Mixer::kMaxChannelVolume,
			0,
			DisposeAfterUse::YES,
			false,
			false
		);
	}
}

void Sound::playVoice(int index, int actor) {
	if (!_voicesOn || g_hdb->isPPC() || ConfMan.getInt(CONFIG_SPEECHVOL) == 0)
		return;

	// is voice channel already active?  if so, shut 'er down (automagically called StopVoice via callback)
	if (_voices[actor].active)
		g_hdb->_mixer->stopHandle(_voices[actor].handle);

	// make sure we aren't playing a line more than once this time (only on CHANNEL 0)
	if (!actor && _voicePlayed[index - FIRST_VOICE])
		return;

	Common::SeekableReadStream *stream = nullptr;
	Common::String updatedName(soundList[index].name);
	if (g_hdb->getPlatform() == Common::kPlatformLinux)
		updatedName.replace(updatedName.begin() + updatedName.size() - 4, updatedName.end(), "_OGG");

	stream = g_hdb->_fileMan->findFirstData(updatedName.c_str(), TYPE_BINARY);
	if (stream == nullptr)
		return;

	if (g_hdb->getPlatform() == Common::kPlatformLinux) {
#ifdef USE_VORBIS
		Audio::AudioStream *audioStream = Audio::makeVorbisStream(stream, DisposeAfterUse::YES);
		if (audioStream == nullptr) {
			delete stream;
			return;
		}

		g_hdb->_mixer->playStream(
			Audio::Mixer::kSpeechSoundType,
			&_voices[actor].handle,
			audioStream,
			-1,
			Audio::Mixer::kMaxChannelVolume,
			0,
			DisposeAfterUse::YES,
			false,
			false
		);
#endif
	} else {
#ifdef USE_MAD
		Audio::AudioStream *audioStream = Audio::makeMP3Stream(stream, DisposeAfterUse::YES);
		if (audioStream == nullptr) {
			delete stream;
			return;
		}

		g_hdb->_mixer->playStream(
			Audio::Mixer::kSpeechSoundType,
			&_voices[actor].handle,
			audioStream,
			-1,
			Audio::Mixer::kMaxChannelVolume,
			0,
			DisposeAfterUse::YES,
			false,
			false
		);
#endif
	}

	_voices[actor].active = true;
	_voicePlayed[index - FIRST_VOICE] = 1;

	return;
}

void Sound::startMusic(SoundType song) {
	g_hdb->_menu->saveSong(song);

	if (ConfMan.getInt(CONFIG_MUSICVOL) == 0)
		return;

	beginMusic(song, false, 0);
}

void Sound::fadeInMusic(SoundType song, int ramp) {
	g_hdb->_menu->saveSong(song);

	if (ConfMan.getInt(CONFIG_MUSICVOL) == 0)
		return;

	stopMusic();
	beginMusic(song, false, ramp);
}

void Sound::fadeOutMusic(int ramp) {
	if (_song1.isPlaying()) {
		_song1.fadeOut(ramp);
	} else if (_song2.isPlaying()) {
		_song2.fadeOut(ramp);
	}
}

bool Sound::songPlaying(SoundType song) {
	if (_song1.isPlaying() && _song1.getSong() == song)
		return true;

	if (_song2.isPlaying() && _song2.getSong() == song)
		return true;

	return false;
}

void Sound::stopChannel(int channel) {
	g_hdb->_mixer->stopHandle(_handles[channel]);
}

void Sound::stopMusic() {
	if (_song1.isPlaying()) {
		_song1.stop();
	}
	if (_song2.isPlaying()) {
		_song2.stop();
	}
}

void Sound::beginMusic(SoundType song, bool fadeIn, int ramp) {
	if (!_song1.isPlaying()) {
		// Start fading out SONG2 if its playing
		if (_song2.isPlaying()) {
			_song2.fadeOut(ramp);
		}

		_song1.playSong(song, fadeIn, ramp);
	}
	else if (!_song2.isPlaying()) {
		// Start fading out SONG1 if its playing
		if (_song1.isPlaying()) {
			_song1.fadeOut(ramp);
		}
		_song2.playSong(song, fadeIn, ramp);
	}
}

bool Song::isPlaying() const {
	return _playing;
}

SoundType Song::getSong() const {
	return _song;
}

void Song::fadeOut(int ramp) {
	fadeOutRamp = ramp;
	fadingOut = true;
	fadeOutVol = Audio::Mixer::kMaxChannelVolume;
}

void Song::stop() {
	_playing = false;
	g_hdb->_mixer->stopHandle(handle);
}

void Song::playSong(SoundType song, bool fadeIn, int ramp) {

	Common::String fileName = getFileName(song);
	Audio::AudioStream* musicStream = createStream(fileName);

	if (musicStream == nullptr) return;

	this->_song = song;
	this->_playing = true;

	int initialVolume;

	if (fadeIn) {
		fadeInRamp = ramp;
		fadingIn = true;
		fadeInVol = 0;
		initialVolume = 0;
	} else {
		initialVolume = Audio::Mixer::kMaxChannelVolume;
	}

	g_hdb->_mixer->playStream(
		Audio::Mixer::kMusicSoundType,
		&handle,
		musicStream,
		-1,
		initialVolume,
		0,
		DisposeAfterUse::YES,
		false,
		false
	);
}

Common::String Song::getFileName(SoundType song) {
	Common::String fileName(soundList[song].name);

	if (g_hdb->getPlatform() == Common::kPlatformLinux) {
		fileName.replace(fileName.begin() + fileName.size() - 4, fileName.end(), ".ogg");
	}

	if (g_hdb->isPPC()) {
		switch (song) {
		case SONG_JEEBIES:
			fileName = "jeebies.mp3";
			break;
		case SONG_VIBRACIOUS:
			fileName = "vibracious.mp3";
			break;
		case SONG_ARETHERE:
			fileName = "are_we_there_yet.mp3";
			break;
		default:
			break;
		}
	}

	return fileName;
}

Audio::AudioStream* Song::createStream(Common::String fileName) {
	Common::SeekableReadStream* stream = SearchMan.createReadStreamForMember(fileName);
	if (stream == nullptr)
		return nullptr;

	if (g_hdb->getPlatform() != Common::kPlatformLinux) {
#ifdef USE_MAD
		Audio::SeekableAudioStream* audioStream = Audio::makeMP3Stream(stream, DisposeAfterUse::YES);
		return new Audio::LoopingAudioStream(audioStream, 0, DisposeAfterUse::YES);
#else
		return nullptr;
#endif
	} else {
#ifdef USE_VORBIS
		Audio::SeekableAudioStream* audioStream = Audio::makeVorbisStream(stream, DisposeAfterUse::YES);
		return new Audio::LoopingAudioStream(audioStream, 0, DisposeAfterUse::YES);
#else
		return nullptr;
#endif
	}
}

//void Song::update() {
//	if (fadingOut) {
//		fadeOutVol = 0;
//		_playing = false;
//		g_hdb->_mixer->stopHandle(handle);
//	}
//	else if (fadingIn) {
//		fadeInVol = Audio::Mixer::kMaxChannelVolume;
//		fadingIn = false;
//	}
//}

Sound::~Sound() {
	for (int i = 0; i < kMaxSounds; i++) {
		free(_soundCache[i].data);
	}
}

//void Sound::updateMusic() {
//	if (_song1.isPlaying()) {
//		_song1.update();
//	}
//
//	if (_song2.isPlaying()) {
//		_song2.update();
//	}
//}

SoundType Sound::whatSongIsPlaying() {
	if (_song1.isPlaying())
		return _song1.getSong();

	if (_song2.isPlaying())
		return _song2.getSong();

	return SONG_NONE;
}

int Sound::registerSound(const char *name) {
	int index = 0;
	while (_soundCache[index].name) {
		index++;
		if (index == kMaxSounds)
			return -1;
	}

	_soundCache[index].name = name;
	_soundCache[index].loaded = SNDMEM_NOTCACHED;   // just to be sure!
	return index;
}

void Sound::freeSound(int index) {
	if (_soundCache[index].loaded == SNDMEM_LOADED) {
		_soundCache[index].loaded = SNDMEM_NOTCACHED;
		_soundCache[index].ext = SNDTYPE_NONE;
	}
}

const char *Sound::getSNDLuaName(int index) {
	if (index >= kMaxSounds || !_soundCache[index].luaName)
		return nullptr;

	return _soundCache[index].luaName;
}

int Sound::getSNDIndex(const char *name) {
	for (int i = 0; soundList[i].idx != LAST_SOUND; ++i) {
		if (!scumm_stricmp(soundList[i].luaName, name))
			return i;
	}

	return 0;
}

void Sound::markSoundCacheFreeable() {
	for (int i = 0; i < kMaxSounds; i++) {
		if (_soundCache[i].loaded == SNDMEM_LOADED)
			_soundCache[i].loaded = SNDMEM_FREEABLE;
	}
}

} // End of Namespace
