/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

// These tables are modified from their FFmpeg counterparts so that
// they work on both little and big endian systems.

#ifndef VIDEO_CODECS_SVQ1_CB_H
#define VIDEO_CODECS_SVQ1_CB_H

#include "common/scummsys.h"

namespace Video {

static const int8 s_svq1InterCodebook4x2[768] = {
    7,  2, -6, -7,  7,  3, -3, -4, -7, -2,  7,  8, -8, -4,  3,  4,
   19, 17,  9,  3,-14,-16,-12, -8,-18,-16, -8, -3, 11, 14, 12,  8,
    7,-16,-10, 20,  7,-17,-10, 20, -6, 18,  8,-21, -7, 18,  9,-20,
   25,  3,-20,-14, 29,  7,-18,-13,-29, -4, 21, 14,-31, -6, 20, 14,
  -19,-26,-28,-24, 31, 32, 22, 10, 15, 24, 31, 28,-32,-32,-22,-13,
    2, -8,-23,-26, -9,  3, 27, 35,  3, 11, 21, 21,  8, -4,-27,-34,
  -30,-31, 12, 47,-29,-30, 13, 47, 38, 30,-17,-46, 34, 26,-19,-46,
  -42,-50,-51,-43, 34, 48, 55, 48, 48, 54, 51, 42,-44,-52,-53,-47,
    4,  5,  0, -6, -2, -2,  0,  1,-11, -6, -1, -2,  1,  8,  9,  1,
    0,  1, -6,  5,  8,  1,-12,  2,  7,-14, -7,  8,  5, -8,  0,  8,
    1,  4, 11,  8,-12, -8,  0, -5, -1,  1,  0,  4,-15, -8,  3, 16,
   17,  8, -4, -6,  9, -4,-13, -8,  2,  6,  1,-18, -1, 11, 11,-12,
    6,  0,  2,  0, 14,  6, -7,-21,  1, -1,-13,-20,  1,  1, 10, 21,
  -22, -5,  7, 13,-11, -1,  4, 12, -7,  0, 14, 19, -4,  3, -5,-19,
  -26,-14, 10, 15, 18,  4, -6, -2, 25, 19, -5,-18,-20, -7,  4,  2,
  -13, -6, -1, -4, 25, 37, -2,-35,  5,  4,  1,  1,-21,-36,  2, 43,
    2, -2, -1,  3,  8, -2, -6, -1, -2, -3,  2, 12, -5, -2, -2, -1,
   -3, -1, -1, -5, -1,  7,  8, -2,  2,  7,  5, -3,  1,  1, -3, -8,
   -3, -1, -3, -2, -2, -3,  2, 13, 15,  0,-11, -6,  3,  0,  0,  0,
   -6, -9, -5, -4, 18,  4,  1,  3, 12,  3,  0,  4,-16, -3,  3, -3,
  -17,  3, 18,  2, -1, -3, -1, -1, -6, 16, -8,  0, -9, 14, -7,  0,
    3,-13, 14, -5,  3,-13, 14, -4, -7, 20, 14,-23,  8, -7, -8,  4,
    8,-15,-19, 16,-10, 13, 11, -3,  9, -1,  1, 26,  5,-15,-27,  2,
  -20,  7, 16, -4,-40,  9, 31,  1, 26,-12,-30, -7, 40, -2,-19,  4,
    6,  0,  0,  0, -6, -2,  1,  2,  0, -1,  0, -6,  9,  0, -2, -1,
   -7,  8,  2, -3, -1,  2, -3,  2,  7, -4, -2,  4,  2,  0,  0, -6,
   -3, -2,  9,  2, -2, -1,  0, -4, -3, -3,  0, -3, -6,  2, 10,  4,
    3,  0,-10,  8,  0,  0, -4,  4, -1,  1,  4,  2,  3, -7, -9,  7,
    2,  1, -9, -4, -1, 12,  0,  0,  3, -1,  7, -4,  3,-14,  4,  2,
  -12, -9,  1, 11,  2,  5,  1,  0,  3,  1,  0,  2,  0,  8,  6,-19,
   -6,-10, -7, -4,  9,  7,  5,  7,  6, 21,  3, -3,-11, -9, -5, -2,
   -4, -9,-16, -1, -2, -5,  1, 36,  8, 11, 19,  0,  2,  5, -4,-41,
   -1, -1, -2, -1, -2, -2,  1,  6,  0,  4,  1, -8,  1,  1,  1,  0,
   -2, -3,  4,  0,  2, -1,  3, -3,  1,  3, -4,  1, -1,  3,  0, -5,
    3,  4,  2,  3, -2, -3, -6, -1, -2, -3, -2,  2, -4,  8,  1,  0,
   -7,  4,  2,  6, -7, -1,  1,  0, -2,  2, -4,  1,  8, -6,  2, -1,
   -6,  2,  0,  2,  5,  4, -8, -1, -1,-11,  0,  9,  0, -2,  2,  2,
   17, -5, -4, -1, -1, -4, -2, -2,  0,-13,  9, -3, -1, 12, -7,  2,
    0, -2, -5,  2, -7, -5, 20, -3,  7,  7, -1,-30,  3,  5,  8,  1,
   -6,  3, -1, -4,  2, -2,-11, 18,  0, -7,  3, 14, 20, -3,-18, -9,
    7, -2,  0, -1, -2,  0,  0, -1, -4, -1,  1,  0, -2,  2,  0,  4,
    1, -3,  2,  1,  3,  1, -5,  1, -3,  0, -1, -2,  7,  1,  0, -3,
    2,  5,  0, -2,  2, -5, -1,  1, -1, -2,  4, -1,  0, -3,  5,  0,
    0,  3, -1, -2, -4,  1,  5, -1, -1,  0, -1,  9, -1, -2, -1, -1,
   -2,  5,  5, -1, -2,  2, -3, -2,  1,  2,-11,  1,  2,  1,  3,  2,
    2,-10, -1, -2,  4,  2,  4,  1,  4,  5, -5,  1,  0,  6,-11,  1,
    1,  0,  6,  6,  0,  2,  1,-15,  7,  3,  5,  9,-30,  2,  2,  2,
  -34,  1,  9,  2,  5,  8,  8,  2,  7,  2,  6,  6,  2,-27,  1,  4
};

static const int8 s_svq1InterCodebook4x4[1536] = {
    4,  0, -6, -7, -4, -8,-13, -9, -8, -8, -1,  6, -2,  5, 22, 27,
  -16, -7, 11, 10,-18, -7, 13, 10,-15, -4, 12,  8, -9, -1,  9,  5,
   -2,  2, 15,-16, -3,  2, 19,-19, -3,  2, 19,-19, -2,  3, 15,-14,
   17, 22, 22, 16, -6, -7, -5, -2,-12,-16,-16,-12,  1,  1, -1, -3,
   11,-17,  0,  8, 14,-21, -1,  9, 14,-21, -2,  8, 11,-16, -2,  6,
    7, -2,-16, 11,  9, -2,-21, 14, 10, -1,-22, 14,  8, -1,-18, 10,
  -10, 16,  3, -9,-13, 20,  4,-11,-14, 21,  4,-10,-11, 16,  3, -8,
   11,  4, -9, -9, 15,  6,-12,-14, 17,  8,-12,-14, 16, 10, -7,-11,
    4, 10, 14, 13, -1,  7, 15, 16,-12, -7,  3,  8,-20,-23,-18,-10,
  -10,-18,-26,-25,  4,  1, -6,-11, 13, 15, 11,  3, 12, 15, 13,  8,
  -16,-19,-16,-11,  7, 12, 15, 11, 11, 16, 16, 11, -6, -9,-11,-10,
   18, 19, 12,  5, 18, 16,  5, -4,  6,  0,-10,-15, -9,-17,-23,-22,
  -10,-14, -1, 21,-11,-17,  0, 29,-11,-16,  1, 30,-10,-14,  0, 23,
  -16,-17,-12, -6,-19,-19,-14, -7, -3, -1,  1,  2, 27, 35, 29, 19,
  -37, -8, 23, 23,-42, -9, 28, 29,-43,-10, 26, 28,-38,-11, 19, 22,
   32, 16,-16,-33, 39, 20,-18,-37, 38, 19,-19,-38, 32, 15,-17,-34,
   24,  9, -6, -4, -1,-10, -6,  3, -8, -9, -1,  3,  3,  7,  2, -6,
   -1, -3, -1,  0, -1,  4,  2, -7, -3, 11,  3,-16,  1, 20,  9,-18,
   -3, -8,  6, 12, -5,-10,  7, 13, -6, -9,  5,  7, -5, -5,  2, -1,
   -8, 12, -3, -1,-10, 15, -3,  1,-11, 13, -4,  1,-11,  8, -3,  2,
    9,  6, -5,-12,  3,  0, -8,-13, -4, -4, -1, -1, -4,  1, 15, 18,
    9, 13, 14, 12,  4,  3, -1, -2, -2, -5, -8, -5, -7,-11, -9, -4,
    7, -5, -7, -4, 14, -2, -7, -4, 17,  0, -8, -5, 15,  1, -7, -5,
  -10, -1,  6,  4,-15, -9,  2,  4,  2, -1, -3,  0, 25, 13, -8,-10,
    7, 11, -3,-16,  7, 11, -3,-15,  6,  7, -2, -9,  4,  2, -3, -5,
   -7, -1, -1,  0, -9, -2,  2,  6,-12, -4,  6, 14,-13, -6,  8, 19,
  -18,-18,-11, -5, -3,  0,  3,  4,  6,  8,  6,  6,  6,  6,  6,  6,
   -5,  3, 13,-10, -6,  1, 15, -9, -6, -3, 15, -6, -6, -6, 10, -3,
    9,  1, -9, -9, 11,  9,  6,  5,  0,  3,  8,  7,-15,-14, -6, -5,
  -11, -6, 11, 19, -2, -5, -9, -8,  6,  2, -9,-10,  6,  5,  4,  5,
   -7, -3,  8, 15, -1,  3, 10, 15,  5,  5, -1, -2,  4, -2,-21,-25,
    6, -6, -6,  5,  8, -9, -7,  9,  8,-12, -7, 13,  4,-14, -7, 14,
   -4, -3,  1,  1, -3, -5, -2, -3,  7,  0, -2, -4, 20,  7, -4, -4,
   -3,-20, -6, 10,  6,  0,  0,  1,  5,  8,  5, -1, -3,  0,  0, -2,
   13,  6, -1,  2,  5,  3,  2,  3, -3,  0,  3,  0,-16, -8, -2, -5,
   -2, -7, -6,  0, -3, -6, -3,  1, -5, -1,  2, -1, -1, 12, 16,  5,
   -7,  1,  9,  8,-10, -2,  5,  3, -6,  2,  7,  3, -4,  0, -1, -7,
    3,  4, -9,-24,  0,  2,  6,  3, -1, -1,  4,  7,  5,  3, -1, -2,
    3,  6, -9,  2,  1,  6,-13,  1,  1,  8,-10,  2,  1,  8, -7,  1,
   -3, -3,  2, 22, -2, -3, -5, 12, -2, -3,-10,  2, -3, -1, -4,  2,
   11, 12,  8,  2, -5, -5, -5, -8, -6, -4,  0, -3, -2, -1,  3,  3,
   12, -6, -2, -1, 12, -8, -2, -2,  9, -7,  0, -3,  4, -6,  2, -2,
  -19,  1, 12, -3, -4,  4,  5, -4,  6,  1, -2, -1,  4, -4, -2,  7,
   -3, -4, -7, -8, -4, -4, -2,  0, -1,  2, 14, 16, -4, -2,  4,  4,
   -1,  7,  2, -5, -2,  0, -1,  1,  4, -3, -1, 13,  6,-12,-14,  8,
   -1,  5,  4, -5, -2,  5,  3, -9, -2,  7,  4,-12, -1,  7,  4, -9,
   -6, -3,  1,  1, 11, 11,  0, -6,  6,  4, -2, -7,-12,-10,  3, 10,
   -2, -3, -3, -2,  6, 11, 14, 10, -9,-11,-10,-10,  2,  2,  3,  2,
   -7, -5, -7, -1, -1,  2,  0,  7, -1,  1,  0,  9,  3,  4, -5, -1,
   10, -1,-15, -1,  4,  1, -5,  2, -3,  1, -1,  1, -3,  1,  4,  4,
    2, -1,  4, 10,  6,  2, -1,  0,  2,  2, -7,-12, -4,  2,  0, -3,
   -1, -4, -1, -8,  3, -1,  2, -9,  4,  0,  5, -5,  2,  0,  8,  3,
    3,  2,  1,  1,  4, -2,  0,  3,  2, -1,  4,  1,  0,  6, -1,-25,
   -1, -2, -2, -4, -3,  0, -1, -4, -1, -1, -4,  2,  0, -6,  2, 25,
  -11, -1,  5,  0,  7,  0, -2,  2, 10, -1, -3,  4, -5, -5, -2, -1,
    0,  6,  3, -1, -2, -1, -1,  1, -1, -7,-12, -5,  8,  6,  2,  4,
    2,  6, -1, -6,  9, 10, -1, -4,  1,  0, -4,  0,  3, -2, -9, -5,
   -4,  3,  4,  0, -4,  3,  3,  0,-11,  0,  3,  2,-11,  3,  7,  2,
    2, -4,  7,  3,  1, -8,  7,  1, -1,-12,  4,  1,  3, -9,  2,  2,
    2, -2, -2,  9,-17, -3,  3,  1, -4,  7,  1, -6,  5,  4, -1,  3,
   -1,  2,  0, -4, -7,  8, 12, -1, -2,  5,  4, -5,  3, -5, -8, -2,
    0,  0, -5, -2, -2, -8,  3, 27, -1, -4, -3,  6, -3,  1, -2, -7,
    4,  4,  1, -1, -7,-10, -7, -3, 10, 10,  5,  3, -2, -2, -4, -3,
    0,  1,  5,  7,  4, -2,-16,-20,  0,  4,  7,  8,  2,  0, -2, -1,
   -2,  1,  3, 17, -3,  1, -2, -1, -1, -2, -1, -2, -1, -5, -1,  0,
    5, -3,  1,  0,  6, -2,  0,  0, -1, -2,  0, -3,-11,  1,  8, -1,
    3,  0,  0,  0,  0,  2,  4,  1,  2,  0,  6,  1, -2,-18, -3,  2,
  -14,  0,  6,  1, -5, -2, -1,  1, -1,  1,  0,  1,  1,  7,  4,  0,
   -1,  0,  1, -4,  1,  8,  3, -4, -3,  4,  1,  3, -6,  1, -4,  1,
    1,-12,  3,  3, -1,-10,  0, -1,  2,  0,  2,  1,  3,  2,  2,  4,
    3,  0,  0,  3,  2,  0, -2,  1,  5,  2, -5,  0,  6, -1,-14, -1,
   -2, -6, -3, -3,  2, -1,  4,  5,  6, -1, -2,  0,  4,  4, -1, -5,
   -4,  1,-11,  0, -1,  2, -4,  1,  2, -3,  3, -1,  1, -2, 15,  0,
    1, -1,  0, -2,  1, -4, -7,  1, -2, -6, -1, 21, -2,  2, -1,  1,
   21, -1, -2,  0, -1, -3,  1, -2, -9, -2,  2, -1,  2,  1, -4, -1,
    1,  8,  2, -6,-10, -1,  4,  0, -4, -3,  3,  3,  5,  0, -1, -1,
    3,  2,  1, -2, -2, -2,  4,  3,  5,  2, -4,-17,  0, -2,  4,  3,
   -7, -4,  0,  3,  9,  9,  2, -1,-11, -6,  0, -1,  5,  1,  0,  1,
    0, 17,  5,-11,  3, -2, -6,  0,  2, -2, -4,  1, -4,  1,  2, -1,
   -5, -1, -5, -3, -3,  5, -3, -2,  4, 16,  2, -5, -2,  5, -1, -1,
    0,  0, -4,  1, -1,  2,  5, 11, -1, -1, -2,  1, -4, -2, -3, -1,
   -5, -1, 10,  0,  6,  1,  0, -3,  0, -4,  1,  0, -2, -4,  3, -1,
    6,  9,  3,  0, -2,  1, -2,  0, -2, -3, -2, -2,  1,  0,  1, -6,
    1,  0,  2,  1, -1,  3, -2,  1,  0, -1,-15,  0, -1,  5,  2,  6,
    2,  0,  2,  2,  0,-12, -4,  6,  0,  1,  4, -1,  1,  2,  1, -4,
    1, -2, -7,  0,  0,  0,  0, -1, -5,  2, 11,  3,  1,  3,  0, -6,
    0, -3, -9, -4,  1,  3, -1,  0,  4,  1, -2,  0,  7, -3, -1,  6,
    1, -2,  6,  2,  0, -1,  3, -2, -2,  4,  0,  2, -1,  2,-14,  2,
    2,  2,  0, -1, -2,  3, -3,-14,  0,  2,  3, -3,  5,  1,  3,  2,
    1, -3,  4,-14,  1, -2, 11, -1,  0, -1,  3,  0, -1,  1,  0,  2,
   -2,  3, -3,  2, -4, -1, -4,  3, -1,  2,  1,  3, -6, -2,  2,  7,
   -2,  1,  2,  0, -2,  0,  0, -1, 12,  5, -1,  2, -8, -1,  1, -7,
    2, -2, -4,  2, 11,  0,-11, -2,  3,  1, -3, -1,  0,  3,  1, -1,
    0,  3,  0, -2,  0, -6, -1, -3, 12, -7, -2,  0,  7, -2,  1,  1,
    1,  2,  2,  2, -1,  2,  0,  2,-23,  0,  4,  0,  3,  2,  1,  3,
   -4, -5, -1,  5, -3,  5, 10, -1,  0,  0,  3, -4,  1, -1,  2, -5
};

static const int8 s_svq1InterCodebook8x4[3072] = {
    9,  8,  4,  0, -3, -4, -4, -3,  9,  8,  4, -1, -4, -5, -5, -3,
    8,  7,  3, -2, -5, -5, -5, -4,  6,  4,  1, -2, -4, -5, -4, -3,
  -12,-14,-11, -4,  1,  5,  6,  6, -8,-10, -7, -5, -2,  1,  1,  1,
    5,  4,  3,  1,  0,  0, -1, -1, 13, 13,  9,  6,  3,  0, -1, -2,
   -4, -4, -3, -1,  1,  4,  8, 11, -5, -6, -4, -2,  0,  3,  8, 12,
   -7, -7, -6, -4, -2,  2,  7, 10, -7, -7, -5, -4, -2,  1,  5,  8,
   -3, -2, -1,  1,  3,  6,  7,  6,  2,  3,  5,  7,  8,  8,  6,  4,
    4,  5,  4,  3,  1, -2, -6, -7,  1,  0, -2, -7,-10,-14,-17,-16,
   -5, -4,  1,  8,  9,  3, -3, -7, -7, -6,  1, 11, 12,  5, -3, -8,
   -8, -7,  0,  9, 11,  5, -3, -7, -8, -6, -1,  5,  8,  4, -2, -6,
   -4, -5, -7, -8, -9, -9, -8, -6, -4, -5, -6, -7, -7, -6, -4, -2,
    0,  1,  2,  3,  5,  8, 10,  9,  1,  2,  3,  6,  9, 12, 14, 13,
    5,  6,  6,  5,  4,  3,  2,  1,  5,  6,  7,  7,  6,  6,  6,  4,
   -1,  0,  1,  1,  3,  5,  5,  5,-13,-16,-17,-17,-14,-10, -6, -4,
    9, 11, 13, 16, 15, 13, 12, 10, -4, -5, -6, -7, -7, -7, -6, -5,
   -6, -6, -7, -7, -7, -7, -6, -5, -2, -1,  0,  0,  0,  0,  0, -1,
  -11,-13,-15,-16,-16,-14,-12,-10,  2,  3,  4,  5,  4,  3,  3,  3,
    6,  7,  8,  8,  8,  7,  6,  5,  3,  4,  3,  3,  3,  3,  3,  3,
    3,  4,  4,  1, -2, -7,-13,-17,  5,  7,  7,  5,  1, -5,-13,-19,
    6,  8,  9,  8,  5, -1, -9,-16,  6,  8, 10, 10,  7,  2, -4,-11,
   18,  9, -1,-10,-13, -9, -4,  0, 22, 12, -1,-12,-15,-10, -4,  2,
   23, 13,  0,-10,-13, -9, -3,  2, 20, 12,  2, -6, -9, -6, -2,  2,
   -6, -6, -6, -7, -7, -7, -7, -6, -6, -7, -8, -8, -9, -9, -9, -8,
   -3, -3, -3, -3, -3, -3, -3, -3, 12, 15, 18, 21, 21, 19, 17, 14,
   14, 16, 18, 18, 18, 16, 15, 13,  5,  6,  6,  5,  5,  4,  4,  3,
   -6, -7, -9,-10,-10,-10, -9, -7,-10,-11,-13,-14,-14,-13,-12,-10,
  -27,-17, -4,  5,  9, 10, 10,  7,-32,-19, -3,  7, 11, 12, 11,  8,
  -30,-16, -2,  8, 12, 12, 10,  7,-23,-12,  0,  7, 10, 11,  9,  6,
   16, 17, 16, 12,  6, -1, -8,-12, 17, 18, 15, 10,  1, -8,-15,-18,
   15, 14, 10,  4, -5,-14,-20,-23, 10,  8,  4, -1, -9,-16,-21,-22,
  -10,-12,-12,-11, -5,  4, 14, 20,-11,-13,-15,-12, -4,  7, 19, 27,
  -11,-13,-14,-11, -3,  8, 21, 28,-10,-11,-12, -9, -2,  8, 18, 25,
   -1, -1, -1,  1,  4,  6,  6,  5,  0,  0,  0,  2,  4,  3,  1, -2,
    0,  0,  2,  4,  4, -1, -7,-10,  0,  0,  3,  5,  3, -3,-11,-15,
  -14,-13, -8, -1,  3,  3, -1, -4, -5, -4, -1,  4,  8,  8,  3,  0,
    3,  2,  2,  3,  4,  5,  3,  1,  5,  3,  0, -2, -2, -1, -1, -1,
    9,  1, -6, -6, -5, -3, -2, -1, 12,  1, -6, -6, -4, -2, -1,  0,
   14,  4, -4, -4, -2, -2, -1, -1, 14,  6, -1, -1, -1, -1, -1, -1,
    4,  6,  8, 10, 11,  9,  7,  5, -1, -1, -1,  0,  0, -1, -1, -2,
   -2, -4, -4, -5, -5, -5, -5, -4, -2, -3, -3, -4, -4, -3, -2, -1,
    2,  3,  4,  4,  3,  1,  0,  0, -1,  1,  4,  5,  6,  5,  4,  3,
   -8, -6, -2,  2,  3,  4,  4,  3,-14,-13, -9, -5, -2, -1,  0,  0,
   -3, -4, -5, -4,  0,  7, 12, 13, -3, -4, -5, -5, -2,  4,  9, 10,
   -2, -3, -4, -5, -4, -1,  3,  4, -1, -1, -2, -3, -3, -2,  0,  1,
    9,  5, -2, -8,-11,-10, -7, -4, 12, 10,  6,  2,  0, -1,  0,  0,
    2,  2,  3,  4,  3,  1,  1,  1, -9, -8, -4,  0,  1,  2,  1,  0,
    6,  8,  8,  5,  1, -5,-11,-13,  0,  1,  2,  2, -1, -4, -8,-11,
   -3, -2,  1,  3,  3,  1, -1, -4, -2, -1,  2,  5,  6,  6,  4,  1,
    3,  4,  5,  5,  4,  1, -3, -6,  5,  6,  4,  2,  2,  2,  0, -3,
    6,  5,  0, -5, -5, -2, -1, -2,  7,  4, -3,-11,-12, -7, -3, -2,
    1,  0, -1, -1, -1,  0,  0,  0,  2,  3,  4,  4,  5,  5,  4,  3,
   -7, -9, -9,-10,-10, -9, -7, -6,  3,  4,  5,  6,  5,  5,  5,  5,
   -7, -7, -7, -7, -6, -6, -5, -4, -5, -4, -3, -1, -1, -1,  0,  0,
   -3, -2,  1,  4,  5,  5,  5,  5, -2, -1,  3,  6,  9, 10, 10,  9,
  -14,  1, 10,  3, -2,  0,  1,  1,-16,  2, 13,  3, -3, -1,  1,  0,
  -15,  2, 12,  3, -4, -2,  1,  1,-10,  3, 10,  2, -3, -1,  1,  1,
    0,  1,  4,  2, -5,-10, -3, 11, -1,  1,  4,  2, -6,-13, -2, 15,
   -1,  0,  3,  1, -6,-12, -1, 15, -1,  1,  2,  1, -4, -8,  0, 11,
   10,  5, -2, -2,  2,  5,  1, -4,  7,  0, -8, -6,  1,  5,  2, -4,
    2, -5,-12, -7,  2,  7,  4, -1, -1, -7,-10, -4,  4,  9,  7,  2,
   -5, -5, -4, -6, -6, -5, -5, -3, -1, -2, -2, -4, -5, -6, -5, -4,
    6,  7,  7,  4,  0, -2, -3, -3, 13, 14, 13, 10,  5,  1, -1, -2,
    1,  1,  2,  2,  2,  2,  2,  2, -5, -6, -8, -9, -9, -8, -7, -6,
    7,  9, 10, 11, 11,  9,  7,  5, -1, -2, -3, -3, -4, -4, -4, -3,
   -1, -1,  0,  0,  0,  0, -1, -1, -3, -3, -4, -5, -4, -3, -3, -2,
    2,  1, -1, -3, -3, -2, -1,  0, 12, 12,  8,  3,  1,  0,  0,  1,
   -6, -8, -8, -6, -2,  2,  6,  8,  1,  1, -1, -2,  0,  3,  5,  7,
    3,  3,  1, -1, -1,  0,  0,  2,  0,  1,  0, -1, -1, -1, -2, -1,
    1,  0,  0,  0,  0,  0,  2,  4,  2,  1,  3,  4,  3,  1,  0,  2,
    2,  1,  0,  0, -1, -1,  0,  3,  5,  1, -6,-12,-13, -8, -1,  4,
   -2,  0, -1, -2, -1,  0,  2,  3, -6, -3, -2,  0,  1,  1,  1,  1,
   -9, -5,  0,  4,  5,  3,  1,  0, -8, -3,  3,  7,  8,  4,  1,  0,
    1,  2,  2,  3,  3,  1, -1, -3,  4,  5,  5,  6,  6,  5,  2,  0,
    0,  0,  0,  0,  1,  0, -2, -4, -3, -3, -4, -3, -3, -4, -7, -8,
   14, 12,  6, -1, -3, -3,  0,  0,  7,  5,  1, -3, -5, -4, -2, -1,
   -2, -2, -2, -2, -2, -2, -1, -1, -6, -4, -1,  1,  1,  1,  0, -1,
    2,  2,  1, -3, -6, -7, -6, -3,  1,  0, -1, -3, -2,  1,  4,  6,
    0,  0,  1,  2,  4,  7,  8,  7,  0,  0,  0,  0, -1, -4, -7, -8,
    0,  2,  1, -2, -3, -3, -2, -1, -1,  1,  0, -3, -5, -2,  0,  2,
   -2, -1, -2, -5, -4,  1,  6,  9, -3, -2, -3, -4, -2,  5, 11, 13,
   -4, -2,  2,  6,  4, -3,-10,-14, -2, -1,  1,  4,  4,  1, -1, -2,
    0,  0, -1, -2, -2,  0,  4,  6,  2,  2,  0, -3, -3,  0,  5,  9,
   -4, -4, -2,  1,  6,  9,  3, -7, -2, -2, -2, -1,  4,  8,  0,-11,
    1,  1,  0,  0,  2,  6, -1,-10,  2,  2,  1,  0,  2,  4,  0, -7,
   -1, -2, -3, -6, -7, -8, -8, -8,  2,  3,  3,  1, -1, -2, -3, -4,
    5,  5,  5,  4,  3,  2,  0, -1,  3,  3,  3,  3,  2,  2,  1,  1,
    3,  3,  2, -2, -3,  0,  7, 10,  1,  2,  2, -2, -5, -4,  0,  3,
    0,  3,  4,  2, -3, -5, -6, -4,  0,  2,  4,  4,  1, -4, -7, -7,
    2,  4,  5,  5,  5,  5,  6,  6, -4, -4, -3, -5, -5, -3, -3, -2,
   -3, -4, -4, -5, -4, -2, -2, -2,  1,  1,  0,  0,  2,  4,  5,  4,
   -2,  0,  3,  4,  4,  3,  2,  2, -9, -7, -4,  0,  3,  6,  6,  6,
   -5, -5, -3, -2,  0,  1,  3,  4,  5,  5,  2, -2, -4, -6, -5, -3,
    1, -6, -4,  7,  5, -2, -2,  1,  5, -5, -4,  6,  4, -5, -4,  1,
    5, -5, -4,  6,  4, -5, -3,  1,  1, -7, -3,  8,  7, -1, -3,  1,
   -8, -7, -4,  0,  2,  4,  5,  5,  5,  6,  5,  2, -1, -5, -7, -7,
    5,  6,  4,  1, -3, -5, -6, -5, -7, -7, -5, -2,  1,  6,  9, 10,
    6,  3,  0,  1,  3,  0, -8,-14,  3,  0, -1,  1,  4,  3,  0, -4,
    1,  0,  0,  1,  2,  1,  1,  1, -1, -1,  1,  2,  1, -1, -1,  0,
    1,  1,  1,  1,  0, -2, -3,  0,  1,  2,  1,  0, -2, -8, -9, -4,
    1,  3,  3,  2,  1, -3, -3,  1,  0,  1,  1,  1,  1,  1,  4,  8,
    2,  5,  9,  7,  2, -1, -1,  1, -4, -1,  1,  0, -3, -4, -1,  2,
   -3,  0,  3,  3,  0, -1,  0,  2, -4, -1,  1,  1, -2, -4, -5, -4,
    1, -1, -2, -2, -1,  2,  4,  5,  2,  1,  1,  0, -1, -1,  0,  0,
    2,  3,  4,  5,  4,  2,  1,  0, -9, -9, -6, -3, -1, -1, -1, -1,
   -6, -6,  4,  7,  0, -2, -1, -2, -1, -2,  5,  6, -1, -2,  0, -1,
    4, -1,  1,  0, -4, -2,  0, -2,  7,  1, -1, -2, -3,  1,  3,  1,
    4,  2,  1,  3,  3,  1,  1,  2,  2, -2, -4,  0,  3,  1,  0,  0,
    1, -4, -8, -4,  1,  2,  1,  0,  2, -3, -9, -6,  0,  3,  3,  2,
   -1, -1,  0, -1, -1,  0,  1,  2,  3,  1, -4, -8, -7, -3,  1,  2,
    2, -1, -3, -2, -1,  0,  1,  0, -1,  0,  5, 11,  9,  3, -1, -3,
   -1, -2, -2, -1,  1,  1,  1,  1,  0, -1,  0,  3,  6,  6,  5,  5,
    2,  1, -1, -1, -2, -5, -6, -4,  2,  2,  2,  1, -1, -4, -5, -5,
   -1, -3, -6, -7, -6, -4, -1,  1,  5,  5,  3,  4,  4,  3,  4,  5,
   -1, -2, -3, -2, -2, -2,  0,  1,  0,  0,  0,  0,  0,  1,  2,  3,
   -6, -6, -4, -1,  2,  2,  2,  2, -6, -7, -5, -2,  0, -1, -1,  0,
    2,  2,  2,  4,  4,  3,  3,  4,  2,  1,  0, -1,  0,  0,  2,  4,
   12,  5, -5, -8, -5,  0,  2,  2,  2, -3, -6, -3,  0,  0, -1, -2,
   -2, -3, -1,  3,  4,  1, -2, -3,  2,  2,  3,  4,  3,  1, -1, -1,
    3,  2,  1,  0,  1,  4,  3,  0,  4,  3,  0, -5, -6,  0,  3,  3,
    2,  3,  1, -7,-12, -6,  1,  3,  1,  3,  4, -1, -6, -4,  0,  1,
   -9, -4,  2,  6,  7,  4,  1,  0, -7, -1,  4,  6,  4,  0, -3, -3,
   -6,  0,  4,  4,  1, -2, -3, -2, -4,  1,  3,  2,  0, -2, -1,  0,
    0,  5,  2, -5, -3,  3,  1, -4, -2,  4,  2, -6, -3,  6,  4, -3,
   -1,  5,  3, -5, -1,  7,  3, -4, -1,  2,  0, -6, -3,  5,  3, -3,
   -8, -3,  3,  5,  3,  1, -2, -2,  2,  4,  4, -2, -4, -3,  1,  3,
    2,  1, -3, -5, -3,  3,  4,  3, -5, -6, -5,  3, 10,  8, -1, -5,
    0,  3,  2, -4, -9, -7,  0,  6, -5, -1,  5,  7,  4, -1, -3, -3,
   -5, -5, -2,  3,  6,  5, -1, -4,  9,  6,  0, -4, -2,  1,  1, -1,
   -1, -1, -1,  1,  1,  0, -1,  0, -1,  0,  0,  0,  0, -1, -1,  0,
    2,  1, -2, -1,  1,  1,  0,  0, 12,  8,  2, -1, -1, -4, -7, -7,
    2,  1,  3,  6,  7,  4,  2,  0,  1,  0, -1,  0, -1, -4, -7, -8,
    0,  0, -1,  0,  0,  0, -1, -3,  0,  0,  0,  0,  1,  1,  0, -2,
   -1,  0,  1,  1,  0,  0, -1, -2,  0,  0, -1, -3, -4, -3, -1,  1,
   -1,  0,  0,  0,  1,  4, 10, 12, -1,  0, -2, -2, -3, -3, -1,  1,
   -3, -1, -2, -4,  2,  9,  9,  7, -3,  0, -1, -3,  0,  2, -1,  1,
   -1,  1, -2, -3,  0, -1, -3,  0,  0,  0, -3, -2,  0, -1, -1,  1,
   -1, -2, -1, -1, -2, -1, -1, -2,  2, -1, -2, -1,  0,  1,  0, -2,
    3, -1, -2,  2,  5,  3, -1, -3,  1, -5, -5,  1,  6,  6,  2,  0,
    1,  2,  0, -1,  0,  1,  0, -2, -5, -3, -1,  0,  1,  2,  1, -2,
   -7, -5, -2, -2, -2, -2,  0,  1, -1,  0,  1,  1,  0,  3,  9, 12,
    0,  6,  5,  1, -2, -3,  0,  3,  0,  6,  5,  1,  1,  1,  2,  3,
   -5, -2, -2, -3,  0,  0,  0,  0, -6, -3, -3, -2,  0,  0, -1, -2,
    4,  4,  2,  1,  0, -1, -1,  0, -2, -2,  0,  1,  2,  1,  1,  0,
    2,  2,  1, -1, -3, -5, -9,-10,  2,  1, -1, -1,  1,  4,  4,  1,
    4,  0, -2, -2, -2, -2, -1,  0,  7,  1, -4, -3, -2,  0,  1,  1,
   10,  5, -1, -2,  0,  1,  1,  0,  5,  1, -3, -4, -3, -1, -1, -2,
    2,  1, -1, -3, -3,  1,  1, -1, -2, -1,  3,  0, -1,  1,  1,  0,
   -3,  1,  7,  2, -3, -2, -1,  0, -2,  4,  8, -1, -8, -5,  0,  2,
   -4, -1,  1,  2,  1, -3, -4, -2, -5, -3, -2,  1,  4,  4,  4,  6,
   -3, -2, -4, -3,  0,  1,  1,  2,  2,  2,  2,  1,  2,  1, -1, -1,
   -4, -1,  0, -1, -3, -3, -1, -1,  1,  4,  4,  2,  0, -1, -2, -3,
    4,  6,  5,  3,  2,  1, -2, -4,  0,  1,  1,  1,  1, -1, -4, -6,
    1,  2,  2, -1, -6, -5, -1,  2, -3, -2,  1,  1, -4, -3,  2,  5,
   -2, -1,  2,  2, -3, -4,  0,  3, -2, -2,  2,  6,  5,  2,  1,  2,
    2, -3, -3,  0,  0,  2,  3,  1,  3, -1,  1,  3,  1,  2, -1, -5,
   -5, -7, -4, -2,  1,  8,  8,  1, -1,  0,  2,  0, -3,  0,  1, -3,
   -2, -5, -5, -2, -3, -1,  0, -2, -1, -4,  0,  4,  0,  2,  4,  0,
    0,  0,  8, 10,  2,  1,  3, -1, -4, -3,  2,  3, -3, -3,  1, -1,
    1, -2, -4,  2,  7,  3, -2, -1,  6,  4, -2, -1,  2,  0, -1,  3,
    1,  1, -2, -2, -2, -5, -3,  4, -6, -2,  1,  1, -1, -4, -2,  4,
   -2, -1, -2, -2,  0,  1,  0, -2, -1,  1,  0, -1,  0,  0, -1, -3,
    0,  1, -2, -4, -3, -1,  0,  0,  6,  8,  5,  0,  0,  1,  2,  3,
   -2, -2,  2,  5,  2,  0,  0,  1,  2, -2, -2, -1, -1,  1,  2,  4,
    2, -1,  0,  1,  0,  0,  0,  1, -8, -7, -1,  1, -1, -1,  1,  3,
    0,  3,  6,  2, -2,  1,  2,  0,-10, -7, -1,  0, -3, -1,  2,  1,
    0,  0,  2,  2,  1,  1,  1, -1,  3,  0, -2, -2,  0,  2,  1,  0,
    8,  1,  0,  0, -2, -3, -1,  0,  2, -2,  2,  5,  1, -2, -1,  1,
   -3, -6, -3, -1, -3, -3, -1,  2,  2,  0,  1,  2,  2,  1,  0,  0,
    1, -1, -1, -2, -1,  0,  1,  0, 15,  9,  2, -1, -2, -3, -3, -3,
    0, -3, -2,  0,  0, -1, -1, -1,  1,  0,  1,  0,  0, -1, -1, -1,
    0,  2,  2, -2, -3, -3, -7, -8,  0,  2,  2,  0,  1,  2,  1,  1,
    1,  2,  2,  2,  3,  1,  0,  3,  1,  0, -1, -2, -1, -2,  0,  5,
  -11, -6, -1,  1,  2,  3,  1, -3,  1,  4,  3, -1, -2,  1,  2, -1,
    2,  2,  1, -1, -2,  0,  1, -1,  0,  0, -1, -1,  0,  2,  3,  2,
    1,  1,  2,  1, -1,  1,  0, -4,  0,  0,  0, -2, -2,  2,  4, -2,
   -2, -3,  0,  0, -1,  2,  1, -6,  0,  2,  5,  5,  3,  2, -1, -7,
    4,  2,  0,  0,  3,  3,  1, -1,  0, -1, -1,  3,  6,  4,  1, -1,
   -2, -2,  0,  2,  2,  0, -2, -2, -1,  0, -1, -5, -7, -5, -1,  1,
    5, -1, -2,  0,  2,  4,  2, -5,  0, -5, -2,  2,  1,  2,  0, -6,
    6,  1,  0,  1, -2, -1,  4,  2,  2, -3, -3,  0, -1, -2,  0,  0,
    1, -1,  0,  2,  0,  0,  6, 11,  2, -1, -1,  0, -3, -2,  3,  5,
    0, -2, -1,  0, -1,  0,  0, -3,  1, -1, -1, -1, -2, -1, -3, -7,
    1,  1, -2, -2,  1,  3,  1, -2, -1,  2,  0, -1, -1,  1,  0,  0,
   -4,  2,  3, -1, -2, -2,  0,  1,-11, -2,  4,  5,  6,  2, -1, -2,
   -6, -2,  1, -1, -3, -4,  1,  9, -3,  0,  3,  3,  2, -3, -3,  3,
    1,  1,  0,  0,  1, -1, -2,  3,  2,  0, -3, -3,  0, -1, -1,  3,
    1, -1, -3,  1,  2, -6, -4,  6,  0, -2, -5, -2,  0, -3, -2,  3,
    2,  2,  1, -2, -2,  1,  2, -1, -1,  1,  1, -2, -1,  6,  7, -1,
    1,  0, -4, -2,  1, -2, -3,  1, -4,  0, -3, -2,  2,  0, -3,  0,
   -3,  4,  3,  1,  8,  7,  0, -1, -3,  4,  1, -4,  2,  3, -2, -3,
   -3,  6,  1, -4,  1,  1, -1, -1, -2,  4, -3, -3,  3,  0, -1, -1,
    1,  2, -4,  2,  4, -3, -1,  2,  3, -1, -4,  5,  4, -6, -3,  2
};

static const int8 s_svq1InterCodebook8x8[6144] = {
   -4, -3,  4,  5,  2,  1,  1,  0, -5, -3,  5,  5,  2,  1,  0,  0,
   -6, -4,  5,  5,  2,  1,  0,  0, -7, -4,  4,  5,  2,  1,  0,  0,
   -8, -5,  3,  4,  2,  1,  0,  0, -8, -6,  3,  4,  1,  1,  1,  0,
   -8, -6,  2,  4,  2,  1,  1,  0, -8, -6,  2,  4,  1,  1,  1,  1,
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2,
   -2, -3, -3, -3, -3, -3, -3, -3, -2, -3, -3, -3, -3, -3, -4, -3,
   -2, -2, -2, -2, -2, -3, -3, -2,  1,  1,  1,  1,  1,  0, -1, -1,
    4,  5,  5,  5,  4,  3,  3,  2,  7,  7,  8,  8,  8,  7,  6,  5,
    2,  1,  2,  4,  4,  0, -4, -6,  1,  1,  2,  5,  5,  1, -5, -7,
    1,  2,  1,  4,  5,  1, -5, -8,  1,  1,  1,  5,  5,  0, -6, -8,
    0,  1,  1,  5,  6,  1, -6, -9,  0,  0,  1,  4,  5,  0, -5, -8,
    0,  0,  1,  4,  5,  0, -5, -7,  0,  0,  1,  4,  4,  1, -4, -7,
    1,  2,  3,  0, -3, -4, -3, -1,  1,  3,  4,  0, -3, -4, -3, -1,
    2,  4,  5,  1, -3, -4, -3, -2,  2,  5,  6,  1, -3, -5, -4, -2,
    3,  6,  6,  1, -3, -5, -4, -2,  3,  6,  6,  1, -3, -5, -4, -2,
    3,  6,  6,  1, -3, -5, -4, -2,  3,  5,  5,  1, -3, -4, -4, -2,
    2,  2,  2,  2,  1,  0,  0, -1,  4,  4,  4,  3,  2,  1,  1,  0,
    4,  5,  4,  4,  3,  3,  2,  1,  4,  4,  4,  4,  4,  3,  2,  2,
    2,  3,  3,  3,  3,  3,  2,  1, -1, -1, -1, -1,  0,  0,  0,  0,
   -5, -6, -6, -5, -5, -4, -3, -3, -7, -9, -9, -8, -7, -6, -6, -5,
    6,  6,  6,  6,  6,  5,  5,  4,  4,  4,  4,  3,  3,  3,  3,  2,
    0, -1, -1, -1, -2, -2, -1, -1, -3, -5, -6, -6, -6, -6, -5, -4,
   -3, -5, -6, -7, -6, -6, -5, -4, -1, -2, -2, -2, -2, -2, -1, -1,
    0,  1,  1,  1,  1,  1,  1,  1,  3,  3,  3,  3,  3,  3,  3,  3,
    2,  1, -2, -5, -4,  0,  2,  5,  2,  1, -2, -6, -5,  0,  3,  5,
    2,  1, -2, -6, -6, -1,  3,  6,  3,  2, -2, -7, -6,  0,  4,  7,
    2,  1, -2, -7, -5,  0,  5,  7,  2,  1, -2, -6, -5,  0,  4,  7,
    2,  1, -2, -6, -4,  0,  4,  6,  1,  1, -2, -5, -4,  0,  3,  6,
  -10, -9, -6, -4, -1,  2,  3,  2,-10, -9, -5, -3,  0,  4,  4,  3,
   -9, -7, -3, -1,  2,  5,  5,  3, -7, -5, -2,  0,  3,  5,  5,  3,
   -6, -3,  0,  1,  4,  6,  5,  3, -4, -2,  1,  2,  3,  5,  4,  2,
   -2,  0,  1,  2,  2,  4,  3,  1, -1,  1,  2,  2,  2,  3,  3,  1,
   -4, -5, -5, -6, -6, -6, -6, -5, -3, -3, -4, -4, -4, -4, -4, -4,
    0,  0,  0,  0, -1, -1, -1, -1,  5,  5,  6,  5,  5,  4,  3,  2,
    5,  6,  7,  7,  7,  6,  5,  4,  3,  3,  4,  4,  4,  4,  3,  2,
    0, -1,  0,  0, -1, -1,  0, -1, -3, -3, -4, -4, -4, -4, -3, -3,
    1, -2, -5,  1,  5,  4,  2,  0,  1, -3, -6,  1,  6,  5,  2,  0,
    0, -4, -7,  0,  6,  6,  2,  1, -1, -5, -9, -1,  6,  6,  3,  1,
   -1, -6,-10, -2,  6,  6,  3,  1, -1, -6, -9, -2,  5,  6,  3,  1,
   -2, -6, -9, -2,  5,  5,  3,  1, -2, -6, -7, -2,  4,  4,  2,  1,
   -5, -7, -8, -9, -9, -8, -7, -6, -5, -6, -6, -7, -7, -6, -6, -5,
   -3, -3, -3, -4, -5, -5, -4, -4, -1,  0,  0, -1, -1, -1, -1, -1,
    0,  1,  2,  2,  2,  2,  2,  1,  2,  3,  4,  5,  5,  5,  5,  4,
    3,  4,  5,  6,  8,  8,  8,  7,  3,  4,  5,  6,  7,  7,  7,  6,
    5,  6,  7,  8,  9, 10, 10,  9,  3,  4,  6,  7,  8,  9,  9,  8,
    0,  1,  2,  3,  4,  5,  5,  5, -1, -2, -1, -1,  0,  1,  2,  2,
   -2, -3, -3, -3, -3, -2, -1,  0, -3, -4, -5, -5, -5, -5, -5, -4,
   -4, -5, -5, -6, -7, -7, -6, -5, -3, -4, -5, -6, -7, -7, -6, -6,
   13,  7,  0, -3, -3, -4, -4, -5, 14,  7,  0, -3, -3, -4, -4, -4,
   15,  8, -1, -4, -4, -4, -5, -4, 15,  8, -1, -4, -4, -5, -4, -3,
   15,  7, -1, -4, -5, -5, -5, -4, 14,  7, -1, -4, -4, -4, -4, -3,
   12,  6, -1, -4, -4, -4, -4, -3, 11,  5, -1, -4, -4, -4, -4, -3,
  -17, -4,  5,  4,  4,  4,  3,  3,-18, -5,  5,  4,  4,  4,  3,  3,
  -19, -5,  6,  4,  4,  4,  3,  2,-20, -5,  6,  4,  4,  4,  3,  3,
  -20, -4,  6,  4,  4,  5,  3,  3,-19, -5,  6,  4,  4,  5,  3,  3,
  -18, -4,  5,  4,  4,  4,  3,  2,-17, -5,  4,  3,  4,  4,  3,  3,
   -6, -6, -6, -4, -2,  1,  6, 11, -6, -7, -7, -4, -2,  2,  8, 13,
   -8, -8, -7, -4, -2,  3,  9, 14, -8, -8, -7, -5, -1,  4, 10, 16,
   -8, -8, -7, -5, -1,  4, 10, 17, -8, -8, -7, -4,  0,  5, 10, 16,
   -8, -8, -6, -3,  0,  4,  9, 15, -7, -7, -5, -3,  0,  4,  8, 12,
    8,  7,  7,  5,  2, -2, -8,-14,  8,  8,  7,  5,  2, -2, -8,-15,
    8,  8,  7,  5,  1, -3, -9,-16,  8,  8,  7,  5,  1, -3,-10,-17,
    8,  9,  8,  5,  1, -3,-10,-17,  8,  8,  7,  4,  1, -4,-10,-16,
    7,  7,  7,  4,  1, -3, -9,-14,  6,  7,  6,  3,  0, -3, -9,-13,
    5,  1, -4, -4, -3, -1,  0,  0,  7,  2, -3, -3, -2, -1,  1,  0,
    7,  1, -3, -3, -1,  0,  1,  1,  6,  1, -3, -2, -1,  1,  1,  0,
    6,  0, -4, -2, -1,  0,  1,  0,  5,  0, -4, -3, -1,  0,  0, -1,
    5,  0, -3, -1,  0,  0,  0, -2,  4,  1, -2, -1,  0,  1,  0, -1,
    2,  2,  1,  1, -2, -6, -8, -8,  1,  1,  1,  1, -2, -5, -8, -8,
    1,  1,  1,  0, -1, -3, -5, -5,  0,  0,  0,  0, -1, -1, -1, -2,
    0, -1,  0,  0,  0,  0,  1,  0,  1,  0,  0,  0,  1,  2,  3,  2,
    2,  1,  1,  1,  2,  3,  4,  3,  3,  3,  3,  3,  4,  4,  5,  4,
   -4, -4, -3, -2,  0,  0,  1,  1, -4, -4, -3, -2, -1,  0,  0,  1,
   -2, -2, -2, -1, -1, -1,  0,  0,  0,  1,  0,  0,  0,  0,  0, -1,
    2,  2,  2,  2,  2,  2,  1,  1,  3,  4,  4,  4,  4,  4,  4,  3,
    1,  1,  1,  3,  3,  4,  3,  3, -5, -6, -5, -4, -3, -3, -2, -2,
   -4, -2, -1, -1, -1, -1,  0,  1, -4, -2, -1, -1, -1, -1,  0,  1,
   -3, -2, -1, -1, -1,  0,  1,  2, -4, -3, -2, -1, -1,  1,  3,  3,
   -4, -3, -3, -1, -1,  1,  4,  5, -4, -3, -2, -2, -1,  1,  4,  7,
   -2, -2, -1, -1,  0,  2,  6,  8, -1,  0,  0,  1,  1,  4,  7,  8,
   -3, -3, -3, -2, -2, -1, -1,  0, -1, -1,  0,  1,  2,  2,  3,  3,
    0,  1,  2,  4,  5,  6,  6,  5, -1,  0,  2,  3,  5,  6,  5,  3,
   -1, -1,  0,  2,  3,  3,  2,  1, -2, -2, -1,  0, -1, -3, -4, -4,
    0,  0, -1, -1, -2, -4, -8, -7,  1,  2,  1,  0, -1, -4, -6, -7,
   -2,  4,  1, -6,  0,  3,  0,  0, -2,  5,  1, -7,  0,  3,  0,  0,
   -3,  5,  1, -8,  0,  3, -1, -1, -2,  6,  1, -9,  0,  3,  0, -1,
   -2,  6,  2, -8,  0,  4,  0, -1, -3,  5,  1, -7,  1,  4,  0,  0,
   -2,  4,  1, -7,  0,  4,  1,  0, -1,  4,  1, -6,  0,  3,  1,  0,
    0,  0,  0,  3,  4,  5,  4,  1,  1,  1,  1,  2,  3,  3,  2,  0,
    2,  2,  1,  2,  2,  1, -1, -2,  4,  3,  1,  1,  0, -1, -3, -5,
    5,  3,  1, -1, -2, -3, -4, -6,  5,  3,  0, -2, -3, -5, -6, -7,
    4,  3,  0, -2, -3, -4, -5, -5,  4,  3,  0, -1, -2, -2, -3, -3,
    0,  0,  0,  0, -1, -5, -2,  6,  0,  0,  0,  1, -1, -6, -2,  8,
    0,  0,  0,  2,  0, -6, -3,  9,  0, -1,  0,  2,  0, -7, -2, 10,
    0, -1,  0,  2, -1, -8, -3, 10,  0, -1, -1,  2, -1, -7, -3,  9,
    0, -1,  0,  1, -1, -6, -3,  8,  0,  0,  0,  1,  0, -5, -2,  7,
    2,  3,  3,  2,  1,  0, -1, -1,  3,  4,  3,  2,  1,  0, -1, -2,
    3,  4,  4,  2,  1, -1, -2, -3,  2,  3,  3,  2,  0, -1, -2, -3,
   -1,  0,  1,  1,  0, -1, -2, -2, -5, -4, -3, -1,  0,  1,  1,  1,
   -8, -8, -5, -1,  1,  3,  4,  3,-10, -9, -5,  0,  3,  5,  6,  5,
   -5, -1,  4,  5,  3,  1,  0,  0, -6, -1,  4,  5,  2,  0, -1, -2,
   -6, -1,  5,  4,  2, -1, -2, -2, -7, -1,  4,  4,  1, -2, -3, -3,
   -6, -1,  5,  4,  1, -2, -3, -3, -5,  0,  4,  4,  1, -1, -2, -2,
   -4,  0,  5,  4,  1, -1, -1, -2, -3,  1,  4,  3,  1, -1, -1, -2,
   -2, -3, -2,  1,  4,  6,  5,  3, -3, -4, -4,  0,  3,  5,  4,  2,
   -3, -5, -5, -1,  2,  4,  3,  1, -4, -6, -4, -1,  2,  4,  2, -1,
   -2, -4, -3,  1,  2,  4,  2, -1, -2, -4, -2,  1,  3,  3,  1, -2,
   -2, -3, -2,  1,  3,  3,  1, -2, -2, -2, -1,  1,  3,  3,  0, -2,
   -4, -4, -3, -2, -1,  2,  5,  7, -4, -4, -3, -3, -2,  1,  5,  7,
   -2, -3, -2, -3, -3, -1,  3,  5, -1, -1,  0, -2, -3, -2,  2,  4,
    1,  1,  1, -1, -4, -3,  1,  3,  4,  3,  2, -1, -4, -3, -1,  1,
    6,  4,  3,  0, -3, -3, -2,  0,  6,  5,  3,  1, -2, -3, -2, -1,
   12, 11,  8,  4,  0, -2, -2, -1, 10,  9,  6,  2, -1, -2, -1,  0,
    4,  3,  2,  0, -1, -1,  0,  1, -1, -1, -1, -1, -2,  0,  1,  2,
   -3, -5, -4, -2, -2,  0,  2,  3, -5, -5, -4, -2, -1,  0,  1,  2,
   -5, -5, -4, -2, -1,  0,  1,  1, -4, -4, -3, -2, -2, -1,  0,  0,
    3,  3,  2, -1, -3, -4, -3, -2,  3,  2,  0, -2, -4, -4, -3, -2,
    2,  2,  1, -1, -3, -5, -4, -3,  3,  3,  3,  1, -2, -3, -3, -3,
    4,  4,  4,  3,  0, -2, -2, -2,  5,  5,  5,  3,  0, -1, -2, -2,
    5,  5,  4,  2, -1, -2, -3, -2,  3,  3,  3,  0, -2, -4, -4, -4,
   -1, -1,  4, -2, -2,  6,  2, -5, -1,  0,  4, -2, -3,  6,  2, -6,
   -1,  0,  4, -2, -3,  7,  3, -7, -1, -1,  4, -3, -4,  8,  3, -7,
    0, -1,  4, -3, -4,  7,  3, -6, -1, -1,  4, -3, -4,  7,  3, -6,
   -1, -1,  3, -3, -4,  6,  3, -6, -1,  0,  3, -2, -3,  6,  3, -5,
    1, -2, -7,  2,  5, -2, -1,  1,  1, -2, -8,  3,  6, -3, -1,  2,
    2, -2, -9,  4,  7, -4, -2,  2,  3, -1, -9,  5,  7, -4, -1,  3,
    3, -1, -9,  4,  7, -4, -2,  2,  3, -1, -7,  4,  6, -4, -2,  1,
    2,  0, -6,  4,  6, -4, -1,  1,  2,  0, -5,  3,  4, -3, -1,  1,
   -2,  2,  2,  0,  0, -1, -3, -4, -2,  2,  2,  1,  1,  0, -2, -4,
   -2,  2,  2,  2,  2,  1, -1, -2, -3,  2,  3,  3,  4,  2,  0, -2,
   -3,  2,  3,  2,  4,  2,  0, -3, -4,  1,  2,  1,  2,  1, -1, -3,
   -5,  0,  1,  0,  1,  1, -2, -3, -4,  0,  0,  0,  1,  0, -2, -3,
    0,  0, -1, -2, -2,  2,  7,  8,  0,  0, -1, -3, -2,  1,  6,  7,
    0,  1, -1, -3, -3,  0,  4,  5,  0,  1,  0, -1, -1,  0,  1,  3,
    0,  2,  1,  1,  0, -1,  0,  1, -2,  0,  1,  2,  1,  0, -1, -1,
   -5, -2,  0,  1,  1,  0, -3, -3, -6, -4, -1,  1,  1, -1, -3, -4,
   -4, -2,  2,  5,  6,  4,  3,  2, -5, -3,  1,  4,  4,  2,  0,  0,
   -4, -2,  0,  2,  1, -1, -2, -2, -2, -1,  0,  1,  0, -2, -3, -2,
   -2,  0,  0,  0, -1, -1, -2, -1, -2, -1, -1,  0,  0,  0,  1,  2,
   -2, -2, -1, -1,  0,  1,  3,  4, -2, -3, -2, -1,  0,  2,  4,  5,
    2,  1, -2, -2, -1,  0,  1,  0,  1,  0, -3, -3, -1,  0,  1,  0,
    0, -1, -3, -3, -1,  1,  1,  1,  0,  0, -3, -1,  1,  2,  3,  3,
    0, -1, -3, -1,  1,  3,  3,  3, -2, -2, -4, -2,  1,  3,  4,  4,
   -3, -3, -4, -2,  1,  3,  3,  4, -2, -3, -5, -2,  1,  2,  3,  3,
    4,  5,  3,  4,  4,  4,  4,  5,  3,  3,  1,  0,  0,  0,  0,  1,
    1,  1, -1, -2, -3, -4, -3, -2,  2,  2,  0, -2, -2, -4, -3, -2,
    2,  3,  1, -1, -1, -3, -3, -2,  1,  2,  0,  0, -1, -2, -2, -1,
    0,  1,  0, -1, -1, -3, -2, -1,  1,  1,  0, -1, -1, -2, -2, -2,
   -2, -1, -1,  0,  1,  2,  1,  0,  1,  2,  3,  5,  6,  5,  5,  3,
    1,  2,  3,  4,  5,  5,  4,  3, -2, -2, -3, -3, -2, -1,  0,  0,
   -3, -3, -4, -5, -4, -3, -2, -1, -1, -1, -2, -2, -2, -1,  0,  0,
    0,  1,  0, -1, -1,  0,  0,  1, -1,  0, -1, -2, -3, -2, -2, -1,
    7,  7,  6,  5,  4,  2, -1, -2,  3,  3,  2,  2,  1,  0, -2, -3,
    0, -1, -1, -1,  0, -1, -2, -2, -1, -3, -2, -1,  0,  0,  0,  1,
    0, -2, -2, -1, -1,  1,  2,  2,  3,  1, -1, -1, -1,  1,  2,  2,
    3,  1, -2, -3, -2, -1,  1,  2,  1, -2, -5, -6, -5, -3, -2,  0,
    0, -1, -2, -3, -1,  0, -2, -2,  0,  0, -1, -1,  0,  1, -1, -2,
    0,  0, -2, -1,  0,  0,  0, -2, -1, -2, -3, -3, -2, -1, -3, -3,
   -1, -2, -3, -3, -2, -2, -3, -4,  2,  2,  0,  0,  0,  0, -1, -2,
    5,  5,  3,  2,  2,  2,  0, -1,  8,  8,  6,  5,  4,  4,  2,  1,
   -7, -8, -6, -3, -1, -1, -2, -1, -5, -5, -3,  0,  2,  1,  0,  0,
   -1, -1,  0,  3,  4,  3,  1,  1,  2,  1,  1,  3,  4,  3,  2,  2,
    3,  2,  0,  2,  3,  2,  1,  2,  4,  2, -1, -1,  0,  1,  1,  1,
    3,  2, -2, -3, -2, -1,  0,  1,  3,  1, -3, -4, -3, -2,  0,  1,
   -4, -2, -1,  2,  3,  3,  1,  0, -7, -5, -4, -2,  0,  0, -1, -2,
   -6, -5, -5, -4, -2, -2, -2, -3, -1,  0, -1, -1,  0,  0,  0, -1,
    2,  3,  2,  2,  2,  2,  1,  0,  3,  5,  4,  3,  1,  0,  1,  0,
    3,  4,  3,  2,  0, -1, -1, -1,  5,  5,  3,  1,  0, -1, -1, -1,
    1,  1,  0, -1, -3, -5, -6, -4,  1,  1,  0,  0,  0, -3, -3, -1,
    0, -1, -1,  0,  1,  0,  1,  3, -2, -2, -3, -1,  2,  2,  4,  7,
   -2, -2, -2,  0,  2,  2,  3,  6, -1,  0,  0,  1,  1,  0,  0,  3,
    0,  3,  3,  3,  1, -2, -3, -1,  1,  3,  4,  3,  0, -3, -5, -4,
    0,  2,  0, -1, -3, -4, -2, -2,  1,  4,  2,  0, -2, -3, -2, -1,
    3,  6,  3,  1, -2, -2,  0, -1,  4,  7,  4,  1, -2, -3, -1,  0,
    3,  6,  3,  0, -3, -3, -1,  0,  1,  3,  0, -1, -3, -2,  1,  1,
    0,  1, -1, -2, -3, -1,  2,  2, -2, -1, -3, -3, -3, -1,  1,  2,
    3,  1, -1,  0,  1,  0,  0,  0,  2, -1, -2, -1,  1,  0, -1, -1,
    1, -1, -2,  0,  1,  0, -2, -3,  0, -2, -1,  1,  3,  1, -3, -5,
    0, -2, -1,  2,  5,  2, -3, -5,  0, -2, -1,  4,  6,  3, -2, -5,
    0, -2,  0,  4,  7,  4, -2, -4,  0, -2,  0,  4,  6,  4, -2, -4,
   -2, -2, -3, -4, -3, -2, -1,  0,  1,  1,  0, -1, -1, -1,  0,  1,
    3,  3,  2,  2,  1,  1,  1,  1,  2,  2,  2,  2,  1,  0,  0,  1,
    0,  0,  0,  0, -1, -1, -1, -1, -4, -4, -4, -4, -4, -4, -4, -3,
   -3, -3, -2, -3, -2, -1, -1,  0,  3,  4,  4,  5,  5,  6,  6,  7,
   -1, -2,  7, -2, -4, -1, -1,  0, -1, -2,  9, -1, -4, -1, -1,  0,
   -1, -3, 10, -1, -4, -1, -1,  1, -1, -3, 10, -2, -3, -1, -1,  2,
   -1, -2, 10, -2, -4, -1, -1,  2, -1, -2,  9, -2, -4, -1, -1,  2,
   -1, -2,  8, -2, -4,  0, -1,  1,  0, -2,  7, -2, -3, -1,  0,  2,
    3, -4,  1,  3, -3, -2,  1,  0,  3, -5,  1,  4, -3, -2,  1,  0,
    3, -6,  2,  5, -3, -1,  3,  0,  3, -6,  2,  5, -3, -1,  2,  0,
    3, -6,  1,  5, -4, -2,  3,  0,  3, -6,  1,  5, -3, -2,  2,  0,
    2, -6,  1,  4, -3, -1,  1,  0,  2, -6,  1,  4, -2, -1,  1,  0,
    0,  0,  1,  1,  1,  0,  0,  2,  0, -1,  1,  1,  1,  0,  0,  2,
    0, -1,  0,  0,  0,  0,  0,  2,  0, -1,  0,  0,  0,  0, -1,  0,
    1,  0,  1,  0,  0, -1, -2, -1,  3,  1,  1,  0,  0, -2, -4, -3,
    5,  3,  2,  1,  0, -3, -5, -4,  5,  4,  2,  0, -1, -4, -5, -5,
    1,  0, -1, -2, -2, -3, -6, -9,  2,  0, -1, -1,  0,  0, -3, -6,
    1,  0,  0, -1,  0,  0, -2, -5,  2,  1,  1,  1,  1,  2, -1, -3,
    1,  1,  2,  1,  2,  2,  1, -1,  1,  1,  2,  1,  1,  1,  1,  1,
    0,  0,  2,  1,  0,  0,  2,  2,  0,  1,  2,  2,  0,  0,  2,  2,
   -4, -3,  0,  1,  4,  6,  4,  3, -3, -2,  0,  0,  2,  4,  1,  0,
   -1, -1,  0,  0,  1,  1, -2, -3,  1,  1,  1,  0,  1,  1, -3, -5,
    1,  1,  1,  0,  1,  1, -3, -5, -1,  0,  0, -1,  1,  1, -2, -4,
   -1,  0,  0, -1,  1,  2,  0, -2, -1,  0,  0,  0,  2,  3,  1,  0,
   -1,  0,  3,  4,  0, -4, -5, -5,  0,  0,  4,  5,  2, -2, -3, -2,
    0, -1,  2,  4,  2, -1, -1,  0,  0, -2, -1,  1,  0, -2,  0,  1,
    1, -2, -2,  0,  0, -1, -1,  1,  1, -2, -3,  0,  1,  0, -1,  0,
    1, -2, -2,  1,  3,  1,  0,  0,  1, -2, -1,  2,  4,  2,  0,  0,
    1,  2,  3,  2,  0,  2,  2,  1, -1,  0,  1,  0, -3,  1,  1,  1,
   -1,  0,  0, -2, -4,  0,  2,  1, -1,  2,  2, -1, -5,  0,  2,  1,
   -1,  3,  4, -1, -5,  0,  2,  1, -2,  2,  4,  0, -4, -1,  0,  0,
   -4,  0,  2,  0, -4, -2,  0,  0, -5, -1,  2,  1, -2,  1,  3,  2,
    1,  0,  1,  0,  1,  2, -1, -2,  2,  0, -1, -2,  1,  3,  0, -1,
    3,  0, -2, -4,  0,  3,  1,  0,  5,  1, -3, -5, -2,  2,  1,  1,
    6,  1, -2, -5, -2,  1,  0,  1,  5,  1, -1, -5, -2,  0, -1,  0,
    3,  0, -2, -4, -2,  0, -1,  0,  1, -1,  0, -2,  0,  1,  0,  1,
    1,  1,  2,  3,  2,  1,  1,  2, -1, -1,  0,  1,  1,  0,  1,  1,
   -4, -3,  0,  0,  1,  1,  1,  2, -4, -3,  0,  2,  2,  2,  3,  2,
   -5, -4,  0,  1,  1,  1,  1,  2, -5, -4, -1, -1, -2, -2, -1,  0,
   -3, -2,  0,  0, -2, -3, -2, -1,  2,  3,  4,  4,  2,  0,  0,  0,
   -4, -2,  0,  1,  0,  0,  0,  0, -3, -1,  1,  1,  0,  0,  0,  0,
   -2,  0,  2,  2,  0,  0,  0,  2, -1,  1,  2,  1, -1,  0,  3,  5,
    0,  2,  1, -1, -2,  0,  5,  6,  0,  1,  0, -3, -3,  0,  4,  6,
    1,  1, -2, -4, -4, -3,  1,  2,  1,  0, -2, -4, -5, -4, -2,  0,
   -1, -3, -3, -3, -3, -2, -1, -1,  3,  2,  1,  0,  0,  1,  1,  1,
    5,  4,  3,  2,  1,  1,  2,  2,  2,  1,  0, -2, -2, -2, -1, -1,
    0,  0,  0, -1, -2, -2, -2, -2,  0,  1,  3,  3,  2,  1, -1, -1,
    0,  1,  3,  4,  3,  2,  1, -1, -4, -3, -1,  1,  0, -2, -3, -3,
   -3, -4, -7, -8, -7, -4, -1,  2,  0, -1, -3, -4, -4, -2,  0,  2,
    1,  0,  0, -1, -3, -2,  0,  2,  2,  1,  1,  0, -1, -1,  0,  2,
    1,  1,  1,  1,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  1,
    0,  0,  1,  2,  3,  3,  2,  2,  0,  0,  1,  3,  4,  4,  3,  2,
    3,  3,  3,  0, -1,  0,  1,  2,  1,  1,  1, -1, -2, -1, -1,  1,
   -2, -2, -1, -3, -3, -2, -2,  0, -4, -4, -2, -2, -2, -2, -3,  0,
   -4, -4, -1,  1,  1,  0, -1,  2, -3, -1,  2,  3,  4,  3,  3,  5,
   -2,  0,  2,  3,  3,  3,  3,  3, -2, -2,  0,  0,  0,  0,  0,  1,
    0,  2,  1, -1, -3, -1,  3, -2, -1,  0, -1, -1, -3,  0,  4, -2,
   -2, -2, -2, -2, -2,  1,  5, -2, -3, -2, -3, -1, -2,  1,  4, -3,
   -2,  0, -1,  0, -1,  0,  3, -5,  1,  2,  1,  2,  0,  0,  2, -5,
    2,  4,  2,  3,  1,  1,  3, -3,  1,  2,  1,  1,  0,  1,  4, -2,
    4, -3, -4, -1,  3,  3,  1,  3,  4, -4, -4, -1,  3,  2,  0,  2,
    4, -3, -4,  0,  2,  2, -1,  1,  4, -3, -2,  1,  2,  1, -2,  0,
    2, -4, -2,  1,  2,  0, -3,  0,  2, -3, -2,  0,  1,  0, -2,  2,
    3, -1, -1,  0,  0,  0,  0,  3,  2, -2, -2, -2, -1, -1, -1,  2,
    2,  2,  3,  4,  3,  1,  0, -1,  1,  0,  1,  2,  1, -1, -2, -2,
    2,  1,  2,  1,  1,  0, -1, -1,  4,  3,  4,  3,  2,  1,  1,  1,
    3,  2,  2,  2,  1,  1,  1,  1, -1, -2, -1,  0, -1, -1, -1, -1,
   -3, -3, -2, -1, -2, -2, -2, -2, -4, -4, -3, -3, -4, -4, -3, -3,
    2,  1, -1, -3, -4, -2,  3,  4,  2,  2,  1, -1, -3, -2,  1,  2,
    1,  2,  3,  3,  0, -2, -1, -2, -1,  0,  2,  4,  2,  0, -1, -3,
   -2, -2,  0,  3,  3,  2,  0, -3,  0, -2, -3, -1,  1,  2,  2, -1,
    3, -1, -4, -5, -3,  0,  2,  0,  6,  3, -2, -6, -5,  0,  3,  1,
   -2,  3, -2,  0,  3, -2, -2,  1, -3,  4, -3,  0,  3, -2, -1,  2,
   -3,  5, -3,  0,  4, -2, -1,  2, -2,  4, -4, -1,  3, -3, -2,  2,
   -3,  4, -3,  0,  3, -3, -1,  2, -2,  5, -2,  0,  3, -3, -1,  2,
   -2,  4, -3,  1,  3, -2, -1,  2, -2,  3, -2,  1,  3, -2,  0,  2,
    1,  0,  0, -1,  1,  2, -4, -1,  2,  0,  0, -1,  1,  2, -4, -2,
    1,  1,  1, -1,  2,  4, -2,  0,  0, -1,  1, -1,  2,  5, -1,  1,
    0, -1,  0, -2,  1,  5, -1,  1,  0, -1, -1, -2,  0,  3, -3, -1,
    1,  1,  0, -2,  0,  3, -3, -1,  1,  1,  0, -3,  0,  3, -2,  0,
    1,  0, -1,  1,  1,  2,  4,  5,  1,  0, -1,  1,  1,  1,  5,  7,
    0,  0, -2, -1, -1,  0,  3,  5,  0, -1, -2, -1, -1, -1,  2,  3,
    0, -1, -3, -1, -1, -1,  1,  2, -1, -2, -4, -2, -2, -2,  0,  0,
   -1, -2, -2, -1, -2, -2,  0,  0,  0, -1, -1,  0, -1, -1,  0,  0,
    3,  3,  0, -1, -1,  1,  4,  4,  2,  3,  0, -2, -2,  0,  1,  1,
    2,  3,  1, -1, -1,  0,  1,  0,  1,  2,  0, -1, -1, -1,  0, -2,
    0,  1,  0, -1, -2, -1,  0, -2,  0,  1,  0, -1, -2, -1,  1,  0,
    1,  1, -1, -3, -4, -3,  1,  3,  1,  2, -1, -3, -5, -4,  1,  3,
   -3, -2,  0,  1,  1,  1,  0, -2,  0,  1,  1,  1,  0,  0, -1, -3,
    1,  2,  1,  1,  0, -1, -1, -2,  0, -1, -3, -1, -1, -1,  0, -1,
    0, -3, -6, -3, -2, -1,  1,  1,  2, -1, -4, -3, -2,  0,  2,  2,
    5,  4,  1,  1,  0,  1,  3,  2,  5,  4,  2,  1,  0, -1,  0,  1,
   -2,  0, -2, -5, -6, -3,  0,  0, -2,  0,  1,  0, -1,  1,  2,  2,
   -2,  0,  1,  3,  2,  2,  2,  1, -2,  0,  2,  4,  3,  2,  1,  1,
   -2,  0,  2,  3,  2,  0, -1,  0, -3, -1,  1,  1,  0, -1, -1,  1,
   -4, -1,  1,  0, -1, -2,  0,  2, -4, -1,  0, -1, -1, -2,  1,  4,
   -3,  0,  0, -1,  1,  1,  1,  0, -3,  1,  0, -1,  0,  0, -1, -1,
   -1,  3,  3,  0,  1,  0,  0,  1, -3,  2,  2, -2, -1,  0,  0,  1,
   -5,  0,  0, -2, -1,  1,  0,  2, -7, -2,  1,  0,  1,  2,  2,  2,
   -5,  0,  3,  2,  3,  3,  2,  2, -3,  2,  4,  1,  0,  0, -2, -3,
    5,  2, -2, -2,  0, -1, -1, -1,  2, -1, -4, -3, -1, -2, -1, -1,
    0, -2, -2,  1,  2, -1,  0,  1, -1, -2, -1,  3,  3, -1,  0,  2,
    1,  0,  0,  3,  3, -2, -1,  2,  2,  1,  1,  3,  2, -2, -2,  0,
    1,  0, -1,  1,  1, -3, -3, -2,  1,  0,  1,  2,  3,  0,  0,  0,
   -4, -5, -3,  0,  1, -1, -2, -1, -2, -3, -1,  1,  2,  0,  0,  0,
    1,  1,  2,  1,  2,  1,  1,  1,  3,  4,  3,  1,  0, -2, -1, -1,
    3,  3,  2,  0, -2, -3, -3, -2,  1,  1,  0, -1, -2, -4, -2, -2,
    2,  1,  0,  0,  0, -1,  0,  1,  2,  1,  1,  1,  1,  1,  1,  3,
    0,  0,  0, -1, -2, -1,  1,  0, -2, -1, -1, -2, -3, -2,  0,  0,
   -1,  0,  0, -1, -2,  0,  1,  1,  1,  1,  0, -1, -1,  1,  3,  1,
    2,  2,  0, -2, -1,  2,  3,  0,  3,  1, -1, -1,  1,  4,  2, -2,
    2,  0, -3, -1,  3,  5,  0, -5,  1, -1, -2,  0,  3,  3, -1, -6,
   -1,  0,  3,  4,  2,  0,  1,  2, -2, -1,  0,  1, -1, -2,  0,  1,
   -2, -3, -2, -3, -6, -7, -6, -3,  2,  2,  3,  1, -1, -2, -3, -2,
    2,  2,  3,  1,  0,  0,  0,  0,  2,  1,  1,  0,  1,  1,  0,  1,
    1,  0,  0,  0,  0,  1,  1,  2,  1,  0, -1,  0,  0,  2,  2,  1,
    1,  1,  3,  1, -1, -1, -1,  1, -2, -1,  0,  0, -2, -2, -1,  2,
   -2, -2,  1,  1,  1,  0,  1,  3, -2, -2,  0, -1,  0, -1,  0,  2,
    0,  0,  1,  0, -1, -1, -2,  1,  3,  2,  2,  1,  0, -2, -2,  1,
    5,  3,  3,  2,  1,  1,  1,  4,  0, -3, -4, -5, -4, -3, -1,  1,
   -6, -4, -1,  2,  2,  0,  0, -1, -4, -2,  1,  3,  3,  2,  2,  0,
   -3, -2, -1,  2,  3,  3,  2,  0, -3, -2, -2,  1,  2,  1,  1, -1,
   -2, -2, -2,  0,  2,  2,  1, -1, -1, -1, -1,  1,  2,  3,  2,  0,
   -1, -1, -2,  1,  2,  2,  2, -1,  0, -1, -2,  0,  2,  1,  0, -1,
    6,  4,  2,  1,  0,  0,  0,  1,  4,  2, -1, -2, -2, -2, -1, -1,
    2,  1, -1, -2, -2, -2, -2, -1,  2,  2,  0, -2, -2, -2, -1,  0,
    0,  0, -1, -2, -2, -1,  0,  1, -3, -3, -2, -1, -1, -2, -1,  0,
   -3, -2,  2,  3,  2,  0, -1, -2, -2,  0,  4,  5,  5,  2,  0, -1,
    5,  4,  2,  0, -1, -2, -1, -1,  4,  3,  2,  1,  0, -1,  0, -1,
    1,  1,  0,  1,  1,  0,  1, -1, -2, -1, -1,  0,  0, -2, -2, -3,
   -1,  0,  0,  0, -1, -3, -3, -5,  0,  1,  1, -1, -1, -2, -2, -3,
   -1, -1, -1, -2, -1,  1,  3,  1, -1, -2, -2, -1,  2,  5,  6,  5,
   -3, -3, -2,  1,  1, -2, -1, -1,  1,  2,  3,  4,  1, -3, -1, -3,
    3,  2,  0,  1, -1, -3, -1, -3,  1,  0, -1,  0, -1, -1,  1,  0,
    1,  1,  0,  1,  2,  2,  5,  3,  1,  1,  1,  2,  2,  2,  3,  0,
   -3, -1, -2, -2, -3, -3, -1, -3, -1,  1,  1,  0, -1, -1,  0, -2,
    2,  0, -2, -2,  2,  4,  1, -2,  1,  0, -2, -1,  3,  5,  2, -1,
   -1, -2, -3, -2,  1,  3,  1, -2, -1, -2, -1, -1,  0,  2,  1, -1,
    0,  0,  1,  1,  1,  2,  2,  0,  0,  1,  4,  4,  2,  2,  3,  1,
   -2, -1,  2,  1, -2, -3, -2, -3, -1,  0,  1,  0, -3, -4, -4, -5,
    4,  0, -3, -4, -4, -4, -2, -1,  5,  0, -1,  0, -1, -3, -2, -1,
    4,  0,  0,  1,  1,  0,  0,  0,  0, -3, -2, -1,  0,  0,  1,  0,
    0, -2,  0,  0,  1,  1,  2,  1,  2,  0,  0,  0,  1,  1,  1,  0,
    2,  0, -1, -1,  1,  1,  1,  0,  1, -1, -2, -2,  0,  2,  2,  2,
   -3, -5, -2,  0, -1, -3, -3,  0,  0, -2,  0,  2,  2,  0,  0,  3,
    2, -1, -2,  0,  0, -1, -1,  2,  5,  2, -1, -1, -1, -1, -1,  2,
    5,  2,  0, -1, -1,  0, -1,  2,  2,  1,  0,  0,  0,  1,  0,  2,
   -1, -1,  1,  1,  2,  2,  1,  2, -3, -2,  0,  0,  0,  0, -2, -1,
    0,  3,  2,  0, -2, -3, -3, -3,  0,  3,  3,  1,  0,  0,  1,  2,
   -1,  0, -1, -2, -1, -1,  1,  3, -1,  0, -1, -2, -1, -1,  0,  2,
   -1,  0, -1, -2,  0,  0, -1,  2, -1,  0, -1, -2, -1, -1, -2,  1,
    0,  1,  0, -3, -1, -1, -1,  2,  5,  5,  2, -1, -1, -1,  1,  3,
    0,  0,  1, -1, -3, -2,  0,  2,  1,  1,  3,  0, -2, -2,  0,  1,
    1,  1,  3,  1,  0,  0, -1, -1,  0, -1,  2,  1,  1,  0, -1, -3,
   -1, -2,  1,  1,  1,  0, -2, -4, -1,  0,  2,  1,  1,  0, -1, -3,
    1,  1,  3,  2,  1,  0, -2, -3,  2,  2,  4,  2,  1, -1, -2, -4,
    1,  2,  2,  2,  0, -2,  0,  2, -1, -1, -2, -3, -4, -5, -3,  1,
    0,  1,  1,  0, -1, -1, -1,  1,  0,  1,  1,  1,  0,  0,  0,  2,
    0,  1,  1,  2,  1,  1,  1,  2, -1, -1,  0,  2,  2,  2,  2,  3,
   -2, -4, -4, -1, -2, -2, -2,  0,  1,  0,  0,  1,  0,  0,  0,  1,
    0, -1, -3, -2,  0,  2,  2,  1,  0, -1, -2, -3,  0,  1,  1,  2,
    1,  0, -2, -3, -1,  0,  0,  1, -1,  0, -1, -2,  0,  0, -1,  0,
   -1,  1,  1,  0,  2,  2,  0,  0,  0,  2,  3,  1,  3,  5,  3,  2,
   -1,  1,  1, -2,  0,  3,  1,  1, -1,  0,  0, -4, -4, -1, -1, -1,
   -1,  1,  1,  0,  1,  2,  1,  2, -3,  0,  1,  0,  1,  1,  0,  2,
   -5, -3, -1, -1,  0,  1,  0,  1, -4, -3, -2, -3, -2, -1, -1,  0,
    0,  0, -1, -2, -2, -2, -2,  0,  3,  4,  2,  0,  0,  0,  0,  1,
    2,  1,  0,  0,  0,  0, -1,  0,  0,  1,  2,  3,  4,  4,  3,  2,
   -1,  4,  7,  4,  0,  0,  0,  0, -1,  4,  6,  3,  0,  1,  1,  1,
    0,  3,  4,  0, -1,  0,  0,  1,  0,  1,  1, -2, -1,  0, -1, -1,
   -1,  0, -1, -1, -1,  0,  0,  0, -1, -1, -1,  0,  0,  0,  0,  0,
   -1, -3, -3,  0,  1, -1, -2, -1, -3, -4, -4, -2, -1, -2, -2, -1,
    2,  2,  1,  0,  1,  1,  0, -3, -2, -1,  0,  0,  1,  1,  0, -3,
   -2, -1,  0,  1,  2,  1,  1, -2,  1,  2,  2,  2,  3,  3,  2, -1,
    1,  2,  1,  0,  1,  1,  2, -1,  0,  1, -2, -4, -2,  0,  1, -1,
    1,  1, -1, -3, -2,  0, -1, -3,  1,  2,  0, -1,  0,  1, -1, -4,
   -1, -1, -2, -2,  0,  3,  4,  3,  1,  1, -1, -3, -2,  0,  0,  0,
    2,  2,  2,  2,  2,  1, -1, -1,  1,  1,  1,  3,  3,  0, -2, -2,
    0, -1, -1, -1,  0, -2, -1, -1, -1, -3, -4, -3, -2, -2,  0,  2,
   -1, -1,  0,  1,  2,  2,  3,  5, -2, -1, -1,  0,  0,  0,  0,  1,
   -2, -3,  2,  0,  0,  1,  1, -1, -1, -4,  1, -2, -1,  2,  2,  0,
    1, -4,  0, -2, -2,  1,  1, -1,  2, -3,  1, -1, -1,  1,  1, -1,
    3, -2,  3,  1,  0,  1,  1, -1,  1, -3,  2,  1,  0,  1,  0, -1,
   -1, -5,  1,  0, -1,  0,  1,  1,  0, -3,  3,  3,  1,  2,  3,  3,
    0, -1, -2,  1,  5,  5,  2, -1,  1, -1, -2, -1,  1,  1, -2, -5,
    1,  1, -1, -2, -1, -1, -1, -3,  1,  1, -1, -1, -1,  2,  4,  3,
   -1, -1, -1, -1, -1,  0,  4,  3, -1, -1,  0,  1, -1, -3, -1, -1,
    0,  0,  0,  2,  2,  0,  0, -1,  0, -2, -3,  0,  1,  1,  3,  2,
    2,  3,  2,  1,  0,  0, -2, -2,  2,  3,  0,  1,  1,  3,  3,  2,
    0,  0, -3, -1, -1,  2,  2,  3, -2, -2, -3,  1,  1,  2,  1,  1,
   -2, -1, -2,  2,  1,  1, -1, -2,  0,  1,  0,  2,  0,  0, -2, -2,
    0,  1,  0,  2,  0,  0, -2, -2, -3, -2, -2,  0, -1, -2, -2, -3,
    0,  1, -1,  3, -1,  1,  3, -1,  0,  1, -1,  3, -1, -1,  2, -3,
    1,  1, -2,  3, -1, -3,  0, -3,  2,  2, -2,  3,  0, -2,  1, -2,
    1,  1, -3,  3, -1, -2,  1, -3,  1,  1, -3,  3,  0, -1,  1, -2,
    1,  2, -1,  4,  0, -1,  1, -2,  0,  1, -1,  3, -1, -3,  0, -3,
   -3, -3, -1,  1,  2,  1, -1, -2, -2, -2,  0,  2,  1,  0, -2, -2,
   -3, -2,  1,  2,  1, -1, -2, -1, -3, -2,  2,  4,  0, -2, -2,  1,
   -3, -1,  2,  4,  0, -2, -2,  2, -1,  1,  4,  3, -1, -3, -2,  2,
    0,  2,  4,  2, -1, -2, -1,  2,  0,  1,  2,  0, -1,  0,  1,  3,
    3,  0, -5,  1,  4,  0,  0,  1,  1, -2, -5,  2,  5, -1, -2,  1,
   -1,  0,  0,  3,  3,  1,  0, -1, -2,  3,  4, -2, -3, -1,  0, -2,
   -3,  3,  5, -3, -3,  0,  0, -2, -1,  3,  2, -2, -2,  2,  2, -1,
    2,  0,  0, -1,  0,  0,  0,  0,  0, -3, -2,  1,  3,  0, -2, -2
};

static const int8 *const s_svq1InterCodebooks[6] = {
    s_svq1InterCodebook4x2, s_svq1InterCodebook4x4,
    s_svq1InterCodebook8x4, s_svq1InterCodebook8x8,
    0, 0
};

static const int8 s_svq1IntraCodebook4x2[768] = {
   12, 13, 13, 11, -7,-10,-15,-17,-16,-15,-12,-10, 11, 15, 15, 12,
    2, 17, 20, 15,-45,-24,  2, 13, 21, 20, -6,-36, 12, 16, -1,-27,
  -18,-21, 10, 45,-11,-20, -7, 21, 43, -8,-28,  0, 33,-16,-28,  3,
  -12,-18,-18, -6,-20,-10, 28, 55, -5,-18,-21,-18, 56, 30, -6,-20,
  -34, 27, 29,-22,-30, 29, 26,-25, 30, 34, 33, 26,-25,-31,-35,-33,
  -31,-35,-36,-32, 29, 36, 37, 31,-71,-12, 38, 34,-63, -1, 42, 33,
   58, 37,-31,-60, 55, 34,-33,-61,-57,-57, 22, 93,-57,-58, 21, 93,
   59, 69, 70, 62,-63,-68,-68,-60,-64,-71,-71,-64, 63, 73, 72, 62,
   -2,  0,  7, 15,-11,-10, -3,  5, -5, -8,-10,-10,  1,  9, 14,  9,
   15,  8, -4,-11, 12,  2,-11,-12, -8,  0, 19, 28,  4, -1,-15,-26,
  -15, 27,  2,-14,-14, 22,  1, -9, -4, -6,-13,-10, -6,-14,  6, 47,
  -35,-20,  6, 23,  6,  9,  6,  4, -6,  2, 23,-22, -7,  4, 28,-21,
   20,-22, -2,  6, 22,-28, -5,  8,-10,-18,-16,-12, 36, 19,  2, -1,
   -3,  0,  4,  8,-45,-10, 23, 23, 40, 15,-20,-35, -4, -1,  4,  1,
    9, -5,-33, 24,  8,  3,-26, 19, -1,  4,  6, -3, 32, 25,-13,-49,
   24, 24, 15,  7,-17,-27,-19, -7,-47,  0, 39, 24,-21, -6,  7,  4,
   -1,  0,-10,-13,  1,  1,  5, 16, 20,  5, -3, -9, -1, -4, -2, -6,
  -17, -7,  1,  4, 12,  7,  0,  0,  3,  0, 12, 11, -3,  1,  0,-23,
    4, 17, -6,  0,  6,  3,-25,  0,-17, 10,  8,  5,-14,  4,  1,  4,
   13, 10,  4,  2,-23, -9,  1,  2,  3, -3,  1,  7,  1,-23, -7, 20,
   -7,-18,  2, 12, -5, -4, 10,  9,  4, 10,  7,-24,  6,  3,  4,-10,
   22,-14,-22,  6,  0,  5,  5, -1, -4,  3,-11, -4, -7, 31,  7,-14,
   -5,-16, -1, 42, -4, -2, -9, -5,  5, -8, -6, -3, 42, -4,-21, -5,
  -18, 12, 20,-12, 13,-13,-10,  7, -8, -9, -2,-18,-16,  6, 40,  8,
   10, -1,  0,  4, -3,  4, -1,-13, -2,  6,  1,-15,  5,  3,  1,  2,
   -4, -2,  1,  3, 15,  0, -9, -4, -3, -4, -4, -4, -3,  5, 16, -3,
    2, 13,  3,  4, -3, -8,-10,  0, -6, -2, -4, -1, -2, -3, -6, 23,
    6, -6,  7,  1,  4,-18,  5,  1, -1,  1,-15, 14, -5,  6, -4,  4,
    2,  2,  2,  6,-24,  2,  7,  3,-26,  0,  3,  3,  5,  7,  1,  6,
   14, -2,-18, -3,  7,  5, -4,  2, -6,  3, 32,  1, -6, -6, -6,-12,
    5,-36,  7,  6,  9, -1, 11,  0,  4,  4,  5,  3,  4, 15,  3,-38,
   10, 23, -5,-42,  0,  4,  4,  4, 23, 17, -6,-13,-13,-37,  1, 29,
    5,-14, -1,  1,  5,  0,  3,  1,  0,  4, -5,  2,  8,  0,  0,-10,
    4,  7, -2, -3,-10,  3,  1,  1,-12, -1, 13,  3,  0, -1,  1, -3,
    0, -1,  3,  1, -6, -9,  3,  9, -6,  1, -4, -6,  8, -1,  0,  8,
   -3, -3,  0, 18, -5, -1, -4, -1, -8, -2,  3, -4,  0, 17, -1, -5,
    5, -2,  9,-10,  1, -5,  6, -5,  4,  2,  2,  3, 10,-14, -8,  1,
   -1, -2,-18, -1, -1, 20,  1,  2, -1,  1, -9,  1, -1, -9, 22, -4,
    6, -4,  8, -3, -1,  7,-19,  5, -7, 31, -4, -4, -6,  0, -5, -5,
   -7, -8,-19, -4,  1,  1,  4, 32, 38, -1, -8,  4, -7, -8, -6,-12,
   -1,  0, -7,  1, -1,  9, -1,  0,  9, -1, -1,  0,  2, -6,  1, -3,
  -12,  0,  2,  1,  1,  1,  8,  0,  9,  1,  0,  2, -2,  1,-11,  0,
    0,  8,  2,-10, -1,  2, -1,  0, -2, -4,  0, -5, -2, -1, -1, 14,
   -3,  7, -1,  5,  0,-10,  1,  1, -1, -5, 14, -1, -2,  1, -3, -2,
   -6,  0,  0,  6,  2,  3, -9,  4,  4, -5, -1, -1, -7,  3,  8, -1,
    2, -4, -1,-11, 11,  2,  1,  0, -1,  2,  3,  9,  0,  2,  0,-15,
    3,  5,-20,  3,  3, -1,  3,  3,  1, -1, 16,  1,  2,-29,  9,  2,
  -13, -6, -1, -3, 36, -1, -8, -3,  2,  5,  4,  2,-37,  9, 11,  3
};

static const int8 s_svq1IntraCodebook4x4[1536] = {
  -11, -3,  3,  6,-10, -1,  5,  7, -9, -1,  6,  7, -9, -1,  4,  6,
    5,  7,  0,-14,  6,  9,  2,-15,  6,  9,  2,-15,  4,  6,  0,-14,
   16,  3, -5, -6, 16,  1, -8, -8, 14, -1, -9, -9, 12,  0, -8, -8,
    8, 12, 16, 17, -2,  2,  6,  9,-10, -8, -4,  0,-15,-14,-11, -7,
   -7,-10, -2, 16, -7,-11, -3, 18, -7,-11, -1, 20, -6, -8,  1, 19,
   -9,-13,-16,-17,  2, -2, -7, -9, 11,  8,  4, -1, 16, 15, 11,  7,
  -22, -2, 13, 15,-24, -2, 14, 16,-25, -4, 13, 15,-25, -6, 10, 13,
   26, 26, 22, 16, 17, 15,  9,  3, -2, -6,-11,-14,-20,-25,-28,-28,
  -27,-27,-25,-21,-16,-15,-11, -7,  3,  8, 12, 13, 23, 28, 31, 30,
   20, 16, -7,-33, 22, 19, -6,-35, 22, 19, -6,-34, 20, 17, -6,-32,
  -20,-20,  2, 38,-21,-22,  2, 40,-21,-22,  2, 40,-20,-20,  3, 38,
  -47, -4, 24, 26,-50, -3, 26, 27,-50, -3, 26, 27,-47, -4, 24, 26,
   45,  6,-23,-27, 48,  5,-25,-28, 48,  5,-26,-28, 44,  6,-24,-27,
  -30,-36,-10, 76,-31,-37,-11, 78,-31,-37,-11, 78,-31,-36,-10, 77,
  -53,-32, 35, 52,-54,-34, 36, 52,-54,-34, 36, 52,-53,-33, 34, 51,
  -93,-34, 62, 65,-93,-34, 62, 66,-93,-34, 62, 65,-93,-34, 60, 64,
   -7,  0,  2,  2, -8, -1,  3,  3, -8,  0,  4,  5, -6,  1,  5,  5,
    3,  7, 11, 11,  2,  2,  3,  3,  1, -2, -6, -7,  1, -5,-11,-13,
    3, -2, -4, -3,  7,  0, -5, -5, 12,  4, -5, -7, 14,  6, -4, -7,
   18, 14,  3, -2,  6,  4,  0, -3, -8, -5, -2,  0,-16,-11, -2,  2,
   -8, -6,  7, 18, -7, -8,  2, 13, -4, -6, -2,  6,  0, -4, -3,  1,
    1, -3,-13,-18,  0, -1, -5, -7, -1,  1,  6,  7, -2,  4, 15, 17,
  -15,-14, -7, -2, -6, -5, -1,  0,  6,  6,  3,  1, 15, 13,  6,  1,
    2, -2,-11, 10,  2, -1,-12, 11,  3, -1,-12, 11,  2, -2,-11, 11,
   -9, 14, -1, -5, -9, 15, -2, -5, -8, 16, -2, -5, -7, 15, -1, -4,
    2,  6,  8,  8, -2,  3,  9, 12,-11, -5,  4, 10,-19,-16, -8,  0,
   14,  8, -7,-15, 12,  7, -7,-14,  8,  5, -4, -9,  5,  3, -1, -4,
   12,-14, -2,  2, 13,-15, -1,  3, 14,-15, -1,  3, 13,-14, -1,  3,
    0,  6, 10,-13,  0,  6, 10,-15,  0,  7,  9,-17,  1,  6,  8,-16,
   -8, -5, 15, -2, -8, -6, 17, -2, -8, -6, 16, -3, -8, -5, 15, -2,
   -9,-11,-11,-10,  9, 10,  9,  8,  8, 10, 10,  9, -8, -9, -8, -7,
    9, 10,  9,  7, -8,-10,-10,-10, -7,-10,-11,-11, 11, 12, 11,  8,
    0, 10,  7,  0,  0,  7,  0, -6,  0,  2, -5, -6, -2, -1, -4, -1,
    5,  0, -6, -9,  2,  2,  2,  1, -2,  0,  5,  7, -6, -5,  1,  4,
    3, -8,  2, -1,  4, -9,  3,  0,  5, -7,  3,  0,  7, -5,  3,  0,
   -5, -3,  2,  9, -6, -3,  1,  8, -6, -3,  1,  7, -5, -2,  0,  4,
   13,  8,  3,  1, -3, -5, -4, -1, -8, -7, -3,  0, -1,  1,  3,  2,
    3,  2, -5,-12,  4,  3, -2, -9,  3,  4,  1, -4,  3,  5,  4, -1,
   -9, -8, -4,  0,  8,  6,  2,  0, 10,  8,  3,  0, -6, -5, -3, -1,
   -3, -9,-12, -5,  0, -3, -5,  0,  2,  3,  2,  4,  5,  8,  7,  6,
   -1, -2,  5, 12, -1, -1,  5,  9,  2,  1, -1, -2,  2, -1,-11,-17,
   -7,  3,  3, -1, -9,  3,  4, -1,-10,  4,  6, -1, -9,  5,  7,  0,
  -18, -7,  2,  2, -8,  1,  5,  3,  3,  4,  1,  0,  9,  5, -2, -3,
   -2,  0,  6,  8, -4, -5, -5, -3,  1, -2, -6, -8, 10,  9,  3, -1,
    0, -2, -2,  0,  0, -4, -5,  0, -2, -8, -4,  8, -5, -7,  6, 24,
    9,  1, -7,  1,  9,  1, -8,  1,  8,  0,-10,  1,  8, -1,-11, -1,
    8,  8,  6,  3,  5,  4,  3,  2, -2, -3, -1,  0,-10,-13, -8, -4,
    0,  4,  2, -3,  0,  6,  3, -5,  3, 10,  2,-12,  5, 10, -4,-22,
    0, -4, -1,  3,  1, -4, -1,  5,  1, -5,  0,  8, -1, -6, -2,  7,
   -1, -1, -2, -4, -1, -2, -4, -6, -1, -1, -1, -2,  1,  5, 10,  9,
   10,  3,  0, -2,  6, -1, -2, -5,  3, -1, -2, -6,  2,  0,  0, -5,
    6,  3,  0,  0,  6,  3,  1,  1,  4, -2, -2,  1,  0, -9, -9, -2,
  -11, -3,  1,  2, -6,  2,  4,  5, -3,  2,  3,  4, -2,  1,  1,  2,
   -6, -4, -1, -2,  2, -1, -1, -2, 10,  2, -2, -2, 11,  2, -4, -1,
    6,  0, -2,  2,  3,  3,  0,  0, -6,  3,  3,  0,-17, -1,  5,  0,
   -1,  4, 10, 11, -3, -2,  0,  1, -3, -4, -5, -3, -1, -2, -2, -1,
    2, -3, -9,-12,  3,  3,  3,  2,  2,  2,  4,  4,  2,  1, -1, -2,
   -2,  9,  5,-10, -3,  5,  5, -5, -2,  1,  2,  0, -1, -2, -2,  1,
   -2, -3,  7, -2, -1, -3,  7, -3, -1, -2,  8, -4, -2, -2,  7, -3,
    1, -8, -3, 12,  2, -2, -2,  4,  1,  3,  0, -5, -1,  5,  2, -7,
   -1,  3,  1, -5, -7, -2,  3,  1, -2, -7, -2,  2, 20,  3, -5, -1,
    5,  0, -3, -2, -7, -7,  0,  6, -6,  0,  7,  6,  2,  6,  0, -7,
   -2,  6, -7,  1, -2,  7, -8,  3, -2,  7, -7,  3, -1,  7, -6,  2,
   -5, -2,  5,  7,  4,  1, -4, -8,  6,  3, -2, -5, -7, -5,  3,  7,
   -1, -1,  6,  5,  0, -1,  1, -4,  2,  1,  0, -7,  1,  0,  0, -4,
   -8,  0,  3,  1, -2,  1, -1, -1,  1, -1, -3,  1,  1, -2,  1,  9,
    5,  2, -3, -4, -1,  0, -1, -3, -3,  1,  3,  1, -4,  0,  4,  2,
    2, -2, -2, 12,  0, -2, -5,  3, -1,  0, -3,  1, -3, -1, -2,  1,
    1,  5,  3,  0, -6, -4, -2,  1,  0, -2, -2,  2,  6,  1, -4, -1,
   -3, -5, -5, -1,  3,  5,  5,  4,  0,  3,  1, -1, -2,  1, -2, -3,
    2, -4, -5, -3,  4, -2, -3, -2,  6,  0, -1, -1,  7,  1,  0,  0,
   -3, -2, -2,  0, -2, -3, -5, -1, -2,  2,  0, -1, -1, 11,  9, -1,
    0,  1, -1,-10, -1,  1,  0, -6,  1,  0,  1,  4,  2, -5, -1, 13,
   -2,  4,  5,  0, -5,  1,  6,  3, -6, -2,  3,  2, -5, -2,  0, -2,
   -1,  1,  1, -2, -1, -2,  0,  2,  5,  5,  5,  7,  0, -4, -8, -7,
    0,  2, -1, -5, -1,  2,  2, -3,  0,  5,  3, -5,  3,  8,  2,-12,
    8,  4,  0, -2, 10, -1, -4, -1,  3, -6, -3,  0, -4, -5,  0,  0,
    0,-10, -4,  2, -1, -6,  3,  5, -1, -3,  6,  4,  0, -2,  4,  2,
    0,  8,  1, -1,  0, 11,  1, -3, -1,  6, -2, -4, -3, -2, -7, -4,
    0, -1, -1, -1,  4,  5,  6,  5, -5, -9, -8, -5,  2,  2,  3,  2,
    0,  2,  6,  1,  2,  0,  3,  0,  1, -2, -1, -2,  0, -1, -3, -6,
    0,  0,  2,  0,  4,  0,  2,  1,  5, -2,  0,  0, -2, -9, -1,  2,
    0,  1,  0,-10, -1,  1,  8,  0, -1, -2,  4,  0,  1, -1,  2, -1,
   -3, -2,  2, -1, -3, -1,  2, -3,  0, -1,  1,  0,  8,  1, -1,  3,
    0,  1,  1,  2,  0, -4, -2,  0, -1, -5,  1, -1, -2, -1, 11,  2,
    1,  5, -2, -2,  0,  2, -4,  0, -2,  1, -5,  1,  0,  5,  0,  1,
   -5, -3,  0,  6, -4,  2,  0,  0, -3,  5,  1,  0, -3,  3,  0,  0,
    3, -2, -3,  1,  1, -4,  0,  8, -2, -3, -2,  3,  1,  2, -1, -1,
    1,  1,  0,  2,  2,  0,  1,  6,  1, -1,  2,  1,  0,  3,  0,-19,
    1, -3, -2,  2,  6,  5, -2, -7, -3,  1,  3,  1, -1, -1,  0,  2,
   -8, -1, -1, -4,  1,  1, -1,  2,  4,  3,  2,  3, -5,  1,  3,  0,
    0,  2, -1,  1, -3,  0,  0,  5, -5, -2,  0,  8, -4, -4, -4,  6,
    1,  2,  1,  2,  2,  2, -3,  2,  4,  0, -9,  0,  7,  0,-11,  1,
    0,  0,  0, -2,  3,  3, -1, -6,  4,  3, -3,-10, -1,  2,  6,  2,
    7, -2, -3,  5, -4,  0,  3, -1, -4,  2,  1, -7,  2, -1, -1,  3,
    3,  2,  2,  2, -5, -7, -7, -5,  5,  6,  4,  2, -2, -1,  0,  1
};

static const int8 s_svq1IntraCodebook8x4[3072] = {
    5,  6,  6,  6,  7,  7,  8,  8,  0,  0,  0,  0,  0,  1,  2,  3,
   -3, -4, -4, -5, -5, -4, -3, -2, -4, -4, -4, -5, -4, -4, -3, -3,
    1,  2,  2,  2,  2,  3,  3,  3,  2,  3,  3,  4,  4,  5,  5,  5,
   -1,  0,  1,  1,  2,  3,  4,  4, -9,-10, -9, -9, -8, -7, -6, -5,
   -4, -4, -5, -6, -6, -7, -7, -7,  0, -1, -2, -2, -3, -3, -4, -4,
    4,  4,  3,  3,  2,  1,  1,  0,  7,  7,  7,  6,  6,  5,  4,  4,
    2,  4,  5,  6,  4,  1, -3, -6,  3,  4,  5,  5,  4,  0, -5, -8,
    2,  3,  4,  4,  2, -2, -7,-10,  2,  2,  2,  1,  0, -4, -9,-12,
   -9, -7, -3,  1,  4,  4,  3,  3,-10, -7, -2,  3,  5,  5,  3,  3,
   -9, -6, -2,  3,  6,  5,  4,  3, -8, -6, -1,  3,  4,  4,  3,  2,
   -5, -5, -5, -5, -3,  1,  4,  7, -5, -5, -5, -4, -2,  1,  6,  8,
   -4, -5, -4, -3, -1,  3,  8, 10, -3, -4, -3, -2,  1,  5,  9, 11,
   -2, -2, -2, -2, -2, -2, -2, -2, -4, -5, -5, -5, -5, -5, -5, -4,
   -3, -4, -4, -4, -4, -4, -4, -3,  9, 10, 10, 11, 11, 11, 10, 10,
    7,  4,  1, -2, -4, -6, -9,-10,  9,  7,  3,  0, -2, -4, -8, -9,
   11,  8,  4,  2,  0, -3, -6, -8, 11,  9,  5,  3,  1, -2, -5, -7,
  -13,-13,-13,-12,-11,-10, -8, -8,  0,  1,  2,  3,  4,  4,  4,  3,
    3,  4,  5,  6,  6,  6,  5,  4,  3,  4,  4,  4,  3,  3,  3,  2,
   10, 10, 11, 10,  9,  9,  8,  7,  6,  6,  6,  6,  5,  4,  3,  2,
    0,  0,  0, -1, -2, -3, -4, -4,-10,-10,-11,-12,-13,-14,-14,-14,
   16, 16, 17, 16, 15, 13, 12, 11, -1, -2, -3, -4, -4, -4, -4, -3,
   -4, -5, -6, -6, -6, -6, -6, -6, -5, -6, -6, -6, -6, -6, -5, -5,
  -13,-13,-13,-12,-11,-10, -8, -6, -9, -8, -7, -6, -4, -2,  0,  1,
   -2, -1,  1,  3,  5,  7,  8,  9,  5,  7,  9, 11, 13, 14, 15, 15,
   16, 14, 11,  7,  2, -3, -7, -9, 14, 12,  8,  3, -1, -6, -9,-11,
   11,  9,  4,  0, -4, -8,-11,-13,  8,  5,  1, -3, -6,-10,-12,-14,
  -18,-15, -9, -3,  1,  6,  9, 11,-17,-13, -7, -1,  3,  7, 11, 12,
  -15,-11, -5,  1,  5,  9, 12, 13,-13, -9, -3,  2,  5,  9, 11, 13,
   22, 21, 19, 15, 10,  3, -4, -9, 20, 18, 15,  9,  2, -5,-12,-17,
   16, 13,  8,  1, -7,-14,-20,-24, 10,  6, -1, -8,-15,-21,-25,-27,
  -25,-23,-20,-14, -7,  1,  9, 14,-23,-21,-16, -9,  0,  9, 16, 21,
  -20,-16,-10, -1,  8, 16, 22, 25,-15,-11, -3,  6, 14, 20, 25, 27,
   -4, -2,  0,  1,  2,  2,  2,  2, -5, -2,  0,  2,  3,  3,  3,  3,
   -6, -4, -1,  1,  2,  3,  3,  3, -7, -5, -2,  0,  1,  1,  2,  2,
    2,  1,  1,  1,  1,  0, -2, -3,  3,  3,  2,  1,  0, -1, -3, -4,
    4,  3,  2,  1,  0, -2, -4, -6,  5,  4,  3,  1, -1, -3, -5, -6,
    5,  6,  6,  4,  2,  0, -2, -3,  3,  4,  4,  4,  3,  1,  0, -1,
   -2, -2, -1, -1, -1, -1, -2, -2, -5, -4, -3, -2, -2, -2, -3, -3,
   -1, -1, -1, -1, -1, -1, -1, -1, -3, -4, -4, -4, -3, -3, -3, -3,
   -1, -1, -1, -1, -1, -1, -1, -2,  5,  6,  6,  6,  6,  5,  4,  3,
    4,  4,  4,  4,  4,  5,  6,  7,  0, -1, -1, -1, -1,  0,  1,  2,
   -2, -3, -3, -3, -3, -2, -1,  0, -3, -3, -4, -4, -4, -3, -2, -1,
    0, -2, -4, -4, -2,  0,  2,  3,  0, -2, -3, -3, -1,  2,  4,  5,
   -1, -2, -4, -3,  0,  3,  5,  6, -2, -3, -4, -3, -1,  2,  4,  5,
    9,  4,  0, -3, -3, -1,  0,  1,  8,  4, -1, -4, -3, -1,  1,  2,
    6,  2, -3, -5, -4, -2,  0,  1,  5,  1, -3, -4, -4, -2,  0,  1,
    5,  3,  1, -1, -4, -8,-10,-10,  3,  3,  2,  1,  0, -2, -3, -4,
    1,  1,  1,  2,  3,  2,  1,  0, -1,  0,  1,  2,  3,  4,  3,  2,
    0,  1,  2,  2,  1, -1, -3, -3,  0,  1,  1,  1, -1, -2, -4, -3,
   -3, -3, -3, -3, -3, -3, -1,  2, -4, -4, -3,  0,  3,  7, 12, 14,
   -5, -5, -6, -6, -6, -6, -6, -5,  2,  2,  2,  1,  0,  0,  0,  0,
    4,  4,  3,  2,  1,  0,  0,  0,  6,  6,  5,  4,  2,  2,  1,  1,
   -7, -7, -6, -3,  0,  4,  7,  8, -1, -2, -3, -3, -2, -1,  1,  2,
    3,  3,  1, -1, -2, -2, -2, -1,  6,  6,  4,  2,  0, -2, -2, -2,
   -6, -5, -2,  2,  5,  9, 11, 12, -4, -4, -2,  0,  2,  4,  5,  6,
   -3, -2, -2, -2, -2, -1,  0,  1, -2, -2, -2, -3, -3, -3, -3, -2,
   -7, -3,  1,  3,  3,  0, -3, -5, -6, -2,  3,  5,  4,  1, -3, -5,
   -5, -1,  4,  6,  5,  2, -3, -4, -4,  0,  5,  7,  6,  3, -1, -3,
    0,  0,  0,  0,  0,  0,  0,  0, -2, -2, -3, -3, -3, -3, -2, -1,
    6,  7,  8,  9,  9,  8,  7,  6, -4, -4, -5, -5, -6, -6, -5, -4,
   -9, -8, -6, -4,  0,  3,  6,  6, -5, -4, -1,  3,  5,  6,  5,  3,
    1,  3,  6,  6,  4,  1, -2, -5,  6,  7,  5,  1, -3, -7,-10,-11,
   10,  9,  5,  1, -3, -6, -6, -4,  5,  3, -1, -5, -6, -5, -2,  2,
   -2, -4, -6, -6, -4,  1,  6, 10, -6, -7, -7, -4,  1,  7, 11, 12,
    6,  5,  3,  2,  0,  0,  0,  0,  2,  1, -1, -2, -3, -2, -1, -1,
    0, -1, -2, -4, -4, -2, -1,  1,  0,  0, -1, -2, -1,  0,  2,  3,
    0, -1, -2, -2, -2, -2, -1, -1,  5,  4,  2,  1,  0,  0,  0,  0,
    6,  5,  3,  1,  0,  0,  0,  0,  2,  0, -2, -4, -4, -3, -2, -2,
   -7, -4,  0,  2,  2,  2,  2,  1, -7, -3,  0,  0,  0,  0,  0,  0,
   -4, -1,  1,  1,  0,  0,  0,  1, -1,  1,  2,  2,  2,  2,  3,  3,
   -2,  0,  2,  2,  1,  1,  1,  1, -1,  1,  2,  2,  1,  0,  0, -1,
    0,  2,  4,  2,  0, -1, -2, -3,  1,  2,  3,  1, -2, -4, -6, -6,
    1,  2,  2,  4,  5,  6,  4,  1,  0, -1, -1, -1,  0,  0, -2, -4,
    0,  0, -1, -2, -2, -2, -4, -6,  2,  1,  0,  0,  1,  1, -1, -3,
    1,  1,  1,  1,  1,  2,  3,  3,  0,  0,  1,  0,  1,  2,  4,  4,
   -1, -1, -1, -1,  0,  1,  2,  3, -4, -4, -5, -5, -5, -3, -1,  0,
   -6, -5, -5, -4, -3, -2, -1, -1, -1,  0,  0,  1,  1,  2,  3,  3,
    0,  1,  1,  1,  2,  2,  3,  4,  0,  0, -1, -1,  0,  1,  2,  3,
    0,  1,  1,  1,  0,  0, -1, -1,  1,  3,  3,  2,  1, -1, -2, -2,
   -2,  0,  2,  2,  2,  2,  1,  1, -9, -8, -4, -2,  1,  3,  3,  3,
   -1, -1, -1, -2, -3, -3, -3, -4,  0,  0,  0, -1, -2, -2, -3, -3,
    2,  2,  2,  0, -1, -1, -1, -1,  5,  5,  4,  3,  2,  2,  2,  2,
    6,  3, -1, -4, -3, -1,  1,  1,  2, -1, -3, -4, -1,  2,  2,  0,
   -1, -2, -2,  1,  4,  4,  1, -3, -2, -1,  1,  4,  6,  3, -3, -8,
    3,  3,  2,  1, -1, -2, -2, -2, -4, -4, -2, -1,  1,  3,  4,  4,
   -4, -5, -5, -4, -2,  0,  2,  2,  7,  7,  4,  1, -1, -2, -3, -2,
   -1,  1,  3,  0, -4, -6,  0,  6, -2,  1,  4,  1, -4, -6, -1,  7,
   -3,  1,  4,  2, -3, -6, -1,  6, -2,  0,  3,  2, -2, -5, -1,  4,
    1, -1, -2,  1,  4,  4, -1, -7,  1, -1, -4, -1,  5,  6,  0, -6,
    3,  0, -4, -3,  3,  6,  2, -4,  3,  0, -5, -4,  1,  4,  1, -3,
    2,  2,  3,  3,  3,  3,  2,  2, -4, -5, -6, -7, -7, -7, -7, -6,
    1,  2,  3,  3,  3,  3,  2,  2,  0,  0,  1,  1,  1,  2,  2,  1,
    3, -3, -3,  3,  4, -2, -2,  2,  3, -4, -4,  4,  4, -4, -4,  2,
    4, -4, -4,  4,  4, -4, -3,  3,  3, -3, -4,  3,  3, -3, -3,  3,
   -2, -2, -2, -2, -2, -2, -1, -1,  6,  7,  8,  8,  8,  7,  6,  5,
   -5, -6, -7, -7, -8, -7, -6, -5,  1,  1,  2,  2,  2,  2,  1,  1,
    0,  0,  0,  0,  0, -1,  0,  0, -1,  0,  0,  0,  0, -1,  0,  0,
   -2, -3, -2, -2, -2, -3, -3, -3,  2,  3,  5,  6,  4,  2,  1,  0,
    8,  6,  2,  0,  0,  0,  0,  0,  4,  1,  0,  0,  0, -1, -1, -1,
    1, -1,  0,  0,  0, -1, -2, -3, -2, -2, -1,  0,  0, -2, -4, -5,
    3,  1, -1, -2, -3, -4, -5, -5,  2,  1,  0,  0,  1,  1,  0,  0,
    0, -1, -1,  0,  2,  2,  2,  2, -1, -2, -1,  1,  2,  2,  2,  2,
    0, -1, -2, -1, -1, -1, -1,  0, -1, -2, -2, -1, -1,  0,  0,  1,
    2,  1,  1,  2,  2,  1,  1,  0,  6,  5,  3,  1,  0, -2, -4, -4,
   -3, -2, -1,  0,  1,  1,  0, -1,  0,  1,  3,  4,  5,  5,  3,  1,
   -1, -1, -1,  0,  1,  0, -1, -2, -2, -2, -2, -1,  0, -1, -2, -3,
    0, -1, -2, -2, -1, -1,  0,  2,  1, -1, -2, -1, -1, -1,  0,  2,
    1,  0, -2, -2, -2, -2,  1,  5,  1, -1, -2, -2, -2,  0,  5, 10,
    0,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1,  0,  0,  0,  1,  2,
    1,  2,  2,  3,  4,  4,  6,  5, -3, -3, -3, -2, -2, -3, -3, -3,
    1, -1, -2, -2,  0,  3,  5,  7,  2,  0, -2, -3, -2,  0,  2,  3,
    3,  1, -2, -3, -3, -2, -1, -1,  3,  1,  0, -1, -1, -1, -1, -1,
    1,  3,  5,  4,  2, -1, -3, -4, -3, -2,  1,  2,  1,  0, -1, -2,
   -5, -3,  0,  2,  2,  1,  0,  0, -3, -1,  1,  2,  2,  1,  0,  0,
    0, -1, -1, -1,  1,  2,  3,  4, -3, -4, -4, -3, -1,  0,  0,  1,
   -2, -3, -2, -1,  1,  1,  1,  1, -2, -2,  0,  3,  4,  4,  3,  2,
   -4, -4, -3, -2, -1,  1,  2,  3,  0,  1,  1,  1, -1, -2, -3, -3,
    3,  4,  5,  4,  2, -1, -3, -3, -2, -2,  0,  2,  2,  2,  1,  0,
   -4,  0,  5,  7,  4, -1, -4, -4, -1,  2,  4,  3,  0, -3, -3, -2,
    2,  1,  0, -1, -2, -2,  0,  1,  0,  0, -1, -2, -2, -1,  1,  2,
   -4, -3, -2, -1,  0,  1,  2,  2, 10,  9,  5,  0, -3, -4, -3, -2,
    1, -1, -2, -2, -1,  0,  0,  0, -2, -2, -1,  1,  1,  1,  0, -1,
   -5, -3,  0,  3,  4,  2,  0, -2, -2, -1,  0,  1,  1,  0, -1, -1,
    3,  2, -1, -2, -2, -1,  1,  1,  7,  5, -1, -5, -6, -2,  2,  4,
   -2,  3,  3, -3, -4,  1,  2, -2, -3,  3,  4, -3, -4,  2,  3, -2,
   -3,  3,  4, -3, -4,  2,  3, -2, -4,  2,  4, -2, -3,  1,  2, -1,
    4,  3, -1, -3, -3, -1,  1,  2, -4, -6, -4,  0,  4,  5,  4,  1,
    0,  2,  5,  6,  2, -3, -5, -4,  1,  1, -1, -3, -5, -2,  2,  4,
   -1,  0,  1,  2,  2,  3,  3,  4, -1,  0,  1,  1,  0, -1, -1, -1,
   -1,  0,  1,  2,  2,  1, -1, -2, -3, -2, -1,  0,  0, -1, -2, -3,
    1,  1,  1,  1,  0,  0,  1,  2,  1,  0, -1,  0,  0,  1,  1,  0,
    1, -2, -4, -1,  1,  2,  1,  0,  1, -4, -7, -3,  1,  3,  2,  1,
    1,  1,  1,  1,  1,  1,  0, -1,  1,  1,  1,  0,  1,  2,  2,  0,
    1,  1,  0,  0,  0,  2,  0, -3,  3,  2,  0, -1, -1, -2, -6, -9,
    0,  0,  0,  1,  0,  0,  1,  2,  1,  0,  0,  0, -1, -1,  0,  2,
    0,  1,  1,  1, -1, -3, -2,  0, -7, -5,  1,  6,  6,  2, -1, -1,
    3,  1, -1, -3, -4, -2,  1,  4,  2,  0, -2, -3, -4, -3, -1,  2,
    2,  2,  1,  1,  1,  0,  0,  1,  1,  1,  0,  0,  0,  0,  0,  1,
   -1,  1,  1, -2, -5, -6, -4, -1, -1,  1,  4,  3,  2,  0,  1,  2,
   -1,  0,  2,  3,  1,  0,  0,  1, -1,  0,  1,  0,  0, -1, -1,  0,
    0,  1,  2,  2,  0, -2, -1,  1, -2, -1, -1, -2, -1,  2,  6,  8,
   -1, -1, -2, -3, -2,  0,  1,  2, -1,  0,  0, -1, -1,  0, -1, -1,
    2,  1,  1,  1,  1,  0,  0,  0,  0,  0,  1,  1,  1, -1, -1,  1,
   -1,  0,  2,  2, -1, -3, -2,  3,  0,  2,  3,  0, -5, -7, -2,  4,
   -1,  0,  0,  0, -1, -2, -3, -3, -1,  0, -1, -2, -2, -2, -2, -2,
    1,  1,  0,  0,  1,  2,  0, -1,  1,  2,  1,  2,  5,  6,  2,  0,
   -2, -4, -3,  0,  2,  2,  0, -3,  3,  1,  0,  1,  2,  1, -2, -3,
    3,  1,  0,  0,  0,  0,  0, -1,  1, -1, -2, -2, -1,  1,  3,  3,
    3,  2,  1,  2,  4,  3,  1, -2, -2, -4, -4, -3, -1,  0, -2, -3,
    1,  0, -1, -1,  0,  1,  0, -1,  3,  2,  0,  0,  0,  1,  1,  0,
    1,  1,  0,  0,  0,  0,  0,  0,  2,  3,  3,  2,  2,  2,  1,  1,
    0, -1, -2, -3, -5, -5, -5, -4,  1,  1,  0, -1,  0,  1,  3,  3,
   -9, -6, -2,  0,  1,  1,  2,  2, -6, -2,  1,  2,  1,  1,  0,  1,
   -2,  1,  2,  2,  1,  1,  1,  1,  0,  2,  2,  1,  0,  1,  1,  1,
    1,  0,  0,  0,  0,  0, -1,  0,  0,  0,  0,  0, -1, -3, -2,  0,
   -3, -3, -3, -2, -1,  3,  7,  9,  1,  2,  2,  2,  0, -2, -4, -3,
    2,  0, -2, -1,  3,  4, -1, -6,  1,  0, -2, -3, -1,  3,  3,  0,
    0,  3,  3,  0, -2, -1,  1,  1, -6, -1,  3,  2, -1, -2,  0,  1,
    5,  3,  0, -2, -3,  0,  2,  1,  1,  1,  2,  2,  0, -2, -4, -7,
   -3, -2,  1,  2,  2,  1, -1, -4,  2,  2,  0, -2, -2,  0,  2,  2,
    0,  0, -2, -3, -2, -1,  0,  0,  0,  0,  0,  0,  0,  0,  2,  2,
   -2, -1,  0,  1,  0,  1,  2,  3, -4, -2,  0,  0, -1,  0,  2,  3,
   -2, -2, -2, -1, -1,  0,  2,  4,  0,  0,  0,  0, -1, -1,  0,  1,
    0, -1, -1, -1, -1, -1,  0,  0,  6,  4,  2,  0, -1, -2, -1, -1,
    0,  1,  1,  1,  1, -1, -5,-10,  1,  1,  1,  1,  1,  1,  0, -4,
    1,  0,  1,  1,  1,  1,  1, -1,  2,  1,  1,  1,  0,  0,  0,  0,
   -3,  1,  4,  3,  3,  1, -1,  0, -4,  0,  1,  0, -1,  0,  0,  0,
   -5,  0,  2,  1,  1,  1,  0, -1, -1,  2,  1, -2, -2, -1,  0, -1,
    2,  4,  5,  3,  0, -1,  1,  2,  0,  0,  1,  0, -2, -2, -1, -1,
   -2, -2, -2, -2, -3, -2, -1,  0,  0,  0,  1,  0,  0,  0,  1,  2,
    0, -2, -2, -3, -1,  2,  2, -1,  1,  0,  0,  0,  1,  5,  3, -2,
   -1, -1,  0, -1,  0,  2,  0, -5, -1,  0,  1,  0,  0,  2,  2, -2,
    3,  1, -1, -1,  0,  1,  1,  2,  1,  0,  0,  1,  1,  1,  1,  1,
  -10, -8, -2,  1,  2,  1,  1,  1, -1,  1,  2,  1,  0,  0,  0,  0,
   -1, -1,  0,  1,  2,  2,  2,  1, -1, -1, -1,  0, -1, -3, -5, -4,
    1,  1,  2,  1,  1,  0,  0,  2, -1, -2, -1, -1, -1,  0,  2,  4,
   -3, -7, -5,  0,  2,  0,  0,  0,  3, -1, -2,  1,  2,  1,  1,  2,
    1, -2, -1,  1,  2,  1,  0,  1,  0, -1,  0,  3,  2, -1, -1, -1,
    2,  1,  1,  0,  0,  0,  0,  0, -9, -7, -2,  3,  3,  2,  1,  1,
    3,  2,  0, -2, -2, -1,  1,  1,  0, -1,  0,  0,  1,  1,  0,  0,
   -2, -1,  1,  1,  1,  0,  0,  0,  1,  2,  1, -2, -4, -3,  1,  2,
    1,  2,  1, -2, -3,  0,  3,  1, -1, -1,  0,  0,  1,  3,  0, -4,
    2,  0, -1,  1,  2, -2, -2,  3,  2,  0, -1,  2,  3, -2, -4,  1,
    0,  1,  1,  1,  2, -2, -6, -2, -1,  0,  0,  0,  2,  0, -2, -1,
   -1, -1,  1,  2,  1, -2, -3, -2,  3, -1, -2, -1, -1,  0,  1,  2,
   10,  4,  0,  0, -1, -2, -2, -1,  3, -1, -2, -1,  0, -1, -1,  0,
   -5,  2,  7,  1, -4, -2,  1,  0, -2,  2,  3, -1, -3,  0,  2,  0,
    2,  1,  0,  0,  1,  1, -1, -2,  1, -2, -2, -1, -1, -2,  0,  0,
    0,  3, -2, -7, -1,  3,  0,  0,  1,  3, -3, -5,  2,  3, -1,  0,
    0,  2, -2, -2,  4,  2, -2,  0, -1,  1, -1,  0,  2, -1, -2,  1,
    4,  0, -3, -4, -2,  1,  2,  1,  0,  0,  3,  5,  3,  1, -1, -2,
    1,  1,  1, -1, -3, -1,  1,  1,  1, -1, -2, -2,  0,  0, -1, -2
};

static const int8 s_svq1IntraCodebook8x8[6144] = {
    4,  4,  3,  2,  2,  1,  0, -1,  4,  3,  3,  2,  1,  0, -1, -1,
    3,  3,  2,  2,  1,  0, -1, -2,  3,  2,  2,  1,  0, -1, -2, -3,
    2,  2,  1,  0, -1, -1, -2, -3,  2,  1,  0,  0, -1, -2, -3, -4,
    1,  0,  0, -1, -2, -3, -4, -4,  0,  0, -1, -2, -2, -3, -4, -4,
    2,  3,  3,  3,  3,  3,  3,  3,  2,  2,  2,  2,  2,  2,  3,  3,
    1,  2,  2,  2,  2,  2,  2,  2,  0,  1,  1,  1,  1,  1,  1,  1,
   -1,  0,  0,  0,  0,  0,  1,  1, -2, -2, -1, -1, -1, -1, -1, -1,
   -3, -3, -3, -3, -3, -3, -2, -2, -5, -4, -4, -4, -4, -4, -4, -3,
   -4, -2, -1,  0,  1,  2,  2,  3, -4, -2, -1,  0,  1,  2,  3,  3,
   -4, -3, -1,  0,  1,  2,  3,  3, -4, -3, -1,  0,  1,  2,  3,  3,
   -5, -3, -1,  0,  1,  2,  3,  3, -5, -3, -1,  0,  1,  2,  3,  3,
   -5, -3, -1,  0,  1,  1,  2,  3, -5, -3, -2, -1,  0,  1,  2,  3,
    4,  4,  5,  5,  6,  6,  7,  7,  2,  2,  2,  3,  3,  4,  4,  4,
    0,  0,  0,  0,  1,  1,  1,  2, -2, -2, -2, -2, -1, -1, -1,  0,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
   -1, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, -2, -2,
    5,  3,  1, -1, -2, -3, -3, -3,  5,  3,  1, -1, -2, -3, -3, -3,
    5,  3,  1, -1, -2, -3, -3, -3,  5,  3,  1, -1, -2, -3, -3, -3,
    5,  4,  1,  0, -2, -3, -3, -3,  6,  4,  2,  0, -2, -2, -3, -3,
    6,  4,  2,  0, -1, -2, -2, -3,  6,  4,  2,  1, -1, -2, -2, -2,
   -1,  1,  3,  3,  2,  0, -3, -6, -1,  1,  3,  4,  3,  0, -3, -6,
   -1,  1,  4,  4,  3,  1, -3, -6, -1,  1,  3,  4,  3,  1, -3, -6,
   -2,  1,  3,  4,  3,  1, -3, -6, -2,  1,  3,  4,  3,  1, -3, -7,
   -2,  1,  3,  3,  2,  0, -3, -7, -2,  0,  2,  3,  2,  0, -3, -6,
   10,  9,  8,  6,  6,  5,  4,  4,  6,  5,  4,  3,  2,  2,  2,  1,
    2,  1,  0, -1, -2, -2, -2, -1, -1, -2, -3, -4, -4, -4, -4, -3,
   -2, -3, -4, -4, -5, -4, -4, -3, -2, -2, -3, -3, -3, -3, -2, -2,
   -1, -1, -1, -1, -1, -1, -1,  0,  1,  1,  1,  1,  1,  1,  1,  2,
   -2, -1,  1,  2,  4,  5,  7,  8, -3, -2,  0,  1,  3,  5,  7,  8,
   -4, -3, -1,  0,  2,  4,  6,  7, -5, -4, -2, -1,  1,  3,  5,  7,
   -6, -5, -3, -2,  0,  2,  4,  6, -6, -5, -4, -2, -1,  1,  3,  5,
   -7, -6, -5, -3, -2,  0,  2,  3, -8, -7, -5, -4, -3, -1,  1,  2,
   11,  9,  7,  5,  3,  1, -1, -1, 10,  8,  6,  3,  1,  0, -2, -2,
    9,  7,  5,  2,  0, -2, -3, -4,  8,  6,  3,  1, -1, -3, -4, -4,
    6,  4,  2, -1, -3, -4, -5, -5,  5,  3,  0, -2, -4, -5, -6, -6,
    3,  1, -1, -3, -5, -6, -7, -7,  2,  0, -2, -4, -6, -6, -7, -7,
    5,  6,  7,  7,  7,  8,  8,  8,  3,  4,  5,  5,  6,  6,  6,  6,
    0,  2,  2,  3,  4,  4,  4,  5, -2, -1,  0,  1,  2,  2,  3,  3,
   -4, -3, -2, -1,  0,  1,  1,  2, -6, -5, -4, -3, -2, -2, -1,  0,
   -8, -7, -6, -6, -5, -4, -3, -3,-10, -9, -8, -8, -7, -6, -6, -5,
    6,  5,  3,  1, -1, -3, -6, -8,  6,  5,  4,  2, -1, -3, -6, -8,
    6,  5,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2,  0, -3, -6, -8,
    6,  6,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2,  0, -3, -6, -8,
    6,  5,  4,  2,  0, -3, -6, -8,  6,  5,  4,  2, -1, -3, -5, -8,
   11, 10,  9,  8,  7,  6,  5,  4,  8,  8,  7,  6,  5,  4,  3,  2,
    6,  5,  4,  4,  2,  2,  1,  0,  3,  3,  2,  1,  0,  0, -1, -2,
    1,  1,  0, -1, -2, -2, -3, -3, -1, -1, -2, -3, -4, -4, -5, -5,
   -3, -4, -4, -5, -6, -6, -7, -7, -5, -5, -6, -7, -8, -8, -8, -8,
  -14,-13,-12,-11, -9, -7, -6, -4,-12,-11,-10, -9, -7, -5, -3, -1,
  -10, -9, -7, -6, -3, -2,  0,  2, -8, -6, -4, -2,  0,  2,  4,  5,
   -5, -3,  0,  2,  4,  5,  7,  8, -2,  0,  2,  4,  6,  8,  9, 10,
    0,  3,  5,  7,  8, 10, 11, 12,  3,  5,  7,  8, 10, 11, 12, 12,
  -19,-19,-18,-18,-17,-16,-15,-14,-15,-15,-14,-13,-12,-11,-10, -9,
  -11,-10, -9, -8, -6, -5, -4, -3, -6, -5, -3, -2, -1,  0,  1,  2,
   -1,  0,  2,  3,  4,  5,  6,  6,  4,  6,  7,  8,  9, 10, 10, 10,
    9, 10, 11, 12, 13, 14, 14, 14, 12, 14, 14, 15, 16, 16, 16, 16,
   22, 21, 19, 17, 14, 11,  9,  5, 20, 19, 17, 14, 11,  8,  4,  1,
   17, 15, 13, 10,  6,  3,  0, -4, 13, 11,  8,  5,  1, -2, -5, -9,
    9,  6,  3, -1, -4, -7,-11,-13,  4,  0, -3, -6, -9,-12,-15,-17,
   -2, -5, -8,-11,-14,-16,-18,-20, -8,-10,-13,-16,-17,-19,-21,-22,
   17, 18, 18, 18, 17, 16, 16, 14, 16, 16, 15, 15, 14, 13, 12, 11,
   12, 12, 11, 10,  9,  8,  7,  5,  7,  6,  6,  4,  3,  2,  1, -1,
    1,  0, -1, -2, -3, -4, -5, -6, -5, -6, -7, -8, -9,-10,-11,-12,
  -11,-12,-13,-14,-15,-16,-16,-17,-16,-17,-17,-18,-19,-20,-20,-20,
    0,  0,  0,  0, -1, -1, -2, -3,  1,  0,  0,  0,  0, -1, -2, -3,
    1,  1,  0,  0, -1, -1, -2, -2,  1,  1,  1,  0,  0, -1, -1, -2,
    2,  1,  1,  1,  0, -1, -1, -2,  2,  2,  1,  1,  0,  0, -1, -2,
    2,  2,  1,  1,  1,  0, -1, -1,  2,  2,  1,  1,  1,  0,  0, -2,
    0, -1, -1,  0,  0,  1,  2,  3,  0, -1, -1,  0,  1,  1,  2,  2,
   -1, -1, -1, -1,  0,  1,  2,  2, -1, -1, -2, -1,  0,  1,  1,  2,
   -1, -2, -2, -1,  0,  0,  1,  2, -1, -2, -2, -2, -1,  0,  1,  2,
   -1, -1, -2, -1,  0,  0,  1,  2, -1, -1, -1, -1,  0,  1,  1,  2,
    3,  2,  2,  2,  1,  1,  0,  0,  3,  2,  2,  2,  2,  1,  0,  0,
    2,  2,  2,  1,  1,  1,  0,  0,  2,  2,  1,  1,  1,  0,  0, -1,
    1,  1,  1,  0,  0,  0, -1, -1,  0,  0, -1, -1, -1, -1, -1, -1,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -2, -2, -2, -2,
    5,  2,  0,  0, -1,  0,  0,  0,  4,  2,  0, -1, -1, -1,  0, -1,
    4,  1, -1, -1, -2, -1, -1, -1,  4,  1, -1, -1, -2, -1, -1, -1,
    4,  1, -1, -2, -2, -1, -1, -1,  4,  1, -1, -2, -2, -1, -1, -1,
    4,  1, -1, -1, -1, -1, -1, -1,  4,  2,  0, -1,  0,  0,  0, -1,
   -2, -1,  0,  1,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  1,  1,
   -3, -1,  0,  1,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  1,  1,
   -3, -2,  0,  1,  2,  2,  1,  1, -4, -2,  0,  1,  2,  2,  2,  2,
   -5, -3, -1,  1,  1,  2,  1,  2, -5, -3, -2,  0,  1,  1,  1,  1,
    3,  3,  1,  0, -2, -4, -4, -5,  3,  3,  2,  0, -1, -2, -3, -4,
    2,  2,  1,  1,  0, -1, -2, -2,  1,  1,  1,  1,  1,  0,  0,  0,
    0,  0,  0,  1,  1,  1,  1,  1, -2, -1, -1,  0,  0,  1,  2,  2,
   -3, -2, -2, -1,  0,  1,  2,  3, -3, -3, -2, -1,  0,  1,  2,  3,
   -3, -3, -3, -3, -3, -2, -2, -2, -3, -3, -2, -2, -2, -1, -1, -1,
   -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,
    0,  0,  0,  0,  1,  1,  1,  1,  0,  0,  1,  1,  2,  2,  2,  2,
    1,  1,  1,  2,  2,  3,  3,  3,  2,  2,  2,  2,  3,  3,  3,  3,
   -8, -7, -5, -3, -2, -1,  0, -1, -4, -3, -1,  0,  1,  2,  1,  1,
   -1,  1,  2,  3,  3,  2,  2,  1,  1,  2,  3,  3,  2,  2,  1,  0,
    2,  3,  3,  2,  1,  0,  0, -1,  1,  2,  1,  0, -1, -1, -1, -1,
    1,  1,  0, -1, -1, -2, -2, -1,  1,  1,  0,  0, -1, -1,  0, -1,
   -4, -3, -2,  0,  1,  2,  3,  3, -4, -3, -2,  0,  1,  2,  2,  2,
   -3, -3, -2, -1,  0,  1,  1,  1, -2, -2, -2, -1, -1,  0,  0,  0,
    0, -1, -1, -1, -1, -1, -1, -1,  2,  1,  1,  0,  0, -1, -1, -2,
    3,  3,  3,  1,  0, -1, -2, -2,  5,  4,  4,  2,  1,  0, -1, -2,
    0,  0,  0,  0,  1,  2,  3,  3,  0, -1,  0,  0,  1,  2,  3,  3,
    0, -1,  0,  0,  1,  2,  3,  2,  0,  0,  0,  1,  1,  2,  2,  2,
    2,  1,  1,  1,  1,  1,  1,  0,  2,  2,  2,  1,  0,  0, -1, -2,
    2,  1,  0,  0, -2, -3, -5, -6,  0, -1, -1, -3, -5, -6, -8, -9,
   -2,  0,  1,  2,  2,  1, -1, -4, -2,  0,  2,  2,  2,  1, -1, -4,
   -2,  0,  2,  2,  2,  1, -1, -3, -2,  0,  2,  2,  2,  1, -1, -3,
   -2, -1,  2,  2,  2,  1, -1, -3, -2, -1,  1,  2,  2,  1, -1, -3,
   -3, -1,  1,  2,  2,  1, -1, -3, -2, -1,  1,  2,  2,  1, -1, -3,
   -1,  1,  1, -1, -3, -3,  0,  4, -1,  1,  1, -1, -3, -3,  0,  4,
   -1,  1,  1,  0, -3, -3,  0,  4, -1,  1,  2,  0, -3, -3,  0,  5,
    0,  1,  2,  0, -3, -4,  0,  4,  0,  1,  2,  0, -3, -4,  0,  5,
    0,  1,  2,  0, -3, -3,  0,  4,  0,  1,  2, -1, -2, -2,  0,  4,
    6,  6,  5,  6,  5,  5,  5,  5,  2,  2,  2,  2,  2,  2,  2,  2,
    0,  0,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1, -2, -2, -2, -2,
   -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2,
   -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    2,  2,  2,  2,  2,  2,  2,  2,  0,  1,  1,  0,  0,  0,  0,  0,
   -1, -2, -2, -2, -2, -2, -2, -1, -3, -3, -3, -3, -3, -3, -3, -2,
   -3, -4, -4, -3, -3, -3, -2, -2, -2, -2, -2, -2, -1, -1,  0,  0,
    0,  1,  1,  1,  2,  2,  3,  3,  3,  4,  4,  5,  5,  6,  6,  6,
    4,  1, -2, -3, -3, -1,  1,  3,  4,  1, -2, -4, -3, -1,  1,  3,
    5,  1, -2, -4, -3, -1,  1,  4,  5,  1, -2, -3, -3, -1,  2,  4,
    5,  1, -2, -3, -3, -1,  2,  4,  4,  0, -3, -4, -3, -1,  2,  4,
    4,  0, -3, -3, -3, -1,  1,  3,  3,  0, -2, -3, -2, -1,  1,  3,
   -3, -4, -4, -4, -4, -4, -4, -4, -1, -1, -1, -1, -1, -1, -2, -2,
    2,  1,  1,  2,  2,  1,  1,  1,  3,  3,  3,  4,  4,  3,  3,  3,
    3,  3,  3,  4,  4,  4,  3,  3,  1,  2,  1,  2,  2,  2,  2,  2,
   -2, -2, -2, -1, -1, -1,  0,  0, -4, -4, -4, -4, -3, -3, -3, -3,
   -1, -2, -3, -3, -2, -2, -1,  0,  0, -1, -2, -2, -2, -1,  0,  1,
    2,  1, -1, -1, -1, -1,  0,  1,  3,  1,  0, -1, -1,  0,  0,  1,
    3,  2,  0, -1,  0,  0,  0,  1,  3,  1,  0, -1,  0,  0,  0,  1,
    3,  1,  0, -1,  0,  0,  0,  1,  2,  1,  0,  0,  0,  0,  0,  1,
    0,  0,  0,  1,  1,  2,  3,  4,  0,  0, -1,  0,  0,  0,  2,  3,
    0, -1, -1, -1, -1, -1,  0,  1,  0, -1, -1, -1, -1, -1, -1,  0,
    0,  0, -1, -1, -1, -2, -2, -1,  1,  0,  0, -1, -1, -2, -2, -1,
    2,  2,  1,  0, -1, -1, -1, -1,  3,  3,  2,  1,  0, -1, -1,  0,
    1,  0,  1,  0,  0, -1, -2, -1,  0,  0,  0,  0, -1, -1, -2, -1,
    0, -1,  0,  0, -1, -1, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0,
   -1, -1, -1,  0,  0,  0,  1,  1, -1, -1, -1,  0,  1,  1,  2,  3,
   -2, -2, -1,  0,  1,  2,  3,  4, -2, -2, -1,  0,  1,  2,  4,  5,
   -3, -1,  1,  0,  0, -1,  0,  1, -3,  0,  1,  0, -1, -1,  0,  2,
   -3,  0,  1,  0, -1, -1,  0,  2, -2,  1,  2,  0, -1, -1,  0,  2,
   -2,  1,  2,  0, -1, -1,  0,  2, -2,  1,  2,  0, -1, -1,  0,  2,
   -1,  2,  2,  0, -1, -1,  0,  2, -1,  1,  1,  0, -1, -1, -1,  1,
   -2, -2, -1,  1,  3,  4,  3,  1, -2, -2, -1,  0,  2,  3,  2,  0,
   -2, -2, -1,  0,  1,  2,  1, -1, -1, -1, -1,  0,  1,  2,  1, -1,
   -1, -1, -1,  0,  1,  1,  0, -2,  0, -1, -1,  0,  1,  1,  0, -1,
    0, -1, -1,  0,  1,  1,  1, -1,  0, -1, -1,  0,  0,  1,  0, -1,
   -2, -1,  0,  1,  1,  1,  1,  1, -2, -1,  0,  0,  0,  0,  0,  0,
   -2, -1, -1,  0, -1, -1, -2, -2, -2, -1, -1, -1, -1, -2, -2, -3,
   -1,  0,  1,  1,  0, -1, -2, -2,  1,  2,  3,  3,  2,  1,  0,  0,
    1,  2,  3,  3,  3,  2,  1,  0,  0,  0,  1,  1,  1,  1,  0,  0,
    0, -1, -1, -1,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  2,  2,  1,  1,  1,  1,
    1,  1,  1,  1,  1,  1,  1,  1, -1,  0,  0,  1,  1,  0,  0,  0,
   -3, -2, -1, -1, -1, -1,  0, -1, -5, -5, -4, -3, -2, -2, -2, -1,
    1,  1,  1,  1,  2,  1,  0, -1,  1,  1,  1,  2,  1,  1,  0, -1,
    1,  1,  1,  1,  1,  1,  0, -2,  2,  1,  1,  1,  1,  1,  0, -2,
    1,  1,  0,  0,  0,  0, -1, -3,  1,  1,  0,  0,  0, -1, -2, -3,
    1,  1,  0,  0, -1, -1, -2, -4,  1,  0,  0, -1, -2, -2, -3, -4,
    8,  7,  5,  3,  2,  1,  1,  1,  2,  1,  0,  0, -1, -1, -2, -1,
   -1, -1, -1, -2, -2, -2, -2, -1, -1, -1, -1, -1,  0, -1, -1,  0,
    0,  0,  0,  1,  1,  0,  0,  0,  0,  0,  1,  1,  1,  0,  0,  0,
   -1,  0,  0,  0,  0,  0, -1, -1, -2, -2, -1, -1, -1, -2, -2, -1,
    9,  4,  0, -2, -2, -2, -1, -1,  7,  2, -1, -2, -2, -1,  0,  0,
    4,  0, -2, -2, -1,  0,  1,  1,  1, -2, -2, -2, -1,  0,  1,  1,
   -1, -2, -2, -1,  0,  1,  1,  1, -1, -2, -1,  0,  1,  1,  1,  0,
   -1, -1,  0,  1,  1,  1,  0, -1,  0, -1,  0,  1,  0,  0, -1, -1,
    0,  1,  1,  1,  1,  1,  0,  0,  1,  2,  2,  2,  1,  0,  0,  0,
    2,  2,  2,  2,  1,  0, -1, -1,  1,  1,  1,  0, -1, -2, -2, -2,
    0,  0,  0, -1, -2, -3, -2, -2, -1, -1, -1, -2, -2, -2, -1,  0,
   -1, -1, -1, -1,  0,  0,  1,  2, -1, -1, -1,  0,  1,  2,  3,  4,
   -1, -1,  0,  0, -1, -2, -3, -3, -1, -1,  0,  0,  0, -1, -1, -1,
   -2, -2, -1,  0,  1,  1,  1,  1, -2, -2, -2,  0,  1,  2,  3,  3,
   -1, -1, -1,  0,  1,  3,  3,  3,  1,  0,  0,  0,  1,  1,  2,  2,
    2,  2,  1,  0,  0, -1, -1, -1,  3,  2,  1,  0, -1, -2, -3, -3,
   -1, -1, -1, -2, -2, -3, -4, -5,  0,  0,  0, -1, -1, -3, -3, -4,
    1,  1,  1,  0,  0, -1, -2, -3,  2,  2,  2,  1,  1,  0, -1, -1,
    2,  2,  2,  2,  1,  1,  0, -1,  2,  2,  2,  2,  2,  1,  0,  0,
    1,  1,  2,  1,  1,  1,  0,  0,  0,  0,  1,  1,  0,  0,  0, -1,
   -2,  2,  3,  1, -1,  1,  1, -1, -3,  2,  3,  0, -1,  1,  1, -1,
   -3,  2,  3,  0, -1,  1,  1, -1, -4,  2,  3,  0, -1,  1,  1, -2,
   -4,  1,  3,  0, -1,  1,  1, -2, -4,  1,  3, -1, -2,  1,  1, -2,
   -3,  1,  2,  0, -1,  1,  1, -2, -3,  1,  2,  0, -1,  1,  1, -1,
   -1, -1, -1, -2, -2, -2, -2, -2,  1,  1,  1,  1,  0,  0,  0,  0,
    1,  2,  2,  2,  2,  2,  2,  2,  0,  0,  1,  1,  1,  2,  2,  2,
   -2, -2, -1, -1, -1,  0,  0,  0, -3, -3, -3, -3, -3, -3, -3, -2,
   -1, -1, -1, -1, -2, -2, -2, -2,  4,  4,  4,  4,  4,  3,  3,  2,
   -3, -3, -2, -1,  0,  1,  2,  5, -3, -3, -3, -2, -1,  1,  3,  6,
   -3, -3, -2, -2,  0,  2,  3,  5, -3, -2, -2, -2,  0,  1,  3,  5,
   -2, -2, -2, -1, -1,  1,  3,  5, -2, -2, -1, -1,  0,  1,  2,  4,
   -1, -1, -1, -1,  0,  1,  1,  4, -1, -1, -1, -1,  0,  1,  2,  3,
    0, -1,  0,  1,  1,  0, -1, -1,  0,  0,  0,  1,  2,  0, -1, -1,
    1,  0, -1,  0,  1,  0,  0,  0,  1, -1, -2, -1,  0,  0,  0,  0,
    1, -2, -3, -1,  0,  0,  0,  1,  1, -1, -3, -2,  0,  1,  1,  2,
    1, -1, -2, -1,  0,  1,  1,  2,  2,  0, -1,  0,  1,  1,  2,  2,
    1,  1,  1,  1,  0,  0,  1,  2, -1,  0,  0, -1,  0,  0,  0,  1,
   -3, -2, -1, -1, -1,  0,  1,  1, -4, -2, -1,  0,  0,  1,  1,  1,
   -3, -2,  0,  0,  1,  1,  1,  1, -3, -1,  0,  1,  1,  1,  0,  0,
   -1,  0,  1,  1,  1,  0,  0, -1,  0,  1,  2,  2,  1,  0,  0, -1,
   -4, -4, -4, -3, -2, -1, -1, -1, -2, -2, -2, -1,  0,  0,  0,  0,
   -1,  0,  0,  0,  1,  1,  1,  1,  0,  0,  1,  1,  1,  1,  1,  1,
    0,  0,  1,  1,  2,  2,  1,  0,  0,  0,  1,  1,  1,  1,  1,  0,
    0,  0,  0,  1,  1,  1,  1,  0, -1,  0,  0,  1,  1,  1,  0,  0,
    1,  2,  2,  2,  1, -1, -2, -4,  1,  1,  2,  2,  1,  0, -2, -4,
    0,  1,  1,  1,  1,  0, -1, -3, -1,  0,  1,  1,  0,  0, -1, -2,
   -1,  0,  1,  1,  1,  0,  0, -1, -2, -1,  0,  0,  0,  0,  0, -1,
   -1, -1,  0,  1,  1,  0,  0,  0, -1,  0,  1,  1,  1,  1,  1,  0,
    2,  2,  0, -1, -2, -1, -1, -2,  1,  1, -1, -2, -2, -1, -1, -2,
    1,  1, -1, -2, -2,  0,  0, -1,  1,  1,  0, -2, -1,  1,  1,  0,
    1,  1,  0, -1, -1,  1,  2,  1,  1,  1,  0, -1, -1,  1,  2,  1,
    1,  1,  0, -1, -1,  1,  1,  1,  1,  1,  0, -1,  0,  1,  1,  1,
    0,  0, -1, -2, -4, -4, -4, -4,  3,  3,  3,  2,  1,  0,  0,  0,
    3,  3,  3,  3,  2,  2,  2,  2,  0,  0,  0,  0,  0,  0,  0,  1,
   -1, -1, -1, -1, -1, -1, -1,  0,  0, -1,  0,  0, -1,  0,  0,  0,
    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, -1, -1,  0,
   -1, -1,  0, -1, -1,  1,  2, -1,  1,  1,  0,  0,  0,  2,  3, -1,
    1,  1,  0, -1, -1,  1,  3, -1,  1,  1,  0, -2, -2,  0,  1, -2,
    1,  0,  0, -2, -2,  0,  1, -3,  0,  0,  0,  0, -1,  1,  1, -3,
    0,  1,  1,  0,  1,  2,  1, -3, -1,  0,  1,  1,  1,  2,  1, -4,
   -4, -3,  0,  1,  1,  1,  0,  0, -4, -2,  0,  1,  1,  1,  0, -1,
   -3, -1,  1,  1,  1,  0, -1, -1, -1,  1,  1,  1,  1,  0, -1,  0,
    1,  2,  2,  1,  0, -1,  0,  0,  2,  2,  1,  0, -1, -1,  0,  1,
    2,  1,  0, -1, -2, -1,  0,  1,  2,  2,  0, -1, -2, -1,  1,  1,
    1,  1,  0,  0, -1, -1, -1, -1,  0, -1, -1, -1, -1, -1, -1, -1,
   -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -1, -1, -1, -1, -1,
    1,  0,  0, -1, -1, -1, -1, -1,  2,  1,  0,  0, -1, -1, -1, -1,
    5,  3,  2,  1,  0,  0,  0,  0,  6,  5,  3,  2,  1,  0,  0,  0,
    4,  4,  3,  1,  0,  0,  0,  1,  3,  3,  2,  1,  0,  0,  0,  1,
    2,  2,  1,  0, -1, -1,  0,  1,  0,  0,  0, -1, -1, -1,  0,  1,
    0,  0, -1, -1, -2, -1,  0,  2,  0, -1, -1, -2, -2, -2,  0,  1,
    0, -1, -1, -2, -2, -2, -1,  0,  0,  0, -1, -2, -2, -2, -1,  0,
    0,  0, -1, -1, -1,  0,  2,  3,  0, -1, -2, -2, -1, -1,  1,  2,
    1,  0, -1, -1, -1,  0,  0,  0,  1,  1,  1,  0,  0,  0, -1, -1,
    1,  2,  1,  0,  0, -1, -1, -1, -1,  0,  0,  0, -1, -1, -1, -1,
   -3, -2, -1, -1,  0,  1,  1,  2, -4, -3, -1,  1,  2,  3,  5,  5,
    0,  0,  0,  0,  0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,
    0,  0,  0, -1,  0,  0,  0,  1, -1, -1, -2, -2, -2, -1, -1,  0,
    0,  0,  0,  0,  0,  1,  1,  1,  2,  2,  2,  2,  2,  3,  3,  3,
    1,  1,  1,  1,  2,  2,  1,  1, -4, -3, -4, -4, -4, -4, -3, -3,
   -1,  0,  1,  2,  2,  3,  3,  3, -1, -1, -1, -1,  0,  0,  0,  0,
    0,  0, -1, -2, -2, -3, -3, -2,  3,  2,  1,  0, -1, -2, -2, -2,
    4,  3,  2,  1,  1,  0,  0,  0,  2,  2,  1,  1,  0,  1,  1,  1,
    0, -1, -1, -1, -1,  0,  0,  1, -2, -2, -2, -2, -2, -1,  0,  0,
    1, -1,  0,  2,  1, -2, -1,  1,  1, -1,  0,  2,  1, -2, -2,  1,
    1, -1,  0,  3,  2, -2, -1,  1,  0, -2,  0,  3,  2, -2, -2,  1,
    0, -2,  0,  3,  2, -2, -2,  1,  0, -2,  0,  3,  1, -2, -1,  1,
    0, -2,  0,  2,  1, -2, -2,  1,  0, -1,  0,  2,  1, -2, -1,  1,
    0,  1,  2,  2,  3,  3,  2,  2,  0,  1,  1,  2,  3,  3,  2,  1,
    0,  0,  1,  2,  2,  2,  2,  1, -1,  0,  0,  1,  1,  1,  1,  1,
   -1, -1,  0,  0,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1, -1, -1,
   -2, -2, -2, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -1,
    0,  0, -1, -2, -1,  0,  3,  5,  0,  0, -1, -1, -1,  0,  2,  4,
    1,  1,  0,  0, -1, -1,  1,  2,  1,  2,  1,  1,  0, -1, -1,  0,
    0,  1,  2,  1,  0, -1, -2, -2, -1,  0,  1,  2,  1,  0, -3, -3,
   -2, -1,  1,  2,  2,  0, -2, -4, -2, -1,  0,  2,  2,  1, -1, -3,
    0,  0,  0,  0,  0,  0, -1, -1,  0,  0, -1,  0,  0,  0,  0,  0,
   -1, -1, -1, -1,  0,  0,  0,  0, -1, -1, -1, -1, -1, -1, -1,  0,
   -1, -1, -1, -1, -1, -1, -1,  0, -1,  0,  0,  0,  0, -1, -1,  0,
    0,  0,  1,  1,  0,  0,  0,  1,  3,  3,  3,  4,  3,  3,  3,  3,
    5,  1, -2, -2,  0,  0,  0, -1,  4, -1, -3, -1,  0,  0,  0, -1,
    3, -1, -1,  0,  1,  1,  0, -1,  2,  0,  0,  1,  1,  1,  0, -2,
    1,  0,  0,  1,  1,  1,  0, -2,  0, -1, -1, -1,  0,  0,  0, -1,
    0, -1, -1, -1, -1,  0,  0, -1,  2,  1,  0,  0,  0,  1,  0,  0,
    1,  0,  1,  1,  1,  1,  0,  0,  1,  0,  0,  1,  1,  0,  0,  0,
    1, -1, -1,  0,  0,  0,  0,  0,  2,  0, -1, -1, -1, -1, -1,  0,
    3,  1, -1, -1, -2, -2, -2, -1,  4,  2,  1,  0, -1, -2, -2, -1,
    2,  1,  0,  0, -1, -1,  0,  0,  0, -1, -1, -1, -1,  0,  1,  1,
    0,  1,  2,  2,  2,  1, -1, -3,  0,  0,  1,  1,  1,  0, -1, -2,
    0,  0,  0,  0,  0,  0, -1, -1,  0,  0, -1,  0,  0,  1,  1,  0,
    0,  0, -1,  0,  1,  1,  1,  1,  0,  0,  0,  0,  1,  1,  1,  0,
    0,  0,  1,  1,  2,  1, -1, -3,  0,  0,  0,  1,  1, -1, -4, -5,
   -2, -2, -2, -1,  0,  2,  2,  2,  0,  0,  0,  0,  1,  1,  1,  0,
    1,  1,  1,  1,  1,  0, -2, -3,  0,  0,  1,  1,  0, -1, -3, -4,
   -1, -1,  0,  1,  0,  0, -2, -3, -1, -1,  0,  1,  1,  1,  0, -1,
    0,  0,  0,  1,  1,  1,  1,  0,  1,  1,  1,  1,  0,  0,  0,  0,
    0,  1,  0,  0,  1,  1,  1,  2,  1,  2,  0,  0,  0,  0, -1,  1,
    0,  2,  0, -1,  1,  0, -1,  0,  0,  1,  0,  0,  2,  1,  0,  1,
    0,  1, -1,  0,  2,  2,  0,  1, -1,  0, -1, -1,  2,  1,  1,  2,
   -2, -2, -3, -2,  0,  1,  1,  1, -2, -2, -3, -3, -1, -1, -1,  0,
   -3, -1,  0,  1,  2,  1,  1,  0, -3, -1,  0,  1,  2,  1,  1,  1,
   -2,  0,  0,  1,  1,  1,  1,  1, -1,  0,  0,  0,  0,  0,  0,  0,
   -2,  0,  0,  0,  0, -1, -1,  0, -2,  0,  0,  0,  0,  0, -1, -1,
   -3,  0,  1,  1,  1,  1,  0,  1, -5, -2,  0,  1,  2,  2,  1,  2,
   -2, -1, -1,  0,  0,  1,  2,  3,  0,  0,  1,  1,  0,  0,  1,  2,
    0,  0,  1,  0, -1, -1,  0,  1, -1, -1, -1, -1, -2, -2, -1,  0,
   -2, -2, -2, -2, -2, -1,  0,  1,  0,  0,  0, -1,  0,  1,  2,  2,
    2,  1,  0,  0,  0,  1,  2,  2,  2,  1,  0, -1, -1, -1,  0,  0,
    0,  1,  1,  1,  1,  1, -1, -4, -1, -1,  0,  1,  1,  1,  0, -3,
   -2, -1,  0,  0,  1,  2,  2, -2, -1,  0,  0,  0,  0,  2,  3, -1,
   -1,  0,  0,  0,  0,  1,  2,  0,  0,  0, -1, -2, -1,  1,  1,  0,
    0,  0, -1, -2, -2,  0,  2,  1,  0,  0, -1, -2, -1,  1,  2,  2,
    1,  0,  0,  0, -2, -3, -2, -3,  0,  0,  1,  0, -2, -2, -1, -1,
    0, -1,  1,  1, -1, -1,  0,  0,  0, -1,  1,  1, -1, -1,  0,  0,
    0,  1,  2,  1, -1, -1,  0,  1,  1,  2,  3,  2,  0,  0,  1,  2,
   -1,  0,  2,  1,  0,  0,  2,  3, -2, -1,  0,  0, -1,  0,  1,  2,
    1,  1,  0, -1, -2, -2, -1,  1,  1,  1,  1, -1, -2, -2,  0,  2,
    1,  1,  1, -1, -1, -1,  0,  2,  0,  0,  0,  0,  0,  0,  1,  2,
   -1, -1, -1,  0,  0,  0,  1,  2, -1, -2, -1,  1,  1,  1,  0,  0,
   -1, -2, -1,  1,  2,  2,  0, -1, -1, -2, -1,  2,  2,  2,  0, -1,
   -1, -1, -1, -2, -1, -1,  0,  1,  0,  0, -1, -1, -1,  0,  1,  2,
    1,  0,  0,  0,  0,  1,  1,  2,  1,  1,  0,  0,  1,  1,  1,  1,
    1,  1,  0,  1,  1,  0,  1,  1,  1,  1,  1,  1,  0, -1, -1, -1,
    1,  2,  1,  0, -1, -2, -2, -3,  2,  2,  1,  0, -2, -3, -4, -4,
   -4, -2,  1,  1,  1,  1,  0,  0, -2,  0,  1,  0,  0,  0,  0,  0,
    0,  1,  1, -2, -2, -1,  0,  1,  2,  2,  1, -2, -2, -1,  1,  2,
    1,  2,  1, -2, -2, -1,  1,  2, -1,  1,  1, -1, -1, -1,  0,  1,
   -2,  0,  1,  1,  0, -1, -1,  0, -2,  0,  2,  2,  1, -1, -1,  0,
    1,  1,  0,  0,  0,  1,  0,  0, -2, -3, -3, -2, -2, -1,  0,  0,
   -3, -4, -3, -2, -1,  0,  0,  0, -1, -1,  0,  1,  2,  3,  2,  1,
    0,  1,  2,  3,  3,  3,  2,  1,  1,  1,  1,  2,  1,  0,  0, -1,
    0,  0,  0,  0, -1, -1, -1, -1,  0, -1, -1,  0,  0,  0,  0,  0,
    1,  1,  0,  0, -1, -1,  0,  2,  0,  0,  1,  0, -1, -1,  1,  1,
   -2, -1,  0,  1,  1,  1,  1,  1, -3, -3,  0,  2,  2,  1,  1,  0,
   -2, -2,  0,  1,  1,  1,  0,  0,  1,  0,  0,  0,  0,  0, -1, -1,
    3,  1, -1, -3, -2, -1,  0,  1,  4,  2, -1, -3, -3, -1,  1,  2,
    0,  0,  0, -1, -1, -1, -1, -1,  1,  2,  1,  0,  0,  0, -1, -1,
    2,  3,  3,  2,  1,  0, -1, -1,  3,  4,  4,  2,  1,  0, -1, -2,
    3,  3,  2,  1,  0, -1, -2, -2,  1,  1,  0, -1, -1, -2, -2, -3,
    0,  0,  0, -1, -1, -2, -2, -2, -1, -1, -1, -1, -1, -2, -2, -1,
    1,  2,  2,  2,  2,  1,  2,  2,  0,  1,  1,  1,  1,  0,  0,  0,
    0,  0,  0,  1,  1,  0, -1, -2,  0,  0,  0,  0,  1,  0, -1, -4,
    1,  0,  0,  0,  0,  0, -2, -5,  1,  0,  0,  0,  0,  0, -1, -4,
    1,  0, -1,  0,  0,  0, -1, -3,  0, -1, -1,  0,  1,  1,  1, -1,
   -2, -1,  0,  0, -1, -1, -1, -2, -1,  0,  0,  0, -1, -1, -2, -2,
    0,  1,  1,  0, -1, -1, -1, -2,  0,  1,  1,  0,  0,  0, -1, -1,
    0,  1,  0,  0,  1,  1,  1,  0,  1,  1,  0,  0,  1,  2,  2,  1,
    1,  1,  0,  0,  1,  2,  2,  1,  1,  1,  0, -1,  0,  1,  1,  0,
    4,  2,  1,  0,  0,  1,  1,  1,  4,  2,  1,  0,  0,  0,  0,  1,
    3,  1,  0,  0, -1, -1, -1,  0,  1,  0,  0, -1, -1, -2, -1,  0,
    0,  0,  0,  0, -1, -1, -1,  0, -1, -1,  0,  0, -1, -1,  0,  1,
   -2, -1,  0, -1, -1,  0,  0,  1, -2, -2, -1, -2, -1,  0,  0,  1,
    0,  1,  1,  1,  2,  1,  0, -1, -1, -1, -1,  0,  0, -1, -2, -2,
   -1,  0, -1,  0,  0, -1, -2, -1,  0,  0,  0,  0,  0,  0,  1,  2,
    0,  0,  0,  0,  0,  0,  2,  3, -1,  0, -1, -1, -1, -1,  0,  3,
   -1,  0,  0, -1, -1, -2,  0,  3,  0,  0,  0,  0, -1, -1,  1,  4,
    2,  2,  0,  0,  0,  0,  0,  1,  1,  1, -1, -2, -1, -2, -1,  1,
   -1, -1, -2, -2, -2, -3, -2,  0, -1,  0, -1, -1, -1, -2, -1,  1,
    1,  1,  0,  0,  1,  0,  0,  1,  2,  2,  0,  0,  1,  0,  0,  1,
    2,  2,  0,  0,  0,  0, -1, -1,  2,  2,  0,  0,  1,  0, -1, -1,
   -1,  0,  1,  1,  0, -1, -1, -1,  1,  2,  3,  2,  1,  0,  0,  0,
    0,  1,  1,  1,  0, -1,  0,  0, -2, -2, -1,  0,  1,  0,  0,  0,
   -2, -2, -1,  2,  2,  2,  1,  0, -2, -1,  0,  1,  1,  0,  0, -1,
   -1, -1,  0,  0, -1, -2, -1, -2,  0,  1,  1,  1,  0,  0,  1,  1,
   -3, -3, -3, -2, -1, -1, -2, -2, -1, -1,  0,  1,  2,  1,  0,  0,
    1,  1,  1,  2,  2,  1,  0,  0,  1,  1,  1,  1,  1,  0, -1,  1,
    1,  0, -1, -1,  0,  0, -1,  1,  0, -1, -1, -1,  0, -1, -1,  1,
    1,  0, -1,  0,  0, -1,  0,  2,  2,  0, -1,  0,  0,  0,  0,  2,
    1,  0, -2, -1,  0,  1,  1,  0,  2,  0, -1, -1,  0,  1,  1,  0,
    1,  0, -2, -1,  0,  1,  0, -1,  1,  0, -1, -1,  0,  1,  0, -1,
    0,  1,  1,  0,  1,  1,  0,  0, -2,  1,  2,  1,  0,  0,  0,  1,
   -5,  0,  2,  1,  0, -1,  0,  1, -6, -1,  2,  1,  0, -1,  0,  0,
    5,  3,  0, -1, -2, -1, -1, -1,  1,  1,  0, -1, -1,  0, -1, -1,
   -1,  0,  1,  1,  2,  2,  1,  0, -2, -1,  0,  1,  2,  1,  1,  1,
   -2, -1, -1, -1,  0, -1,  0,  1,  0,  1,  0,  0, -1, -1,  0,  0,
    0,  1,  1,  1,  1,  0,  0,  0, -3, -2,  0,  1,  1,  0,  0, -1,
   -1,  0,  1,  0, -1,  0,  2,  3, -1,  0,  0, -2, -4, -2, -1,  0,
    0,  1,  1,  0, -2, -1,  0, -1,  1,  2,  3,  1,  0,  1,  1,  0,
   -1,  0,  1,  1,  1,  1,  1,  0, -2, -3, -2,  0,  0,  0,  1,  0,
   -1, -2, -2,  0,  1,  0,  0, -1,  3,  1,  0,  0,  1,  0, -1, -1,
   -2, -1,  0,  0, -1, -1,  0,  0, -1,  0,  0,  0,  0,  1,  1,  1,
   -1, -1, -1,  0,  1,  1,  1,  1,  0, -2, -3, -1,  1,  0,  0,  0,
    1, -1, -3, -1,  1,  1,  0, -1,  3,  1, -1,  1,  2,  2,  0, -1,
    3,  1,  0,  1,  2,  1,  1,  0,  0, -2, -2, -1, -1,  0,  0,  0,
    1,  0, -1, -1,  1,  2,  1,  0,  0, -1, -2, -1,  1,  2,  2,  1,
   -1, -1, -1,  0,  0,  1,  2,  0, -2,  0,  0,  0,  0,  0,  1, -1,
   -1,  0,  1,  0, -1, -1, -1, -1,  0,  1,  1,  2,  0, -2, -1,  0,
    1,  2,  2,  2,  1, -1, -1,  0,  0,  1,  1,  1,  0, -2, -2, -1,
    0,  0, -1, -1, -1, -1, -2, -2,  0,  0, -1,  0,  1,  2,  2,  1,
    0,  0, -1, -1,  0,  1,  2,  2,  1,  1, -1, -2, -1, -1, -1, -1,
    2,  2,  1,  0,  0, -1, -2, -2,  1,  2,  2,  1,  0,  0, -2, -2,
    0,  0,  0,  0,  1,  1,  0, -1,  0, -1, -1, -1,  2,  3,  2,  1,
    0, -2,  1,  2, -1,  0,  0,  1, -1, -2,  2,  3, -1,  0,  0,  0,
    0, -2,  2,  3, -1, -1,  0,  0,  0, -1,  3,  2, -2,  0,  1,  0,
    0, -1,  3,  1, -2,  0,  1,  0,  0, -1,  2,  1, -1,  1,  0, -1,
    0,  0,  1, -1, -2,  0,  0, -1,  1,  0,  0, -2, -2, -1, -1, -1,
    1,  1,  1,  1,  1, -1, -1, -2,  0,  0,  0,  1,  1,  1,  1,  1,
    0,  0,  0,  1,  1,  1,  2,  3,  1,  0,  0, -1,  0,  0,  1,  2,
    0, -1, -1, -2, -1,  0,  1,  2, -2, -2, -2, -2, -1,  0,  1,  1,
   -1, -1, -1, -1,  0,  0,  0, -1,  2,  2,  2,  0, -1, -1, -2, -4,
   -1, -2, -1, -1,  0,  1,  2,  3, -1, -1, -1, -1,  0,  1,  2,  3,
    1,  0, -1,  0, -1,  0,  1,  2,  1,  0,  0,  0, -1,  0,  2,  2,
    1,  0, -1, -1, -2,  0,  1,  2,  0, -2, -2, -2, -3, -1,  0,  1,
    0, -2, -2, -2, -2, -1,  1,  1,  0,  0,  0,  0,  0,  1,  2,  2
};

static const int8 *const s_svq1IntraCodebooks[6] = {
    s_svq1IntraCodebook4x2, s_svq1IntraCodebook4x4,
    s_svq1IntraCodebook8x4, s_svq1IntraCodebook8x8,
    0, 0
};

} // End of namespace Video

#endif
