/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//own headers
#include <charsets.h>
#include <helper.h>
#include <gtincl.h>
#include "gsm.h"

//standard headers
#include <string.h>
#include <stdio.h>

ucs4char_t* convert_from_gsm (gsmchar_t* input)  {
  ucs4char_t* retval;
  unsigned int i;
  unsigned int k=0;
  unsigned int g;
    
  retval = mem_alloc((strlen((char*)input)+1)*sizeof(ucs4char_t),1);
  for (i = 0; i < strlen((char*)input); ++i) {
    for (g = 0; gsm_chars[g].gsize != 0; ++g) {
      if (input[i] == gsm_chars[g].gval[0] &&
	  (gsm_chars[g].gsize < 2 ||
	   input[i+1] == gsm_chars[g].gval[1])) {
	break;
      }
    }
    if (gsm_chars[g].gsize == 0) {
      fprintf(stderr,_("Ups, value 0x%02x not found in list of valid GSM characters.\n"),
	      input[i]);
      continue;
    }
    retval[k++] = gsm_chars[g].uval;
    i += (gsm_chars[g].gsize-1);
  }
  retval[k]=0;

  return mem_realloc(retval,(k+1)*sizeof(ucs4char_t));
}
