/*
 *                            COPYRIGHT
 *
 *  cschem - modular/flexible schematics editor - generic graph plotting
 *  Copyright (C) 2023 Tibor 'Igor2' Palinkas
 *
 *  (Supported by NLnet NGI0 Entrust in 2023)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Contact:
 *    Project page: http://repo.hu/projects/sch-rnd
 *    contact lead developer: http://www.repo.hu/projects/sch-rnd/contact.html
 *    mailing list: http://www.repo.hu/projects/sch-rnd/contact.html
 */

#include <librnd/hid/hid.h>
#include <plugins/lib_plot/plot_data.h>

typedef struct plot_preview_s {
	/* config */
	plot_axis_type_t type_x;
	plot_data_t pdata;

	/* runtime state */
	long zoom_x;      /* effective plot data is every (zoom_x)th point of the 1:1 plot data; equals to 2^n */
	double zoom_y;    /* y zoom is independent of the number of data points (x direction); also a divider (for consistency with zoom_x) */

	long wsx, wsy;    /* the gui window's size in effective plot data */
	long wsox, wsoy;  /* the gui window's bottom left pixel within the effective plot data */
} plot_preview_t;

/* This is the expose function to be bound to the preview widget, with
   ->draw_data pointing to csch_plot_preview_t */
void plot_preview_expose(rnd_hid_t *hid, rnd_hid_expose_ctx_t *ctx);
