description: "This profile defines a baseline that aligns to the \"Level 1 - Workstation\"\nconfiguration
    from the Center for Internet Security\xAE Red Hat Enterprise\nLinux 9 Benchmark\u2122,
    v1.0.0, released 2022-11-28.\n\nThis profile includes Center for Internet Security\xAE\nRed
    Hat Enterprise Linux 9 CIS Benchmarks\u2122 content."
extends: null
hidden: ''
metadata:
    version: 1.0.0
    SMEs:
    - marcusburghardt
    - vojtapolasek
    - yuumasato
reference: https://www.cisecurity.org/benchmark/red_hat_linux/
selections:
- coredump_disable_storage
- package_dovecot_removed
- accounts_passwords_pam_faillock_unlock_time
- sysctl_net_ipv4_conf_all_accept_redirects
- firewalld_loopback_traffic_restricted
- sysctl_net_ipv6_conf_all_accept_redirects
- mount_option_var_log_nodev
- file_groupowner_etc_gshadow
- file_owner_grub2_cfg
- no_shelllogin_for_systemaccounts
- file_owner_cron_allow
- dconf_gnome_screensaver_idle_delay
- ensure_root_password_configured
- file_owner_cron_daily
- file_owner_backup_etc_shadow
- mount_option_var_log_audit_noexec
- sshd_set_login_grace_time
- file_owner_cron_hourly
- package_samba_removed
- no_rsh_trust_files
- rsyslog_files_permissions
- account_password_pam_faillock_system_auth
- dconf_gnome_disable_automount_open
- mount_option_var_tmp_noexec
- selinux_not_disabled
- sshd_set_loglevel_verbose
- sysctl_net_ipv4_conf_default_log_martians
- service_systemd-journald_enabled
- package_nftables_installed
- mount_option_var_nodev
- accounts_user_interactive_home_directory_exists
- accounts_tmout
- file_groupowner_etc_issue
- mount_option_var_log_noexec
- file_owner_backup_etc_group
- file_permissions_cron_daily
- file_groupowner_backup_etc_shadow
- file_permissions_home_directories
- file_groupowner_backup_etc_passwd
- set_password_hashing_algorithm_systemauth
- package_mcstrans_removed
- sshd_limit_user_access
- sshd_set_max_sessions
- file_permissions_crontab
- journald_compress
- file_permissions_at_allow
- file_owner_etc_passwd
- mount_option_var_tmp_nodev
- file_owner_backup_etc_passwd
- package_sudo_installed
- root_path_no_dot
- file_permissions_etc_shadow
- file_groupowner_etc_passwd
- mount_option_var_tmp_nosuid
- package_rsync_removed
- accounts_password_pam_retry
- package_firewalld_installed
- package_telnet_removed
- sudo_require_reauthentication
- file_permissions_unauthorized_world_writable
- sysctl_net_ipv4_conf_all_accept_source_route
- chronyd_run_as_chrony_user
- file_at_deny_not_exist
- file_groupowner_crontab
- selinux_confinement_of_daemons
- mount_option_home_nosuid
- file_permissions_cron_weekly
- file_cron_deny_not_exist
- dconf_gnome_disable_autorun
- accounts_password_set_max_life_existing
- file_permissions_etc_group
- accounts_no_uid_except_zero
- disable_host_auth
- file_permissions_ungroupowned
- sshd_disable_empty_passwords
- mount_option_dev_shm_nosuid
- aide_build_database
- file_owner_user_cfg
- package_tftp-server_removed
- sysctl_net_ipv6_conf_all_forwarding
- file_groupowner_backup_etc_gshadow
- accounts_password_all_shadowed
- account_unique_id
- set_nftables_table
- accounts_set_post_pw_existing
- file_groupowner_etc_motd
- file_permissions_cron_d
- grub2_password
- file_groupowner_cron_hourly
- dconf_db_up_to_date
- sysctl_net_ipv4_ip_forward
- file_owner_sshd_config
- file_owner_cron_monthly
- file_permissions_etc_motd
- set_password_hashing_algorithm_logindefs
- mount_option_tmp_nosuid
- no_password_auth_for_systemaccounts
- accounts_password_pam_minclass
- service_rsyslog_enabled
- sshd_set_maxstartups
- file_groupowner_cron_allow
- sudo_add_use_pty
- sysctl_net_ipv6_conf_all_accept_ra
- accounts_maximum_age_login_defs
- file_permissions_etc_issue
- package_httpd_removed
- no_forward_files
- service_firewalld_enabled
- rsyslog_nolisten
- file_owner_etc_group
- accounts_password_pam_pwhistory_remember_password_auth
- group_unique_id
- selinux_policytype
- sysctl_net_ipv4_conf_default_secure_redirects
- file_cron_allow_exists
- file_groupowner_user_cfg
- dconf_gnome_disable_automount
- package_bind_removed
- file_groupowner_cron_weekly
- socket_systemd-journal-remote_disabled
- package_net-snmp_removed
- coredump_disable_backtraces
- enable_authselect
- partition_for_dev_shm
- kernel_module_udf_disabled
- file_groupowner_etc_issue_net
- file_permissions_user_cfg
- service_crond_enabled
- sysctl_net_ipv4_conf_all_send_redirects
- sysctl_net_ipv6_conf_default_accept_ra
- dconf_gnome_screensaver_lock_delay
- configure_ssh_crypto_policy
- account_password_pam_faillock_password_auth
- banner_etc_motd
- file_permissions_backup_etc_gshadow
- file_permissions_etc_passwd
- ensure_pam_wheel_group_empty
- file_permissions_backup_etc_shadow
- journald_storage
- file_owner_crontab
- package_vsftpd_removed
- sudo_custom_logfile
- sshd_disable_x11_forwarding
- file_groupownership_sshd_pub_key
- file_owner_etc_issue_net
- account_disable_post_pw_expiration
- sshd_enable_pam
- sshd_set_keepalive
- sysctl_net_ipv4_tcp_syncookies
- set_firewalld_default_zone
- aide_check_audit_tools
- postfix_network_listening_disabled
- accounts_umask_etc_bashrc
- mount_option_var_log_audit_nodev
- rsyslog_files_groupownership
- service_nfs_disabled
- accounts_minimum_age_login_defs
- file_permissions_grub2_cfg
- dconf_gnome_screensaver_user_locks
- file_permissions_etc_gshadow
- sshd_enable_warning_banner_net
- package_dnsmasq_removed
- file_ownership_sshd_private_key
- file_permissions_sshd_private_key
- no_empty_passwords
- grub2_enable_selinux
- file_permissions_sshd_pub_key
- service_nftables_disabled
- mount_option_var_log_nosuid
- accounts_password_pam_minlen
- file_permissions_cron_allow
- sysctl_net_ipv6_conf_all_accept_source_route
- file_owner_etc_motd
- use_pam_wheel_group_for_su
- rsyslog_filecreatemode
- sysctl_net_ipv4_conf_all_secure_redirects
- file_owner_cron_d
- file_groupowner_sshd_config
- file_owner_etc_gshadow
- accounts_password_pam_pwhistory_remember_system_auth
- file_permissions_etc_issue_net
- package_nginx_removed
- dir_perms_world_writable_sticky_bits
- file_ownership_sshd_pub_key
- mount_option_var_log_audit_nosuid
- package_rsyslog_installed
- accounts_umask_etc_login_defs
- kernel_module_squashfs_disabled
- sysctl_kernel_randomize_va_space
- accounts_user_dot_no_world_writable_programs
- sysctl_net_ipv4_conf_all_rp_filter
- sshd_set_max_auth_tries
- sysctl_net_ipv4_conf_default_accept_redirects
- package_telnet-server_removed
- gnome_gdm_disable_xdmcp
- mount_option_home_nodev
- file_groupownership_home_directories
- sshd_disable_root_login
- mount_option_dev_shm_noexec
- sysctl_net_ipv6_conf_default_accept_source_route
- file_permissions_backup_etc_passwd
- package_cyrus-imapd_removed
- file_permissions_sshd_config
- no_netrc_files
- banner_etc_issue_net
- journald_forward_to_syslog
- package_tftp_removed
- no_empty_passwords_etc_shadow
- package_dhcp_removed
- file_groupowner_at_allow
- mount_option_dev_shm_nodev
- package_aide_installed
- file_permissions_cron_monthly
- mount_option_tmp_noexec
- sysctl_net_ipv4_conf_default_accept_source_route
- package_ftp_removed
- rsyslog_files_ownership
- accounts_password_last_change_is_in_past
- sysctl_net_ipv4_conf_default_rp_filter
- sysctl_net_ipv4_conf_all_log_martians
- sshd_disable_rhosts
- dconf_gnome_login_banner_text
- chronyd_specify_remote_server
- file_groupowner_etc_group
- file_groupowner_backup_etc_group
- sysctl_net_ipv4_conf_default_send_redirects
- file_permissions_backup_etc_group
- file_groupowner_grub2_cfg
- banner_etc_issue
- accounts_umask_etc_profile
- mount_option_tmp_nodev
- file_owner_etc_issue
- package_libselinux_installed
- service_rpcbind_disabled
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses
- accounts_root_path_dirs_no_write
- dconf_gnome_disable_user_list
- file_owner_cron_weekly
- gid_passwd_group_same
- sysctl_net_ipv6_conf_default_accept_redirects
- partition_for_tmp
- mount_option_var_nosuid
- set_password_hashing_algorithm_passwordauth
- package_squid_removed
- sshd_do_not_permit_user_env
- file_owner_backup_etc_gshadow
- dconf_gnome_session_idle_user_locks
- accounts_passwords_pam_faillock_deny
- accounts_password_set_min_life_existing
- file_groupowner_cron_daily
- file_owner_etc_shadow
- package_openldap-clients_removed
- account_unique_name
- sshd_set_idle_timeout
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts
- no_files_unowned_by_user
- file_groupowner_cron_monthly
- ensure_gpgcheck_globally_activated
- firewalld_loopback_traffic_trusted
- configure_crypto_policy
- has_nonlocal_mta
- accounts_root_gid_zero
- dconf_gnome_banner_enabled
- accounts_password_warn_age_login_defs
- accounts_password_set_warn_age_existing
- aide_periodic_cron_checking
- file_groupowner_etc_shadow
- file_groupowner_cron_d
- file_groupownership_sshd_private_key
- file_permissions_cron_hourly
- var_accounts_user_umask=027
- var_accounts_tmout=15_min
- var_account_disable_post_pw_expiration=30
- var_accounts_password_warn_age_login_defs=7
- var_accounts_minimum_age_login_defs=1
- var_accounts_maximum_age_login_defs=365
- var_password_hashing_algorithm=SHA512
- var_password_pam_remember_control_flag=requisite_or_required
- var_password_pam_remember=5
- var_accounts_passwords_pam_faillock_deny=3
- var_accounts_passwords_pam_faillock_unlock_time=900
- var_password_pam_minclass=4
- var_password_pam_minlen=14
- var_pam_wheel_group_for_su=cis
- sshd_idle_timeout_value=15_minutes
- var_sshd_set_keepalive=1
- var_sshd_set_login_grace_time=60
- var_sshd_max_sessions=10
- var_sshd_set_maxstartups=10:30:60
- sshd_max_auth_tries_value=4
- var_nftables_family=inet
- var_nftables_table=firewalld
- sysctl_net_ipv6_conf_all_accept_ra_value=disabled
- sysctl_net_ipv6_conf_default_accept_ra_value=disabled
- sysctl_net_ipv4_tcp_syncookies_value=enabled
- sysctl_net_ipv4_conf_all_rp_filter_value=enabled
- sysctl_net_ipv4_conf_default_rp_filter_value=enabled
- sysctl_net_ipv4_icmp_ignore_bogus_error_responses_value=enabled
- sysctl_net_ipv4_icmp_echo_ignore_broadcasts_value=enabled
- sysctl_net_ipv4_conf_all_log_martians_value=enabled
- sysctl_net_ipv4_conf_default_log_martians_value=enabled
- sysctl_net_ipv4_conf_all_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_default_secure_redirects_value=disabled
- sysctl_net_ipv4_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv4_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_all_accept_redirects_value=disabled
- sysctl_net_ipv6_conf_default_accept_redirects_value=disabled
- sysctl_net_ipv4_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv4_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_all_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_default_accept_source_route_value=disabled
- sysctl_net_ipv6_conf_all_forwarding_value=disabled
- var_postfix_inet_interfaces=loopback-only
- var_multiple_time_servers=rhel
- var_system_crypto_policy=default_policy
- inactivity_timeout_value=15_minutes
- var_screensaver_lock_delay=5_seconds
- remote_login_banner_text=cis_banners
- login_banner_text=cis_banners
- motd_banner_text=cis_banners
- var_selinux_policy_name=targeted
- var_authselect_profile=sssd
unselected_groups: []
platforms: !!set {}
cpe_names: !!set {}
platform: null
filter_rules: ''
policies:
- cis_rhel9
title: CIS Red Hat Enterprise Linux 9 Benchmark for Level 1 - Workstation
definition_location: /home/jcerny/work/git/content/products/rhel9/profiles/cis_workstation_l1.profile
documentation_complete: true
