#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the logging features of the sanitizer.

Also tests the "try" configuration file statement.

tac

(for scratch in 0 50; do
for level in 0 1 2; do

echo
echo "######### feat_log_inline = $level, feat_log_after = $scratch ##########"
echo

$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
          'feat_verbose = 1' \
	  "feat_log_inline = $level" \
	  "feat_log_after = $scratch" \
          'file_list_2_policy = accept' \
          'file_list_2 = (?i)\.(txt|html)$' \
          'feat_testing = 1' \
	  'try /dev/null/file/should/not/exist' \
	  "header_rev = 0" \
          'msg_defanged = -DE FA_NG ED-' \
	  <<EOF
From bre Fri Jan 30 03:37:34 1998
Date: Wed, 13 Dec 2000 17:13:26 +0800
From: Log test <foo@bar.com>
Subject: THIS LONG SUBJECT LINE MAKES THE LOG INTERESTING!
   YEAHAHAAAAEAHAHAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAEAHAHAAAAAAAAAAAAAAAAAAAAH!
To: Log test <baz@bar.com>
MIME-Version: 1.0
Content-Type: MULTIPART/ALTERNATIVE; boundary=abcdefg
Content-Transfer-Encoding: quoted-printable

--abcdefg
Content-type: text/plain; charset=us-ascii
Content-disposition: inline
Content-transfer-encoding: Base64

VGhpcyBpcyBhIHRleHQgdGVzdC4gIEhlcmUgY29tZXMgdGhlIGxvZy4uLiBJIGhvcGUuCg==

--abcdefg
Content-type: text/html; charset=us-ascii
Content-disposition: inline
Content-transfer-encoding: 7bit

<html><head><title>blah</title><body>
Here comes the log, I hope:
</body>
</html>
</body>
</html>

--abcdefg--

EOF
echo "*** Exit code was $? ***" 

done
done) 2>test.log >test.out
