#!/bin/bash
# bbou@ac-toulouse.fr
# 2005-09-11 17:55:49 
# _preinstall-fc.sh

### P A R A M S

package="$1"

### I N C L U D E

. ./_include.sh

### H E L P E R S

function rpmdeps()
{
	rpm -q -p $1 -R | grep -v '^/' | sed 's/(.*)//g' | sed 's/[><].*$//g' 
}

### S T A R T
packages=`rpmdeps ${package}`

# I N S T A L L E R
if ! rpm -q yum > /dev/null ; then
	echo "install needs the yum rpm"
	exit 1
fi
echo "yum is installed"

# I N S T A L L   L O O P

echo "+INSTALL"
for p in ${packages}; do
	echo "+package ${p}"
	if ! rpm -q "${p}" > /dev/null ; then
		yum -y install "${p}"
	else
		echo "package ${p} is installed"
	fi
done

# U P D A T E
echo "+UPDATE"
yum -y update ${packages}

echo '+end of fc preinstall'
