# Summary

[Introduction](./introduction.md)

- [Floating-point Math](./float-math/fp.md)
  - [Short-vector Math Library](./float-math/svml.md)
  - [Approximate functions](./float-math/approx.md)
  - [Fused multiply-accumulate](./float-math/fma.md)

- [Target features](./target-feature/features.md)
  - [Using `RUSTFLAGS`](./target-feature/rustflags.md)
  - [Using the `target_feature` attribute](./target-feature/attribute.md)
  - [Interaction with inlining](./target-feature/inlining.md)
  - [Detecting features at runtime](./target-feature/runtime.md)

- [Bounds checking](./bound_checks.md)
- [Vertical and horizontal operations](./vert-hor-ops.md)

- [Performance profiling](./prof/profiling.md)
  - [Profiling on Linux](./prof/linux.md)
  - [Using machine code analyzers](./prof/mca.md)
