// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{BackgroundPatternType, Indenter, SmartHomeEndType, View};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceMap")]
    pub struct Map(Object<ffi::GtkSourceMap, ffi::GtkSourceMapClass>) @extends View, gtk::TextView, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::Scrollable;

    match fn {
        type_ => || ffi::gtk_source_map_get_type(),
    }
}

impl Map {
    pub const NONE: Option<&'static Map> = None;

    #[doc(alias = "gtk_source_map_new")]
    pub fn new() -> Map {
        assert_initialized_main_thread!();
        unsafe { gtk::Widget::from_glib_none(ffi::gtk_source_map_new()).unsafe_cast() }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Map`] objects.
    ///
    /// This method returns an instance of [`MapBuilder`](crate::builders::MapBuilder) which can be used to create [`Map`] objects.
    pub fn builder() -> MapBuilder {
        MapBuilder::new()
    }
}

impl Default for Map {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Map`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MapBuilder {
    builder: glib::object::ObjectBuilder<'static, Map>,
}

impl MapBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn font_desc(self, font_desc: &pango::FontDescription) -> Self {
        Self {
            builder: self.builder.property("font-desc", font_desc),
        }
    }

    pub fn view(self, view: &impl IsA<View>) -> Self {
        Self {
            builder: self.builder.property("view", view.clone().upcast()),
        }
    }

    pub fn auto_indent(self, auto_indent: bool) -> Self {
        Self {
            builder: self.builder.property("auto-indent", auto_indent),
        }
    }

    pub fn background_pattern(self, background_pattern: BackgroundPatternType) -> Self {
        Self {
            builder: self
                .builder
                .property("background-pattern", background_pattern),
        }
    }

    pub fn enable_snippets(self, enable_snippets: bool) -> Self {
        Self {
            builder: self.builder.property("enable-snippets", enable_snippets),
        }
    }

    pub fn highlight_current_line(self, highlight_current_line: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("highlight-current-line", highlight_current_line),
        }
    }

    pub fn indent_on_tab(self, indent_on_tab: bool) -> Self {
        Self {
            builder: self.builder.property("indent-on-tab", indent_on_tab),
        }
    }

    pub fn indent_width(self, indent_width: i32) -> Self {
        Self {
            builder: self.builder.property("indent-width", indent_width),
        }
    }

    pub fn indenter(self, indenter: &impl IsA<Indenter>) -> Self {
        Self {
            builder: self.builder.property("indenter", indenter.clone().upcast()),
        }
    }

    pub fn insert_spaces_instead_of_tabs(self, insert_spaces_instead_of_tabs: bool) -> Self {
        Self {
            builder: self.builder.property(
                "insert-spaces-instead-of-tabs",
                insert_spaces_instead_of_tabs,
            ),
        }
    }

    pub fn right_margin_position(self, right_margin_position: u32) -> Self {
        Self {
            builder: self
                .builder
                .property("right-margin-position", right_margin_position),
        }
    }

    pub fn show_line_marks(self, show_line_marks: bool) -> Self {
        Self {
            builder: self.builder.property("show-line-marks", show_line_marks),
        }
    }

    pub fn show_line_numbers(self, show_line_numbers: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-line-numbers", show_line_numbers),
        }
    }

    pub fn show_right_margin(self, show_right_margin: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("show-right-margin", show_right_margin),
        }
    }

    pub fn smart_backspace(self, smart_backspace: bool) -> Self {
        Self {
            builder: self.builder.property("smart-backspace", smart_backspace),
        }
    }

    pub fn smart_home_end(self, smart_home_end: SmartHomeEndType) -> Self {
        Self {
            builder: self.builder.property("smart-home-end", smart_home_end),
        }
    }

    pub fn tab_width(self, tab_width: u32) -> Self {
        Self {
            builder: self.builder.property("tab-width", tab_width),
        }
    }

    pub fn accepts_tab(self, accepts_tab: bool) -> Self {
        Self {
            builder: self.builder.property("accepts-tab", accepts_tab),
        }
    }

    pub fn bottom_margin(self, bottom_margin: i32) -> Self {
        Self {
            builder: self.builder.property("bottom-margin", bottom_margin),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<gtk::TextBuffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn cursor_visible(self, cursor_visible: bool) -> Self {
        Self {
            builder: self.builder.property("cursor-visible", cursor_visible),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn extra_menu(self, extra_menu: &impl IsA<gio::MenuModel>) -> Self {
        Self {
            builder: self
                .builder
                .property("extra-menu", extra_menu.clone().upcast()),
        }
    }

    pub fn im_module(self, im_module: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("im-module", im_module.into()),
        }
    }

    pub fn indent(self, indent: i32) -> Self {
        Self {
            builder: self.builder.property("indent", indent),
        }
    }

    pub fn input_hints(self, input_hints: gtk::InputHints) -> Self {
        Self {
            builder: self.builder.property("input-hints", input_hints),
        }
    }

    pub fn input_purpose(self, input_purpose: gtk::InputPurpose) -> Self {
        Self {
            builder: self.builder.property("input-purpose", input_purpose),
        }
    }

    pub fn justification(self, justification: gtk::Justification) -> Self {
        Self {
            builder: self.builder.property("justification", justification),
        }
    }

    pub fn left_margin(self, left_margin: i32) -> Self {
        Self {
            builder: self.builder.property("left-margin", left_margin),
        }
    }

    pub fn monospace(self, monospace: bool) -> Self {
        Self {
            builder: self.builder.property("monospace", monospace),
        }
    }

    pub fn overwrite(self, overwrite: bool) -> Self {
        Self {
            builder: self.builder.property("overwrite", overwrite),
        }
    }

    pub fn pixels_above_lines(self, pixels_above_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-above-lines", pixels_above_lines),
        }
    }

    pub fn pixels_below_lines(self, pixels_below_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-below-lines", pixels_below_lines),
        }
    }

    pub fn pixels_inside_wrap(self, pixels_inside_wrap: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-inside-wrap", pixels_inside_wrap),
        }
    }

    pub fn right_margin(self, right_margin: i32) -> Self {
        Self {
            builder: self.builder.property("right-margin", right_margin),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn top_margin(self, top_margin: i32) -> Self {
        Self {
            builder: self.builder.property("top-margin", top_margin),
        }
    }

    pub fn wrap_mode(self, wrap_mode: gtk::WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    pub fn hadjustment(self, hadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("hadjustment", hadjustment.clone().upcast()),
        }
    }

    pub fn hscroll_policy(self, hscroll_policy: gtk::ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("hscroll-policy", hscroll_policy),
        }
    }

    pub fn vadjustment(self, vadjustment: &impl IsA<gtk::Adjustment>) -> Self {
        Self {
            builder: self
                .builder
                .property("vadjustment", vadjustment.clone().upcast()),
        }
    }

    pub fn vscroll_policy(self, vscroll_policy: gtk::ScrollablePolicy) -> Self {
        Self {
            builder: self.builder.property("vscroll-policy", vscroll_policy),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Map`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Map {
        self.builder.build()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Map>> Sealed for T {}
}

pub trait MapExt: IsA<Map> + sealed::Sealed + 'static {
    #[doc(alias = "gtk_source_map_get_view")]
    #[doc(alias = "get_view")]
    fn view(&self) -> Option<View> {
        unsafe { from_glib_none(ffi::gtk_source_map_get_view(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_map_set_view")]
    fn set_view(&self, view: &impl IsA<View>) {
        unsafe {
            ffi::gtk_source_map_set_view(
                self.as_ref().to_glib_none().0,
                view.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription> {
        ObjectExt::property(self.as_ref(), "font-desc")
    }

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        ObjectExt::set_property(self.as_ref(), "font-desc", font_desc)
    }

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<P: IsA<Map>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Map::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "view")]
    fn connect_view_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_view_trampoline<P: IsA<Map>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkSourceMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Map::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::view\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_view_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<Map>> MapExt for O {}
