// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{Buffer, CompressionType, Encoding, File, FileSaverFlags, NewlineType};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceFileSaver")]
    pub struct FileSaver(Object<ffi::GtkSourceFileSaver, ffi::GtkSourceFileSaverClass>);

    match fn {
        type_ => || ffi::gtk_source_file_saver_get_type(),
    }
}

impl FileSaver {
    #[doc(alias = "gtk_source_file_saver_new")]
    pub fn new(buffer: &impl IsA<Buffer>, file: &impl IsA<File>) -> FileSaver {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_file_saver_new(
                buffer.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_saver_new_with_target")]
    #[doc(alias = "new_with_target")]
    pub fn with_target(
        buffer: &impl IsA<Buffer>,
        file: &impl IsA<File>,
        target_location: &impl IsA<gio::File>,
    ) -> FileSaver {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::gtk_source_file_saver_new_with_target(
                buffer.as_ref().to_glib_none().0,
                file.as_ref().to_glib_none().0,
                target_location.as_ref().to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`FileSaver`] objects.
    ///
    /// This method returns an instance of [`FileSaverBuilder`](crate::builders::FileSaverBuilder) which can be used to create [`FileSaver`] objects.
    pub fn builder() -> FileSaverBuilder {
        FileSaverBuilder::new()
    }

    #[doc(alias = "gtk_source_file_saver_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> Buffer {
        unsafe { from_glib_none(ffi::gtk_source_file_saver_get_buffer(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_file_saver_get_compression_type")]
    #[doc(alias = "get_compression_type")]
    pub fn compression_type(&self) -> CompressionType {
        unsafe {
            from_glib(ffi::gtk_source_file_saver_get_compression_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_saver_get_encoding")]
    #[doc(alias = "get_encoding")]
    pub fn encoding(&self) -> Encoding {
        unsafe {
            from_glib_none(ffi::gtk_source_file_saver_get_encoding(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_saver_get_file")]
    #[doc(alias = "get_file")]
    pub fn file(&self) -> File {
        unsafe { from_glib_none(ffi::gtk_source_file_saver_get_file(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_file_saver_get_flags")]
    #[doc(alias = "get_flags")]
    pub fn flags(&self) -> FileSaverFlags {
        unsafe { from_glib(ffi::gtk_source_file_saver_get_flags(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_file_saver_get_location")]
    #[doc(alias = "get_location")]
    pub fn location(&self) -> gio::File {
        unsafe {
            from_glib_none(ffi::gtk_source_file_saver_get_location(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_saver_get_newline_type")]
    #[doc(alias = "get_newline_type")]
    pub fn newline_type(&self) -> NewlineType {
        unsafe {
            from_glib(ffi::gtk_source_file_saver_get_newline_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_file_saver_set_compression_type")]
    pub fn set_compression_type(&self, compression_type: CompressionType) {
        unsafe {
            ffi::gtk_source_file_saver_set_compression_type(
                self.to_glib_none().0,
                compression_type.into_glib(),
            );
        }
    }

    #[doc(alias = "gtk_source_file_saver_set_encoding")]
    pub fn set_encoding(&self, encoding: Option<&Encoding>) {
        unsafe {
            ffi::gtk_source_file_saver_set_encoding(
                self.to_glib_none().0,
                encoding.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_file_saver_set_flags")]
    pub fn set_flags(&self, flags: FileSaverFlags) {
        unsafe {
            ffi::gtk_source_file_saver_set_flags(self.to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "gtk_source_file_saver_set_newline_type")]
    pub fn set_newline_type(&self, newline_type: NewlineType) {
        unsafe {
            ffi::gtk_source_file_saver_set_newline_type(
                self.to_glib_none().0,
                newline_type.into_glib(),
            );
        }
    }

    #[doc(alias = "compression-type")]
    pub fn connect_compression_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_compression_type_trampoline<F: Fn(&FileSaver) + 'static>(
            this: *mut ffi::GtkSourceFileSaver,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::compression-type\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_compression_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "encoding")]
    pub fn connect_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_encoding_trampoline<F: Fn(&FileSaver) + 'static>(
            this: *mut ffi::GtkSourceFileSaver,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::encoding\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_encoding_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "flags")]
    pub fn connect_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flags_trampoline<F: Fn(&FileSaver) + 'static>(
            this: *mut ffi::GtkSourceFileSaver,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::flags\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_flags_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "newline-type")]
    pub fn connect_newline_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_newline_type_trampoline<F: Fn(&FileSaver) + 'static>(
            this: *mut ffi::GtkSourceFileSaver,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::newline-type\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_newline_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for FileSaver {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`FileSaver`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct FileSaverBuilder {
    builder: glib::object::ObjectBuilder<'static, FileSaver>,
}

impl FileSaverBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn buffer(self, buffer: &impl IsA<Buffer>) -> Self {
        Self {
            builder: self.builder.property("buffer", buffer.clone().upcast()),
        }
    }

    pub fn compression_type(self, compression_type: CompressionType) -> Self {
        Self {
            builder: self.builder.property("compression-type", compression_type),
        }
    }

    pub fn encoding(self, encoding: &Encoding) -> Self {
        Self {
            builder: self.builder.property("encoding", encoding),
        }
    }

    pub fn file(self, file: &impl IsA<File>) -> Self {
        Self {
            builder: self.builder.property("file", file.clone().upcast()),
        }
    }

    pub fn flags(self, flags: FileSaverFlags) -> Self {
        Self {
            builder: self.builder.property("flags", flags),
        }
    }

    pub fn location(self, location: &impl IsA<gio::File>) -> Self {
        Self {
            builder: self.builder.property("location", location.clone().upcast()),
        }
    }

    pub fn newline_type(self, newline_type: NewlineType) -> Self {
        Self {
            builder: self.builder.property("newline-type", newline_type),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`FileSaver`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> FileSaver {
        self.builder.build()
    }
}
