// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{Buffer, CompletionProvider, View};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkSourceCompletion")]
    pub struct Completion(Object<ffi::GtkSourceCompletion, ffi::GtkSourceCompletionClass>);

    match fn {
        type_ => || ffi::gtk_source_completion_get_type(),
    }
}

impl Completion {
    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Completion`] objects.
    ///
    /// This method returns an instance of [`CompletionBuilder`](crate::builders::CompletionBuilder) which can be used to create [`Completion`] objects.
    pub fn builder() -> CompletionBuilder {
        CompletionBuilder::new()
    }

    #[doc(alias = "gtk_source_completion_add_provider")]
    pub fn add_provider(&self, provider: &impl IsA<CompletionProvider>) {
        unsafe {
            ffi::gtk_source_completion_add_provider(
                self.to_glib_none().0,
                provider.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_block_interactive")]
    pub fn block_interactive(&self) {
        unsafe {
            ffi::gtk_source_completion_block_interactive(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_completion_get_buffer")]
    #[doc(alias = "get_buffer")]
    pub fn buffer(&self) -> Buffer {
        unsafe { from_glib_none(ffi::gtk_source_completion_get_buffer(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_completion_get_page_size")]
    #[doc(alias = "get_page_size")]
    pub fn page_size(&self) -> u32 {
        unsafe { ffi::gtk_source_completion_get_page_size(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_source_completion_get_view")]
    #[doc(alias = "get_view")]
    pub fn view(&self) -> View {
        unsafe { from_glib_none(ffi::gtk_source_completion_get_view(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_source_completion_hide")]
    pub fn hide(&self) {
        unsafe {
            ffi::gtk_source_completion_hide(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_completion_remove_provider")]
    pub fn remove_provider(&self, provider: &impl IsA<CompletionProvider>) {
        unsafe {
            ffi::gtk_source_completion_remove_provider(
                self.to_glib_none().0,
                provider.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_source_completion_set_page_size")]
    pub fn set_page_size(&self, page_size: u32) {
        unsafe {
            ffi::gtk_source_completion_set_page_size(self.to_glib_none().0, page_size);
        }
    }

    #[doc(alias = "gtk_source_completion_show")]
    pub fn show(&self) {
        unsafe {
            ffi::gtk_source_completion_show(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_source_completion_unblock_interactive")]
    pub fn unblock_interactive(&self) {
        unsafe {
            ffi::gtk_source_completion_unblock_interactive(self.to_glib_none().0);
        }
    }

    #[doc(alias = "remember-info-visibility")]
    pub fn is_remember_info_visibility(&self) -> bool {
        ObjectExt::property(self, "remember-info-visibility")
    }

    #[doc(alias = "remember-info-visibility")]
    pub fn set_remember_info_visibility(&self, remember_info_visibility: bool) {
        ObjectExt::set_property(self, "remember-info-visibility", remember_info_visibility)
    }

    #[doc(alias = "select-on-show")]
    pub fn selects_on_show(&self) -> bool {
        ObjectExt::property(self, "select-on-show")
    }

    #[doc(alias = "select-on-show")]
    pub fn set_select_on_show(&self, select_on_show: bool) {
        ObjectExt::set_property(self, "select-on-show", select_on_show)
    }

    #[doc(alias = "show-icons")]
    pub fn shows_icons(&self) -> bool {
        ObjectExt::property(self, "show-icons")
    }

    #[doc(alias = "show-icons")]
    pub fn set_show_icons(&self, show_icons: bool) {
        ObjectExt::set_property(self, "show-icons", show_icons)
    }

    #[doc(alias = "gtk_source_completion_fuzzy_highlight")]
    pub fn fuzzy_highlight(haystack: &str, casefold_query: &str) -> Option<pango::AttrList> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_source_completion_fuzzy_highlight(
                haystack.to_glib_none().0,
                casefold_query.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_source_completion_fuzzy_match")]
    pub fn fuzzy_match(haystack: Option<&str>, casefold_needle: &str) -> Option<u32> {
        assert_initialized_main_thread!();
        unsafe {
            let mut priority = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_source_completion_fuzzy_match(
                haystack.to_glib_none().0,
                casefold_needle.to_glib_none().0,
                priority.as_mut_ptr(),
            ));
            if ret {
                Some(priority.assume_init())
            } else {
                None
            }
        }
    }

    #[doc(alias = "hide")]
    pub fn connect_hide<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn hide_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"hide\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    hide_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_hide(&self) {
        self.emit_by_name::<()>("hide", &[]);
    }

    #[doc(alias = "provider-added")]
    pub fn connect_provider_added<F: Fn(&Self, &CompletionProvider) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn provider_added_trampoline<
            F: Fn(&Completion, &CompletionProvider) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletion,
            provider: *mut ffi::GtkSourceCompletionProvider,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(provider))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"provider-added\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    provider_added_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "provider-removed")]
    pub fn connect_provider_removed<F: Fn(&Self, &CompletionProvider) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn provider_removed_trampoline<
            F: Fn(&Completion, &CompletionProvider) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletion,
            provider: *mut ffi::GtkSourceCompletionProvider,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(provider))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"provider-removed\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    provider_removed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show")]
    pub fn connect_show<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn show_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"show\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    show_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn emit_show(&self) {
        self.emit_by_name::<()>("show", &[]);
    }

    #[doc(alias = "buffer")]
    pub fn connect_buffer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_buffer_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::buffer\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_buffer_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "page-size")]
    pub fn connect_page_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_size_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::page-size\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_page_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "remember-info-visibility")]
    pub fn connect_remember_info_visibility_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_remember_info_visibility_trampoline<
            F: Fn(&Completion) + 'static,
        >(
            this: *mut ffi::GtkSourceCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::remember-info-visibility\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_remember_info_visibility_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "select-on-show")]
    pub fn connect_select_on_show_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_select_on_show_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::select-on-show\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_select_on_show_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "show-icons")]
    pub fn connect_show_icons_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_show_icons_trampoline<F: Fn(&Completion) + 'static>(
            this: *mut ffi::GtkSourceCompletion,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::show-icons\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_show_icons_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Completion`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CompletionBuilder {
    builder: glib::object::ObjectBuilder<'static, Completion>,
}

impl CompletionBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn page_size(self, page_size: u32) -> Self {
        Self {
            builder: self.builder.property("page-size", page_size),
        }
    }

    pub fn remember_info_visibility(self, remember_info_visibility: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("remember-info-visibility", remember_info_visibility),
        }
    }

    pub fn select_on_show(self, select_on_show: bool) -> Self {
        Self {
            builder: self.builder.property("select-on-show", select_on_show),
        }
    }

    pub fn show_icons(self, show_icons: bool) -> Self {
        Self {
            builder: self.builder.property("show-icons", show_icons),
        }
    }

    pub fn view(self, view: &impl IsA<View>) -> Self {
        Self {
            builder: self.builder.property("view", view.clone().upcast()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Completion`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Completion {
        self.builder.build()
    }
}
