= MPEG playback
* ((<MPEG playback Outline>))
* ((<SDL::MPEG>))
* ((<SDL::MPEG::Info>))
* ((<MPEG playback methods>))
  * ((<SDL::MPEG.new>)) -- Load MPEG file.
  * ((<SDL::MPEG#info>)) -- Get information about MPEG object
  * ((<SDL::MPEG#enable_audio>)) -- Enable/Dislable audio
  * ((<SDL::MPEG#enable_video>)) -- Enable/Disable video
  * ((<SDL::MPEG#status>)) -- Get current status
  * ((<SDL::MPEG#set_volume>)) -- Change volume of MPEG stream
  * ((<SDL::MPEG#set_display>)) -- Set display surface
  * ((<SDL::MPEG#set_loop>)) -- Set/Clear looping play
  * ((<SDL::MPEG#scale_xy>)) -- Scale pixel display
  * ((<SDL::MPEG#scale>)) -- Scale pixel display
  * ((<SDL::MPEG#move>)) -- Move the video display area
  * ((<SDL::MPEG#set_display_region>)) -- Set the video display region
  * ((<SDL::MPEG#play>)) -- Play an MPEG object
  * ((<SDL::MPEG#stop>)) -- Stop playback of an MPEG object
  * ((<SDL::MPEG#pause>)) -- Pause/Resume playback of an MPEG object
  * ((<SDL::MPEG#rewind>)) -- Rewind the play position 
  * ((<SDL::MPEG#seek>)) -- Seek in the MPEG stream.
  * ((<SDL::MPEG#skip>)) -- Skip seconds in the MPEG stream
  * ((<SDL::MPEG#render_frame>)) -- Render a particular frame in the MPEG video.
  * ((<SDL::MPEG#render_final>)) -- Render the last frame of an MPEG video
  * ((<SDL::MPEG#set_filer>)) -- Set video filter
  * ((<SDL::MPEG::Info#has_audio>)) -- Get whether an MPEG stream has audio data
  * ((<SDL::MPEG::Info#has_video>)) -- Get whether an MPEG stream has video data
  * ((<SDL::MPEG::Info#width>)) -- Get width of video
  * ((<SDL::MPEG::Info#height>)) -- Get height of video
  * ((<SDL::MPEG::Info#current_frame>)) -- 
  * ((<SDL::MPEG::Info#current_fps>)) -- 
  * ((<SDL::MPEG::Info#audio_string>)) -- 
  * ((<SDL::MPEG::Info#audio_current_frame>)) -- 
  * ((<SDL::MPEG::Info#current_offset>)) -- 
  * ((<SDL::MPEG::Info#total_size>)) -- 
  * ((<SDL::MPEG::Info#current_time>)) -- 
  * ((<SDL::MPEG#total_time>)) -- 
  * ((<SDL::MPEG#delete>)) -- 
  * ((<SDL::MPEG#deleted?>)) -- 

== MPEG playback Outline
Ruby/SDL enables you to play MPEG movie 
with ((<SMPEG|URL:http://www.icculus.org/smpeg>)).

Before calling MPEG methods, ((<SDL.init>)) should be called 
with SDL::INIT_AUDIO|SDL::INIT_VIDEO and 
((<SDL::Mixer.open>)) should be called.

MPEG playback system runs in sub thread(native thread).
Therefore you cannot read and write movie ((<SDL::Surface>)) 
while playing. In addition you cannot use ((<SDL::Mixer>)) 
routines while playing if ((<audio is enabled|SDL::MPEG#enable_audio>)).
Ruby/SDL doesn't control such an invalid access.

== SDL::MPEG
This class represents MPEG stream and playing state.

* ((<SDL::MPEG.new>)) -- Load MPEG file.
* ((<SDL::MPEG#info>)) -- Get information about MPEG object
* ((<SDL::MPEG#enable_audio>)) -- Enable/Dislable audio
* ((<SDL::MPEG#enable_video>)) -- Enable/Disable video
* ((<SDL::MPEG#status>)) -- Get current status
* ((<SDL::MPEG#set_volume>)) -- Change volume of MPEG stream
* ((<SDL::MPEG#set_display>)) -- Set display surface
* ((<SDL::MPEG#set_loop>)) -- Set/Clear looping play
* ((<SDL::MPEG#scale_xy>)) -- Scale pixel display
* ((<SDL::MPEG#scale>)) -- Scale pixel display
* ((<SDL::MPEG#move>)) -- Move the video display area
* ((<SDL::MPEG#set_display_region>)) -- Set the video display region
* ((<SDL::MPEG#play>)) -- Play an MPEG object
* ((<SDL::MPEG#stop>)) -- Stop playback of an MPEG object
* ((<SDL::MPEG#pause>)) -- Pause/Resume playback of an MPEG object
* ((<SDL::MPEG#rewind>)) -- Rewind the play position 
* ((<SDL::MPEG#seek>)) -- Seek in the MPEG stream.
* ((<SDL::MPEG#skip>)) -- Skip seconds in the MPEG stream
* ((<SDL::MPEG#render_frame>)) -- Render a particular frame in the MPEG video.
* ((<SDL::MPEG#render_final>)) -- Render the last frame of an MPEG video
* ((<SDL::MPEG#set_filer>)) -- Set video filter
* ((<SDL::MPEG#total_time>)) -- 
* ((<SDL::MPEG#delete>)) -- 
* ((<SDL::MPEG#deleted?>)) -- 

== SDL::MPEG::Info
This class represents ((<SDL::MPEG>)) information.
You can get instance by ((<SDL::MPEG#info>)).

* ((<SDL::MPEG::Info#has_audio>)) -- Get whether an MPEG stream has audio data
* ((<SDL::MPEG::Info#has_video>)) -- Get whether an MPEG stream has video data
* ((<SDL::MPEG::Info#width>)) -- Get width of video
* ((<SDL::MPEG::Info#height>)) -- Get height of video
* ((<SDL::MPEG::Info#current_frame>)) -- 
* ((<SDL::MPEG::Info#current_fps>)) -- 
* ((<SDL::MPEG::Info#audio_string>)) -- 
* ((<SDL::MPEG::Info#audio_current_frame>)) -- 
* ((<SDL::MPEG::Info#current_offset>)) -- 
* ((<SDL::MPEG::Info#total_size>)) -- 
* ((<SDL::MPEG::Info#current_time>)) -- 

== MPEG playback methods

--- SDL::MPEG.new(filename)
--- SDL::MPEG.load(filename)

    Loads a ((|filename|)) and returns 
    new ((<SDL::MPEG>)) object.

    Raises ((<SDL::Error>)) on failure

    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#info>)), ((<SDL::MPEG#play>))

--- SDL::MPEG#info

    Gets information about ((|self|)) as ((<SDL::MPEG::Info>)) object.


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG::Info>))

--- SDL::MPEG#enable_audio(enable)
--- SDL::MPEG#enableAudio(enable)

    Enables or disables audio.
    If ((|enable|)) is true, audio data is played, but if ((|enable|))
    is false, audio data is not played.


    You need SMPEG to use this method.
    * NOTES

      Audio enable/disable setting is reflected after
      playing starts.

    * See Also
      
      ((<SDL::MPEG#enable_video>)), ((<SDL::MPEG#info>))

--- SDL::MPEG#enable_video(enable)
--- SDL::MPEG#enableVideo(enable)

    Enables or disables audio.
    If ((|enable|)) is true, movie data is played, but if ((|enable|))
    is false, movie data is not played.


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#enable_audio>)), ((<SDL::MPEG#info>))

--- SDL::MPEG#status

    Returns current status of ((|self|)) as follows:
    * SDL::MEPG::ERROR - system has some errors
    * SDL::MPEG::STOPPED - movie is stopped
    * SDL::MPEG::PLAYING - movie is playing


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#info>))

--- SDL::MPEG#set_volume(volume)
--- SDL::MPEG#setVolume(volume)

    Set volume MPEG stream from 0 to 100.


    You need SMPEG to use this method.
    * NOTES

      You cannot get current volume.

    * See Also
      
      ((<SDL::MPEG#enable_audio>))

--- SDL::MPEG#set_display(surface)
--- SDL::MPEG#setDisplay(surface)

    Sets the ((<surface|SDL::Surface>)) that the playing movie displays on.
    Normally, the surface object returned by ((<SDL.set_video_mode>))
    is used as ((|surface|)).


    You need SMPEG to use this method.
    * NOTES

      MPEG playback system call ((<SDL::Screen#update_rect>)) from 
      a (native) sub thread.

    * See Also
      
      ((<SDL::Surface>)), ((<SDL::MPEG#play>))

--- SDL::MPEG#set_loop(repeat)
--- SDL::MPEG#setLoop(repeat)

    Set or clear looping play on ((|self|)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#play>))

--- SDL::MPEG#scale_xy(width, height)
--- SDL::MPEG#scaleXY(width, height)

    Set scale pixel display on ((|self|)).
    The Unit of ((|width|)) and ((|height|)) is pixel.


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#scale>)), ((<SDL::MPEG#set_display_region>))

--- SDL::MPEG#scale(scale)

    Set scale display on ((|self|)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#scale_xy>))

--- SDL::MPEG#move(x, y)

    Moves the video display to (((|x|)), ((|y|))) 
    within the destination surface set by ((<SDL::MPEG#set_display>)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#set_display>)), ((<SDL::MPEG#set_display_region>))

--- SDL::MPEG#set_display_region(x, y, w, h)

    Set the region of the video to be shown at 
    the rectangle of ((|x|)), ((|y|)), ((|w|)), ((|h|))


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#move>)), ((<SDL::MPEG#scale_xy>))

--- SDL::MPEG#play

    Plays an MPEG object.


    You need SMPEG to use this method.
    * NOTES

      You don't have to access surface set by ((<SDL::MPEG#set_display>)).
      x

    * See Also
      
      ((<SDL::MPEG#pause>)), ((<SDL::MPEG#stop>)), ((<SDL::MPEG#rewind>)), ((<SDL::MPEG#seek>)), ((<SDL::MPEG#skip>)), ((<SDL::MPEG#render_frame>))

--- SDL::MPEG#stop

    Stop play back of ((|self|)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#play>))

--- SDL::MPEG#pause

    Pauses/Resumes playback of ((|self|)).
    Pauses playback if ((|self|)) is playing, and
    Resume playback if paused.


    You need SMPEG to use this method.
--- SDL::MPEG#rewind

    Rewinds the play position of ((|self|))
    to the beginning of the MPEG.


    You need SMPEG to use this method.
--- SDL::MPEG#seek(bytes)

    Seeks ((|bytes|)) ((*bytes*)) the play position of ((|self|)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#play>)), ((<SDL::MPEG#skip>))

--- SDL::MPEG#skip(seconds)

    Skips ((|seconds|)) seconds in ((|self|)) MPEG stream.
    ((|seconds|)) can be Float or Integer.


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#play>)), ((<SDL::MPEG#seek>))

--- SDL::MPEG#render_frame(framenum)

    Render the ((|framenum|))-th frame in the surface set by
    ((<SDL::MEPG#set_display>)).


    You need SMPEG to use this method.
    * See Also
      
      ((<SDL::MPEG#render_final>)), ((<SDL::MPEG#play>))

--- SDL::MPEG#render_final(dst, x, y)

    Render the last frame of ((|self|)) video 
    at (((|x|)), ((|y|))) in the ((|dst|)) ((<surface|SDL::Surface>)).


    You need SMPEG to use this method.
--- SDL::MPEG#set_filer(filter)

    Selects video filter from one of following:
    * SDL::MPEG::NULL_FILTER no filter
    * SDL::MPEG::BILIEAR_FILTER bilinear filter
    * SDL::MPEG::DEBLOCKING_FILTER deblocking filter


    You need SMPEG to use this method.
--- SDL::MPEG::Info#has_audio

    Returns true if ((|self|)) MPEG stream has audio data,
    otherwise returns false.


    You need SMPEG to use this method.
--- SDL::MPEG::Info#has_video

    Returns true if ((|self|)) MPEG stream has video data,
    otherwise returns false.


    You need SMPEG to use this method.
--- SDL::MPEG::Info#width

    Returns the width of video as pixels.


    You need SMPEG to use this method.
--- SDL::MPEG::Info#height

    Returns the width of video as pixels.


    You need SMPEG to use this method.
--- SDL::MPEG::Info#current_frame

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#current_fps

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#audio_string

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#audio_current_frame

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#current_offset

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#total_size

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG::Info#current_time

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG#total_time

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG#delete

    not documented yet


    You need SMPEG to use this method.
--- SDL::MPEG#deleted?

    not documented yet


    You need SMPEG to use this method.
