// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_HPP_

#include "../../../type_traits.hpp"
#include "../device_config_helper.hpp"
#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{

template<unsigned int arch,
         class key_type,
         class value_type = rocprim::empty_type,
         class enable     = void>
struct default_radix_sort_config : default_radix_sort_config_base<key_type, value_type>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 3>,
                        ::rocprim::kernel_config<256, 12>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 5>,
                        ::rocprim::kernel_config<256, 12>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 2>,
                        ::rocprim::kernel_config<256, 16>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 4>,
                        ::rocprim::kernel_config<256, 12>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 16>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int64_t, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 2>,
                        ::rocprim::kernel_config<256, 10>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int64_t, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 8>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int64_t, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 4>,
                        ::rocprim::kernel_config<256, 12>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int64_t, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 10>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), int64_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030),
                                 rocprim::half,
                                 rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 9>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), short>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 9>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 12>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030), uint8_t, uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 15>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

// Based on key_type = rocprim::half
template<class key_type, class value_type>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx1030),
                                 key_type,
                                 value_type,
                                 std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value)
                                                   && (sizeof(key_type) <= 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = int64_t
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value)
                      && (sizeof(key_type) > 4))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

// Based on key_type = int
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 16>,
                        5>
{};

// Based on key_type = short
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 9>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 5>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 3>,
                        ::rocprim::kernel_config<256, 8>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int64_t, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int64_t, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 8>,
                        6>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int64_t, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 8>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int64_t, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 13>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), int64_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 8>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900),
                                 rocprim::half,
                                 rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 13>,
                        ::rocprim::kernel_config<256, 14>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), short>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 19>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900), uint8_t, uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

// Based on key_type = rocprim::half
template<class key_type, class value_type>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx900),
                                 key_type,
                                 value_type,
                                 std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value)
                                                   && (sizeof(key_type) <= 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = int64_t
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx900),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value)
                      && (sizeof(key_type) > 4))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 8>,
                        5>
{};

// Based on key_type = int
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx900),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = short
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx900),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 19>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 4>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 14>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 19>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 15>,
                        ::rocprim::kernel_config<256, 14>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int64_t, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 12>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int64_t, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 3>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int64_t, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int64_t, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 15>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), int64_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 17>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 12>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906),
                                 rocprim::half,
                                 rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 12>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), short>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 5>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 18>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906), uint8_t, uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

// Based on key_type = rocprim::half
template<class key_type, class value_type>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx906),
                                 key_type,
                                 value_type,
                                 std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value)
                                                   && (sizeof(key_type) <= 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 12>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = int64_t
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value)
                      && (sizeof(key_type) > 4))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 17>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

// Based on key_type = int
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 15>,
                        ::rocprim::kernel_config<256, 14>,
                        4>
{};

// Based on key_type = short
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 5>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 17>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 4>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 18>,
                        ::rocprim::kernel_config<256, 16>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 18>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int64_t, double>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 9>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int64_t, double2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 6>,
                        ::rocprim::kernel_config<256, 6>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int64_t, float>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int64_t, float2>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 12>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), int64_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908),
                                 rocprim::half,
                                 rocprim::half>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 15>,
                        ::rocprim::kernel_config<256, 14>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), short>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 20>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

template<>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908), uint8_t, uint8_t>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 4>,
                        ::rocprim::kernel_config<256, 16>,
                        4>
{};

// Based on key_type = rocprim::half
template<class key_type, class value_type>
struct default_radix_sort_config<static_cast<unsigned int>(target_arch::gfx908),
                                 key_type,
                                 value_type,
                                 std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value)
                                                   && (sizeof(key_type) <= 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 14>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = int64_t
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value)
                      && (sizeof(key_type) > 4))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 8>,
                        ::rocprim::kernel_config<256, 10>,
                        5>
{};

// Based on key_type = int
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 18>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

// Based on key_type = short
template<class key_type, class value_type>
struct default_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1))>>
    : radix_sort_config<4,
                        4,
                        ::rocprim::kernel_config<256, 7>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<256, 10>,
                        ::rocprim::kernel_config<1024, 1>,
                        1024,
                        0,
                        ::rocprim::kernel_config<256, 16>,
                        ::rocprim::kernel_config<256, 15>,
                        4>
{};

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_RADIX_SORT_HPP_
