// Copyright (C) 2021 - 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// complex number operators that are not present in hipRTC

#ifndef ROCFFT_RTC_WORKAROUND_H
#define ROCFFT_RTC_WORKAROUND_H

__device__ float2& operator*=(float2& f2, const float f)
{
    return f2 *= float2{f};
}

__device__ double2& operator*=(double2& f2, const double f)
{
    return f2 *= double2{f};
}

__device__ float2 operator-(float2 f2)
{
    return float2{-f2.x, -f2.y};
}

__device__ double2 operator-(double2 f2)
{
    return double2{-f2.x, -f2.y};
}

#endif // ROCFFT_RTC_WORKAROUND_H
