#ifndef PKD_SET_IOS_PERMUTATIONS_H
#define PKD_SET_IOS_PERMUTATIONS_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// permut to/from ios dof numbering, for distributed environment
#include "rheolef/geo.h"

namespace rheolef {

template <class T, class M>
void
Pkd_set_ios_permutations (
    const geo_basic<T,M>& omega,
    std::size_t			       degree,
    disarray<distributor::size_type,M>&   idof2ios_dis_idof,
    disarray<distributor::size_type,M>&   ios_idof2dis_idof,
    const std::array<distributor::size_type,reference_element::max_variant>& loc_ndof_by_variant);

#ifdef _RHEOLEF_HAVE_MPI
template <class T>
void
Pkd_set_ios_permutations (
    const geo_basic<T,distributed>&              omega,
    size_t                                       degree,
    disarray<distributor::size_type,distributed>&   idof2ios_dis_idof,
    disarray<distributor::size_type,distributed>&   ios_idof2dis_idof,
    const std::array<distributor::size_type,reference_element::max_variant>& loc_ndof_by_variant);
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
#endif // PKD_SET_IOS_PERMUTATIONS_H
