#! /bin/sh

# Test generation of archives with CSV templates

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .sh)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

. tests/inputs/test1.domain.net-template.env

${INPUT_SCRIPT} action=template format=csv+zip \
    | tail -n +6 > ${TMP_DIR}/template.zip

(
    cd ${TMP_DIR}
    unzip template.zip \
        | grep '^ extracting' \
        | cut -d ' ' -f 3- \
        | while read CSV
          do
              echo ${CSV}:
              cat ${CSV}
          done
)

# Temporary directory will be deleted by the trap.
