use strict;
use warnings;

use RT::Test tests => undef;

my $root = RT::CurrentUser->new('root');
my ($ok, $msg) = $root->UserObj->SetLang('en-us');
ok $ok, $msg;

my $year = (localtime time)[5] + 1900;
my $date = RT::Date->new( $root );
$date->SetToNow;

like $date->AsString( Format => 'LocalizedDateTime' ),
     qr/\Q$year\E/, 'contains full year';

unlike $date->AsString( Format => 'LocalizedDateTime', DateFormat => 'date_format_short' ),
     qr/\Q$year\E/, 'lacks full year';

eval {
    $date->AsString( Format => 'LocalizedDateTime', DateFormat => 'bogus::format' );
};
ok !$@, "didn't die with bogus DateFormat";

eval {
    $date->AsString( Format => 'LocalizedDateTime', TimeFormat => 'bogus::format' );
};
ok !$@, "didn't die with bogus TimeFormat";

done_testing;
