% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_classification.R
\name{precision}
\alias{precision}
\title{Precision}
\usage{
precision(actual, predicted)
}
\arguments{
\item{actual}{The ground truth binary numeric vector containing 1 for the positive
class and 0 for the negative class.}

\item{predicted}{The predicted binary numeric vector containing 1 for the positive
class and 0 for the negative class. Each element represents the
prediction for the corresponding element in \code{actual}.}
}
\description{
\code{precision} computes proportion of observations predicted to be in the
                 positive class (i.e. the element in \code{predicted} equals 1)
                 that actually belong to the positive class (i.e. the element 
                 in \code{actual} equals 1)
}
\examples{
actual <- c(1, 1, 1, 0, 0, 0)
predicted <- c(1, 1, 1, 1, 1, 1)
precision(actual, predicted)
}
\seealso{
\code{\link{recall}} \code{\link{fbeta_score}}
}
