% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spaghetti.R
\name{spaghetti}
\alias{spaghetti}
\title{Spaghetti plot}
\usage{
spaghetti(formula, data, id = "id", group = NULL, type = "o", lty = 1,
  pch = NA, col = 1:10, alpha = 0.3, lwd = 1, level = 0.95,
  trend.formula = formula, tau = NULL, trend.lty = 1, trend.join = TRUE,
  trend.delta = 0.2, trend = !is.null(tau), trend.col = col,
  trend.alpha = 0.2, trend.lwd = 3, trend.jitter = 0, legend = NULL,
  by = NULL, xlab = "Time", ylab = "", add = FALSE, ...)
}
\arguments{
\item{formula}{Formula (response ~ time)}

\item{data}{data.frame}

\item{id}{Id variable}

\item{group}{group variable}

\item{type}{Type (line 'l', stair 's', ...)}

\item{lty}{Line type}

\item{pch}{Colour}

\item{col}{Colour}

\item{alpha}{transparency (0-1)}

\item{lwd}{Line width}

\item{level}{Confidence level}

\item{trend.formula}{Formula for trendline}

\item{tau}{Quantile to estimate (trend)}

\item{trend.lty}{Trend line type}

\item{trend.join}{Trend polygon}

\item{trend.delta}{Length of limit bars}

\item{trend}{Add trend line}

\item{trend.col}{Colour of trend line}

\item{trend.alpha}{Transparency}

\item{trend.lwd}{Trend line width}

\item{trend.jitter}{Jitter amount}

\item{legend}{Legend}

\item{by}{make separate plot for each level in 'by' (formula, name of column, or vector)}

\item{xlab}{Label of X-axis}

\item{ylab}{Label of Y-axis}

\item{add}{Add to existing device}

\item{...}{Additional arguments to lower level arguments}
}
\description{
Spaghetti plot for longitudinal data
}
\examples{
if (interactive() & requireNamespace("mets")) {
K <- 5
y <- "y"\%++\%seq(K)
m <- lvm()
regression(m,y=y,x=~u) <- 1
regression(m,y=y,x=~s) <- seq(K)-1
regression(m,y=y,x=~x) <- "b"
N <- 50
d <- sim(m,N); d$z <- rbinom(N,1,0.5)
dd <- mets::fast.reshape(d); dd$num <- dd$num+3
spaghetti(y~num,dd,id="id",lty=1,col=Col(1,.4),
          trend.formula=~factor(num),trend=TRUE,trend.col="darkblue")
dd$num <- dd$num+rnorm(nrow(dd),sd=0.5) ## Unbalance
spaghetti(y~num,dd,id="id",lty=1,col=Col(1,.4),
          trend=TRUE,trend.col="darkblue")
spaghetti(y~num,dd,id="id",lty=1,col=Col(1,.4),
           trend.formula=~num+I(num^2),trend=TRUE,trend.col="darkblue")
}
}
\author{
Klaus K. Holst
}
