% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_metrics.R
\name{bridging}
\alias{bridging}
\title{Valente's Bridging vertex measure.}
\usage{
bridging(g)
}
\arguments{
\item{g}{The igraph object to analyze.}
}
\value{
A numeric vector with the bridging score for each vertex
}
\description{
Edges that reduces distances in a network are important structural bridges. Here we implement Valente and Fujimoto's metric,
where a node's bridging score is the average decrease in cohesiveness if each of
its edges were removed from the graph.
}
\examples{
ig.ex <- igraph::erdos.renyi.game(100, p.or.m=0.3) # generate an undirected 'igraph' object
bridging(ig.ex) # bridging scores for each node in the graph

}
\references{
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC2889704/}
}
