% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proc_freq.R
\name{proc_freq}
\alias{proc_freq}
\title{Frequency table}
\usage{
proc_freq(
  x,
  row = character(),
  col = character(),
  include.row_percent = TRUE,
  include.column_percent = TRUE,
  include.table_percent = TRUE,
  weight = character(),
  ...
)
}
\arguments{
\item{x}{a \code{data.frame} object containing variable(s) to use for counts.}

\item{row}{\code{characer} column names for row}

\item{col}{\code{characer} column names for column}

\item{include.row_percent}{\code{boolean} whether to include the row percents; defaults to \code{TRUE}}

\item{include.column_percent}{\code{boolean} whether to include the column percents; defaults to \code{TRUE}}

\item{include.table_percent}{\code{boolean} whether to include the table percents; defaults to \code{TRUE}}

\item{weight}{\code{character} column name for weight}

\item{...}{unused arguments}
}
\description{
This function compute a one or two way
contingency table and create a flextable from the result.

The function is largely inspired by "PROC FREQ" from "SAS"
and was written with the intent to make it
as compact as possible.
}
\examples{
proc_freq(mtcars, "vs", "gear")
proc_freq(mtcars, "gear", "vs", weight = "wt")
}
