% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment_rows.R
\name{add_header_row}
\alias{add_header_row}
\title{Add header labels}
\usage{
add_header_row(x, top = TRUE, values = character(0), colwidths = integer(0))
}
\arguments{
\item{x}{a flextable object}

\item{top}{should the row be inserted at the
top or the bottom. Default to TRUE.}

\item{values}{values to add, a character vector (as header rows
contains only character values/columns), a list
or a call to \code{\link[=as_paragraph]{as_paragraph()}}.}

\item{colwidths}{the number of columns used for each label}
}
\description{
Add a row of new columns labels in header part.
Labels can be spanned along multiple columns, as merged cells.

Labels are associated with a number of columns
to merge that default to one if not specified.
In this case, you have to make sure that the
number of labels is equal to the number of columns displayed.

The function can add only one single row by call.

Labels can also be formatted with \code{\link[=as_paragraph]{as_paragraph()}}.
}
\examples{
library(flextable)

ft01 <- fp_text_default(color = "red")
ft02 <- fp_text_default(color = "orange")

pars <- as_paragraph(
  as_chunk(c("(1)", "(2)"), props = ft02), " ",
  as_chunk(c("My tailor is rich",
    "My baker is rich"), props = ft01)
)

ft_1 <- flextable(head(mtcars))
ft_1 <- add_header_row(ft_1, values = pars,
  colwidths = c(5, 6), top = FALSE)
ft_1 <- add_header_row(ft_1, values = pars,
  colwidths = c(3, 8), top = TRUE)
ft_1

ft_2 <- flextable(head(airquality))
ft_2 <- add_header_row(ft_2, values = c("Measure", "Time"),
  colwidths = c(4, 2), top = TRUE)
ft_2 <- theme_box(ft_2)
ft_2
}
\seealso{
\code{\link[=flextable]{flextable()}}, \code{\link[=set_caption]{set_caption()}}

Other functions to add rows in a flextable: 
\code{\link{add_body_row}()},
\code{\link{add_body}()},
\code{\link{add_footer_lines}()},
\code{\link{add_footer_row}()},
\code{\link{add_footer}()},
\code{\link{add_header}()},
\code{\link{separate_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{functions to add rows in a flextable}
