% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_panel_size.r
\name{set_panel_size}
\alias{set_panel_size}
\title{set_panel_size}
\usage{
set_panel_size(p = NULL, g = ggplot2::ggplotGrob(p), file = NULL,
  margin = unit(1, "mm"), width = unit(4, "cm"), height = unit(4,
  "cm"))
}
\arguments{
\item{p}{ggplot2}

\item{g}{gtable}

\item{file}{optional output filename}

\item{margin}{grid unit}

\item{width}{grid unit, requested panel width}

\item{height}{grid unit, requested panel height}
}
\value{
gtable with fixed panel sizes
}
\description{
Set the panel width/height of a ggplot to a fixed value.
}
\examples{
p1 <- qplot(mpg, wt, data=mtcars, colour=cyl)
p2 <- p1 + facet_wrap(~carb, nrow=1)
grid.arrange(grobs=lapply(list(p1,p2), set_panel_size))
}
