% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventDetection.R
\name{numtDetect}
\alias{numtDetect}
\title{Detecting nuclear mitochondria fusion events.}
\usage{
numtDetect(gr, nonStandardChromosomes = FALSE, max_ins_dist = 1000)
}
\arguments{
\item{gr}{A GRanges object}

\item{nonStandardChromosomes}{Whether to report insertion sites on non-standard reference 
chromosomes. Default value is set to FALSE.}

\item{max_ins_dist}{The maxium distance allowed on the reference genome between the paired insertion sites.
Only intra-chromosomal NUMT events are supported. Default value is 1000.}
}
\value{
A GRanges object of possible NUMT loci.
}
\description{
Detecting nuclear mitochondria fusion events.
}
\details{
Nuclear mitochondrial fusion (NUMT) is a common event found in human genomes.
This function searches for NUMT events by identifying breakpoints supporting the fusion of
nuclear chromosome and mitochondrial genome. Only BND notations are supported at the current stage.
Possible linked nuclear insertion sites are reported using SV IDs in the candidatePartnerId metadata column.
}
\examples{
vcf.file <- system.file("extdata", "MT.vcf", package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
gr <- breakpointRanges(vcf, nominalPosition=TRUE)
numt.gr <- numtDetect(gr)
}
