% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCWL.R
\name{runCWL}
\alias{runCWL}
\title{run cwlProcess}
\usage{
runCWL(
  cwl,
  cwlRunner = "cwltool",
  outdir = ".",
  cachedir = NULL,
  cwlTemp = NULL,
  cwlArgs = character(),
  stdout = TRUE,
  stderr = TRUE,
  showLog = FALSE,
  docker = TRUE,
  conda = FALSE,
  yml_prefix = deparse(substitute(cwl)),
  yml_outdir = tempfile(),
  ...
)
}
\arguments{
\item{cwl}{A `cwlProcess` or `cwlWorkflow` object.}

\item{cwlRunner}{The path to the `cwltool` or `cwl-runner`. If not
exists, the cwltool package will be installed by `reticulate`.}

\item{outdir}{Output directory, default is current working
directory.}

\item{cachedir}{Directory to cache intermediate workflow outputs to
avoid recomputing steps.}

\item{cwlTemp}{File path to keep intermediate files. If a directory
path is given, the intermediate files will be kept in the
directory. Default is NULL to remove all intermediate files.}

\item{cwlArgs}{The arguments for `cwltool` or `cwl-runner`. For
example, "--debug" can work with `cwltool` to show debug
information.}

\item{stdout}{standard output from `system2`.}

\item{stderr}{standard error from `system2`. By setting it to "",
the detailed running logs will return directly.}

\item{showLog}{Whether to show log details to standard
out. i.e. stderr = "".}

\item{docker}{Whether to use docker, or "sigularity" if use
Singularity runtime to run container.}

\item{conda}{Whether to install packages using conda if
`SoftwareRequirement` is defined.}

\item{yml_prefix}{The prefix of `.cwl` and `.yml` files that are to
be internally executed.}

\item{yml_outdir}{The output directory for the `.cwl` and `.yml`
files.}

\item{...}{The other options from `writeCWL` and `system2`.}
}
\value{
A list of outputs from tools and logs from cwltool.
}
\description{
Execute a cwlProcess object with assigned inputs.
}
\examples{
input1 <- InputParam(id = "sth")
echo <- cwlProcess(baseCommand = "echo",
                 inputs = InputParamList(input1))
echo$sth <- "Hello World!"
## res <- runCWL(echo)
}
