% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mbs_contexts.R
\name{plot_mbs_contexts}
\alias{plot_mbs_contexts}
\title{Plot the MBS contexts}
\usage{
plot_mbs_contexts(counts, same_y = TRUE)
}
\arguments{
\item{counts}{A tibble containing the number of MBS per MBS length.}

\item{same_y}{A boolean describing whether the same y axis should be used for all samples.}
}
\value{
A ggplot figure.
}
\description{
Plot the MBS contexts
}
\details{
Plots the number of MBS per MBS length per sample.
It takes a tibble with counts as its input. This tibble can be generated by count_mbs_contexts
Each sample is plotted in a separate facet.
The same y axis can be used for all samples or a separate y axis can be used.
}
\examples{
## Get The mbs counts
## See 'count_mbs_contexts()' for more info on how to do this.
mbs_counts <- readRDS(system.file("states/blood_mbs_counts.rds",
  package = "MutationalPatterns"
))

## Plot contexts
plot_mbs_contexts(mbs_counts)

## Use a different y axis for all samples.
plot_mbs_contexts(mbs_counts, same_y = FALSE)
}
\seealso{
\code{\link{count_mbs_contexts}}

Other MBS: 
\code{\link{count_mbs_contexts}()},
\code{\link{plot_compare_mbs}()}
}
\concept{MBS}
