% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R, R/ReferenceTrack-class.R
\docType{class}
\name{availableDefaultMapping}
\alias{availableDefaultMapping}
\alias{ReferenceTrack-class}
\alias{initialize,ReferenceTrack-method}
\title{ReferenceTrack class and methods}
\usage{
availableDefaultMapping(file, trackType)

\S4method{initialize}{ReferenceTrack}(
  .Object,
  stream,
  reference,
  mapping = list(),
  args = list(),
  defaults = list()
)
}
\arguments{
\item{file}{A \code{character} scalar with a file name or just a file extension.}

\item{trackType}{A \code{character} scalar with one of the available track types
in the package.}

\item{.Object}{.Object}

\item{stream}{stream}

\item{reference}{reference}

\item{mapping}{mapping}

\item{args}{ars}

\item{defaults}{defaults}
}
\value{
Constructor functions of \code{AnnotationTrack}, \code{DataTrack}, \code{SequenceTrack}
and \verb{AlignmentsTrack`` can create a special object of corresponding }Reference*Track` subclass with pointer to the referenced
file.

A virtual class: No objects may be created from it.
}
\description{
A class allow for on-demand streaming of data off the file system.
}
\details{
The \code{availableDefaultMappings} function can be used to find out whether
the package defines a mapping scheme between one of the many supported input
file types and the metadata columns of the tracks' \code{GRanges} objects.
}
\section{Functions}{
\itemize{
\item \code{availableDefaultMapping}: Function to find out whether the package
defines a mapping scheme between one of the many supported input file types
and the metadata columns of the tracks's \code{GRanges} objects.

\item \code{initialize,ReferenceTrack-method}: Initialize.
}}

\section{Slots}{

\describe{
\item{\code{stream}}{Object of class function. The import function to stream data
of the file system. Needs to be able to handle the two mandatory arguments
\code{file} (a \code{character} containing a valid file path) and \code{selection}
(a \code{GRanges} object with the genomic region to plot).}

\item{\code{reference}}{Object of class "character", the path to the file
containing the data.}

\item{\code{mapping}}{Object of class \code{list}, a default mapping between the
metadata columns of the returned \code{GRanges} object from the import function
and the \code{elemenMetadata} columns that make up the final track object.}

\item{\code{args}}{Object of class \code{list}, the passed in constructor arguments
during object instantiation. Those will be needed when fetching the data
in order to fill all necessary slots.}

\item{\code{defaults}}{Object of class \code{list}, the relevant default values to be
used when neither mapping nor args provides the necessary information.}
}}

\examples{
# This is a reference class, below example from AlignmentsTrack

afrom <- 2960000
ato <- 3160000
alTrack <- AlignmentsTrack(system.file(
    package = "Gviz", "extdata",
    "gapped.bam"
), isPaired = TRUE)
plotTracks(alTrack, from = afrom, to = ato, chromosome = "chr12")
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
