% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataTrack-class.R
\docType{class}
\name{DataTrack-class}
\alias{DataTrack-class}
\alias{initialize,DataTrack-method}
\alias{ReferenceDataTrack-class}
\alias{initialize,ReferenceDataTrack-method}
\alias{DataTrack}
\alias{values,DataTrack-method}
\alias{values<-,DataTrack-method}
\alias{strand,DataTrack-method}
\alias{strand<-,DataTrack,ANY-method}
\alias{split,DataTrack,ANY-method}
\alias{feature,DataTrack-method}
\alias{feature<-,DataTrack,character-method}
\alias{collapseTrack,DataTrack-method}
\alias{[,DataTrack,ANY,ANY,ANY-method}
\alias{subset,DataTrack-method}
\alias{subset,ReferenceDataTrack-method}
\alias{drawAxis,DataTrack-method}
\alias{drawGD,DataTrack-method}
\alias{show,DataTrack-method}
\alias{show,ReferenceDataTrack-method}
\title{DataTrack class and methods}
\usage{
\S4method{initialize}{DataTrack}(.Object, data = matrix(), strand, ...)

\S4method{initialize}{ReferenceDataTrack}(
  .Object,
  stream,
  reference,
  mapping = list(),
  args = list(),
  defaults = list(),
  ...
)

DataTrack(
  range = NULL,
  start = NULL,
  end = NULL,
  width = NULL,
  data,
  chromosome,
  strand,
  genome,
  name = "DataTrack",
  importFunction,
  stream = FALSE,
  ...
)

\S4method{values}{DataTrack}(x, all = FALSE)

\S4method{values}{DataTrack}(x) <- value

\S4method{strand}{DataTrack}(x)

\S4method{strand}{DataTrack,ANY}(x) <- value

\S4method{split}{DataTrack,ANY}(x, f, drop = FALSE, ...)

\S4method{feature}{DataTrack}(GdObject)

\S4method{feature}{DataTrack,character}(GdObject) <- value

\S4method{collapseTrack}{DataTrack}(GdObject, diff = .pxResolution(coord = "x"), xrange)

\S4method{[}{DataTrack,ANY,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{subset}{DataTrack}(
  x,
  from = NULL,
  to = NULL,
  sort = FALSE,
  drop = TRUE,
  use.defaults = TRUE,
  ...
)

\S4method{subset}{ReferenceDataTrack}(x, from, to, chromosome, ...)

\S4method{drawAxis}{DataTrack}(GdObject, ...)

\S4method{drawGD}{DataTrack}(GdObject, minBase, maxBase, prepare = FALSE, subset = TRUE, ...)

\S4method{show}{DataTrack}(object)

\S4method{show}{ReferenceDataTrack}(object)
}
\arguments{
\item{.Object}{.Object}

\item{data}{A numeric matrix of data points with the number of columns equal
to the number of coordinates in \code{range}, or a numeric vector of
appropriate length that will be coerced into such a one-row matrix. Each
individual row is supposed to contain data for a given sample, where the
coordinates for each single observation are constant across samples.
Depending on the plotting type of the data (see 'Details' and 'Display
Parameters' sections), sample grouping or data aggregation may be available.
Alternatively, this can be a character vector of column names that point
into the element metadata of the \code{range} object for subsetting.
Naturally, this is only supported when the \code{range} argument is of class
\code{GRanges}.}

\item{strand}{Character vector, the strand information for the individual
track items. Currently this has to be unique for the whole track and doesn't
really have any visible consequences, but we might decide to make
\code{DataTracks} strand-specific at a later stage.}

\item{\dots}{Additional items which will all be interpreted as further
display parameters.}

\item{stream}{A logical flag indicating that the user-provided import
function can deal with indexed files and knows how to process the additional
\code{selection} argument when accessing the data on disk. This causes the
constructor to return a \code{ReferenceDataTrack} object which will grab the
necessary data on the fly during each plotting operation.}

\item{range}{An optional meta argument to handle the different input types.
If the \code{range} argument is missing, all the relevant information to create
the object has to be provided as individual function arguments (see below).

The different input options for \code{range} are:

\describe{

\item{}{A \code{GRanges} object: essentially all the necessary information
to create a \code{DataTrack} can be contained in a single \code{GRanges}
object. The track's coordinates are taken from the \code{start}, \code{end}
and \code{seqnames} slots, the genome information from the genome slot, and
the numeric data values can be extracted from additional metadata columns
columns (please note that non-numeric columns are being ignored with a
warning). As a matter of fact, calling the constructor on a \code{GRanges}
object without further arguments, e.g.  \code{DataTrack(range=obj)} is
equivalent to calling the coerce method \code{as(obj, "DataTrack")}.
Alternatively, the \code{GRanges} object may only contain the coordinate
information, in which case the numeric data part is expected to be present
in the separate \code{data} argument, and the ranges have to match the
dimensions of the data matrix. If \code{data} is not \code{NULL}, this will
always take precedence over anything defined in the \code{range} argument.
See below for details.}

\item{}{An \code{\linkS4class{IRanges}} object: this is very similar to the
above case, except that the numeric data part now always has to be provided
in the separate \code{data} argument. Also the chromosome information must
be provided in the \code{chromosome} argument, because neither of the two
can be directly encoded in an \code{IRange} object.}

\item{}{A \code{data.frame} object: the \code{data.frame} needs to contain
at least the two mandatory columns \code{start} and \code{end} with the
range coordinates. It may also contain a \code{chromosome} column with the
chromosome information for each range. If missing it will be drawn from the
separate \code{chromosome} argument. All additional numeric columns will be
interpreted as data columns, unless the \code{data} argument is explicitely
provided.}

\item{}{A \code{character} scalar: in this case the value of the
\code{range} argument is considered to be a file path to an annotation file
on disk. A range of file types are supported by the \code{Gviz} package as
identified by the file extension. See the \code{importFunction}
documentation below for further details.}

}}

\item{start, end, width}{Integer vectors, giving the start and the end end
coordinates for the individual track items, or their width. Two of the three
need to be specified, and have to be of equal length or of length one, in
which case the single value will be recycled accordingly. Otherwise, the
usual R recycling rules for vectors do not apply and the function will cast
an error.}

\item{chromosome}{The chromosome on which the track's genomic ranges are
defined. A valid UCSC chromosome identifier if
\code{options(ucscChromosomeNames=TRUE)}. Please note that in this case only
syntactic checking takes place, i.e., the argument value needs to be an
integer, numeric character or a character of the form \code{chrx}, where
\code{x} may be any possible string. The user has to make sure that the
respective chromosome is indeed defined for the the track's genome. If not
provided here, the constructor will try to construct the chromosome
information based on the available inputs, and as a last resort will fall
back to the value \code{chrNA}. Please note that by definition all objects
in the \code{Gviz} package can only have a single active chromosome at a
time (although internally the information for more than one chromosome may
be present), and the user has to call the \code{chromosome<-} replacement
method in order to change to a different active chromosome.}

\item{genome}{The genome on which the track's ranges are defined. Usually
this is a valid UCSC genome identifier, however this is not being formally
checked at this point. If not provided here the constructor will try to
extract this information from the provided input, and eventually will fall
back to the default value of \code{NA}.}

\item{name}{Character scalar of the track's name used in the title panel
when plotting.}

\item{importFunction}{A user-defined function to be used to import the data
from a file. This only applies when the \code{range} argument is a character
string with the path to the input data file. The function needs to accept an
argument \code{file} containing the file path and has to return a proper
\code{GRanges} object with the data part attached as numeric metadata
columns. Essentially the process is equivalent to constructing a
\code{DataTrack} directly from a \code{GRanges} object in that non-numeric
columns will be dropped, and further subsetting can be archived by means of
the \code{data} argument. A set of default import functions is already
implemented in the package for a number of different file types, and one of
these defaults will be picked automatically based on the extension of the
input file name. If the extension can not be mapped to any of the existing
import function, an error is raised asking for a user-defined import
function. Currently the following file types can be imported with the
default functions: \code{wig}, \code{bigWig/bw}, \code{bedGraph} and
\code{bam}.

Some file types support indexing by genomic coordinates (e.g., \code{bigWig}
and \code{bam}), and it makes sense to only load the part of the file that
is needed for plotting. To this end, the \code{Gviz} package defines the
derived \code{ReferenceDataTrack} class, which supports streaming data from
the file system. The user typically does not have to deal with this
distinction but may rely on the constructor function to make the right
choice as long as the default import functions are used. However, once a
user-defined import function has been provided and if this function adds
support for indexed files, you will have to make the constructor aware of
this fact by setting the \code{stream} argument to \code{TRUE}. Please note
that in this case the import function needs to accept a second mandatory
argument \code{selection} which is a \code{GRanges} object containing the
dimensions of the plotted genomic range. As before, the function has to
return an appropriate \code{GRanges} object.}

\item{value}{Value to be set.}

\item{GdObject}{Object of \code{GdObject-class}.}
}
\value{
The return value of the constructor function is a new object of class
\code{DataTrack} or \code{ReferenceDataTrack}.
}
\description{
A class to store numeric data values along genomic coordinates. Multiple
samples as well as sample groupings are supported, with the restriction of
equal genomic coordinates for a single observation across samples.
}
\details{
Depending on the setting of the \code{type} display parameter, the data can
be plotted in various different forms as well as combinations thereof.
Supported plotting types are:

\describe{

\item{}{\code{p}: simple xy-plot.}

\item{}{\code{l}: lines plot. In the case of multiple samples this plotting
type is not overly usefull since the points in the data matrix are connected
in column-wise order. Type \code{a} might be more appropriate in these
situations.}

\item{}{\code{b}: combination of xy-plot and lines plot.}

\item{}{\code{a}: lines plot of the column-wise average values.}

\item{}{\code{s}: sort and connect data points along the x-axis}

\item{}{\code{S}: sort and connect data points along the y-axis}

\item{}{\code{g}: add grid lines. To ensure a consitant look and feel across
multiple tracks, grid lines should preferentially be added by using the
\code{grid} display parameter.}

\item{}{\code{r}: add a regression line to the plot.}

\item{}{\code{h}: histogram-like vertical lines centered in the middle of
the coordinate ranges.}

\item{}{\code{smooth}: add a loess fit to the plot. The following display
parameters can be used to control the loess calculation: \code{span, degree,
family, evaluation}. See \code{\link{panel.loess}} for details.}

\item{}{\code{histogram}: plot data as a histogram, where the width of the
histogram bars reflects the width of the genomic ranges in the \code{range}
slot.}

\item{}{\code{mountain}: plot a smoothed version of the data relative to a
baseline, as defined by the \code{baseline} display parameter. The following
display parameters can be used to control the smoothing: \code{span, degree,
family, evaluation}. See \code{\link{panel.loess}} for details. The layout
of the plot can be further customized via the following display parameters:
\code{col.mountain, lwd.mountain, lty.mountain, fill.mountain}.}

\item{}{\code{polygon}: plot data as a polygon (similar to
\code{mountain}-type but without smoothing). Data are plotted relative to a
baseline, as defined by the \code{baseline} display parameter. The layout of
the plot can be further customized via the following display parameters:
\code{col.mountain, lwd.mountain, lty.mountain, fill.mountain}.}

\item{}{\code{boxplot}: plot the data as box-and-whisker plots. The layout
of the plot can be further customized via the following display parameters:
\code{box.ratio, box.width, varwidt, notch, notch.frac, levels.fos, stats,
coef, do.out}. See \code{\link{panel.bwplot}} for details.}

\item{}{\code{gradient}: collapse the data across samples and plot this
average value as a color-coded gradient. Essenitally this is similar to the
heatmap-type plot of a single sample. The layout of the plot can be further
customized via the display parameters \code{ncolor} and \code{gradient}
which control the number of gradient colors as well as the gradient base
colors, respectively.}

\item{}{\code{heatmap}: plot the color-coded values for all samples in the
form of a heatmap. The data for individual samples can be visually separated
by setting the \code{separator} display parameter. It's value is taken as
the amount of spacing in pixels in between two heatmap rows. The layout of
the plot can be further customized via the display parameters \code{ncolor}
and \code{gradient} which control the number of gradient colors as well as
the gradient base colors, respectively.}

\item{}{\code{horizon}: plot continuous data by cutting the y range into
segments and overplotting them with color representing the magnitude and
direction of deviation. This is particularly useful when comparing multiple
samples, in which case the horizon strips are stacked. See
\code{\link{horizonplot}} for details. Please note that the \code{origin}
and \code{horizonscale} arguments of the Lattice \code{horizonplot} function
are available as display parameters \code{horizon.origin} and
\code{horizon.scale}.}

}

For some of the above plotting-types the \code{groups} display parameter can
be used to indicate sample sub-groupings. Its value is supposed to be a
factor vector of similar length as the number of samples. In most cases, the
groups are shown in different plotting colors and data aggregation
operations are done in a stratified fashion.

The \code{window} display parameter can be used to aggregate the data prior
to plotting. Its value is taken as the number of equal-sized windows along
the genomic coordinates of the track for which to compute average values.
The special value \code{auto} can be used to automatically determine a
reasonable number of windows which can be particularly useful when plotting
very large genomic regions with many data points.

The \code{aggregation} parameter can be set to define the aggregation
function to be used when averaging in windows or across collapsed items. It
takes the form of either a function which should condense a numeric vector
into a single number, or one of the predefined options as character scalars
\code{"mean"}, \code{"median"} or \code{"sum"} for mean, median or
summation, respectively. Defaults to computing mean values for each sample.
Note that the predefined options can be much faster because they are
optimized to work on large numeric tables.
}
\section{Functions}{
\itemize{
\item \code{initialize,DataTrack-method}: Initialize.

\item \code{ReferenceDataTrack-class}: The file-based version of the \code{DataTrack-class}.

\item \code{initialize,ReferenceDataTrack-method}: Initialize.

\item \code{DataTrack}: Constructor function for \code{DataTrack-class}

\item \code{values,DataTrack-method}: return the raw data values of the object, i.e.,
the data matrix in the \code{data} slot.

\item \code{values<-,DataTrack-method}: Replace the data matrix in the \code{data} slot.

\item \code{strand,DataTrack-method}: return a vector of strand specifiers for all
track items, in the form '+' for the Watson strand, '-' for the Crick
strand or '*' for either of the two.

\item \code{strand<-,DataTrack,ANY-method}: replace the strand information for the track items.
The replacement value needs to be an appropriate scalar or vector of strand values.

\item \code{split,DataTrack,ANY-method}: Split a \code{DataTrack} object by an appropriate
factor vector (or another vector that can be coerced into one).
The output of this operation is a list of \code{DataTrack} objects.

\item \code{feature,DataTrack-method}: returns NULL since there is no grouping
information for the ranges in a \code{DataTrack}.

\item \code{feature<-,DataTrack,character-method}: this return the unaltered input object since
there is no grouping information for the ranges in a \code{DataTrack}.

\item \code{collapseTrack,DataTrack-method}: preprocess the track before plotting.
This will collapse overlapping track items based on the available resolution
and increase the width and height of all track objects to a minimum value
to avoid rendering issues. See collapsing for details.

\item \code{[,DataTrack,ANY,ANY,ANY-method}: subset the items in the \code{DataTrack} object.
This is essentially similar to subsetting of the \code{GRanges} object in the
\code{range} slot. For most applications, the subset method may be more appropriate.

\item \code{subset,DataTrack-method}: Subset a \code{DataTrack} by coordinates
and sort if necessary.

\item \code{subset,ReferenceDataTrack-method}: Subset a \code{ReferenceDataTrack} by coordinates
and sort if necessary.

\item \code{drawAxis,DataTrack-method}: add a y-axis to the title panel of a track.

\item \code{drawGD,DataTrack-method}: plot the object to a graphics device.
The return value of this method is the input object, potentially updated
during the plotting operation. Internally, there are two modes in which the
method can be called. Either in 'prepare' mode, in which case no plotting is
done but the object is preprocessed based on the available space, or in
'plotting' mode, in which case the actual graphical output is created.
Since subsetting of the object can be potentially costly, this can be
switched off in case subsetting has already been performed before or
is not necessary.

\item \code{show,DataTrack-method}: Show method.

\item \code{show,ReferenceDataTrack-method}: Show method.
}}

\section{Objects from the class}{


Objects can be created using the constructor function \code{DataTrack}.
}

\examples{
## Object construction:

## An empty object
DataTrack()

## from individual arguments
dat <- matrix(runif(400), nrow = 4)
dtTrack <- DataTrack(
    start = seq(1, 1000, len = 100), width = 10, data = dat,
    chromosome = 1, genome = "mm9", name = "random data"
)

## from GRanges
library(GenomicRanges)
gr <- GRanges(seqnames = "chr1", ranges = IRanges(seq(1, 1000, len = 100),
    width = 10
))
values(gr) <- t(dat)
dtTrack <- DataTrack(range = gr, genome = "mm9", name = "random data")

## from IRanges
dtTrack <- DataTrack(
    range = ranges(gr), data = dat, genome = "mm9",
    name = "random data", chromosome = 1
)

## from a data.frame
df <- as.data.frame(gr)
colnames(df)[1] <- "chromosome"
dtTrack <- DataTrack(range = df, genome = "mm9", name = "random data")
\dontshow{
## For some annoying reason the postscript device does not know about
## the sans font
if (!interactive()) {
    font <- ps.options()$family
    displayPars(dtTrack) <- list(fontfamily = font, fontfamily.title = font)
}
}

## Plotting
plotTracks(dtTrack)

## Track names
names(dtTrack)
names(dtTrack) <- "foo"
plotTracks(dtTrack)

## Subsetting and splitting
subTrack <- subset(dtTrack, from = 100, to = 300)
length(subTrack)
subTrack[1:2, ]
subTrack[, 1:2]
split(dtTrack, rep(1:2, each = 50))

## Accessors
start(dtTrack)
end(dtTrack)
width(dtTrack)
position(dtTrack)
width(subTrack) <- width(subTrack) - 5

strand(dtTrack)
strand(subTrack) <- "-"

chromosome(dtTrack)
chromosome(subTrack) <- "chrX"

genome(dtTrack)
genome(subTrack) <- "mm9"

range(dtTrack)
ranges(dtTrack)

## Data
values(dtTrack)
score(dtTrack)

## coercion
as(dtTrack, "data.frame")
}
\seealso{
\code{\linkS4class{DisplayPars}}

\code{\linkS4class{GdObject}}

\code{\linkS4class{GRanges}}

\code{\linkS4class{HighlightTrack}}

\code{\linkS4class{ImageMap}}

\code{\linkS4class{IRanges}}

\code{\linkS4class{RangeTrack}}

\code{\linkS4class{DataTrack}}

\code{\link{collapsing}}

\code{\link{grouping}}

\code{\link{panel.grid}}

\code{\link{plotTracks}}

\code{\link{settings}}
}
\author{
Florian Hahne
}
\keyword{internal}
