% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\docType{methods}
\name{plotDispEsts}
\alias{plotDispEsts}
\alias{plotDispEsts,DESeqDataSet-method}
\title{Plot dispersion estimates}
\usage{
\S4method{plotDispEsts}{DESeqDataSet}(
  object,
  ymin,
  CV = FALSE,
  genecol = "black",
  fitcol = "red",
  finalcol = "dodgerblue",
  legend = TRUE,
  xlab,
  ylab,
  log = "xy",
  cex = 0.45,
  ...
)
}
\arguments{
\item{object}{a DESeqDataSet, with dispersions estimated}

\item{ymin}{the lower bound for points on the plot, points beyond this
are drawn as triangles at ymin}

\item{CV}{logical, whether to plot the asymptotic or biological
coefficient of variation (the square root of dispersion) on the y-axis.
As the mean grows to infinity, the square root of dispersion gives
the coefficient of variation for the counts. Default is \code{FALSE},
plotting dispersion.}

\item{genecol}{the color for gene-wise dispersion estimates}

\item{fitcol}{the color of the fitted estimates}

\item{finalcol}{the color of the final estimates used for testing}

\item{legend}{logical, whether to draw a legend}

\item{xlab}{xlab}

\item{ylab}{ylab}

\item{log}{log}

\item{cex}{cex}

\item{...}{further arguments to \code{plot}}
}
\description{
A simple helper function that plots the per-gene dispersion
estimates together with the fitted mean-dispersion relationship.
}
\examples{

dds <- makeExampleDESeqDataSet()
dds <- estimateSizeFactors(dds)
dds <- estimateDispersions(dds)
plotDispEsts(dds)

}
\author{
Simon Anders
}
