/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef USER_H
#define USER_H

#include <QTcpSocket>

#include "userinfo.h"
#include "userstatistics.h"
#include "qchatserversocket.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class User
{
  private:
    QChatServerSocket* m_socket;
    UserInfo*          m_info;
    UserStatistics*    m_stats;
    QString            m_login;
    uint               m_uid;
    QStringList        m_channels;

  public:
    User();
    ~User();

    void setSocket(QChatServerSocket* s){m_socket = s;}
    const QString & login() const {return m_login;}
    void setLogin(const QString& l){m_login = l;}

    void setUid( const uint& theValue ){m_uid = theValue;}
    uint uid() const {return m_uid;}

    void addChannel   (const QString & ch){if(!m_channels.contains(ch)) m_channels.append(ch);}
    void removeChannel(const QString & ch){m_channels.removeAll(ch);}
    const QStringList & channels() const {return m_channels;}

    UserInfo* info(){return m_info;}
};

#endif
