#version 450 core
#define PRECISION $precision
#define FORMAT $format

layout(std430) buffer;

/* Qualifiers: layout - storage - precision - memory */

/*
 * Output Image
 */
layout(set = 0, binding = 0, FORMAT) uniform PRECISION restrict writeonly image3D uOutput;

/*
 * Input Buffer
 */
layout(set = 0, binding = 1) uniform PRECISION sampler3D uInput;

/*
 * Params Buffer
 */
layout(set = 0, binding = 2) uniform PRECISION restrict Block {
  // batch_info.x: number of texels per batch
  // batch_info.y: index along batch dim to select
  ivec2 batch_info;
}
uBlock;

/*
 * Local Work Group Size
 */
layout(local_size_x_id = 0, local_size_y_id = 1, local_size_z_id = 2) in;

void main() {
  const ivec3 pos = ivec3(gl_GlobalInvocationID);
  const uint src_pos_z = (uBlock.batch_info.y * uBlock.batch_info.x) + pos.z;
  imageStore(
      uOutput, pos, texelFetch(uInput, ivec3(pos.x, pos.y, src_pos_z), 0));
}
