# Docker

You can run PyG with CUDA 10.1 inside a docker image.
The creation of [our dockerfile](https://github.com/pyg-team/pytorch_geometric/blob/master/docker/Dockerfile) refers to the dockerfiles provided by [NVIDIA](https://gitlab.com/nvidia/cuda/tree/ubuntu18.04) and [PyTorch](https://github.com/anibali/docker-pytorch).

1. Download the dockerfile to your host server.
2. `$ docker build -t "custom image name"`
3. `$ docker run --rm -it --init --runtime=nvidia --ipc=host --network=host --volume=$PWD:/app -e NVIDIA_VISIBLE_DEVICES=0 "custom image name" /bin/bash`

If you encounter any problems, please feel free to contact <liangshengwen@ict.ac.cn>.


# Singularity

You can run PyG inside a singularity image. An example singularity file can be found in this folder.

You might have to modify the script; depending on your needs, modify the following:

- **cuda version 10.1**: If you need another version, change `From: nvidia/cuda:10.1-cudnn7-devel-ubuntu16.04` to the corresponding tag from <https://hub.docker.com/r/nvidia/cuda>. Same if you want to use anything but Ubuntu 16.04. Your host has to have at least this cuda version!
- **python version 3.7.2**: If you need another version, change `pyenv install 3.7.2` and the following lines to the corresponding version.
- **pytorch version 1.3.0**: If you need another version, change `pip install torch==1.3.0`.
- **pytorch_geometric versions**: This uses specific versions for each of the `pytorch_geometric` requirements (scatter: 1.4.0, sparse: 0.4.3, cluster: 1.4.5, geometric 1.3.2). To change these, change the corresponding `git checkout` lines near the bottom.
- **cuda compute capability 5.0 and 6.1**: If you run it on multiply systems (likely, with singularity), ensure that all compute capabilities are listed here. If you have the cuda samples installed, check it with (for example) `/usr/local/cuda-10.1/extras/demo_suite/deviceQuery | grep 'CUDA Capability'`; if not, check [here](https://en.wikipedia.org/wiki/CUDA#GPUs_supported).

Note: If your harddisk runs full after multiple builds, this is known and apparently working as intended; delete the `/tmp/sbuild-XXXXXXXXX` files.

## Building and Using the Container

To build the container, run

`sudo singularity build geometric.sif singularity`

then wait. Once finished, you can run the GAT example in the folder you built the image in by calling

```
wget https://raw.githubusercontent.com/pyg-team/pytorch_geometric/master/examples/gat.py
```

(to download the sample),

then

```
singularity exec geometric.sif python3 gat.py
```

to run on the CPU, or

```
singularity exec --nv geometric.sif python3 gat.py
```
to run on the GPU.
