# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class StyleSheetList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the StyleSheetList

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetList
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetList
        """
        super(StyleSheetList, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }

    def get(self):
        """
        Constructs a StyleSheetContext

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        """
        return StyleSheetContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __call__(self):
        """
        Constructs a StyleSheetContext

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        """
        return StyleSheetContext(self._version, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.StyleSheetList>'


class StyleSheetPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the StyleSheetPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param assistant_sid: The SID of the Assistant that is the parent of the resource

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetPage
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetPage
        """
        super(StyleSheetPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of StyleSheetInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        return StyleSheetInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Autopilot.V1.StyleSheetPage>'


class StyleSheetContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, assistant_sid):
        """
        Initialize the StyleSheetContext

        :param Version version: Version that contains the resource
        :param assistant_sid: The SID of the Assistant with the StyleSheet resource to fetch

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        """
        super(StyleSheetContext, self).__init__(version)

        # Path Solution
        self._solution = {'assistant_sid': assistant_sid, }
        self._uri = '/Assistants/{assistant_sid}/StyleSheet'.format(**self._solution)

    def fetch(self):
        """
        Fetch the StyleSheetInstance

        :returns: The fetched StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return StyleSheetInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def update(self, style_sheet=values.unset):
        """
        Update the StyleSheetInstance

        :param dict style_sheet: The JSON string that describes the style sheet object

        :returns: The updated StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        data = values.of({'StyleSheet': serialize.object(style_sheet), })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return StyleSheetInstance(self._version, payload, assistant_sid=self._solution['assistant_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.StyleSheetContext {}>'.format(context)


class StyleSheetInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, assistant_sid):
        """
        Initialize the StyleSheetInstance

        :returns: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        super(StyleSheetInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assistant_sid': payload.get('assistant_sid'),
            'url': payload.get('url'),
            'data': payload.get('data'),
        }

        # Context
        self._context = None
        self._solution = {'assistant_sid': assistant_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: StyleSheetContext for this StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetContext
        """
        if self._context is None:
            self._context = StyleSheetContext(self._version, assistant_sid=self._solution['assistant_sid'], )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assistant_sid(self):
        """
        :returns: The SID of the Assistant that is the parent of the resource
        :rtype: unicode
        """
        return self._properties['assistant_sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the StyleSheet resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def data(self):
        """
        :returns: The JSON string that describes the style sheet object
        :rtype: dict
        """
        return self._properties['data']

    def fetch(self):
        """
        Fetch the StyleSheetInstance

        :returns: The fetched StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        return self._proxy.fetch()

    def update(self, style_sheet=values.unset):
        """
        Update the StyleSheetInstance

        :param dict style_sheet: The JSON string that describes the style sheet object

        :returns: The updated StyleSheetInstance
        :rtype: twilio.rest.autopilot.v1.assistant.style_sheet.StyleSheetInstance
        """
        return self._proxy.update(style_sheet=style_sheet, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Autopilot.V1.StyleSheetInstance {}>'.format(context)
