# mypy: disallow_untyped_defs=False
# BettyCrocker.com scraper
# Written by G.D. Wallters
# Freely released the code to recipe_scraper group
# 18 January, 2020
# =======================================================


from ._abstract import AbstractScraper
from ._grouping_utils import group_ingredients


class BettyCrocker(AbstractScraper):
    @classmethod
    def host(cls):
        return "bettycrocker.com"

    def ingredient_groups(self):
        return group_ingredients(
            self.ingredients(),
            self.soup,
            ".recipeIngredients h3",
            ".recipeIngredients li",
        )
